/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ptm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class PTMExperimentHeader
extends JPanel {
    private PTMVectorPanel ptmVectorPanel;
    private static final String PTM_TEMPLATE_STRING = "Template";
    private Insets insets = new Insets(0, 10, 0, 0);
    private BufferedImage posColorImage;
    private BufferedImage negColorImage;
    private boolean useDoubleGradient = true;

    public PTMExperimentHeader(JComponent jComponent, Vector vector) {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.ptmVectorPanel = new PTMVectorPanel(vector);
        this.add((Component)jComponent, "North");
        this.add((Component)this.ptmVectorPanel, "South");
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.ptmVectorPanel);
        objectOutputStream.writeObject(this.insets);
        objectOutputStream.writeBoolean(this.useDoubleGradient);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.ptmVectorPanel = (PTMVectorPanel)objectInputStream.readObject();
        this.insets = (Insets)objectInputStream.readObject();
        this.useDoubleGradient = objectInputStream.readBoolean();
    }

    public void setUseDoubleGradient(boolean bl) {
        this.useDoubleGradient = bl;
    }

    public void updateSize(Dimension dimension) {
        this.ptmVectorPanel.updateSize(dimension);
    }

    public void setCurrentCluster(int n) {
        this.ptmVectorPanel.setCurrentCluster(n);
    }

    public void setDrawBorders(boolean bl) {
        this.ptmVectorPanel.setDrawBorders(bl);
    }

    public void setValues(float f, float f2) {
        this.ptmVectorPanel.setValues(f, f2);
    }

    public void setValues(float f, float f2, float f3) {
        this.ptmVectorPanel.setValues(f, f2, f3);
    }

    public void setColorImages(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.posColorImage = bufferedImage;
        this.negColorImage = bufferedImage2;
    }

    public void setMissingColor(Color color) {
        this.ptmVectorPanel.setMissingColor(color);
    }

    public void setAntiAliasing(boolean bl) {
        this.ptmVectorPanel.setAntiAliasing(bl);
    }

    private class PTMVectorPanel
    extends JPanel {
        private Vector templateVector;
        private int cluster;
        private float maxValue = 3.0f;
        private float minValue = -3.0f;
        private float midValue = 0.0f;
        private Dimension elementSize;
        private boolean drawBorders = true;
        private boolean isAntiAliasing = false;
        private Color missingColor = new Color(128, 128, 128);

        public PTMVectorPanel(Vector vector) {
            this.setBackground(Color.white);
            this.templateVector = vector;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeObject(this.templateVector);
            objectOutputStream.writeInt(this.cluster);
            objectOutputStream.writeFloat(this.maxValue);
            objectOutputStream.writeFloat(this.minValue);
            objectOutputStream.writeObject(this.elementSize);
            objectOutputStream.writeBoolean(this.drawBorders);
            objectOutputStream.writeBoolean(this.isAntiAliasing);
            objectOutputStream.writeObject(this.missingColor);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.templateVector = (Vector)objectInputStream.readObject();
            this.cluster = objectInputStream.readInt();
            this.maxValue = objectInputStream.readFloat();
            this.minValue = objectInputStream.readFloat();
            this.elementSize = (Dimension)objectInputStream.readObject();
            this.drawBorders = objectInputStream.readBoolean();
            this.isAntiAliasing = objectInputStream.readBoolean();
            this.missingColor = (Color)objectInputStream.readObject();
        }

        public void setMissingColor(Color color) {
            this.missingColor = color;
        }

        public void setCurrentCluster(int n) {
            this.cluster = n;
        }

        public void setDrawBorders(boolean bl) {
            this.drawBorders = bl;
        }

        public void setAntiAliasing(boolean bl) {
            this.isAntiAliasing = bl;
        }

        public void setValues(float f, float f2) {
            this.maxValue = f2;
            this.minValue = f;
        }

        public void setValues(float f, float f2, float f3) {
            this.maxValue = f3;
            this.minValue = f;
            this.midValue = f2;
        }

        public void setLeftInset(int n) {
            ((PTMExperimentHeader)PTMExperimentHeader.this).insets.left = n;
        }

        public void updateSize(Dimension dimension) {
            this.elementSize = new Dimension(dimension);
            this.setFont(new Font("monospaced", 0, dimension.height));
            Graphics2D graphics2D = (Graphics2D)this.getGraphics();
            if (this.isAntiAliasing) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n = fontMetrics.stringWidth(PTMExperimentHeader.PTM_TEMPLATE_STRING) + 10;
            int n2 = dimension.width * this.templateVector.size() + n;
            int n3 = dimension.height + 10;
            this.setSize(n2, n3);
            this.setPreferredSize(new Dimension(n2, n3));
        }

        public void paint(Graphics graphics) {
            int n;
            super.paint(graphics);
            if (this.isAntiAliasing) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            int n2 = this.templateVector.size();
            Vector<Float> vector = new Vector<Float>();
            float f = this.getMax(this.templateVector);
            float f2 = this.getMin(this.templateVector);
            for (n = 0; n < this.templateVector.size(); ++n) {
                float f3 = ((Float)this.templateVector.get(n)).floatValue();
                if (f3 == f) {
                    vector.add(new Float(3.0f));
                    continue;
                }
                if (f3 == f2) {
                    vector.add(new Float(-3.0f));
                    continue;
                }
                float f4 = 6.0f * ((f3 - f2) / (f - f2)) - 3.0f;
                vector.add(new Float(f4));
            }
            for (n = 0; n < n2; ++n) {
                this.fillRectAt(graphics, n, this.getColor(((Float)vector.get(n)).floatValue()));
                if (!this.drawBorders) continue;
                this.drawRectAt(graphics, n, Color.black);
            }
            graphics.setColor(Color.black);
            graphics.drawString(PTMExperimentHeader.PTM_TEMPLATE_STRING, this.elementSize.width * n2 + 10 + ((PTMExperimentHeader)PTMExperimentHeader.this).insets.left, this.elementSize.height);
        }

        private float getMax(Vector vector) {
            float f = Float.MIN_VALUE;
            for (int i = 0; i < vector.size(); ++i) {
                float f2;
                if (Float.isNaN(((Float)vector.get(i)).floatValue()) || !((f2 = ((Float)vector.get(i)).floatValue()) > f)) continue;
                f = f2;
            }
            return f;
        }

        private float getMin(Vector vector) {
            float f = Float.MAX_VALUE;
            for (int i = 0; i < vector.size(); ++i) {
                float f2;
                if (Float.isNaN(((Float)vector.get(i)).floatValue()) || !((f2 = ((Float)vector.get(i)).floatValue()) < f)) continue;
                f = f2;
            }
            return f;
        }

        private void fillRectAt(Graphics graphics, int n, Color color) {
            graphics.setColor(color);
            graphics.fillRect(n * this.elementSize.width + ((PTMExperimentHeader)PTMExperimentHeader.this).insets.left, 0, this.elementSize.width, this.elementSize.height);
        }

        private void drawRectAt(Graphics graphics, int n, Color color) {
            graphics.setColor(color);
            graphics.drawRect(n * this.elementSize.width, 0, this.elementSize.width - 1, this.elementSize.height - 1);
        }

        private Color getColor(float f) {
            int n;
            if (Float.isNaN(f)) {
                return this.missingColor;
            }
            if (PTMExperimentHeader.this.useDoubleGradient) {
                float f2 = f < this.midValue ? this.minValue : this.maxValue;
                int n2 = (int)(255.0f * (f - this.midValue) / (f2 - this.midValue));
                n2 = n2 > 255 ? 255 : n2;
                n = f < this.midValue ? PTMExperimentHeader.this.negColorImage.getRGB(255 - n2, 0) : PTMExperimentHeader.this.posColorImage.getRGB(n2, 0);
            } else {
                float f3 = this.maxValue - this.minValue;
                int n3 = f <= this.minValue ? 0 : (f >= this.maxValue ? 255 : (int)((f - this.minValue) / f3 * 255.0f));
                n = PTMExperimentHeader.this.posColorImage.getRGB(n3, 0);
            }
            return new Color(n);
        }
    }
}

