/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.som;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DistanceMetricPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.SampleSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class SOMInitDialog
extends AlgorithmDialog {
    private int result;
    private SampleSelectionPanel sampleSelectionPanel;
    private HCLSelectionPanel hclOpsPanel;
    private DistanceMetricPanel metricPanel;
    public JTextField dimXField;
    public JTextField dimYField;
    public JTextField iterField;
    public JTextField alphaField;
    public JTextField radiusField;
    public JComboBox initList;
    public JComboBox neighbList;
    public JComboBox topoList;

    public SOMInitDialog(Frame frame, int n, int n2, long l, float f, float f2, int n3, int n4, int n5, String string, boolean bl) {
        super(frame, "SOM: Self Organizing Maps", true);
        this.setSize(520, 343);
        this.setResizable(false);
        Listener listener = new Listener();
        this.addWindowListener(listener);
        this.sampleSelectionPanel = new SampleSelectionPanel(Color.white, UIManager.getColor("Label.foreground"), true, "Sample Selection");
        this.sampleSelectionPanel.setExperimentButtonActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SOMInitDialog.this.sampleSelectionPanel.isClusterGenesSelected()) {
                    return;
                }
                int n = SOMInitDialog.this.initList.getSelectedIndex();
                SOMInitDialog.this.initList.removeItemAt(1);
                SOMInitDialog.this.initList.insertItemAt("Random Samples", 1);
                SOMInitDialog.this.initList.setSelectedIndex(n);
            }
        });
        this.sampleSelectionPanel.setGeneButtonActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!SOMInitDialog.this.sampleSelectionPanel.isClusterGenesSelected()) {
                    return;
                }
                int n = SOMInitDialog.this.initList.getSelectedIndex();
                SOMInitDialog.this.initList.removeItemAt(1);
                SOMInitDialog.this.initList.insertItemAt("Random Genes", 1);
                SOMInitDialog.this.initList.setSelectedIndex(n);
            }
        });
        this.metricPanel = new DistanceMetricPanel(string, bl, "Euclidean Distance", "SOM", true, true);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(5, 10, 20, 0));
        jPanel.setBackground(Color.white);
        jPanel.setForeground(Color.black);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel("Dimension X"), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)new JLabel("Dimension Y"), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)new JLabel("Iterations"), gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)new JLabel("Alpha"), gridBagConstraints);
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)new JLabel("Radius"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.fill = 2;
        this.dimXField = new JTextField(String.valueOf(n), 5);
        jPanel.add((Component)this.dimXField, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.dimYField = new JTextField(String.valueOf(n2), 5);
        jPanel.add((Component)this.dimYField, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.iterField = new JTextField(String.valueOf(l), 5);
        jPanel.add((Component)this.iterField, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.alphaField = new JTextField(String.valueOf(f), 5);
        jPanel.add((Component)this.alphaField, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.radiusField = new JTextField(String.valueOf(f2), 5);
        jPanel.add((Component)this.radiusField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1, 0, 10));
        jPanel2.setBorder(new EmptyBorder(5, 25, 15, 10));
        jPanel2.setBackground(Color.white);
        jPanel2.add((Component)new JLabel("Initialization"), "West");
        jPanel2.add((Component)new JLabel("Neighborhood"), "West");
        jPanel2.add((Component)new JLabel("Topology"), "West");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 1, 10, 10));
        jPanel3.setBorder(new EmptyBorder(10, 0, 15, 10));
        jPanel3.setBackground(Color.white);
        this.initList = new JComboBox<String>(new String[]{"Random Vector", "Random Genes"});
        this.initList.setSelectedIndex(n3);
        FontMetrics fontMetrics = this.initList.getFontMetrics(this.initList.getFont());
        int n6 = fontMetrics.stringWidth("Random Samples");
        this.initList.setPreferredSize(new Dimension(n6 + 40, this.initList.getHeight()));
        this.neighbList = new JComboBox<String>(new String[]{"Bubble", "Gaussian"});
        this.neighbList.setSelectedIndex(n4);
        this.neighbList.setPreferredSize(new Dimension(n6, this.initList.getHeight()));
        this.topoList = new JComboBox<String>(new String[]{"Hexagonal", "Rectangular"});
        this.topoList.setSelectedIndex(n5);
        this.initList.setBackground(Color.white);
        this.neighbList.setBackground(Color.white);
        this.topoList.setBackground(Color.white);
        jPanel3.add(this.initList);
        jPanel3.add(this.neighbList);
        jPanel3.add(this.topoList);
        this.hclOpsPanel = new HCLSelectionPanel();
        ParameterPanel parameterPanel = new ParameterPanel();
        parameterPanel.setLayout(new BorderLayout());
        parameterPanel.add((Component)jPanel, "West");
        parameterPanel.add((Component)jPanel2, "Center");
        parameterPanel.add((Component)jPanel3, "East");
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.add((Component)this.sampleSelectionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)this.metricPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)parameterPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)this.hclOpsPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setActionListeners(listener);
        this.addContent(jPanel4);
        this.pack();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public boolean isClusterGenes() {
        return this.sampleSelectionPanel.isClusterGenesSelected();
    }

    public int getDimensionX() {
        return Integer.parseInt(this.dimXField.getText());
    }

    public int getDimensionY() {
        return Integer.parseInt(this.dimYField.getText());
    }

    public long getIterations() {
        return Long.parseLong(this.iterField.getText());
    }

    public float getAlpha() {
        return Float.parseFloat(this.alphaField.getText());
    }

    public float getRadius() {
        return Float.parseFloat(this.radiusField.getText());
    }

    public int getInitType() {
        return this.initList.getSelectedIndex();
    }

    public int getNeighborhood() {
        return this.neighbList.getSelectedIndex();
    }

    public int getTopology() {
        return this.topoList.getSelectedIndex();
    }

    public boolean isHierarchicalTree() {
        return this.hclOpsPanel.isHCLSelected();
    }

    public int getDistanceMetric() {
        return this.metricPanel.getMetricIndex();
    }

    public boolean isAbsoluteDistance() {
        return this.metricPanel.getAbsoluteSelection();
    }

    private void resetControls() {
        this.dimXField.setText("3");
        this.dimYField.setText("3");
        this.iterField.setText("2000");
        this.alphaField.setText("0.05");
        this.radiusField.setText("3.0");
        this.initList.removeItemAt(1);
        this.initList.insertItemAt("Random Genes", 1);
        this.initList.setSelectedIndex(1);
        this.neighbList.setSelectedIndex(1);
        this.topoList.setSelectedIndex(0);
        this.sampleSelectionPanel.setClusterGenesSelected(true);
        this.hclOpsPanel.setHCLSelected(false);
        this.initList.setSelectedIndex(1);
        this.neighbList.setSelectedIndex(1);
        this.topoList.setSelectedIndex(0);
        this.metricPanel.reset();
    }

    private boolean validInput(int n, int n2, long l, float f, float f2) {
        boolean bl = true;
        if (n < 1) {
            JOptionPane.showMessageDialog(this, "x Dimension must be > 0", "Input Error!", 0);
            this.dimXField.requestFocus();
            this.dimXField.selectAll();
            bl = false;
        } else if (n2 < 1) {
            JOptionPane.showMessageDialog(this, "y Dimension must be > 0", "Input Error!", 0);
            this.dimYField.requestFocus();
            this.dimYField.selectAll();
            bl = false;
        } else if (l < 1L) {
            JOptionPane.showMessageDialog(this, "Number of Iterations must be > 0", "Input Error!", 0);
            this.iterField.requestFocus();
            this.iterField.selectAll();
            bl = false;
        } else if (f <= 0.0f) {
            JOptionPane.showMessageDialog(this, "Alpha value must be > 0", "Input Error!", 0);
            this.alphaField.requestFocus();
            this.alphaField.selectAll();
            bl = false;
        } else if (f2 <= 0.0f) {
            JOptionPane.showMessageDialog(this, "Radius value must be > 0", "Input Error!", 0);
            this.radiusField.requestFocus();
            this.radiusField.selectAll();
            bl = false;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        SOMInitDialog sOMInitDialog = new SOMInitDialog(new Frame(), 0, 0, 0L, 0.0f, 0.0f, 1, 0, 0, "Euclidean Distance", false);
        sOMInitDialog.showModal();
        System.exit(0);
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                try {
                    int n = Integer.parseInt(SOMInitDialog.this.dimXField.getText());
                    int n2 = Integer.parseInt(SOMInitDialog.this.dimYField.getText());
                    long l = Long.parseLong(SOMInitDialog.this.iterField.getText());
                    float f = Float.parseFloat(SOMInitDialog.this.alphaField.getText());
                    float f2 = Float.parseFloat(SOMInitDialog.this.radiusField.getText());
                    if (SOMInitDialog.this.validInput(n, n2, l, f, f2)) {
                        SOMInitDialog.this.result = 0;
                        SOMInitDialog.this.dispose();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(SOMInitDialog.this, "Input value " + numberFormatException.getMessage() + " is not valid input. \nPlease enter a new value or view the parameter information help page for this algorithm.", "Input Error!", 0);
                    SOMInitDialog.this.result = 2;
                }
            } else if (string.equals("cancel-command")) {
                SOMInitDialog.this.result = 2;
                SOMInitDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                SOMInitDialog.this.resetControls();
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow(SOMInitDialog.this, "SOM Initialization Dialog");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 600);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.dispose();
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            SOMInitDialog.this.result = -1;
            SOMInitDialog.this.dispose();
        }
    }
}

