/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sota;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLCluster;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLExperimentHeader;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTree;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTACentroidExpressionViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTAConfigDialog;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTATree;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTATreeData;
import org.tigr.util.FloatMatrix;

public class SOTAGeneTreeViewer
extends JPanel
implements IViewer,
Serializable {
    public static final long serialVersionUID = 202017040001L;
    protected static String SET_CLUSTER_CMD = "set-cluster-cmd";
    protected static String SET_CLUSTER_TEXT_CMD = "set-cluster-text-cmd";
    protected static String SAVE_CLUSTER_CMD = "save-cluster-cmd";
    protected static String DELETE_CLUSTER_CMD = "delete-cluster-cmd";
    protected static String DELETE_ALL_CLUSTERS_CMD = "delete-all-clusters-cmd";
    protected static String SOTA_TREE_PROPERTIES_CMD = "gene-tree-properties-cmd";
    protected static String SAMPLE_TREE_PROPERTIES_CMD = "sample-tree-properties-cmd";
    private int numberOfCells;
    private int numberOfSamples;
    private Experiment centroidData;
    private SOTATree sotaTree;
    private FloatMatrix clusterDivFM;
    private int[] clusterPop;
    private int[][] clusterIndices;
    private ArrayList selectedClusterList = new ArrayList();
    private SOTACentroidExpressionViewer expViewer;
    private Dimension elementSize;
    private IFramework framework;
    private IData data;
    private Experiment experiment;
    private HCLExperimentHeader header;
    protected HCLTree sampleTree;
    private int elementHeight;
    private int elementWidth;
    private Listener listener;
    private int function;
    private int currClusterNum = -1;
    private DefaultMutableTreeNode expImageNode;
    private JPopupMenu popup;

    public SOTAGeneTreeViewer(Experiment experiment, SOTATreeData sOTATreeData, Cluster cluster, int[][] nArray) {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        this.listener = new Listener();
        this.clusterPop = sOTATreeData.clusterPopulation;
        this.clusterDivFM = sOTATreeData.clusterDiversity;
        this.clusterIndices = nArray;
        this.function = sOTATreeData.function;
        this.numberOfSamples = experiment.getNumberOfSamples();
        this.numberOfCells = sOTATreeData.clusterPopulation.length;
        this.sotaTree = new SOTATree(sOTATreeData, true);
        if (this.sotaTree != null) {
            this.sotaTree.addMouseListener(this.listener);
        }
        int[] nArray2 = null;
        this.sampleTree = null;
        if (cluster != null) {
            Node node = cluster.getNodeList().getNode(0);
            this.sampleTree = new HCLTree(this.getResult(node, 0), 1);
            nArray2 = this.getLeafOrder(this.getResult(node, 0), null);
            this.sampleTree.addMouseListener(this.listener);
        }
        this.centroidData = new Experiment(sOTATreeData.centroidMatrix, nArray2 != null ? nArray2 : experiment.getColumnIndicesCopy());
        this.numberOfSamples = this.centroidData.getNumberOfSamples();
        this.expViewer = new SOTACentroidExpressionViewer(this.centroidData, null, nArray2, sOTATreeData.clusterPopulation, sOTATreeData.clusterDiversity, this.selectedClusterList);
        this.expViewer.addMouseListener(this.listener);
        this.header = new HCLExperimentHeader(this.expViewer.getHeaderComponent());
        this.header.addMouseListener(this.listener);
        this.addComponents(this.sotaTree, this.expViewer, this.sampleTree);
        this.setLocation(0, 0);
        this.addMouseListener(this.listener);
        this.popup = this.createJPopupMenu(this.listener);
        this.experiment = experiment;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.numberOfCells);
        objectOutputStream.writeInt(this.numberOfSamples);
        objectOutputStream.writeObject(this.centroidData);
        objectOutputStream.writeObject(this.sotaTree);
        objectOutputStream.writeObject(this.clusterDivFM);
        objectOutputStream.writeObject(this.clusterPop);
        objectOutputStream.writeObject(this.clusterIndices);
        objectOutputStream.writeObject(this.selectedClusterList);
        objectOutputStream.writeObject(this.expViewer);
        objectOutputStream.writeObject(this.elementSize);
        objectOutputStream.writeObject(this.experiment);
        objectOutputStream.writeObject(this.header);
        objectOutputStream.writeBoolean(this.sampleTree != null);
        if (this.sampleTree != null) {
            objectOutputStream.writeObject(this.sampleTree);
        }
        objectOutputStream.writeInt(this.elementHeight);
        objectOutputStream.writeInt(this.elementWidth);
        objectOutputStream.writeInt(this.function);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.numberOfCells = objectInputStream.readInt();
        this.numberOfSamples = objectInputStream.readInt();
        this.centroidData = (Experiment)objectInputStream.readObject();
        this.sotaTree = (SOTATree)objectInputStream.readObject();
        this.clusterDivFM = (FloatMatrix)objectInputStream.readObject();
        this.clusterPop = (int[])objectInputStream.readObject();
        this.clusterIndices = (int[][])objectInputStream.readObject();
        this.selectedClusterList = (ArrayList)objectInputStream.readObject();
        this.expViewer = (SOTACentroidExpressionViewer)objectInputStream.readObject();
        this.elementSize = (Dimension)objectInputStream.readObject();
        this.experiment = (Experiment)objectInputStream.readObject();
        this.header = (HCLExperimentHeader)objectInputStream.readObject();
        if (objectInputStream.readBoolean()) {
            this.sampleTree = (HCLTree)objectInputStream.readObject();
        }
        this.elementHeight = objectInputStream.readInt();
        this.elementWidth = objectInputStream.readInt();
        this.function = objectInputStream.readInt();
        this.currClusterNum = -1;
        this.listener = new Listener();
        this.expViewer.addMouseListener(this.listener);
        this.header.addMouseListener(this.listener);
        this.addMouseListener(this.listener);
        this.popup = this.createJPopupMenu(this.listener);
    }

    public void associateExpressionImageNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.expImageNode = defaultMutableTreeNode;
    }

    private HCLTreeData getResult(Node node, int n) {
        HCLTreeData hCLTreeData = new HCLTreeData();
        NodeValueList nodeValueList = node.getValues();
        hCLTreeData.child_1_array = (int[])nodeValueList.getNodeValue((int)n).value;
        hCLTreeData.child_2_array = (int[])nodeValueList.getNodeValue((int)(n + 1)).value;
        hCLTreeData.node_order = (int[])nodeValueList.getNodeValue((int)(n + 2)).value;
        hCLTreeData.height = (float[])nodeValueList.getNodeValue((int)(n + 3)).value;
        return hCLTreeData;
    }

    int[] getSamplesOrder(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    protected void addComponents(JComponent jComponent, JComponent jComponent2, JComponent jComponent3) {
        int n;
        int n2 = n = jComponent3 == null ? 1 : 2;
        if (jComponent3 != null) {
            this.add((Component)jComponent3, new GridBagConstraints(1, n - 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (jComponent != null) {
            this.add((Component)jComponent, new GridBagConstraints(0, n - 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.add((Component)jComponent2, new GridBagConstraints(1, n - 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        this.sotaTree.onMenuChanged(iDisplayMenu);
        this.expViewer.onMenuChanged(iDisplayMenu);
        if (this.sampleTree != null) {
            this.sampleTree.onMenuChanged(iDisplayMenu);
        }
        this.header.setHeaderPosition(this.sotaTree.getTreeHeight() - 10);
        this.header.updateSize(this.getCommonWidth(), this.elementSize.width);
    }

    public void onDeselected() {
    }

    public void onSelected(IFramework iFramework) {
        this.framework = iFramework;
        this.data = iFramework.getData();
        IDisplayMenu iDisplayMenu = iFramework.getDisplayMenu();
        this.elementSize = iDisplayMenu.getElementSize();
        if (this.expViewer.isVisible()) {
            this.expViewer.onSelected(iFramework);
        }
        if (this.sampleTree != null) {
            this.sampleTree.onSelected(iFramework);
        }
        this.sotaTree.onSelected(iFramework);
        this.header.updateSize(this.getCommonWidth(), this.elementSize.width);
        this.verifyClusterExistence(this.data);
        this.verifyClusterMembership(this.data);
        this.header.setHeaderPosition(this.sotaTree.getTreeHeight() - 10);
        if (this.expImageNode == null) {
            DefaultMutableTreeNode defaultMutableTreeNode = iFramework.getCurrentNode();
            if (defaultMutableTreeNode != null) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            }
            if (defaultMutableTreeNode != null) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(1);
            }
            if (defaultMutableTreeNode != null) {
                this.expImageNode = defaultMutableTreeNode;
            }
        }
    }

    public int getCommonWidth() {
        int n = 0;
        if (this.sotaTree != null) {
            n += this.sotaTree.getTreeHeight();
        }
        return n += this.expViewer.getWidth();
    }

    public int getCommonHeight() {
        int n = 0;
        if (this.sotaTree != null) {
            n += this.sotaTree.getTreeWidth();
        }
        return n += this.header.getHeight();
    }

    public void onClosed() {
    }

    public JComponent getContentComponent() {
        return this;
    }

    public BufferedImage getImage() {
        return null;
    }

    public void onDataChanged(IData iData) {
        this.data = iData;
        this.verifyClusterExistence(iData);
    }

    private void verifyClusterExistence(IData iData) {
        Color[] colorArray = iData.getColors();
        if (colorArray.length == 0) {
            this.selectedClusterList.clear();
            this.expViewer.onDataChanged(iData);
        }
    }

    private void verifyClusterMembership(IData iData) {
        int n;
        Color[] colorArray = iData.getColors();
        Color color = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean[] blArray = new boolean[this.selectedClusterList.size()];
        for (n = 0; n < this.selectedClusterList.size(); ++n) {
            HCLCluster hCLCluster = (HCLCluster)this.selectedClusterList.get(n);
            color = hCLCluster.color;
            int n2 = hCLCluster.root;
            bl2 = false;
            for (int i = 0; i < this.clusterIndices[n2].length; ++i) {
                if (color.equals(iData.getProbeColor(this.clusterIndices[n2][i]))) continue;
                bl = true;
                bl2 = true;
                break;
            }
            if (!bl2) continue;
            blArray[n] = true;
        }
        for (n = this.selectedClusterList.size() - 1; n >= 0; --n) {
            if (!blArray[n]) continue;
            this.selectedClusterList.remove(n);
        }
        if (bl) {
            this.expViewer.onDataChanged(iData);
        }
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    private int[] getLeafOrder(HCLTreeData hCLTreeData, int[] nArray) {
        if (hCLTreeData == null || hCLTreeData.node_order.length < 2) {
            return null;
        }
        return this.getLeafOrder(hCLTreeData.node_order, hCLTreeData.child_1_array, hCLTreeData.child_2_array, nArray);
    }

    private int[] getLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int[] nArray5 = new int[nArray.length];
        Arrays.fill(nArray5, -1);
        this.fillLeafOrder(nArray5, nArray2, nArray3, 0, nArray2.length - 2, nArray4);
        return nArray5;
    }

    private int fillLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int[] nArray4) {
        if (nArray2[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray2[n2], nArray4);
        }
        if (nArray3[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray3[n2], nArray4);
        } else {
            nArray[n] = nArray4 == null ? n2 : nArray4[n2];
            ++n;
        }
        return n;
    }

    private Frame getFrame() {
        return JOptionPane.getFrameForComponent(this);
    }

    private void setSOTATreeProperties() {
        Frame frame = JOptionPane.getFrameForComponent(this);
        SOTAConfigDialog sOTAConfigDialog = new SOTAConfigDialog(frame, 0.0f, this.sotaTree.getMinDistance(), this.sotaTree.getMaxDistance());
        if (sOTAConfigDialog.showModal() == 0) {
            this.sotaTree.setProperties(sOTAConfigDialog.getZeroThreshold(), sOTAConfigDialog.getMinDistance(), sOTAConfigDialog.getMaxDistance());
        }
        this.header.updateSize(this.getCommonWidth(), this.elementSize.width);
        this.header.setHeaderPosition(this.sotaTree.getTreeHeight() - 10);
        this.revalidate();
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu, listener);
        return jPopupMenu;
    }

    private void showClusterInfo(int n) {
        int n2 = this.getClosestCentroid(n);
        if (n2 == n) {
            return;
        }
        float f = org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil.geneDistance((FloatMatrix)this.centroidData.getMatrix(), null, (int)n, (int)n2, (int)this.function, (float)1.0f, (boolean)false);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.expImageNode.getChildAt(n);
        if (this.framework != null) {
            this.framework.setTreeNode(defaultMutableTreeNode);
        }
    }

    private int getClosestCentroid(int n) {
        float f = Float.POSITIVE_INFINITY;
        int n2 = n;
        for (int i = 0; i < this.numberOfCells; ++i) {
            float f2 = org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil.geneDistance((FloatMatrix)this.centroidData.getMatrix(), null, (int)n, (int)i, (int)this.function, (float)1.0f, (boolean)false);
            if (!(f2 < f) || i == n) continue;
            f = f2;
            n2 = i;
        }
        return n2;
    }

    private void onSaveCluster(int n) {
        try {
            ExperimentUtil.saveExperiment((Frame)this.getFrame(), (Experiment)this.experiment, (IData)this.data, (int[])this.clusterIndices[n]);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.getFrame(), "Can not save cluster!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSetCluster(int n) {
        Color color = JColorChooser.showDialog(this.getFrame(), "Choose color", new Color(128, 128, 128));
        if (color == null || n == -1) {
            return;
        }
        HCLCluster hCLCluster = new HCLCluster(n, n - 1, n + 1);
        this.selectedClusterList.add(hCLCluster);
        hCLCluster.color = color;
        this.header.updateSize(this.getCommonWidth(), this.elementSize.width);
        this.revalidate();
        this.data.setProbesColor(this.getIDataRowIndices(this.clusterIndices[n]), color);
        this.repaint();
    }

    private int[] getIDataRowIndices(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.experiment.getGeneIndexMappedToData(nArray[i]);
        }
        return nArray2;
    }

    private void onDeleteCluster(int n) {
        for (int i = 0; i < this.selectedClusterList.size(); ++i) {
            HCLCluster hCLCluster = (HCLCluster)this.selectedClusterList.get(i);
            if (hCLCluster.root != n) continue;
            this.data.setProbesColor(this.clusterIndices[n], null);
            this.selectedClusterList.remove(i);
        }
        this.repaint();
    }

    private void onDeleteAllClusters() {
        this.selectedClusterList.clear();
        this.data.deleteColors();
        this.repaint();
    }

    protected void addMenuItems(JPopupMenu jPopupMenu, Listener listener) {
        JMenuItem jMenuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon("save_as16.gif"));
        jMenuItem.setEnabled(false);
        jMenuItem.setActionCommand(SAVE_CLUSTER_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("SOTATree properties...", GUIFactory.getIcon("edit16.gif"));
        jMenuItem.setEnabled(this.sotaTree != null);
        jMenuItem.setActionCommand(SOTA_TREE_PROPERTIES_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
    }

    protected JMenuItem getJMenuItem(String string) {
        Component[] componentArray = this.popup.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JMenuItem) || !((JMenuItem)componentArray[i]).getActionCommand().equals(string)) continue;
            return (JMenuItem)componentArray[i];
        }
        return null;
    }

    protected void setEnableMenuItem(String string, boolean bl) {
        JMenuItem jMenuItem = this.getJMenuItem(string);
        if (jMenuItem == null) {
            return;
        }
        jMenuItem.setEnabled(bl);
    }

    private boolean isClusterSet(int n) {
        for (int i = 0; i < this.selectedClusterList.size(); ++i) {
            HCLCluster hCLCluster = (HCLCluster)this.selectedClusterList.get(i);
            if (hCLCluster.root != n) continue;
            return true;
        }
        return false;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int n) {
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getViewerType() {
        return -1;
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(SOTA_TREE_PROPERTIES_CMD)) {
                SOTAGeneTreeViewer.this.setSOTATreeProperties();
            } else if (string.equals(SET_CLUSTER_CMD)) {
                if (SOTAGeneTreeViewer.this.currClusterNum != -1) {
                    SOTAGeneTreeViewer.this.onSetCluster(SOTAGeneTreeViewer.this.currClusterNum);
                }
            } else if (string.equals(SAVE_CLUSTER_CMD)) {
                if (SOTAGeneTreeViewer.this.currClusterNum != -1) {
                    SOTAGeneTreeViewer.this.onSaveCluster(SOTAGeneTreeViewer.this.currClusterNum);
                }
            } else if (string.equals(DELETE_CLUSTER_CMD)) {
                if (SOTAGeneTreeViewer.this.currClusterNum != -1) {
                    SOTAGeneTreeViewer.this.onDeleteCluster(SOTAGeneTreeViewer.this.currClusterNum);
                }
            } else if (string.equals(DELETE_ALL_CLUSTERS_CMD)) {
                SOTAGeneTreeViewer.this.onDeleteAllClusters();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!this.maybeShowPopup(mouseEvent) && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                SOTAGeneTreeViewer.this.currClusterNum = SOTAGeneTreeViewer.this.expViewer.getCurrentCentroidNumber();
                if (SOTAGeneTreeViewer.this.currClusterNum != -1) {
                    SOTAGeneTreeViewer.this.showClusterInfo(SOTAGeneTreeViewer.this.currClusterNum);
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.maybeShowPopup(mouseEvent) && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                SOTAGeneTreeViewer.this.currClusterNum = SOTAGeneTreeViewer.this.expViewer.getCurrentCentroidNumber();
                if (SOTAGeneTreeViewer.this.currClusterNum != -1) {
                    SOTAGeneTreeViewer.this.showClusterInfo(SOTAGeneTreeViewer.this.currClusterNum);
                }
            }
        }

        private boolean maybeShowPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                return false;
            }
            SOTAGeneTreeViewer.this.currClusterNum = SOTAGeneTreeViewer.this.expViewer.getCurrentCentroidNumber();
            SOTAGeneTreeViewer.this.setEnableMenuItem(SET_CLUSTER_CMD, SOTAGeneTreeViewer.this.currClusterNum != -1);
            SOTAGeneTreeViewer.this.setEnableMenuItem(DELETE_CLUSTER_CMD, SOTAGeneTreeViewer.this.currClusterNum != -1 && SOTAGeneTreeViewer.this.isClusterSet(SOTAGeneTreeViewer.this.currClusterNum));
            SOTAGeneTreeViewer.this.setEnableMenuItem(DELETE_ALL_CLUSTERS_CMD, !SOTAGeneTreeViewer.this.selectedClusterList.isEmpty());
            SOTAGeneTreeViewer.this.setEnableMenuItem(SAVE_CLUSTER_CMD, SOTAGeneTreeViewer.this.currClusterNum != -1);
            SOTAGeneTreeViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            return true;
        }
    }
}

