/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sota;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTATreeData;

public class SOTATree
extends JPanel {
    private int TREE_X_ORIGIN = 10;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int orientation = 0;
    protected Color lineColor = new Color(0, 0, 128);
    protected Color extenderColor = Color.lightGray;
    private int numberOfClusters;
    private double maxLeafToRootPath;
    private int treeHeight;
    int maxXPosition;
    private int maxNodeHeight;
    private int minNodeHeight;
    private int height;
    private int width;
    private int elementHeight = 10;
    private int elementWidth = 20;
    private int paintElementHeight;
    private int FACTOR = 20;
    private int origX;
    private int origY;
    private int utilCounter;
    protected IData data;
    int sign = 1;
    float[] nodeHeights;
    int[] leftChild;
    int[] rightChild;
    int[] nodePopulation;

    public SOTATree(SOTATreeData sOTATreeData, boolean bl) {
        this.setBackground(Color.white);
        if (!bl) {
            this.orientation = 1;
        }
        this.nodeHeights = sOTATreeData.nodeHeights;
        this.leftChild = sOTATreeData.leftChild;
        this.rightChild = sOTATreeData.rightChild;
        this.nodePopulation = sOTATreeData.nodePopulation;
        this.numberOfClusters = this.nodeHeights.length / 2;
        this.maxNodeHeight = 40;
        this.minNodeHeight = 5;
        this.width = this.getTreeHeight();
        this.height = this.getTreeWidth();
        if (this.orientation == 0) {
            this.setSizes(this.width, this.height);
        } else {
            this.setSizes(this.height, this.width);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.TREE_X_ORIGIN);
        objectOutputStream.writeInt(this.orientation);
        objectOutputStream.writeObject(this.lineColor);
        objectOutputStream.writeObject(this.extenderColor);
        objectOutputStream.writeInt(this.numberOfClusters);
        objectOutputStream.writeDouble(this.maxLeafToRootPath);
        objectOutputStream.writeInt(this.treeHeight);
        objectOutputStream.writeInt(this.maxXPosition);
        objectOutputStream.writeInt(this.maxNodeHeight);
        objectOutputStream.writeInt(this.minNodeHeight);
        objectOutputStream.writeInt(this.height);
        objectOutputStream.writeInt(this.width);
        objectOutputStream.writeInt(this.elementHeight);
        objectOutputStream.writeInt(this.elementWidth);
        objectOutputStream.writeInt(this.paintElementHeight);
        objectOutputStream.writeInt(this.FACTOR);
        objectOutputStream.writeInt(this.origX);
        objectOutputStream.writeInt(this.origY);
        objectOutputStream.writeInt(this.utilCounter);
        objectOutputStream.writeInt(this.sign);
        objectOutputStream.writeObject(this.nodeHeights);
        objectOutputStream.writeObject(this.leftChild);
        objectOutputStream.writeObject(this.rightChild);
        objectOutputStream.writeObject(this.nodePopulation);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.TREE_X_ORIGIN = objectInputStream.readInt();
        this.orientation = objectInputStream.readInt();
        this.lineColor = (Color)objectInputStream.readObject();
        this.extenderColor = (Color)objectInputStream.readObject();
        this.numberOfClusters = objectInputStream.readInt();
        this.maxLeafToRootPath = objectInputStream.readDouble();
        this.treeHeight = objectInputStream.readInt();
        this.maxXPosition = objectInputStream.readInt();
        this.maxNodeHeight = objectInputStream.readInt();
        this.minNodeHeight = objectInputStream.readInt();
        this.height = objectInputStream.readInt();
        this.width = objectInputStream.readInt();
        this.elementHeight = objectInputStream.readInt();
        this.elementWidth = objectInputStream.readInt();
        this.paintElementHeight = objectInputStream.readInt();
        this.FACTOR = objectInputStream.readInt();
        this.origX = objectInputStream.readInt();
        this.origY = objectInputStream.readInt();
        this.utilCounter = objectInputStream.readInt();
        this.sign = objectInputStream.readInt();
        this.nodeHeights = (float[])objectInputStream.readObject();
        this.leftChild = (int[])objectInputStream.readObject();
        this.rightChild = (int[])objectInputStream.readObject();
        this.nodePopulation = (int[])objectInputStream.readObject();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.height = this.numberOfClusters * this.elementHeight;
        this.width = this.getTreeHeight();
        this.paintSotaTree(graphics);
    }

    private void paintSotaTree(Graphics graphics) {
        Color color = graphics.getColor();
        this.origX = this.TREE_X_ORIGIN;
        graphics.setColor(this.lineColor);
        this.paintElementHeight = this.elementHeight;
        if (this.orientation == 1) {
            ((Graphics2D)graphics).rotate(-1.5707963267948966);
            this.paintElementHeight = this.elementWidth;
            this.sign = -1;
            this.origY = this.getSubTreeSize(this.rightChild[0]) * this.elementWidth;
            this.paintSotaTree(graphics, 0, this.origX, this.origY + 10);
        } else {
            this.origY = this.getSubTreeSize(this.rightChild[0]) * this.elementHeight;
            this.paintSotaTree(graphics, 0, this.origX, this.origY);
        }
        graphics.setColor(color);
        this.sign = 1;
    }

    private void paintSotaTree(Graphics graphics, int n, int n2, int n3) {
        int n4;
        if (this.nodePopulation[n] == 0) {
            return;
        }
        int n5 = n2;
        int n6 = n4 = n3;
        if (this.leftChild[n] == -1) {
            if ((n5 = (int)((float)n5 + (float)this.FACTOR * this.nodeHeights[n])) - n2 < this.minNodeHeight) {
                n5 = n2 + this.minNodeHeight;
            } else if (n5 - n2 > this.maxNodeHeight) {
                n5 = n2 + this.maxNodeHeight;
            }
            graphics.drawLine(n2 * this.sign, n3, n5 * this.sign, n3);
            graphics.setColor(this.extenderColor);
            graphics.drawLine(n5 * this.sign, n3, this.maxXPosition * this.sign, n3);
            graphics.setColor(this.lineColor);
            return;
        }
        if (n == 0) {
            n5 = n2;
        } else {
            if ((n5 = (int)((float)n5 + (float)this.FACTOR * this.nodeHeights[n])) - n2 < this.minNodeHeight) {
                n5 = n2 + this.minNodeHeight;
            } else if (n5 - n2 > this.maxNodeHeight) {
                n5 = n2 + this.maxNodeHeight;
            }
            this.maxXPosition = this.max(this.maxXPosition, n5);
            graphics.drawLine(n2 * this.sign, n3, n5 * this.sign, n3);
        }
        int n7 = 1;
        int n8 = 1;
        if (this.rightChild[this.leftChild[n]] != -1 && this.nodePopulation[this.rightChild[this.leftChild[n]]] != -1) {
            n7 = this.getSubTreeSize(this.rightChild[this.leftChild[n]]);
            n6 = n3 + (n7 *= this.paintElementHeight);
        } else {
            n6 = n3 + (int)((double)this.paintElementHeight / 2.0);
        }
        if (this.leftChild[this.rightChild[n]] != -1 && this.nodePopulation[this.leftChild[this.rightChild[n]]] != -1) {
            n8 = this.getSubTreeSize(this.leftChild[this.rightChild[n]]);
            n4 = n3 - (n8 *= this.paintElementHeight);
        } else {
            n4 = n3 - (int)((double)this.paintElementHeight / 2.0);
        }
        graphics.drawLine(n5 * this.sign, n3, n5 * this.sign, n6);
        this.paintSotaTree(graphics, this.leftChild[n], n5, n6);
        graphics.drawLine(n5 * this.sign, n3, n5 * this.sign, n4);
        this.paintSotaTree(graphics, this.rightChild[n], n5, n4);
    }

    private int getSubTreeSize(int n) {
        this.utilCounter = 0;
        this.getNumberOfSubtreeNodes(n);
        return this.utilCounter;
    }

    private void getNumberOfSubtreeNodes(int n) {
        if (this.leftChild[n] != -1) {
            this.getNumberOfSubtreeNodes(this.leftChild[n]);
        }
        if (this.rightChild[n] != -1) {
            this.getNumberOfSubtreeNodes(this.rightChild[n]);
        } else {
            ++this.utilCounter;
        }
    }

    private int max(int n, int n2) {
        if (n > n2) {
            return n;
        }
        return n2;
    }

    public int getTreeWidth() {
        return this.elementHeight * this.numberOfClusters;
    }

    public int getTreeHeight() {
        this.maxXPosition = this.TREE_X_ORIGIN;
        this.getTreeHeight(0, this.TREE_X_ORIGIN);
        return this.maxXPosition;
    }

    private void getTreeHeight(int n, int n2) {
        if (n < 0) {
            return;
        }
        int n3 = n2;
        if (this.leftChild[n] == -1) {
            if ((n3 = (int)((float)n3 + (float)this.FACTOR * this.nodeHeights[n])) - n2 < this.minNodeHeight) {
                n3 = n2 + this.minNodeHeight;
            } else if (n3 - n2 > this.maxNodeHeight) {
                n3 = n2 + this.maxNodeHeight;
            }
            this.maxXPosition = this.max(this.maxXPosition, n3);
            return;
        }
        if (n == 0) {
            n3 = n2;
        } else {
            if ((n3 = (int)((float)n3 + (float)this.FACTOR * this.nodeHeights[n])) - n2 < this.minNodeHeight) {
                n3 = n2 + this.minNodeHeight;
            } else if (n3 - n2 > this.maxNodeHeight) {
                n3 = n2 + this.maxNodeHeight;
            }
            this.maxXPosition = this.max(this.maxXPosition, n3);
        }
        this.getTreeHeight(this.leftChild[n], n3);
        this.getTreeHeight(this.rightChild[n], n3);
    }

    public void onSelected(IFramework iFramework) {
        this.data = iFramework.getData();
        this.updateSize(iFramework.getDisplayMenu().getElementSize());
        this.repaint();
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        this.updateSize(iDisplayMenu.getElementSize());
    }

    private void updateSize(Dimension dimension) {
        this.elementHeight = dimension.height;
        this.elementWidth = dimension.width;
        switch (this.orientation) {
            case 0: {
                if (this.elementHeight == dimension.height) {
                    return;
                }
                this.elementHeight = dimension.height;
                this.setSizes(this.getTreeHeight(), this.elementHeight * this.numberOfClusters);
                break;
            }
            case 1: {
                if (this.elementWidth == dimension.width) {
                    return;
                }
                this.elementWidth = dimension.width;
                this.setSizes(this.elementWidth * this.numberOfClusters, this.getTreeHeight());
            }
        }
    }

    private void setSizes(int n, int n2) {
        this.setSize(n, n2);
        this.setPreferredSize(new Dimension(n, n2));
    }

    public int getMinDistance() {
        return this.minNodeHeight;
    }

    public int getMaxDistance() {
        return this.maxNodeHeight;
    }

    public void setProperties(float f, int n, int n2) {
        this.minNodeHeight = n;
        this.maxNodeHeight = n2;
        this.treeHeight = this.getTreeHeight();
        if (this.orientation == 0) {
            this.setSizes(this.getTreeHeight(), this.getTreeWidth());
        } else {
            this.setSizes(this.getTreeWidth(), this.getTreeHeight());
        }
    }
}

