/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.tfa;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.tfa.TFACentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.tfa.TFACentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.tfa.TFAExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.tfa.TFAInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.tfa.TFAInitBox1;
import org.tigr.microarray.mev.cluster.gui.impl.tfa.TFAInitBox2;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class TFAGUI
implements IClusterGUI,
IScriptGUI {
    public static final int JUST_ALPHA = 4;
    public static final int STD_BONFERRONI = 5;
    public static final int ADJ_BONFERRONI = 6;
    public static final int MAX_T = 9;
    public static final int MIN_P = 10;
    private Algorithm algorithm;
    private Progress progress;
    private Experiment experiment;
    private IData data;
    private int[][] clusters;
    private FloatMatrix means;
    private FloatMatrix variances;
    Vector exptNamesVector;
    String[] factorNames;
    int[] numFactorLevels;
    int[] factorAAssignments;
    int[] factorBAssignments;
    private Object[][] auxData;
    private String[] auxTitles;
    String[] clusterLabels;
    private boolean usePerms;
    private boolean drawSigTreesOnly;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        DefaultMutableTreeNode defaultMutableTreeNode;
        block18: {
            Object object;
            IDistanceMenu iDistanceMenu;
            int n;
            this.experiment = iFramework.getData().getExperiment();
            this.data = iFramework.getData();
            int n2 = this.experiment.getNumberOfSamples();
            int n3 = this.experiment.getNumberOfGenes();
            this.exptNamesVector = new Vector();
            for (int i = 0; i < n2; ++i) {
                this.exptNamesVector.add(iFramework.getData().getFullSampleName(this.experiment.getSampleIndex(i)));
            }
            TFAInitBox1 tFAInitBox1 = new TFAInitBox1((JFrame)iFramework.getFrame(), true);
            tFAInitBox1.setVisible(true);
            if (!tFAInitBox1.isOkPressed()) {
                return null;
            }
            this.factorNames = new String[2];
            this.numFactorLevels = new int[2];
            this.factorNames[0] = tFAInitBox1.getFactorAName();
            this.factorNames[1] = tFAInitBox1.getFactorBName();
            String[] stringArray = new String[]{this.factorNames[0] + " significant", this.factorNames[1] + " significant", "Interaction signficant", this.factorNames[0] + " non-significant", this.factorNames[1] + " non-significant", "Interaction non-signficant", "Non-significant for all effects"};
            this.clusterLabels = new String[stringArray.length];
            for (int i = 0; i < this.clusterLabels.length; ++i) {
                this.clusterLabels[i] = stringArray[i];
            }
            this.numFactorLevels[0] = tFAInitBox1.getNumFactorALevels();
            this.numFactorLevels[1] = tFAInitBox1.getNumFactorBLevels();
            TFAInitBox2 tFAInitBox2 = new TFAInitBox2((JFrame)iFramework.getFrame(), true, this.exptNamesVector, this.factorNames, this.numFactorLevels);
            tFAInitBox2.setVisible(true);
            if (!tFAInitBox2.isOkPressed()) {
                return null;
            }
            boolean bl = tFAInitBox2.allCellsHaveOneSample();
            boolean bl2 = tFAInitBox2.drawTrees();
            this.drawSigTreesOnly = true;
            if (bl2) {
                this.drawSigTreesOnly = tFAInitBox2.drawSigTreesOnly();
            }
            int n4 = tFAInitBox2.getAdjustmentMethod();
            float f = tFAInitBox2.getAlpha();
            this.factorAAssignments = tFAInitBox2.getFactorAAssignments();
            this.factorBAssignments = tFAInitBox2.getFactorBAssignments();
            Object[][] objectArray = tFAInitBox2.getBothFactorAssignments();
            boolean bl3 = false;
            if (!bl) {
                bl3 = tFAInitBox2.isBalancedDesign();
            }
            this.usePerms = tFAInitBox2.usePerms();
            int n5 = 0;
            if (this.usePerms) {
                n5 = tFAInitBox2.getNumPerms();
            }
            if ((n = (iDistanceMenu = iFramework.getDistanceMenu()).getDistanceFunction()) == 0) {
                n = 4;
            }
            int n6 = 0;
            boolean bl4 = false;
            boolean bl5 = false;
            int n7 = 4;
            boolean bl6 = false;
            if (bl2) {
                object = new HCLInitDialog(iFramework.getFrame(), iDistanceMenu.getFunctionName(n), iDistanceMenu.isAbsoluteDistance(), true);
                if (((HCLInitDialog)object).showModal() != 0) {
                    return null;
                }
                n6 = ((HCLInitDialog)object).getMethod();
                bl4 = ((HCLInitDialog)object).isClusterExperiments();
                bl5 = ((HCLInitDialog)object).isClusterGenes();
                n7 = ((HCLInitDialog)object).getDistanceMetric();
                bl6 = ((HCLInitDialog)object).getAbsoluteSelection();
            }
            object = new Listener();
            try {
                this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("TFA");
                this.algorithm.addAlgorithmListener((AlgorithmListener)object);
                int n8 = this.experiment.getNumberOfGenes();
                this.progress = new Progress(iFramework.getFrame(), "Finding significant genes", (DialogListener)object);
                this.progress.show();
                AlgorithmData algorithmData = new AlgorithmData();
                algorithmData.addMatrix("experiment", this.experiment.getMatrix());
                algorithmData.addParam("distance-factor", String.valueOf(1.0f));
                algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
                algorithmData.addParam("distance-function", String.valueOf(n));
                algorithmData.addIntArray("numFactorLevels", this.numFactorLevels);
                algorithmData.addParam("allCellsHaveOneSample", String.valueOf(bl));
                algorithmData.addParam("adjustmentMethod", String.valueOf(n4));
                algorithmData.addParam("alpha", String.valueOf(f));
                algorithmData.addIntArray("factorAAssignments", this.factorAAssignments);
                algorithmData.addIntArray("factorBAssignments", this.factorBAssignments);
                algorithmData.addObjectMatrix("bothFactorAssignments", objectArray);
                algorithmData.addParam("isBalancedDesign", String.valueOf(bl3));
                algorithmData.addParam("usePerms", String.valueOf(this.usePerms));
                algorithmData.addParam("numPerms", String.valueOf(n5));
                if (bl2) {
                    algorithmData.addParam("hierarchical-tree", String.valueOf(true));
                    algorithmData.addParam("draw-sig-trees-only", String.valueOf(this.drawSigTreesOnly));
                    algorithmData.addParam("method-linkage", String.valueOf(n6));
                    algorithmData.addParam("calculate-genes", String.valueOf(bl5));
                    algorithmData.addParam("calculate-experiments", String.valueOf(bl4));
                    algorithmData.addParam("hcl-distance-function", String.valueOf(n7));
                    algorithmData.addParam("hcl-distance-absolute", String.valueOf(bl6));
                }
                long l = System.currentTimeMillis();
                AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
                long l2 = System.currentTimeMillis() - l;
                Cluster cluster = algorithmData2.getCluster("cluster");
                NodeList nodeList = cluster.getNodeList();
                int n9 = 7;
                this.clusters = new int[n9][];
                for (int i = 0; i < n9; ++i) {
                    this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
                }
                this.means = algorithmData2.getMatrix("clusters_means");
                this.variances = algorithmData2.getMatrix("clusters_variances");
                FloatMatrix floatMatrix = algorithmData2.getMatrix("factorAFValuesMatrix");
                FloatMatrix floatMatrix2 = algorithmData2.getMatrix("factorBFValuesMatrix");
                FloatMatrix floatMatrix3 = algorithmData2.getMatrix("interactionFValuesMatrix");
                FloatMatrix floatMatrix4 = algorithmData2.getMatrix("factorADfValuesMatrix");
                FloatMatrix floatMatrix5 = algorithmData2.getMatrix("factorBDfValuesMatrix");
                FloatMatrix floatMatrix6 = algorithmData2.getMatrix("interactionDfValuesMatrix");
                FloatMatrix floatMatrix7 = algorithmData2.getMatrix("errorDfValuesMatrix");
                FloatMatrix floatMatrix8 = algorithmData2.getMatrix("origFactorAPValuesMatrix");
                FloatMatrix floatMatrix9 = algorithmData2.getMatrix("origFactorBPValuesMatrix");
                FloatMatrix floatMatrix10 = algorithmData2.getMatrix("origInteractionPValuesMatrix");
                FloatMatrix floatMatrix11 = algorithmData2.getMatrix("adjFactorAPValuesMatrix");
                FloatMatrix floatMatrix12 = algorithmData2.getMatrix("adjFactorBPValuesMatrix");
                FloatMatrix floatMatrix13 = algorithmData2.getMatrix("adjInteractionPValuesMatrix");
                this.auxTitles = new String[13];
                this.auxTitles[0] = "Adj. p-values (" + this.factorNames[0] + ")";
                this.auxTitles[1] = "Adj. p-values (" + this.factorNames[1] + ")";
                this.auxTitles[2] = "Adj. p-values (interaction)";
                this.auxTitles[3] = "Orig. p-values (" + this.factorNames[0] + ")";
                this.auxTitles[4] = "Orig. p-values (" + this.factorNames[1] + ")";
                this.auxTitles[5] = "Orig. p-values (interaction)";
                this.auxTitles[6] = "F-ratio (" + this.factorNames[0] + ")";
                this.auxTitles[7] = "F-ratio (" + this.factorNames[1] + ")";
                this.auxTitles[8] = "F-ratio (interaction)";
                this.auxTitles[9] = "df (" + this.factorNames[0] + ")";
                this.auxTitles[10] = "df (" + this.factorNames[1] + ")";
                this.auxTitles[11] = "df (interaction)";
                this.auxTitles[12] = "df (error)";
                this.auxData = new Object[floatMatrix.A.length][13];
                for (int i = 0; i < this.auxData.length; ++i) {
                    this.auxData[i][0] = new Float(floatMatrix11.A[i][0]);
                    this.auxData[i][1] = new Float(floatMatrix12.A[i][0]);
                    this.auxData[i][2] = new Float(floatMatrix13.A[i][0]);
                    this.auxData[i][3] = new Float(floatMatrix8.A[i][0]);
                    this.auxData[i][4] = new Float(floatMatrix9.A[i][0]);
                    this.auxData[i][5] = new Float(floatMatrix10.A[i][0]);
                    this.auxData[i][6] = new Float(floatMatrix.A[i][0]);
                    this.auxData[i][7] = new Float(floatMatrix2.A[i][0]);
                    this.auxData[i][8] = new Float(floatMatrix3.A[i][0]);
                    this.auxData[i][9] = new Integer((int)floatMatrix4.A[i][0]);
                    this.auxData[i][10] = new Integer((int)floatMatrix5.A[i][0]);
                    this.auxData[i][11] = new Integer((int)floatMatrix6.A[i][0]);
                    this.auxData[i][12] = new Integer((int)floatMatrix7.A[i][0]);
                }
                GeneralInfo generalInfo = new GeneralInfo();
                generalInfo.time = l2;
                generalInfo.alpha = f;
                generalInfo.adjMethod = this.getAdjMethod(n4);
                generalInfo.pValueBasedOn = this.getPValueBasedOn(this.usePerms);
                if (this.usePerms) {
                    generalInfo.numPerms = n5;
                }
                generalInfo.function = iDistanceMenu.getFunctionName(n);
                generalInfo.hcl = bl2;
                generalInfo.hcl_genes = bl5;
                generalInfo.hcl_samples = bl4;
                generalInfo.hcl_method = n6;
                defaultMutableTreeNode = this.createResultTree(cluster, generalInfo);
                Object var48_49 = null;
                if (this.algorithm == null) break block18;
            }
            catch (Throwable throwable) {
                block19: {
                    Object var48_50 = null;
                    if (this.algorithm != null) {
                        this.algorithm.removeAlgorithmListener((AlgorithmListener)object);
                    }
                    if (this.progress == null) break block19;
                    this.progress.dispose();
                }
                throw throwable;
            }
            this.algorithm.removeAlgorithmListener((AlgorithmListener)object);
        }
        if (this.progress != null) {
            this.progress.dispose();
        }
        return defaultMutableTreeNode;
    }

    public AlgorithmData getScriptParameters(IFramework iFramework) {
        IDistanceMenu iDistanceMenu;
        int n;
        this.experiment = iFramework.getData().getExperiment();
        this.data = iFramework.getData();
        int n2 = this.experiment.getNumberOfSamples();
        int n3 = this.experiment.getNumberOfGenes();
        this.exptNamesVector = new Vector();
        for (int i = 0; i < n2; ++i) {
            this.exptNamesVector.add(iFramework.getData().getFullSampleName(this.experiment.getSampleIndex(i)));
        }
        TFAInitBox1 tFAInitBox1 = new TFAInitBox1((JFrame)iFramework.getFrame(), true);
        tFAInitBox1.setVisible(true);
        if (!tFAInitBox1.isOkPressed()) {
            return null;
        }
        this.factorNames = new String[2];
        this.numFactorLevels = new int[2];
        this.factorNames[0] = tFAInitBox1.getFactorAName();
        this.factorNames[1] = tFAInitBox1.getFactorBName();
        String[] stringArray = new String[]{this.factorNames[0] + " significant", this.factorNames[1] + " significant", "Interaction signficant", this.factorNames[0] + " non-significant", this.factorNames[1] + " non-significant", "Interaction non-signficant", "Non-significant for all effects"};
        this.clusterLabels = new String[stringArray.length];
        for (int i = 0; i < this.clusterLabels.length; ++i) {
            this.clusterLabels[i] = stringArray[i];
        }
        this.numFactorLevels[0] = tFAInitBox1.getNumFactorALevels();
        this.numFactorLevels[1] = tFAInitBox1.getNumFactorBLevels();
        TFAInitBox2 tFAInitBox2 = new TFAInitBox2((JFrame)iFramework.getFrame(), true, this.exptNamesVector, this.factorNames, this.numFactorLevels);
        tFAInitBox2.setVisible(true);
        if (!tFAInitBox2.isOkPressed()) {
            return null;
        }
        boolean bl = tFAInitBox2.allCellsHaveOneSample();
        boolean bl2 = tFAInitBox2.drawTrees();
        this.drawSigTreesOnly = true;
        if (bl2) {
            this.drawSigTreesOnly = tFAInitBox2.drawSigTreesOnly();
        }
        int n4 = tFAInitBox2.getAdjustmentMethod();
        float f = tFAInitBox2.getAlpha();
        this.factorAAssignments = tFAInitBox2.getFactorAAssignments();
        this.factorBAssignments = tFAInitBox2.getFactorBAssignments();
        Object[][] objectArray = tFAInitBox2.getBothFactorAssignments();
        boolean bl3 = false;
        if (!bl) {
            bl3 = tFAInitBox2.isBalancedDesign();
        }
        this.usePerms = tFAInitBox2.usePerms();
        int n5 = 0;
        if (this.usePerms) {
            n5 = tFAInitBox2.getNumPerms();
        }
        if ((n = (iDistanceMenu = iFramework.getDistanceMenu()).getDistanceFunction()) == 0) {
            n = 4;
        }
        int n6 = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        int n7 = 4;
        boolean bl6 = false;
        if (bl2) {
            HCLInitDialog hCLInitDialog = new HCLInitDialog(iFramework.getFrame(), iDistanceMenu.getFunctionName(n), iDistanceMenu.isAbsoluteDistance(), true);
            if (hCLInitDialog.showModal() != 0) {
                return null;
            }
            n6 = hCLInitDialog.getMethod();
            bl4 = hCLInitDialog.isClusterExperiments();
            bl5 = hCLInitDialog.isClusterGenes();
            n7 = hCLInitDialog.getDistanceMetric();
            bl6 = hCLInitDialog.getAbsoluteSelection();
        }
        int n8 = this.experiment.getNumberOfGenes();
        AlgorithmData algorithmData = new AlgorithmData();
        algorithmData.addStringArray("cluster-labels", this.clusterLabels);
        algorithmData.addStringArray("factor-names", this.factorNames);
        algorithmData.addParam("distance-factor", String.valueOf(1.0f));
        algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
        algorithmData.addParam("distance-function", String.valueOf(n));
        algorithmData.addIntArray("numFactorLevels", this.numFactorLevels);
        algorithmData.addParam("allCellsHaveOneSample", String.valueOf(bl));
        algorithmData.addParam("adjustmentMethod", String.valueOf(n4));
        algorithmData.addParam("alpha", String.valueOf(f));
        algorithmData.addIntArray("factorAAssignments", this.factorAAssignments);
        algorithmData.addIntArray("factorBAssignments", this.factorBAssignments);
        algorithmData.addObjectMatrix("bothFactorAssignments", objectArray);
        algorithmData.addParam("isBalancedDesign", String.valueOf(bl3));
        algorithmData.addParam("usePerms", String.valueOf(this.usePerms));
        algorithmData.addParam("numPerms", String.valueOf(n5));
        if (bl2) {
            algorithmData.addParam("hierarchical-tree", String.valueOf(true));
            algorithmData.addParam("draw-sig-trees-only", String.valueOf(this.drawSigTreesOnly));
            algorithmData.addParam("method-linkage", String.valueOf(n6));
            algorithmData.addParam("calculate-genes", String.valueOf(bl5));
            algorithmData.addParam("calculate-experiments", String.valueOf(bl4));
            algorithmData.addParam("hcl-distance-function", String.valueOf(n7));
            algorithmData.addParam("hcl-distance-absolute", String.valueOf(bl6));
        }
        algorithmData.addParam("name", "2 Fact. ANOVA");
        algorithmData.addParam("alg-type", "cluster-genes");
        algorithmData.addParam("output-class", "partition-output");
        algorithmData.addStringArray("output-nodes", this.clusterLabels);
        return algorithmData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework iFramework, AlgorithmData algorithmData, Experiment experiment) throws AlgorithmException {
        DefaultMutableTreeNode defaultMutableTreeNode;
        block9: {
            this.experiment = experiment;
            this.data = iFramework.getData();
            this.exptNamesVector = new Vector();
            for (int i = 0; i < this.data.getFeaturesCount(); ++i) {
                this.exptNamesVector.add(iFramework.getData().getFullSampleName(i));
            }
            this.clusterLabels = algorithmData.getStringArray("cluster-labels");
            this.factorNames = algorithmData.getStringArray("factor-names");
            this.factorAAssignments = algorithmData.getIntArray("factorAAssignments");
            this.factorBAssignments = algorithmData.getIntArray("factorBAssignments");
            this.drawSigTreesOnly = algorithmData.getParams().getBoolean("draw-sig-trees-only");
            algorithmData.addMatrix("experiment", experiment.getMatrix());
            Listener listener = new Listener();
            try {
                this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("TFA");
                this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
                int n = experiment.getNumberOfGenes();
                this.progress = new Progress(iFramework.getFrame(), "Finding significant genes", listener);
                this.progress.show();
                long l = System.currentTimeMillis();
                AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
                long l2 = System.currentTimeMillis() - l;
                Cluster cluster = algorithmData2.getCluster("cluster");
                NodeList nodeList = cluster.getNodeList();
                int n2 = 7;
                this.clusters = new int[n2][];
                for (int i = 0; i < n2; ++i) {
                    this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
                }
                this.means = algorithmData2.getMatrix("clusters_means");
                this.variances = algorithmData2.getMatrix("clusters_variances");
                FloatMatrix floatMatrix = algorithmData2.getMatrix("factorAFValuesMatrix");
                FloatMatrix floatMatrix2 = algorithmData2.getMatrix("factorBFValuesMatrix");
                FloatMatrix floatMatrix3 = algorithmData2.getMatrix("interactionFValuesMatrix");
                FloatMatrix floatMatrix4 = algorithmData2.getMatrix("factorADfValuesMatrix");
                FloatMatrix floatMatrix5 = algorithmData2.getMatrix("factorBDfValuesMatrix");
                FloatMatrix floatMatrix6 = algorithmData2.getMatrix("interactionDfValuesMatrix");
                FloatMatrix floatMatrix7 = algorithmData2.getMatrix("errorDfValuesMatrix");
                FloatMatrix floatMatrix8 = algorithmData2.getMatrix("origFactorAPValuesMatrix");
                FloatMatrix floatMatrix9 = algorithmData2.getMatrix("origFactorBPValuesMatrix");
                FloatMatrix floatMatrix10 = algorithmData2.getMatrix("origInteractionPValuesMatrix");
                FloatMatrix floatMatrix11 = algorithmData2.getMatrix("adjFactorAPValuesMatrix");
                FloatMatrix floatMatrix12 = algorithmData2.getMatrix("adjFactorBPValuesMatrix");
                FloatMatrix floatMatrix13 = algorithmData2.getMatrix("adjInteractionPValuesMatrix");
                this.auxTitles = new String[13];
                this.auxTitles[0] = "Adj. p-values (" + this.factorNames[0] + ")";
                this.auxTitles[1] = "Adj. p-values (" + this.factorNames[1] + ")";
                this.auxTitles[2] = "Adj. p-values (interaction)";
                this.auxTitles[3] = "Orig. p-values (" + this.factorNames[0] + ")";
                this.auxTitles[4] = "Orig. p-values (" + this.factorNames[1] + ")";
                this.auxTitles[5] = "Orig. p-values (interaction)";
                this.auxTitles[6] = "F-ratio (" + this.factorNames[0] + ")";
                this.auxTitles[7] = "F-ratio (" + this.factorNames[1] + ")";
                this.auxTitles[8] = "F-ratio (interaction)";
                this.auxTitles[9] = "df (" + this.factorNames[0] + ")";
                this.auxTitles[10] = "df (" + this.factorNames[1] + ")";
                this.auxTitles[11] = "df (interaction)";
                this.auxTitles[12] = "df (error)";
                this.auxData = new Object[floatMatrix.A.length][13];
                for (int i = 0; i < this.auxData.length; ++i) {
                    this.auxData[i][0] = new Float(floatMatrix11.A[i][0]);
                    this.auxData[i][1] = new Float(floatMatrix12.A[i][0]);
                    this.auxData[i][2] = new Float(floatMatrix13.A[i][0]);
                    this.auxData[i][3] = new Float(floatMatrix8.A[i][0]);
                    this.auxData[i][4] = new Float(floatMatrix9.A[i][0]);
                    this.auxData[i][5] = new Float(floatMatrix10.A[i][0]);
                    this.auxData[i][6] = new Float(floatMatrix.A[i][0]);
                    this.auxData[i][7] = new Float(floatMatrix2.A[i][0]);
                    this.auxData[i][8] = new Float(floatMatrix3.A[i][0]);
                    this.auxData[i][9] = new Integer((int)floatMatrix4.A[i][0]);
                    this.auxData[i][10] = new Integer((int)floatMatrix5.A[i][0]);
                    this.auxData[i][11] = new Integer((int)floatMatrix6.A[i][0]);
                    this.auxData[i][12] = new Integer((int)floatMatrix7.A[i][0]);
                }
                AlgorithmParameters algorithmParameters = algorithmData.getParams();
                GeneralInfo generalInfo = new GeneralInfo();
                generalInfo.time = l2;
                generalInfo.alpha = algorithmParameters.getFloat("alpha");
                generalInfo.adjMethod = this.getAdjMethod(algorithmParameters.getInt("adjustmentMethod"));
                generalInfo.pValueBasedOn = this.getPValueBasedOn(algorithmParameters.getBoolean("usePerms"));
                if (this.usePerms) {
                    generalInfo.numPerms = algorithmParameters.getInt("numPerms");
                }
                int n3 = algorithmParameters.getInt("distance-function");
                generalInfo.function = iFramework.getDistanceMenu().getFunctionName(n3);
                generalInfo.hcl = algorithmParameters.getBoolean("hierarchical-tree");
                generalInfo.hcl_genes = algorithmParameters.getBoolean("calculate-genes");
                generalInfo.hcl_samples = algorithmParameters.getBoolean("calculate-experiments");
                if (generalInfo.hcl) {
                    generalInfo.hcl_method = algorithmParameters.getInt("method-linkage");
                }
                defaultMutableTreeNode = this.createResultTree(cluster, generalInfo);
                Object var32_32 = null;
                if (this.algorithm == null) break block9;
            }
            catch (Throwable throwable) {
                block10: {
                    Object var32_33 = null;
                    if (this.algorithm != null) {
                        this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
                    }
                    if (this.progress == null) break block10;
                    this.progress.dispose();
                }
                throw throwable;
            }
            this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
        }
        if (this.progress != null) {
            this.progress.dispose();
        }
        return defaultMutableTreeNode;
    }

    private String getPValueBasedOn(boolean bl) {
        String string = "";
        string = bl ? "permutation" : "F-distribution";
        return string;
    }

    private String getAdjMethod(int n) {
        String string = "";
        if (n == 4) {
            string = "None";
        } else if (n == 5) {
            string = "Standard Bonferroni correction";
        } else if (n == 6) {
            string = "Adjusted Bonferroni correction";
        } else if (n == 10) {
            string = "Step-down Westfall Young: Min P";
        } else if (n == 9) {
            string = "Step-down Westfall Young: Max T";
        }
        return string;
    }

    private DefaultMutableTreeNode createResultTree(Cluster cluster, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Two-factor ANOVA");
        this.addResultNodes(defaultMutableTreeNode, cluster, generalInfo);
        return defaultMutableTreeNode;
    }

    private void addResultNodes(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        this.addExpressionImages(defaultMutableTreeNode);
        this.addHierarchicalTrees(defaultMutableTreeNode, cluster, generalInfo);
        this.addCentroidViews(defaultMutableTreeNode);
        this.addClusterInfo(defaultMutableTreeNode);
        this.addTableViews(defaultMutableTreeNode);
        this.addGeneralInfo(defaultMutableTreeNode, generalInfo);
    }

    private void addExpressionImages(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Expression Images");
        TFAExperimentViewer tFAExperimentViewer = new TFAExperimentViewer(this.experiment, this.clusters, this.auxTitles, this.auxData);
        for (int i = 0; i < this.clusters.length; ++i) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo(this.clusterLabels[i], (IViewer)tFAExperimentViewer, (Object)new Integer(i))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addTableViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Table views");
        ClusterTableViewer clusterTableViewer = new ClusterTableViewer(this.experiment, this.clusters, this.data, this.auxTitles, this.auxData);
        for (int i = 0; i < this.clusters.length; ++i) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo(this.clusterLabels[i], (IViewer)clusterTableViewer, (Object)new Integer(i))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addHierarchicalTrees(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        if (!generalInfo.hcl) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = cluster.getNodeList();
        if (!this.drawSigTreesOnly) {
            for (int i = 0; i < nodeList.getSize(); ++i) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo(this.clusterLabels[i], this.createHCLViewer(nodeList.getNode(i), generalInfo))));
            }
        } else {
            for (int i = 0; i < nodeList.getSize(); ++i) {
                if (i > 2) continue;
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo(this.clusterLabels[i], this.createHCLViewer(nodeList.getNode(i), generalInfo))));
            }
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private IViewer createHCLViewer(Node node, GeneralInfo generalInfo) {
        HCLTreeData hCLTreeData;
        HCLTreeData hCLTreeData2 = hCLTreeData = generalInfo.hcl_genes ? this.getResult(node, 0) : null;
        HCLTreeData hCLTreeData3 = generalInfo.hcl_samples ? this.getResult(node, generalInfo.hcl_genes ? 4 : 0) : null;
        return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData, hCLTreeData3);
    }

    private void addCentroidViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Expression Graphs");
        TFACentroidViewer tFACentroidViewer = new TFACentroidViewer(this.experiment, this.clusters, this.auxTitles, this.auxData);
        tFACentroidViewer.setMeans(this.means.A);
        tFACentroidViewer.setVariances(this.variances.A);
        for (int i = 0; i < this.clusters.length; ++i) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo(this.clusterLabels[i], (IViewer)tFACentroidViewer, (Object)new CentroidUserObject(i, 0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo(this.clusterLabels[i], (IViewer)tFACentroidViewer, (Object)new CentroidUserObject(i, 1))));
        }
        TFACentroidsViewer tFACentroidsViewer = new TFACentroidsViewer(this.experiment, this.clusters, this.auxTitles, this.auxData);
        tFACentroidsViewer.setMeans(this.means.A);
        tFACentroidsViewer.setVariances(this.variances.A);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)tFACentroidsViewer, (Object)new Integer(0))));
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)tFACentroidsViewer, (Object)new Integer(1))));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
    }

    private HCLTreeData getResult(Node node, int n) {
        HCLTreeData hCLTreeData = new HCLTreeData();
        NodeValueList nodeValueList = node.getValues();
        hCLTreeData.child_1_array = (int[])nodeValueList.getNodeValue((int)n).value;
        hCLTreeData.child_2_array = (int[])nodeValueList.getNodeValue((int)(n + 1)).value;
        hCLTreeData.node_order = (int[])nodeValueList.getNodeValue((int)(n + 2)).value;
        hCLTreeData.height = (float[])nodeValueList.getNodeValue((int)(n + 3)).value;
        return hCLTreeData;
    }

    private void addClusterInfo(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Cluster Information");
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Results (#,%)", (IViewer)new TFAInfoViewer(this.clusters, this.experiment.getNumberOfGenes(), this.factorNames))));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addGeneralInfo(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        defaultMutableTreeNode2.add(this.getGroupAssignmentInfo());
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Alpha (overall threshold p-value): " + generalInfo.alpha));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("P-values based on: " + generalInfo.pValueBasedOn));
        if (this.usePerms) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Number of permutations per gene: " + generalInfo.numPerms));
        }
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("P-value adjustment: " + generalInfo.adjMethod));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("HCL: " + generalInfo.getMethodName()));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Time: " + String.valueOf(generalInfo.time) + " ms"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(generalInfo.function));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private DefaultMutableTreeNode getGroupAssignmentInfo() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Factor Assignments");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.factorNames[0]);
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(this.factorNames[1]);
        for (int i = 0; i < this.exptNamesVector.size(); ++i) {
            if (this.factorAAssignments[i] != 0) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i) + ": Group " + this.factorAAssignments[i]));
            } else {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i) + ": Unassigned"));
            }
            if (this.factorBAssignments[i] != 0) {
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i) + ": Group " + this.factorBAssignments[i]));
                continue;
            }
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i) + ": Unassigned"));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        return defaultMutableTreeNode;
    }

    private class GeneralInfo {
        public int clusters;
        public String adjMethod;
        public String pValueBasedOn;
        public float alpha;
        public int numPerms;
        public long time;
        public String function;
        private boolean hcl;
        private int hcl_method;
        private boolean hcl_genes;
        private boolean hcl_samples;

        private GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
            switch (algorithmEvent.getId()) {
                case 1: {
                    TFAGUI.this.progress.setUnits(algorithmEvent.getIntValue());
                    TFAGUI.this.progress.setDescription(algorithmEvent.getDescription());
                    break;
                }
                case 2: {
                    TFAGUI.this.progress.setValue(algorithmEvent.getIntValue());
                    TFAGUI.this.progress.setDescription(algorithmEvent.getDescription());
                    break;
                }
                case 3: {
                    int n = algorithmEvent.getIntValue();
                    if (n != -1) break;
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                TFAGUI.this.algorithm.abort();
                TFAGUI.this.progress.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            TFAGUI.this.algorithm.abort();
            TFAGUI.this.progress.dispose();
        }
    }
}

