/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.tfa;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSigOnlyPanel;
import org.tigr.util.StringSplitter;

public class TFAInitBox2
extends AlgorithmDialog {
    public static final int JUST_ALPHA = 4;
    public static final int STD_BONFERRONI = 5;
    public static final int ADJ_BONFERRONI = 6;
    public static final int MAX_T = 9;
    public static final int MIN_P = 10;
    boolean okPressed = false;
    private boolean oneSamplePerCell = false;
    Vector exptNames;
    String[] factorNames;
    int[] numFactorLevels;
    GroupExptsPanel gPanel;
    PValuePanel pPanel;
    PValueAdjustmentPanel pAdjPanel;
    HCLSigOnlyPanel hclOpsPanel;

    public TFAInitBox2(JFrame jFrame, boolean bl, Vector vector, String[] stringArray, int[] nArray) {
        super(jFrame, "Two-factor ANOVA Initialization", bl);
        this.exptNames = vector;
        this.factorNames = stringArray;
        this.numFactorLevels = nArray;
        this.setBounds(0, 0, 800, 720);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this.gPanel = new GroupExptsPanel();
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 80);
        gridBagLayout.setConstraints(this.gPanel, gridBagConstraints);
        jPanel.add(this.gPanel);
        this.pPanel = new PValuePanel();
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 8);
        gridBagLayout.setConstraints(this.pPanel, gridBagConstraints);
        jPanel.add(this.pPanel);
        this.pAdjPanel = new PValueAdjustmentPanel();
        this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 0, 8);
        gridBagLayout.setConstraints(this.pAdjPanel, gridBagConstraints);
        jPanel.add(this.pAdjPanel);
        this.hclOpsPanel = new HCLSigOnlyPanel();
        this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 0, 4);
        gridBagLayout.setConstraints(this.hclOpsPanel, gridBagConstraints);
        jPanel.add(this.hclOpsPanel);
        this.addContent(jPanel);
        EventListener eventListener = new EventListener();
        this.setActionListeners(eventListener);
        this.addWindowListener(eventListener);
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public boolean allCellsHaveOneSample() {
        return this.oneSamplePerCell;
    }

    public boolean usePerms() {
        return this.pPanel.permutButton.isSelected();
    }

    public float getAlpha() {
        return Float.parseFloat(this.pPanel.alphaInputField.getText());
    }

    public int getNumPerms() {
        return Integer.parseInt(this.pPanel.timesField.getText());
    }

    public boolean isBalancedDesign() {
        int n;
        int n2;
        boolean bl = true;
        Vector[][] vectorArray = this.getBothFactorAssignments();
        int[] nArray = new int[vectorArray.length * vectorArray[0].length];
        int n3 = 0;
        for (n2 = 0; n2 < vectorArray.length; ++n2) {
            for (n = 0; n < vectorArray[n2].length; ++n) {
                nArray[n3] = vectorArray[n2][n].size();
                ++n3;
            }
        }
        n2 = nArray[0];
        for (n = 1; n < nArray.length; ++n) {
            if (nArray[n] == n2) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public int getAdjustmentMethod() {
        if (this.pAdjPanel.justAlphaButton.isSelected()) {
            return 4;
        }
        if (this.pAdjPanel.stdBonfButton.isSelected()) {
            return 5;
        }
        if (this.pAdjPanel.adjBonfButton.isSelected()) {
            return 6;
        }
        if (this.pAdjPanel.maxTButton.isSelected()) {
            return 9;
        }
        if (this.pAdjPanel.minPButton.isSelected()) {
            return 10;
        }
        return -1;
    }

    public boolean drawTrees() {
        return this.hclOpsPanel.isHCLSelected();
    }

    public boolean drawSigTreesOnly() {
        return this.hclOpsPanel.drawSigTreesOnly();
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public void setVisible(boolean bl) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        super.setVisible(bl);
        if (bl) {
            // empty if block
        }
    }

    public int[] getFactorAAssignments() {
        return this.gPanel.factorAPanel.getGroupAssignments();
    }

    public int[] getFactorBAssignments() {
        return this.gPanel.factorBPanel.getGroupAssignments();
    }

    public Vector[][] getBothFactorAssignments() {
        Vector[][] vectorArray = new Vector[this.numFactorLevels[0]][this.numFactorLevels[1]];
        for (int i = 0; i < vectorArray.length; ++i) {
            for (int j = 0; j < vectorArray[i].length; ++j) {
                vectorArray[i][j] = new Vector();
            }
        }
        int[] nArray = this.getFactorAAssignments();
        int[] nArray2 = this.getFactorBAssignments();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0 || nArray2[i] == 0) continue;
            vectorArray[nArray[i] - 1][nArray2[i] - 1].add(new Integer(i));
        }
        return vectorArray;
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                int n;
                int n2;
                Vector[][] vectorArray = TFAInitBox2.this.getBothFactorAssignments();
                int[] nArray = new int[vectorArray.length * vectorArray[0].length];
                int n3 = 0;
                for (n2 = 0; n2 < vectorArray.length; ++n2) {
                    for (n = 0; n < vectorArray[n2].length; ++n) {
                        nArray[n3] = vectorArray[n2][n].size();
                        ++n3;
                    }
                }
                if (nArray[0] == 1) {
                    n2 = 1;
                    for (n = 1; n < nArray.length; ++n) {
                        if (nArray[n] == 1) continue;
                        n2 = 0;
                        break;
                    }
                    if (n2 == 0) {
                        JOptionPane.showMessageDialog(null, "All factor combinations must contain more than one sample, or else they must all contain exactly one sample each", "Error", 0);
                        TFAInitBox2.this.okPressed = false;
                        return;
                    }
                    TFAInitBox2.this.oneSamplePerCell = true;
                } else {
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        if (nArray[n2] >= 2) continue;
                        JOptionPane.showMessageDialog(null, "All factor combinations must contain more than one sample, or else they must all contain exactly one sample each", "Error", 0);
                        TFAInitBox2.this.okPressed = false;
                        return;
                    }
                }
                if (TFAInitBox2.this.usePerms()) {
                    try {
                        n2 = TFAInitBox2.this.getNumPerms();
                        if (n2 <= 0) {
                            JOptionPane.showMessageDialog(null, "Number of permutations should be an integer > 0", "Error", 0);
                            TFAInitBox2.this.okPressed = false;
                            return;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        JOptionPane.showMessageDialog(null, "Number of permutations should be an integer > 0", "Error", 0);
                        TFAInitBox2.this.okPressed = false;
                        return;
                    }
                }
                try {
                    float f = TFAInitBox2.this.getAlpha();
                    if (f <= 0.0f || f >= 1.0f) {
                        JOptionPane.showMessageDialog(null, "Critical p-value should be between 0 and 1", "Error", 0);
                        TFAInitBox2.this.okPressed = false;
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(null, "Critical p-value should be between 0 and 1", "Error", 0);
                    TFAInitBox2.this.okPressed = false;
                    return;
                }
                TFAInitBox2.this.okPressed = true;
                TFAInitBox2.this.hide();
                TFAInitBox2.this.dispose();
            } else {
                if (string.equals("reset-command")) {
                    TFAInitBox2.this.okPressed = false;
                    TFAInitBox2.this.gPanel.reset();
                    return;
                }
                if (string.equals("cancel-command")) {
                    TFAInitBox2.this.okPressed = false;
                    TFAInitBox2.this.setVisible(false);
                    TFAInitBox2.this.dispose();
                } else if (string.equals("info-command")) {
                    // empty if block
                }
            }
        }
    }

    class PValueAdjustmentPanel
    extends JPanel {
        JRadioButton minPButton;
        JRadioButton maxTButton;
        JRadioButton justAlphaButton;
        JRadioButton stdBonfButton;
        JRadioButton adjBonfButton;

        PValueAdjustmentPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(1), "Alpha Corrections", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            ButtonGroup buttonGroup = new ButtonGroup();
            this.justAlphaButton = new JRadioButton("just alpha (no correction)", true);
            this.justAlphaButton.setFocusPainted(false);
            this.justAlphaButton.setForeground(UIManager.getColor("Label.foreground"));
            this.justAlphaButton.setBackground(Color.white);
            buttonGroup.add(this.justAlphaButton);
            this.stdBonfButton = new JRadioButton("standard Bonferroni correction", false);
            this.stdBonfButton.setEnabled(false);
            this.stdBonfButton.setFocusPainted(false);
            this.stdBonfButton.setForeground(UIManager.getColor("Label.foreground"));
            this.stdBonfButton.setBackground(Color.white);
            buttonGroup.add(this.stdBonfButton);
            this.adjBonfButton = new JRadioButton("adjusted Bonferroni correction", false);
            this.adjBonfButton.setEnabled(false);
            this.adjBonfButton.setFocusPainted(false);
            this.adjBonfButton.setForeground(UIManager.getColor("Label.foreground"));
            this.adjBonfButton.setBackground(Color.white);
            buttonGroup.add(this.adjBonfButton);
            this.minPButton = new JRadioButton("minP", false);
            this.minPButton.setEnabled(false);
            this.minPButton.setFocusPainted(false);
            this.minPButton.setForeground(UIManager.getColor("Label.foreground"));
            this.minPButton.setBackground(Color.white);
            buttonGroup.add(this.minPButton);
            this.maxTButton = new JRadioButton("maxT", false);
            this.maxTButton.setEnabled(false);
            this.maxTButton.setFocusPainted(false);
            this.maxTButton.setForeground(UIManager.getColor("Label.foreground"));
            this.maxTButton.setBackground(Color.white);
            buttonGroup.add(this.maxTButton);
            TFAInitBox2.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 33, 50);
            gridBagLayout.setConstraints(this.justAlphaButton, gridBagConstraints);
            this.add(this.justAlphaButton);
            TFAInitBox2.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 33, 0);
            gridBagLayout.setConstraints(this.stdBonfButton, gridBagConstraints);
            this.add(this.stdBonfButton);
            TFAInitBox2.this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 34, 0);
            gridBagLayout.setConstraints(this.adjBonfButton, gridBagConstraints);
            this.add(this.adjBonfButton);
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Color.white);
            jPanel.setBorder(new EtchedBorder());
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            jPanel.setLayout(gridBagLayout2);
            JLabel jLabel = new JLabel("Step-down Westfall and Young methods (for permutations only): ");
            TFAInitBox2.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 34, 100);
            gridBagLayout2.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            TFAInitBox2.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 33, 0);
            gridBagLayout2.setConstraints(this.minPButton, gridBagConstraints);
            jPanel.add(this.minPButton);
            TFAInitBox2.this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 33, 0);
            gridBagLayout2.setConstraints(this.maxTButton, gridBagConstraints);
            jPanel.add(this.maxTButton);
            TFAInitBox2.this.buildConstraints(gridBagConstraints, 0, 1, 3, 1, 100, 50);
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.add(jPanel);
        }
    }

    class PValuePanel
    extends JPanel {
        JRadioButton tDistButton;
        JRadioButton permutButton;
        JLabel numPermsLabel;
        JTextField timesField;
        JTextField alphaInputField;

        PValuePanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(1), "P-Value Parameters", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            ButtonGroup buttonGroup = new ButtonGroup();
            this.tDistButton = new JRadioButton("p-values based on F-distribution", true);
            this.tDistButton.setFocusPainted(false);
            this.tDistButton.setForeground(UIManager.getColor("Label.foreground"));
            this.tDistButton.setBackground(Color.white);
            this.numPermsLabel = new JLabel("Enter number of permutations");
            this.numPermsLabel.setEnabled(false);
            this.timesField = new JTextField("1000", 7);
            this.timesField.setEnabled(false);
            this.timesField.setBackground(Color.darkGray);
            this.tDistButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ PValuePanel this$1;
                {
                    this.this$1 = pValuePanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.numPermsLabel.setEnabled(false);
                    this.this$1.timesField.setEnabled(false);
                    this.this$1.timesField.setBackground(Color.darkGray);
                    PValuePanel.access$100((PValuePanel)this.this$1).pAdjPanel.maxTButton.setEnabled(false);
                    PValuePanel.access$100((PValuePanel)this.this$1).pAdjPanel.minPButton.setEnabled(false);
                }
            });
            buttonGroup.add(this.tDistButton);
            this.permutButton = new JRadioButton("p-values based on permutation:  ", false);
            this.permutButton.setFocusPainted(false);
            this.permutButton.setForeground(UIManager.getColor("Label.foreground"));
            this.permutButton.setBackground(Color.white);
            this.permutButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ PValuePanel this$1;
                {
                    this.this$1 = pValuePanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.numPermsLabel.setEnabled(true);
                    this.this$1.timesField.setEnabled(true);
                    this.this$1.timesField.setBackground(Color.white);
                }
            });
            buttonGroup.add(this.permutButton);
            TFAInitBox2.this.buildConstraints(gridBagConstraints, 0, 0, 3, 1, 100, 30);
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.tDistButton, gridBagConstraints);
            this.add(this.tDistButton);
            TFAInitBox2.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 30, 30);
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.permutButton, gridBagConstraints);
            this.add(this.permutButton);
            TFAInitBox2.this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 30, 0);
            gridBagLayout.setConstraints(this.numPermsLabel, gridBagConstraints);
            this.add(this.numPermsLabel);
            TFAInitBox2.this.buildConstraints(gridBagConstraints, 2, 1, 1, 1, 40, 0);
            gridBagLayout.setConstraints(this.timesField, gridBagConstraints);
            this.add(this.timesField);
            JLabel jLabel = new JLabel("Enter critical p-value");
            TFAInitBox2.this.buildConstraints(gridBagConstraints, 0, 2, 2, 1, 60, 40);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            this.alphaInputField = new JTextField("0.01", 7);
            TFAInitBox2.this.buildConstraints(gridBagConstraints, 1, 2, 1, 1, 40, 0);
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.alphaInputField, gridBagConstraints);
            this.add(this.alphaInputField);
        }

        static /* synthetic */ TFAInitBox2 access$100(PValuePanel pValuePanel) {
            return pValuePanel.TFAInitBox2.this;
        }
    }

    class MultiGroupExperimentsPanel
    extends JPanel {
        JLabel[] expLabels;
        JRadioButton[][] exptGroupRadioButtons;
        JRadioButton[] notInGroupRadioButtons;
        int numGroups;

        MultiGroupExperimentsPanel(String string, int n) {
            int n2;
            this.setBorder(new TitledBorder(new EtchedBorder(), string + " assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.numGroups = n;
            this.setBackground(Color.white);
            JPanel jPanel = new JPanel();
            this.expLabels = new JLabel[TFAInitBox2.this.exptNames.size()];
            this.exptGroupRadioButtons = new JRadioButton[n][TFAInitBox2.this.exptNames.size()];
            this.notInGroupRadioButtons = new JRadioButton[TFAInitBox2.this.exptNames.size()];
            ButtonGroup[] buttonGroupArray = new ButtonGroup[TFAInitBox2.this.exptNames.size()];
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout2);
            jPanel.setLayout(gridBagLayout);
            for (n2 = 0; n2 < TFAInitBox2.this.exptNames.size(); ++n2) {
                int n3;
                String string2 = (String)TFAInitBox2.this.exptNames.get(n2);
                this.expLabels[n2] = new JLabel(string2);
                buttonGroupArray[n2] = new ButtonGroup();
                for (n3 = 0; n3 < n; ++n3) {
                    this.exptGroupRadioButtons[n3][n2] = new JRadioButton("Group " + (n3 + 1) + "     ", n3 == 0);
                    buttonGroupArray[n2].add(this.exptGroupRadioButtons[n3][n2]);
                }
                this.notInGroupRadioButtons[n2] = new JRadioButton("Not in groups", false);
                buttonGroupArray[n2].add(this.notInGroupRadioButtons[n2]);
                for (n3 = 0; n3 < n; ++n3) {
                    TFAInitBox2.this.buildConstraints(gridBagConstraints, n3, n2, 1, 1, 100, 100);
                    gridBagLayout.setConstraints(this.exptGroupRadioButtons[n3][n2], gridBagConstraints);
                    jPanel.add(this.exptGroupRadioButtons[n3][n2]);
                }
                TFAInitBox2.this.buildConstraints(gridBagConstraints, n + 1, n2, 1, 1, 100, 100);
                gridBagLayout.setConstraints(this.notInGroupRadioButtons[n2], gridBagConstraints);
                jPanel.add(this.notInGroupRadioButtons[n2]);
            }
            n2 = 0;
            for (int i = 0; i < this.expLabels.length; ++i) {
                if (!(this.expLabels[i].getPreferredSize().getWidth() > (double)n2)) continue;
                n2 = (int)Math.ceil(this.expLabels[i].getPreferredSize().getWidth());
            }
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setHorizontalScrollBarPolicy(32);
            jScrollPane.setVerticalScrollBarPolicy(22);
            JPanel jPanel2 = new JPanel();
            GridBagLayout gridBagLayout3 = new GridBagLayout();
            jPanel2.setSize(50, jPanel.getPreferredSize().height);
            jPanel2.setPreferredSize(new Dimension(n2 + 10, jPanel.getPreferredSize().height));
            jPanel2.setLayout(gridBagLayout3);
            for (int i = 0; i < this.expLabels.length; ++i) {
                TFAInitBox2.this.buildConstraints(gridBagConstraints, 0, i, 1, 1, 100, 100);
                gridBagConstraints.fill = 1;
                gridBagLayout3.setConstraints(this.expLabels[i], gridBagConstraints);
                jPanel2.add(this.expLabels[i]);
            }
            jScrollPane.setRowHeaderView(jPanel2);
            TFAInitBox2.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 100);
            gridBagConstraints.fill = 1;
            gridBagLayout2.setConstraints(jScrollPane, gridBagConstraints);
            this.add(jScrollPane);
        }

        public void reset() {
            for (int i = 0; i < TFAInitBox2.this.exptNames.size(); ++i) {
                this.exptGroupRadioButtons[0][i].setSelected(true);
            }
        }

        public int[] getGroupAssignments() {
            int n;
            int[] nArray = new int[TFAInitBox2.this.exptNames.size()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = 0;
            }
            block1: for (n = 0; n < nArray.length; ++n) {
                for (int i = 0; i < this.numGroups; ++i) {
                    if (!this.exptGroupRadioButtons[i][n].isSelected()) continue;
                    nArray[n] = i + 1;
                    continue block1;
                }
            }
            return nArray;
        }

        public void setGroupAssignments(int[] nArray) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == 0) {
                    this.notInGroupRadioButtons[i].setSelected(true);
                    continue;
                }
                this.exptGroupRadioButtons[nArray[i] - 1][i].setSelected(true);
            }
        }
    }

    class GroupExptsPanel
    extends JPanel {
        MultiGroupExperimentsPanel factorAPanel;
        MultiGroupExperimentsPanel factorBPanel;
        JPanel panel2;

        GroupExptsPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "Group Assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            this.factorAPanel = new MultiGroupExperimentsPanel(TFAInitBox2.this.factorNames[0], TFAInitBox2.this.numFactorLevels[0]);
            this.factorBPanel = new MultiGroupExperimentsPanel(TFAInitBox2.this.factorNames[1], TFAInitBox2.this.numFactorLevels[1]);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            TFAInitBox2.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50, 90);
            gridBagConstraints.fill = 1;
            gridBagLayout.setConstraints(this.factorAPanel, gridBagConstraints);
            this.add(this.factorAPanel);
            TFAInitBox2.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50, 0);
            gridBagConstraints.fill = 1;
            gridBagLayout.setConstraints(this.factorBPanel, gridBagConstraints);
            this.add(this.factorBPanel);
            JPanel jPanel = new JPanel();
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            jPanel.setLayout(gridBagLayout2);
            jPanel.setBackground(Color.white);
            JButton jButton = new JButton("  Save settings  ");
            jButton.setFocusPainted(false);
            jButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
            JButton jButton2 = new JButton("  Load settings  ");
            jButton2.setFocusPainted(false);
            jButton2.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
            JButton jButton3 = new JButton("  Reset  ");
            jButton3.setFocusPainted(false);
            jButton3.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
            jButton3.addActionListener(new ActionListener(this){
                private final /* synthetic */ GroupExptsPanel this$1;
                {
                    this.this$1 = groupExptsPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.factorAPanel.reset();
                    this.this$1.factorBPanel.reset();
                }
            });
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(new File("Data"));
            jButton.addActionListener(new ActionListener(this, jFileChooser, TFAInitBox2.this){
                private final /* synthetic */ JFileChooser val$fc;
                private final /* synthetic */ TFAInitBox2 val$this$0;
                private final /* synthetic */ GroupExptsPanel this$1;
                {
                    this.this$1 = groupExptsPanel;
                    this.val$fc = jFileChooser;
                    this.val$this$0 = tFAInitBox2;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = this.val$fc.showSaveDialog(this.this$1);
                    if (n == 0) {
                        File file = this.val$fc.getSelectedFile();
                        try {
                            int n2;
                            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                            int[] nArray = this.this$1.factorAPanel.getGroupAssignments();
                            int[] nArray2 = this.this$1.factorBPanel.getGroupAssignments();
                            for (n2 = 0; n2 < nArray.length; ++n2) {
                                printWriter.print(nArray[n2]);
                                if (n2 >= nArray.length - 1) continue;
                                printWriter.print("\t");
                            }
                            printWriter.println();
                            for (n2 = 0; n2 < nArray2.length; ++n2) {
                                printWriter.print(nArray2[n2]);
                                if (n2 >= nArray2.length - 1) continue;
                                printWriter.print("\t");
                            }
                            printWriter.println();
                            printWriter.flush();
                            printWriter.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            jButton2.addActionListener(new ActionListener(this, jFileChooser, TFAInitBox2.this){
                private final /* synthetic */ JFileChooser val$fc;
                private final /* synthetic */ TFAInitBox2 val$this$0;
                private final /* synthetic */ GroupExptsPanel this$1;
                {
                    this.this$1 = groupExptsPanel;
                    this.val$fc = jFileChooser;
                    this.val$this$0 = tFAInitBox2;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = this.val$fc.showOpenDialog(this.this$1);
                    if (n == 0) {
                        try {
                            Object object;
                            FileReader fileReader = new FileReader(this.val$fc.getSelectedFile());
                            BufferedReader bufferedReader = new BufferedReader(fileReader);
                            String string = bufferedReader.readLine();
                            StringSplitter stringSplitter = new StringSplitter('\t');
                            stringSplitter.init(string);
                            Vector<Integer> vector = new Vector<Integer>();
                            Vector<Integer> vector2 = new Vector<Integer>();
                            while (stringSplitter.hasMoreTokens()) {
                                object = stringSplitter.nextToken();
                                vector.add(new Integer((String)object));
                            }
                            string = bufferedReader.readLine();
                            stringSplitter.init(string);
                            while (stringSplitter.hasMoreTokens()) {
                                object = stringSplitter.nextToken();
                                vector2.add(new Integer((String)object));
                            }
                            bufferedReader.close();
                            object = this.this$1.factorAPanel.getGroupAssignments();
                            int[] nArray = this.this$1.factorBPanel.getGroupAssignments();
                            if (vector.size() != ((Object)object).length || vector2.size() != nArray.length) {
                                JOptionPane.showMessageDialog(GroupExptsPanel.access$000((GroupExptsPanel)this.this$1).gPanel, "Incompatible file!", "Error", 2);
                            } else {
                                int[] nArray2 = new int[vector.size()];
                                int[] nArray3 = new int[vector2.size()];
                                for (int i = 0; i < nArray2.length; ++i) {
                                    nArray2[i] = (Integer)vector.get(i);
                                    nArray3[i] = (Integer)vector2.get(i);
                                }
                                this.this$1.factorAPanel.setGroupAssignments(nArray2);
                                this.this$1.factorBPanel.setGroupAssignments(nArray3);
                            }
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(GroupExptsPanel.access$000((GroupExptsPanel)this.this$1).gPanel, "Incompatible file!", "Error", 2);
                            this.this$1.factorAPanel.reset();
                            this.this$1.factorBPanel.reset();
                        }
                    }
                }
            });
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            TFAInitBox2.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 33, 100);
            gridBagLayout2.setConstraints(jButton, gridBagConstraints);
            jPanel.add(jButton);
            TFAInitBox2.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 33, 0);
            gridBagLayout2.setConstraints(jButton2, gridBagConstraints);
            jPanel.add(jButton2);
            TFAInitBox2.this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 34, 0);
            gridBagLayout2.setConstraints(jButton3, gridBagConstraints);
            jPanel.add(jButton3);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            TFAInitBox2.this.buildConstraints(gridBagConstraints, 0, 1, 2, 1, 100, 5);
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.add(jPanel);
        }

        public void reset() {
            this.factorAPanel.reset();
            this.factorBPanel.reset();
        }

        static /* synthetic */ TFAInitBox2 access$000(GroupExptsPanel groupExptsPanel) {
            return groupExptsPanel.TFAInitBox2.this;
        }
    }
}

