/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.db.Index;
import org.biojava.bio.seq.db.IndexStore;
import org.biojava.bio.seq.db.SimpleIndex;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.utils.NestedError;
import org.biojava.utils.OverlayMap;

public class TabIndexStore
implements IndexStore,
Serializable {
    private transient Map idToIndex;
    private transient Map commited;
    private transient Map uncommited;
    private final File storeFile;
    private final File indexFile;
    private final String name;
    private final Set files;
    private File[] seqFileIndex;
    private final SequenceFormat format;
    private final SequenceBuilderFactory sbFactory;
    private final SymbolTokenization symbolParser;

    public static TabIndexStore open(File storeFile) throws IOException {
        try {
            FileInputStream fis = new FileInputStream(storeFile);
            ObjectInputStream p = new ObjectInputStream(fis);
            TabIndexStore indxStore = (TabIndexStore)p.readObject();
            fis.close();
            return indxStore;
        }
        catch (ClassNotFoundException cnfe) {
            throw new NestedError(cnfe, "Assertion Failure: How did we get here?");
        }
    }

    public TabIndexStore(File storeFile, File indexFile, String name, SequenceFormat format, SequenceBuilderFactory sbFactory, SymbolTokenization symbolParser) throws IOException, BioException {
        if (storeFile.exists() || indexFile.exists()) {
            throw new BioException("Files already exist");
        }
        this.storeFile = storeFile.getAbsoluteFile();
        this.indexFile = indexFile.getAbsoluteFile();
        this.name = name;
        this.format = format;
        this.sbFactory = sbFactory;
        this.symbolParser = symbolParser;
        this.files = new HashSet();
        this.seqFileIndex = new File[0];
        this.commited = new HashMap();
        this.uncommited = new HashMap();
        this.idToIndex = new OverlayMap(this.commited, this.uncommited);
        this.commit();
    }

    public void store(Index indx) throws IllegalIDException, BioException {
        if (this.idToIndex.containsKey(indx.getID())) {
            throw new IllegalIDException("ID already in use: '" + indx.getID() + "'");
        }
        this.addFile(indx.getFile());
        this.uncommited.put(indx.getID(), indx);
    }

    public Index fetch(String id) throws IllegalIDException, BioException {
        Index indx = (Index)this.idToIndex.get(id);
        if (indx == null) {
            throw new IllegalIDException("No Index known for id '" + id + "'");
        }
        return indx;
    }

    public void commit() throws BioException {
        try {
            PrintWriter out = new PrintWriter(new FileWriter(this.indexFile.toString(), true));
            Iterator i = this.uncommited.values().iterator();
            while (i.hasNext()) {
                Index indx = (Index)i.next();
                out.println(this.getFileIndex(indx.getFile()) + "\t" + indx.getStart() + "\t" + indx.getID());
            }
            this.commitStore();
            out.close();
            this.commited.putAll(this.uncommited);
            this.uncommited.clear();
        }
        catch (IOException ioe) {
            throw new BioException(ioe, "Failed to commit");
        }
    }

    public void rollback() {
        this.uncommited.clear();
    }

    public String getName() {
        return this.name;
    }

    public Set getIDs() {
        return Collections.unmodifiableSet(this.idToIndex.keySet());
    }

    public Set getFiles() {
        return Collections.unmodifiableSet(this.files);
    }

    public SequenceFormat getFormat() {
        return this.format;
    }

    public SequenceBuilderFactory getSBFactory() {
        return this.sbFactory;
    }

    public SymbolTokenization getSymbolParser() {
        return this.symbolParser;
    }

    protected void commitStore() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.storeFile);
        ObjectOutputStream p = new ObjectOutputStream(fos);
        p.writeObject(this);
        p.flush();
        fos.close();
    }

    protected void addFile(File f) {
        if (!this.files.contains(f)) {
            int len = this.seqFileIndex.length;
            this.files.add(f);
            File[] sfi = new File[len + 1];
            System.arraycopy(this.seqFileIndex, 0, sfi, 0, len);
            sfi[len] = f;
            this.seqFileIndex = sfi;
        }
    }

    protected int getFileIndex(File file) {
        int pos = this.seqFileIndex.length - 1;
        while (pos >= 0) {
            File f = this.seqFileIndex[pos];
            if (f == file || file.equals(f)) {
                return pos;
            }
            --pos;
        }
        throw new IndexOutOfBoundsException("Index not found for File '" + file + "'");
    }

    protected void initialize() throws IOException {
        if (this.indexFile.exists()) {
            BufferedReader reader = new BufferedReader(new FileReader(this.indexFile));
            String line = reader.readLine();
            while (line != null) {
                StringTokenizer stok = new StringTokenizer(line);
                int fileNum = Integer.parseInt(stok.nextToken());
                long start = Long.parseLong(stok.nextToken());
                String id = stok.nextToken();
                SimpleIndex index = new SimpleIndex(this.seqFileIndex[fileNum], start, -1, id);
                this.commited.put(id, index);
                line = reader.readLine();
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.commited = new HashMap();
        this.uncommited = new HashMap();
        this.idToIndex = new OverlayMap(this.commited, this.uncommited);
        this.initialize();
    }
}

