/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm;

import java.util.NoSuchElementException;
import org.biojava.stats.svm.SVMKernel;

public class SVMRegressionModel {
    private SVMKernel kernel;
    private double threshold;
    private double[][] kvals;
    private Object[] vectors;
    private double[] alphas;
    private double[] alphaStars;
    private int size;

    public SVMRegressionModel() {
        this(100);
    }

    public SVMRegressionModel(int capacity) {
        this.vectors = new Object[capacity];
        this.alphas = new double[capacity];
        this.alphaStars = new double[capacity];
        this.size = 0;
    }

    public SVMKernel getKernel() {
        return this.kernel;
    }

    public void setKernel(SVMKernel k) {
        this.kernel = k;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double t) {
        this.threshold = t;
    }

    public void addVector(Object v, double alpha, double alphaStar) {
        if (this.size + 1 >= this.vectors.length) {
            Object[] nVectors = new Object[this.vectors.length * 2];
            System.arraycopy(this.vectors, 0, nVectors, 0, this.size);
            this.vectors = nVectors;
            double[] nAlphas = new double[this.alphas.length * 2];
            System.arraycopy(this.alphas, 0, nAlphas, 0, this.size);
            this.alphas = nAlphas;
            double[] nAlphaStars = new double[this.alphaStars.length * 2];
            System.arraycopy(this.alphaStars, 0, nAlphaStars, 0, this.size);
        }
        this.vectors[this.size] = v;
        this.alphas[this.size] = alpha;
        this.alphaStars[this.size] = alphaStar;
        ++this.size;
    }

    public void addVector(Object v) {
        this.addVector(v, 0.0, 0.0);
    }

    public int size() {
        return this.size;
    }

    public Object getVector(int pos) {
        if (pos >= this.size) {
            throw new NoSuchElementException();
        }
        return this.vectors[pos];
    }

    public double getAlpha(int pos) {
        if (pos >= this.size) {
            throw new NoSuchElementException();
        }
        System.out.println("retrieving alpha " + pos + "=" + this.alphas[pos]);
        return this.alphas[pos];
    }

    public void setAlpha(int pos, double a) {
        if (pos >= this.size) {
            throw new NoSuchElementException();
        }
        this.alphas[pos] = a;
        System.out.println("setting alpha " + pos + "=" + this.alphas[pos]);
    }

    public double getAlphaStar(int pos) {
        if (pos >= this.size) {
            throw new NoSuchElementException();
        }
        System.out.println("retrieving alpha* " + pos + "=" + this.alphaStars[pos]);
        return this.alphaStars[pos];
    }

    public void setAlphaStar(int pos, double a) {
        if (pos >= this.size) {
            throw new NoSuchElementException();
        }
        this.alphaStars[pos] = a;
        System.out.println("setting alpha* " + pos + "=" + this.alphaStars[pos]);
    }

    public double classify(Object v) {
        double delta = 0.0;
        int i = 0;
        while (i < this.size) {
            double a = this.alphas[i] - this.alphaStars[i];
            if (a != 0.0) {
                delta += a * this.kernel.evaluate(this.vectors[i], v);
            }
            ++i;
        }
        return delta + this.threshold;
    }

    public double internalClassify(int obj) {
        double delta = 0.0;
        int i = 0;
        while (i < this.size) {
            double a = this.alphas[i] - this.alphaStars[i];
            delta += a * this.kvals[i][obj];
            ++i;
        }
        return delta + this.threshold;
    }

    public void calcKernel() {
        this.kvals = new double[this.size][this.size];
        int i = 0;
        while (i < this.size) {
            int j = 0;
            while (j < i) {
                double d = this.kernel.evaluate(this.vectors[i], this.vectors[j]);
                this.kvals[j][i] = d;
                this.kvals[i][j] = d;
                ++j;
            }
            this.kvals[i][i] = this.kernel.evaluate(this.vectors[i], this.vectors[i]);
            System.out.print(".");
            ++i;
        }
    }

    public double getKernelValue(int i, int j) {
        return this.kvals[i][j];
    }
}

