/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.tables;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import org.biolegato.main.BLMain;
import org.biolegato.main.DataCanvas;
import org.biolegato.tables.CSVFile;
import org.biolegato.tables.TSVFile;

public class TableCanvas
extends JScrollPane
implements DataCanvas {
    DefaultTableModel tableModel = new DefaultTableModel();
    JTable tablePane = new JTable(this.tableModel);
    private static final String[][] EMPTY_DATA = new String[0][0];
    private static final FileFilter CSV_FILTER = new CSVFile();
    private static final FileFilter TSV_FILTER = new TSVFile();

    public TableCanvas() {
        super(22, 32);
        this.setViewportView(this.tablePane);
        this.tablePane.setCellSelectionEnabled(true);
        this.tablePane.setColumnSelectionAllowed(true);
        this.tablePane.setRowSelectionAllowed(true);
        BLMain.addMenuItem((int)0, (String)"File", (JMenuItem)new JMenuItem(new AbstractAction("Open..."){
            private static final long serialVersionUID = 7526472295622776157L;
            {
                this.putValue("MnemonicKey", new Integer(79));
            }

            public void actionPerformed(ActionEvent evt) {
                JFileChooser openDialog = new JFileChooser();
                openDialog.setCurrentDirectory(BLMain.getCurrentPWD());
                openDialog.setAcceptAllFileFilterUsed(false);
                openDialog.setMultiSelectionEnabled(true);
                openDialog.addChoosableFileFilter(CSV_FILTER);
                openDialog.addChoosableFileFilter(TSV_FILTER);
                if (openDialog.showOpenDialog(BLMain.getJFrame()) == 0) {
                    if (openDialog.getSelectedFiles() != null) {
                        File[] openFiles;
                        for (File ofile : openFiles = openDialog.getSelectedFiles()) {
                            if (!ofile.exists() || !ofile.isFile()) continue;
                            if (openDialog.getFileFilter() == CSV_FILTER) {
                                TableCanvas.this.readFile("csv", ofile);
                                continue;
                            }
                            TableCanvas.this.readFile("tsv", ofile);
                        }
                    }
                    if (openDialog.getCurrentDirectory() != null) {
                        BLMain.setCurrentPWD((File)openDialog.getCurrentDirectory());
                    }
                }
            }
        }));
        BLMain.addMenuItem((int)1, (String)"File", (JMenuItem)new JMenuItem(new AbstractAction("Save As..."){
            private static final long serialVersionUID = 7526472295622776157L;
            {
                this.putValue("MnemonicKey", new Integer(83));
            }

            public void actionPerformed(ActionEvent evt) {
                JFileChooser saveDialog = new JFileChooser();
                saveDialog.setCurrentDirectory(BLMain.getCurrentPWD());
                saveDialog.setAcceptAllFileFilterUsed(false);
                saveDialog.addChoosableFileFilter(new CSVFile());
                if (saveDialog.showSaveDialog(BLMain.getJFrame()) == 0 && saveDialog.getSelectedFile() != null && (!saveDialog.getSelectedFile().exists() || saveDialog.getSelectedFile().canWrite() && JOptionPane.showConfirmDialog(null, "Overwrite existing file?", "Overwrite", 2, 3) != 2)) {
                    if (saveDialog.getFileFilter() == CSV_FILTER) {
                        TableCanvas.this.readFile("csv", saveDialog.getSelectedFile());
                    } else {
                        TableCanvas.this.readFile("tsv", saveDialog.getSelectedFile());
                    }
                    if (saveDialog.getCurrentDirectory() != null) {
                        BLMain.setCurrentPWD((File)saveDialog.getCurrentDirectory());
                    }
                }
            }
        }));
        BLMain.addMenuItem((int)0, (String)"Edit", (JMenuItem)new JMenuItem(new AbstractAction("Delete Row"){
            private static final long serialVersionUID = 7526472295622776157L;
            {
                this.putValue("MnemonicKey", new Integer(79));
            }

            public void actionPerformed(ActionEvent evt) {
                int[] rowSelection = TableCanvas.this.tablePane.getSelectedRows();
                Arrays.sort(rowSelection);
                for (int count = rowSelection.length - 1; count >= 0; --count) {
                    TableCanvas.this.tableModel.removeRow(rowSelection[count]);
                }
            }
        }));
    }

    public String[][] getData() {
        int[] rows = this.tablePane.getSelectedRows();
        int[] columns = this.tablePane.getSelectedColumns();
        String[][] result = new String[rows.length][];
        if (rows != null && columns != null) {
            for (int y = 0; y < rows.length; ++y) {
                result[y] = new String[columns.length];
                for (int x = 0; x < columns.length; ++x) {
                    result[y][x] = (String)this.tableModel.getValueAt(rows[y], columns[x]);
                }
            }
        }
        return result;
    }

    public String getName() {
        return "Table";
    }

    public void readFile(String format, File currentFile) {
        if (format.equalsIgnoreCase("csv")) {
            CSVFile.readFile(this.tableModel, currentFile);
        } else if (format.equalsIgnoreCase("tsv")) {
            TSVFile.readFile(this.tableModel, currentFile);
        }
    }

    public void writeFile(String format, File currentFile) {
        if (format.equalsIgnoreCase("csv")) {
            CSVFile.writeFile(currentFile, this.getData());
        } else if (format.equalsIgnoreCase("tsv")) {
            TSVFile.writeFile(currentFile, this.getData());
        }
    }

    public Component display() {
        return this;
    }
}

