/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.form;

import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.emboss.jemboss.gui.form.TextFieldSink;

public class TextFieldInt
extends TextFieldSink {
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private NumberFormat integerFormatter = NumberFormat.getNumberInstance(Locale.UK);

    public TextFieldInt() {
        this.integerFormatter.setParseIntegerOnly(true);
    }

    public int getValue() {
        int n = 0;
        try {
            n = this.integerFormatter.parse(this.getText()).intValue();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return n;
    }

    public void setValue(int n) {
        this.setText(this.integerFormatter.format(n));
    }

    protected Document createDefaultModel() {
        return new WholeNumberDocument();
    }

    protected class WholeNumberDocument
    extends PlainDocument {
        protected WholeNumberDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n2 = 0;
            for (int i = 0; i < cArray2.length; ++i) {
                if (Character.isDigit(cArray[i]) || cArray[i] == '-') {
                    cArray2[n2++] = cArray[i];
                    continue;
                }
                if (cArray[i] != ',') {
                    TextFieldInt.this.toolkit.beep();
                }
                System.err.println("insertString: " + cArray[i]);
            }
            super.insertString(n, new String(cArray2, 0, n2), attributeSet);
        }
    }
}

