/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.seahawk.gui;

import ca.ucalgary.seahawk.gui.MobyContentClipboard;
import ca.ucalgary.seahawk.gui.MobySecondaryInputGUI;
import ca.ucalgary.seahawk.services.MobyClient;
import ca.ucalgary.seahawk.util.HTMLUtils;
import ca.ucalgary.seahawk.util.SeahawkOptions;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;
import org.biomoby.client.MobyRequest;
import org.biomoby.client.MobyRequestEventHandler;
import org.biomoby.shared.Central;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyNamespace;
import org.biomoby.shared.MobyPrimaryData;
import org.biomoby.shared.MobySecondaryData;
import org.biomoby.shared.MobyService;
import org.biomoby.shared.MobyServiceType;
import org.biomoby.shared.data.MobyDataInstance;
import org.biomoby.shared.data.MobyDataObject;
import org.biomoby.shared.data.MobyDataObjectSAI;
import org.biomoby.shared.data.MobyDataObjectSet;
import org.biomoby.shared.data.MobyDataObjectSetSAI;
import org.biomoby.shared.data.MobyDataSecondaryInstance;
import org.biomoby.shared.data.MobyDataServiceAssocInstance;
import org.biomoby.shared.data.MobyDataXref;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobyServicesGUI
implements ActionListener,
Comparator<MobyService>,
PopupMenuListener {
    public static final int MAX_ID_LEN = 30;
    public static final String SERVICE_SUBMENU_NAME = "seahawkPopupSubMenuName";
    public static final int MAX_SERVICES_PER_SUBMENU = 12;
    public static final int MAX_SERVICE_DESC_LEN = 50;
    public static final String CLIPBOARD_CMD = "clipboard";
    public static final int USE_DEFAULT_HANDLER_MASK = 1;
    public static final int USE_DEFAULT_SECONDARIES_MASK = 2;
    Collator textCollator;
    MobySecondaryInputGUI secondaryGUI = null;
    Frame rootFrame = null;
    MobyRequestEventHandler mobyRequestEventHandler = null;
    JMenuItem waitItem = null;
    MobyContentClipboard clipboard = null;
    MobyRequest mobyRequest;
    MobyClient mobyClient = new MobyClient();
    JPopupMenu lastPopup;
    MobyDataServiceAssocInstance[] ms;
    MobyDataSecondaryInstance[] secondaryInputInstances = null;
    MobyPrimaryData[] primaryInput = null;
    int maxDataDesc = 22;
    private Map<JMenu, JMenu> service2submenu;
    private Map<JComponent, Integer> submenu2msIndex;
    private Map<JMenu, JMenuItem> submenu2waitItem;
    private Map<Integer, WeakReference<MobyRequestEventHandler>> specificHandlers;
    private static Logger logger = Logger.getLogger(MobyServicesGUI.class);
    MobyContentClipboard clip = null;

    public MobyServicesGUI() throws Exception {
        this.mobyClient.setRequiredServiceLevel(2);
        this.mobyRequest = new MobyRequest(this.mobyClient.getMobyCentralImpl());
        this.waitItem = new JMenuItem("Building data list, please wait...");
        this.textCollator = Collator.getInstance();
        this.ms = new MobyDataServiceAssocInstance[0];
        this.submenu2msIndex = new HashMap<JComponent, Integer>();
        this.submenu2waitItem = new HashMap<JMenu, JMenuItem>();
        this.service2submenu = new HashMap<JMenu, JMenu>();
        this.specificHandlers = new HashMap<Integer, WeakReference<MobyRequestEventHandler>>();
    }

    public Central getMobyCentralImpl() {
        return this.mobyClient.getMobyCentralImpl();
    }

    public MobyClient getMobyClient() {
        return this.mobyClient;
    }

    public void setClipboard(MobyContentClipboard clip) {
        this.clipboard = clip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.secondaryGUI) {
            this.removePopupOptions(e.getSource());
            this.setupServiceSecondaryData(this.getHandlerByHashCode(e.getActionCommand()));
        } else {
            if (e.getActionCommand().startsWith("MOBY")) {
                StringTokenizer st = new StringTokenizer(e.getActionCommand(), ":", false);
                st.nextToken();
                int which_data = Integer.parseInt(st.nextToken());
                String service = st.nextToken();
                if (service.equals(CLIPBOARD_CMD)) {
                    MobyDataServiceAssocInstance[] mobyDataServiceAssocInstanceArray = this.ms;
                    synchronized (this.ms) {
                        if (this.ms[which_data] == null) {
                            logger.warn("Ignoring clipboard action in " + this.getClass().getName() + ", the data to add is currently null (index " + which_data + ")" + ", from source " + e.getSource());
                            this.removePopupOptions(e.getSource());
                            // ** MonitorExit[var5_5] (shouldn't be in output)
                            return;
                        }
                        if (this.clipboard == null) {
                            logger.warn("Ignoring clipboard action in " + this.getClass().getName() + ", the clipboard is currently null:\n" + this.ms[which_data]);
                            this.removePopupOptions(e.getSource());
                            // ** MonitorExit[var5_5] (shouldn't be in output)
                            return;
                        }
                        this.clipboard.addCollectionData(this.ms[which_data]);
                        this.removePopupOptions(e.getSource());
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return;
                    }
                }
                int which_service = Integer.parseInt(service);
                MobyRequestEventHandler handler = this.mobyRequestEventHandler;
                if ((e.getModifiers() & 1) == 0 && st.hasMoreTokens()) {
                    handler = this.getHandlerByHashCode(Integer.parseInt(st.nextToken()));
                }
                MobyDataServiceAssocInstance[] mobyDataServiceAssocInstanceArray = this.ms;
                synchronized (this.ms) {
                    this.setupService(this.ms[which_data].getServices()[which_service], this.ms[which_data], handler.hashCode(), (e.getModifiers() & 2) != 0);
                    // ** MonitorExit[var7_9] (shouldn't be in output)
                }
            }
            logger.warn("Source of ActionEvent was unrecognized: " + e.getSource());
        }
    }

    private MobyRequestEventHandler getHandlerByHashCode(String hashCode) {
        try {
            return this.getHandlerByHashCode(Integer.parseInt(hashCode));
        }
        catch (Exception e) {
            logger.error("Exception: Warning: Could not create hash code integer from string " + hashCode + ": " + e);
            return this.mobyRequestEventHandler;
        }
    }

    private MobyRequestEventHandler getHandlerByHashCode(int hashCode) {
        if (hashCode == this.mobyRequestEventHandler.hashCode()) {
            return this.mobyRequestEventHandler;
        }
        if (!this.specificHandlers.containsKey(hashCode)) {
            logger.warn("Warning: The MOBY event handler corresponding to hash code " + hashCode + "cannot be found, using default handler instead.");
            return this.mobyRequestEventHandler;
        }
        WeakReference<MobyRequestEventHandler> ref = this.specificHandlers.get(hashCode);
        MobyRequestEventHandler handler = (MobyRequestEventHandler)ref.get();
        if (handler == null) {
            logger.warn("Notice: The MOBY event handler corresponding to hash code " + hashCode + "was deleted before the response was ready, using default handler instead.");
            return this.mobyRequestEventHandler;
        }
        return handler;
    }

    public void setupServiceSecondaryData(MobyRequestEventHandler handler) {
        MobyDataInstance[] castInputs = new MobyDataInstance[this.primaryInput.length];
        System.err.println("Submitting job with " + this.primaryInput.length + " parameters");
        for (int i = 0; i < this.primaryInput.length; ++i) {
            if (!(this.primaryInput[i] instanceof MobyDataInstance)) {
                logger.warn("Warning: setupServiceSecondaryData was called before the primary input for the service was instantiated, ignoring the call.  Object found was of class " + this.primaryInput[i].getClass().getName());
                return;
            }
            castInputs[i] = (MobyDataInstance)((Object)this.primaryInput[i]);
        }
        try {
            this.mobyRequest.setInput(castInputs);
        }
        catch (MobyException me) {
            me.printStackTrace();
            logger.warn("Error while trying to set service input: " + me);
        }
        this.mobyRequest.setSecondaryInput(this.secondaryInputInstances);
        this.executeService(handler);
    }

    protected void setupService(MobyService mobyService, MobyDataInstance mdi, int handlerHashCode, boolean useDefaultSecondaries) {
        if (!(mdi instanceof MobyPrimaryData)) {
            logger.error("Failure in MOBY input, was not primary data as expected, but rather " + mdi.getClass().getName());
            return;
        }
        this.mobyRequest.setDebugMode(System.getProperty("moby.debug") != null);
        this.mobyRequest.setService(mobyService);
        MobyPrimaryData[] primaryInputTemplate = mobyService.getPrimaryInputs();
        this.primaryInput = new MobyPrimaryData[primaryInputTemplate.length];
        System.arraycopy(primaryInputTemplate, 0, this.primaryInput, 0, this.primaryInput.length);
        if (!this.hasSecondaryInput(mobyService)) {
            try {
                this.mobyRequest.setInput(mdi, "");
            }
            catch (MobyException me) {
                logger.error("Failure in MOBY input, was not acceptable:" + me);
                return;
            }
            this.removePopupOptions();
            this.executeService(this.getHandlerByHashCode(handlerHashCode));
        } else {
            MobyService metaDataMobyService = MobyService.getService(mobyService.getName(), mobyService.getAuthority());
            Vector<String> paramMatch = new Vector<String>();
            int paramMatchDefault = 0;
            MobyDataType providedDataType = ((MobyPrimaryData)((Object)mdi)).getDataType();
            for (MobyPrimaryData input : this.primaryInput) {
                if (!providedDataType.inheritsFrom(input.getDataType())) continue;
                paramMatch.add(input.getName());
            }
            if (paramMatch.size() == 0) {
                logger.error("Failure in MOBY input, could not match the input (" + providedDataType.getName() + ") to any service param for service " + mobyService.getName());
                return;
            }
            String targetParamName = (String)paramMatch.elementAt(0);
            if (paramMatch.size() > 1) {
                targetParamName = (String)JOptionPane.showInputDialog(null, "Choose the service parameter\nthe chosen object represents", "Service Parameter Choice", 3, null, paramMatch.toArray(), paramMatch.elementAt(paramMatchDefault));
            }
            for (int i = 0; i < this.primaryInput.length; ++i) {
                if (!targetParamName.equals(this.primaryInput[i].getName())) continue;
                mdi.setName(targetParamName);
                this.primaryInput[i] = (MobyPrimaryData)((Object)mdi);
            }
            this.getSecondaryInput(metaDataMobyService, handlerHashCode, useDefaultSecondaries);
        }
    }

    private boolean hasSecondaryInput(MobyService mobyService) {
        MobySecondaryData[] secondaryInputTemplate = mobyService.getSecondaryInputs();
        return secondaryInputTemplate != null && secondaryInputTemplate.length != 0 || mobyService.getPrimaryInputs().length > 1;
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        this.removePopupOptions(e.getSource());
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    public boolean isSecondaryParamDialogNew() {
        if (this.secondaryGUI == null) {
            return false;
        }
        return this.secondaryGUI.isNewShowing();
    }

    protected void getSecondaryInput(MobyService mobyService, int handlerHashCode, boolean useDefaults) {
        MobySecondaryData[] secondaryInputTemplate = mobyService.getSecondaryInputs();
        if (this.secondaryGUI == null) {
            this.secondaryGUI = new MobySecondaryInputGUI(this, handlerHashCode, this.mobyClient);
        }
        this.secondaryInputInstances = new MobyDataSecondaryInstance[secondaryInputTemplate.length];
        for (int i = 0; i < this.secondaryInputInstances.length; ++i) {
            this.secondaryInputInstances[i] = new MobyDataSecondaryInstance(secondaryInputTemplate[i]);
        }
        if (useDefaults && this.secondaryGUI.defaultFillIn(this.secondaryInputInstances)) {
            this.setupServiceSecondaryData(this.getHandlerByHashCode(handlerHashCode));
            return;
        }
        boolean SHOW_DIALOG = true;
        this.secondaryGUI.fillIn(this.primaryInput, this.secondaryInputInstances, SHOW_DIALOG);
    }

    protected void executeService() {
        this.executeService(this.mobyRequestEventHandler);
    }

    protected void executeService(MobyRequestEventHandler mreh) {
        this.mobyRequest.invokeService(mreh);
        this.removePopupOptions();
    }

    protected void getRootFrame(JPopupMenu popup) {
        Component root = popup.getInvoker();
        while (root != null && !(root instanceof Frame)) {
        }
        this.rootFrame = (Frame)root;
    }

    public void setResponseHandler(MobyRequestEventHandler mreh) {
        this.mobyRequestEventHandler = mreh;
    }

    public void addXPathMapping(String xpath, String[] mobyDataTypes) {
        this.mobyClient.addXPathMapping(xpath, mobyDataTypes);
    }

    public void addXPathMapping(String xpath, String desc_xpath, String[] mobyDataTypes) {
        this.addXPathMapping(xpath, mobyDataTypes);
    }

    public void addRegexMapping(String xpath, String[] mobyDataTypes) {
        this.mobyClient.addXPathMapping(xpath, mobyDataTypes);
    }

    public void addRegexMapping(String xpath, String desc_xpath, String[] mobyDataTypes) {
        this.addXPathMapping(xpath, mobyDataTypes);
    }

    public void setDataDescMax(int cutoff) {
        this.maxDataDesc = cutoff;
    }

    public void addPopupOptions(Node targetNode, JPopupMenu popupList, boolean asynchronous) {
        this.addPopupOptions(targetNode, popupList, asynchronous, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPopupOptions(Node targetNode, JPopupMenu popupList, boolean asynchronous, MobyRequestEventHandler handler) {
        popupList.addPopupMenuListener(this);
        if (this.lastPopup != popupList) {
            this.removePopupOptions();
            this.lastPopup = popupList;
        }
        if (asynchronous) {
            Point p = popupList.getLocation(null);
            JPopupMenu jPopupMenu = popupList;
            synchronized (jPopupMenu) {
                popupList.setVisible(false);
                popupList.add(this.waitItem);
                popupList.setVisible(true);
            }
            OptionLoaderThread lt = new OptionLoaderThread(targetNode, popupList, handler);
            lt.start();
            return;
        }
        MobyDataServiceAssocInstance[] serviceAssocObjects = null;
        JMenu[] submenus = null;
        try {
            MobyDataObject[] mobyObjects = this.mobyClient.getMobyObjects(targetNode);
            submenus = new JMenu[mobyObjects.length];
            for (int i = 0; i < mobyObjects.length; ++i) {
                JMenu submenu = this.createObjectSubMenu(mobyObjects[i]);
                if (submenu == null) continue;
                popupList.add(submenu);
                this.addClipboardItem(submenu, mobyObjects[i]);
                submenu.add(this.getWaitItem(submenu));
                submenus[i] = submenu;
            }
            if (popupList.getSubElements().length > 0) {
                JPopupMenu i = popupList;
                synchronized (i) {
                    popupList.setVisible(false);
                    popupList.remove(this.waitItem);
                    popupList.setVisible(true);
                }
            }
            serviceAssocObjects = this.mobyClient.getServices(mobyObjects);
        }
        catch (Exception mobye) {
            logger.error("Could not retrieve list of MobyServices from initialized MobyClient using the context node " + targetNode.getNodeName());
            mobye.printStackTrace();
            popupList.setVisible(false);
            popupList.remove(this.waitItem);
            for (int i = 0; submenus != null && i < submenus.length; ++i) {
                if (submenus[i] == null) continue;
                if (submenus[i].isPopupMenuVisible()) {
                    submenus[i].setPopupMenuVisible(false);
                    submenus[i].remove(this.getWaitItem(submenus[i]));
                    submenus[i].setPopupMenuVisible(true);
                    continue;
                }
                submenus[i].remove(this.getWaitItem(submenus[i]));
            }
            if (popupList.getSubElements().length != 0) {
                popupList.setVisible(true);
            }
            return;
        }
        if (this.ms == null || this.ms.length == 0) {
            popupList.remove(this.waitItem);
            if (popupList.getSubElements().length == 0) {
                popupList.setVisible(false);
            }
            return;
        }
        for (int i = 0; i < submenus.length; ++i) {
            this.addServicesToSubMenu(submenus[i], serviceAssocObjects[i], handler);
        }
    }

    public void removePopupOptions(Object source) {
        this.removePopupOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePopupOptions() {
        MobyDataServiceAssocInstance[] mobyDataServiceAssocInstanceArray = this.ms;
        synchronized (this.ms) {
            if (this.lastPopup != null) {
                try {
                    this.lastPopup.removeAll();
                    this.lastPopup.setVisible(false);
                    this.lastPopup = null;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            this.service2submenu.clear();
            this.submenu2msIndex.clear();
            this.submenu2waitItem.clear();
            this.ms = new MobyDataServiceAssocInstance[0];
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void addPopupOptions(String textData, JPopupMenu popupList, boolean asynchronous) {
        this.addPopupOptions(textData, popupList, asynchronous, null);
    }

    public void addPopupOptions(String textData, JPopupMenu popupList, boolean asynchronous, MobyRequestEventHandler handler) {
        MobyDataObject[] mobyObjects = this.mobyClient.getMobyObjects(textData);
        for (int i = 0; mobyObjects != null && i < mobyObjects.length; ++i) {
            this.addPopupOptions(mobyObjects[i], popupList, asynchronous, handler);
        }
    }

    public void addPopupOptions(MobyDataInstance mobyData, JPopupMenu popupList, boolean asynchronous) {
        this.addPopupOptions(mobyData, popupList, asynchronous, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPopupOptions(MobyDataInstance mobyData, JPopupMenu popupList, boolean asynchronous, MobyRequestEventHandler handler) {
        MobyDataServiceAssocInstance serviceAssocObject;
        JMenu submenu;
        block13: {
            if (asynchronous) {
                JPopupMenu jPopupMenu = popupList;
                synchronized (jPopupMenu) {
                    popupList.setVisible(false);
                    popupList.add(this.waitItem);
                    popupList.setVisible(true);
                }
                OptionLoaderThread lt = new OptionLoaderThread(mobyData, popupList, handler);
                lt.start();
                return;
            }
            submenu = this.createObjectSubMenu(mobyData);
            if (submenu == null) {
                return;
            }
            popupList.add(submenu);
            JPopupMenu jPopupMenu = popupList;
            synchronized (jPopupMenu) {
                popupList.setVisible(false);
                popupList.remove(this.waitItem);
                popupList.setVisible(true);
            }
            this.addClipboardItem(submenu, mobyData);
            submenu.add(this.getWaitItem(submenu));
            serviceAssocObject = null;
            try {
                if (mobyData instanceof MobyDataObjectSet) {
                    serviceAssocObject = this.mobyClient.getServices((MobyDataObjectSet)mobyData);
                    break block13;
                }
                if (mobyData instanceof MobyDataObject) {
                    serviceAssocObject = this.mobyClient.getServices((MobyDataObject)mobyData);
                    break block13;
                }
                logger.warn("Service options for objects other than MobyDataObject and MobyDataObjectSet are not yet supported.");
                return;
            }
            catch (Exception mobye) {
                logger.error("Could not retrieve list of MobyServices from initialized MobyClient using the MOBY data " + mobyData);
                mobye.printStackTrace();
                popupList.setVisible(false);
                return;
            }
        }
        if (serviceAssocObject == null || serviceAssocObject.getServices() == null || serviceAssocObject.getServices().length == 0) {
            popupList.setVisible(false);
            return;
        }
        this.addServicesToSubMenu(submenu, serviceAssocObject, handler);
    }

    protected synchronized void addServicesToSubMenu(JMenu submenu, MobyDataServiceAssocInstance msadi) {
        this.addServicesToSubMenu(submenu, msadi, null);
    }

    protected void addHandler(MobyRequestEventHandler handler) {
        if (handler != null && !this.specificHandlers.containsKey(handler)) {
            this.specificHandlers.put(handler.hashCode(), new WeakReference<MobyRequestEventHandler>(handler));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void addServicesToSubMenu(JMenu submenu, MobyDataServiceAssocInstance msadi, MobyRequestEventHandler handler) {
        int dataIndex = 0;
        boolean isSubSubMenu = false;
        MobyDataServiceAssocInstance[] mobyDataServiceAssocInstanceArray = this.ms;
        synchronized (this.ms) {
            if (this.submenu2msIndex == null || submenu == null || this.submenu2msIndex.size() == 0) {
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return;
            }
            if (!this.submenu2msIndex.containsKey(submenu)) {
                JMenu parent = this.service2submenu.get(submenu);
                if (parent == null) {
                    logger.warn("Cannot add service options, cannot find parent moby object index for submenu " + submenu.getText());
                    System.err.println("Cannot add service options, cannot find parent moby object index for submenu " + submenu.getText());
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    return;
                }
                dataIndex = this.submenu2msIndex.get(parent);
                isSubSubMenu = true;
            } else {
                dataIndex = this.submenu2msIndex.get(submenu);
                if (this.ms.length > dataIndex) {
                    this.ms[dataIndex] = msadi;
                } else {
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    return;
                }
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            MobyService[] unsortedServices = msadi.getServices();
            boolean subDivided = false;
            if (unsortedServices.length > 12) {
                int i;
                int ontologyDepth;
                subDivided = true;
                MobyServiceType[][] serviceLineages = new MobyServiceType[unsortedServices.length][];
                int maxOntologyDepth = 0;
                for (int i2 = 0; i2 < unsortedServices.length; ++i2) {
                    MobyServiceType serviceType = unsortedServices[i2].getServiceType();
                    if (serviceType == null) {
                        logger.warn("No service type (ontology) was associated with service " + unsortedServices[i2] + ", cannot add to the hierarchical service " + "menus (skipping)");
                        continue;
                    }
                    serviceLineages[i2] = serviceType.getLineage();
                    if (serviceLineages[i2] == null) {
                        logger.warn("No service type lineage (ontology position) was associated with service type " + serviceType + ", cannot add to the hierarchical service " + "menus (skipping)");
                    } else if (serviceLineages[i2].length > maxOntologyDepth) {
                        maxOntologyDepth = serviceLineages[i2].length;
                    }
                    logger.debug("Lineage for " + unsortedServices[i2].getName() + "had length " + serviceLineages[i2].length);
                }
                String commonAncestorDesc = "";
                block4: for (ontologyDepth = 0; ontologyDepth < maxOntologyDepth; ++ontologyDepth) {
                    MobyServiceType commonServiceType = null;
                    for (i = 0; i < serviceLineages.length; ++i) {
                        if (serviceLineages[i] == null || serviceLineages[i].length <= ontologyDepth) continue;
                        if (commonServiceType == null) {
                            commonServiceType = serviceLineages[i][ontologyDepth];
                            commonAncestorDesc = commonAncestorDesc + serviceLineages[i][ontologyDepth] + " > ";
                            continue;
                        }
                        if (!commonServiceType.equals(serviceLineages[i][ontologyDepth])) break block4;
                    }
                }
                if (ontologyDepth >= maxOntologyDepth) {
                    int i3;
                    int dataOntologyDepth;
                    MobyDataType[][] outputLineages = new MobyDataType[unsortedServices.length][];
                    int maxDataOntologyDepth = 0;
                    for (int i4 = 0; i4 < unsortedServices.length; ++i4) {
                        MobyPrimaryData[] output = unsortedServices[i4].getPrimaryOutputs();
                        MobyDataType outputType = null;
                        if (output != null && output.length != 0 && output[0] instanceof MobyPrimaryData) {
                            outputType = MobyDataType.getDataType(output[0].getDataType().getName(), SeahawkOptions.getRegistry());
                        }
                        if (outputType == null) {
                            logger.warn("No output data type (ontology) was associated with service " + unsortedServices[i4] + ", cannot add to the hierarchical service " + "menus (skipping)");
                            continue;
                        }
                        outputLineages[i4] = outputType.getLineage();
                        if (outputLineages[i4] == null) {
                            logger.debug("No output data type lineage (ontology position) was associated with service type " + outputType + ", cannot add to the hierarchical service " + "menus (skipping)");
                        } else if (outputLineages[i4].length > maxOntologyDepth) {
                            maxDataOntologyDepth = outputLineages[i4].length;
                        }
                        logger.debug("Data lineage for " + unsortedServices[i4].getName() + "had length " + outputLineages[i4].length);
                    }
                    String commonDataAncestorDesc = "";
                    block7: for (dataOntologyDepth = 0; dataOntologyDepth < maxDataOntologyDepth; ++dataOntologyDepth) {
                        MobyDataType commonOutputType = null;
                        for (i3 = 0; i3 < outputLineages.length; ++i3) {
                            if (outputLineages[i3] == null || outputLineages[i3].length <= dataOntologyDepth) continue;
                            if (commonOutputType == null) {
                                commonOutputType = outputLineages[i3][dataOntologyDepth];
                                commonAncestorDesc = commonAncestorDesc + outputLineages[i3][dataOntologyDepth] + " > ";
                                continue;
                            }
                            if (!commonOutputType.equals(outputLineages[i3][dataOntologyDepth])) break block7;
                        }
                    }
                    if (dataOntologyDepth >= maxDataOntologyDepth) {
                        this.sortServicesByName(unsortedServices);
                        for (int j = 0; j < unsortedServices.length - 1; j += 12) {
                            MobyService[] services = null;
                            if (j + 12 < unsortedServices.length) {
                                services = new MobyService[12];
                                System.arraycopy(unsortedServices, j, services, 0, 12);
                            } else {
                                services = new MobyService[unsortedServices.length - j];
                                System.arraycopy(unsortedServices, j, services, 0, unsortedServices.length - j);
                            }
                            JMenu newMenu = this.addNameDivSubMenu(submenu, services);
                            MobyPrimaryData newMsadi = null;
                            if (msadi instanceof MobyDataXref) {
                                newMsadi = new MobyDataXref((MobyDataObject)((Object)msadi), services[0]);
                            } else if (msadi instanceof MobyDataObjectSAI) {
                                newMsadi = new MobyDataObjectSAI((MobyDataObject)((Object)msadi), services);
                            } else if (msadi instanceof MobyDataObjectSetSAI) {
                                newMsadi = new MobyDataObjectSetSAI((MobyDataObjectSet)((Object)msadi), services);
                            }
                            this.addServicesToSubMenu(newMenu, (MobyDataServiceAssocInstance)((Object)newMsadi), handler);
                        }
                    } else {
                        TreeMap outputType2Services = new TreeMap();
                        for (i3 = 0; i3 < outputLineages.length; ++i3) {
                            if (outputLineages[i3] == null) continue;
                            MobyDataType type = null;
                            type = outputLineages[i3].length > dataOntologyDepth ? outputLineages[i3][dataOntologyDepth] : (dataOntologyDepth >= 1 ? outputLineages[i3][outputLineages[i3].length - 1] : new MobyDataType("Object (no details)"));
                            MobyService service = unsortedServices[i3];
                            if (outputType2Services.containsKey(type)) {
                                ((Vector)outputType2Services.get(type)).add(service);
                                continue;
                            }
                            Vector<MobyService> serviceItems = new Vector<MobyService>();
                            serviceItems.add(service);
                            outputType2Services.put(type, serviceItems);
                        }
                        for (MobyDataType type : outputType2Services.keySet()) {
                            JMenu newMenu = this.addOutputTypeSubMenu(submenu, type);
                            Vector serviceVector = (Vector)outputType2Services.get(type);
                            MobyService[] services = serviceVector.toArray(new MobyService[serviceVector.size()]);
                            MobyPrimaryData newMsadi = null;
                            if (msadi instanceof MobyDataXref) {
                                newMsadi = new MobyDataXref((MobyDataObject)((Object)msadi), services[0]);
                            } else if (msadi instanceof MobyDataObjectSAI) {
                                newMsadi = new MobyDataObjectSAI((MobyDataObject)((Object)msadi), services);
                            } else if (msadi instanceof MobyDataObjectSetSAI) {
                                newMsadi = new MobyDataObjectSetSAI((MobyDataObjectSet)((Object)msadi), services);
                            }
                            this.addServicesToSubMenu(newMenu, (MobyDataServiceAssocInstance)((Object)newMsadi), handler);
                        }
                    }
                } else {
                    TreeMap serviceType2Services = new TreeMap();
                    for (i = 0; i < serviceLineages.length; ++i) {
                        if (serviceLineages[i] == null) continue;
                        MobyServiceType type = null;
                        type = serviceLineages[i].length > ontologyDepth ? serviceLineages[i][ontologyDepth] : (ontologyDepth >= 1 ? serviceLineages[i][serviceLineages[i].length - 1] : new MobyServiceType("Service (no details)"));
                        MobyService service = unsortedServices[i];
                        if (serviceType2Services.containsKey(type)) {
                            ((Vector)serviceType2Services.get(type)).add(service);
                            continue;
                        }
                        Vector<MobyService> serviceItems = new Vector<MobyService>();
                        serviceItems.add(service);
                        serviceType2Services.put(type, serviceItems);
                    }
                    for (MobyServiceType type : serviceType2Services.keySet()) {
                        JMenu newMenu = this.addServiceTypeSubMenu(submenu, type);
                        Vector serviceVector = (Vector)serviceType2Services.get(type);
                        MobyService[] services = serviceVector.toArray(new MobyService[serviceVector.size()]);
                        MobyPrimaryData newMsadi = null;
                        if (msadi instanceof MobyDataXref) {
                            newMsadi = new MobyDataXref((MobyDataObject)((Object)msadi), services[0]);
                        } else if (msadi instanceof MobyDataObjectSAI) {
                            newMsadi = new MobyDataObjectSAI((MobyDataObject)((Object)msadi), services);
                        } else if (msadi instanceof MobyDataObjectSetSAI) {
                            newMsadi = new MobyDataObjectSetSAI((MobyDataObjectSet)((Object)msadi), services);
                        }
                        this.addServicesToSubMenu(newMenu, (MobyDataServiceAssocInstance)((Object)newMsadi), handler);
                    }
                }
                if (submenu.isPopupMenuVisible()) {
                    submenu.setPopupMenuVisible(false);
                    submenu.remove(this.getWaitItem(submenu));
                    submenu.setPopupMenuVisible(true);
                } else {
                    submenu.remove(this.getWaitItem(submenu));
                }
                return;
            }
            this.addHandler(handler);
            MobyService[] services = new MobyService[unsortedServices.length];
            System.arraycopy(unsortedServices, 0, services, 0, unsortedServices.length);
            this.sortServicesByName(services);
            msadi.setServices(services);
            for (int i = 0; i < services.length; ++i) {
                MobyService service = services[i];
                int serviceIndex = i;
                if (isSubSubMenu) {
                    MobyService[] referenceServices = this.ms[dataIndex].getServices();
                    for (serviceIndex = 0; serviceIndex < referenceServices.length && !referenceServices[serviceIndex].equals(service); ++serviceIndex) {
                    }
                    if (serviceIndex == referenceServices.length) {
                        logger.warn("Cannot add service option, cannot find parent moby object service array index for service " + service.getName());
                        continue;
                    }
                }
                JMenuItem mobyItem = new JMenuItem("Run " + service.getName() + (this.hasSecondaryInput(service) ? "..." : "") + (service.isAsynchronous() ? "(async)" : ""));
                mobyItem.setActionCommand("MOBY:" + dataIndex + ":" + serviceIndex + (handler == null ? "" : ":" + handler.hashCode()));
                mobyItem.addActionListener(this);
                String sdesc = "No description provided";
                String serviceDesc = service.getDescription();
                String serviceAuthority = service.getAuthority();
                if (serviceDesc != null && serviceDesc.length() > 0) {
                    if (serviceAuthority != null && serviceAuthority.length() > 0) {
                        serviceDesc = serviceDesc + " [" + serviceAuthority + "]";
                    }
                    sdesc = serviceDesc = HTMLUtils.htmlifyToolTipText(serviceDesc, 50);
                }
                if (sdesc != null) {
                    mobyItem.setToolTipText(sdesc);
                }
                submenu.add(mobyItem);
            }
            if (submenu.isPopupMenuVisible()) {
                submenu.setPopupMenuVisible(false);
                submenu.remove(this.getWaitItem(submenu));
                submenu.setPopupMenuVisible(true);
            } else {
                submenu.remove(this.getWaitItem(submenu));
            }
            return;
        }
    }

    public JMenu addServiceTypeSubMenu(JMenu parentMenu, MobyServiceType type) {
        JMenu menu = new JMenu("Service type: " + type.getName());
        MobyServiceType[] typeLineage = type.getLineage();
        String commonAncestorDesc = "";
        for (int i = 0; i < typeLineage.length; ++i) {
            if (typeLineage == null) {
                commonAncestorDesc = "No details available";
                break;
            }
            commonAncestorDesc = commonAncestorDesc + typeLineage[i].getName() + " > ";
        }
        String menuToolTip = commonAncestorDesc + type.getDescription();
        menuToolTip = HTMLUtils.htmlifyToolTipText(menuToolTip, 50);
        menu.setToolTipText(menuToolTip);
        parentMenu.add(menu);
        while (this.service2submenu.containsKey(parentMenu)) {
            parentMenu = this.service2submenu.get(parentMenu);
        }
        this.service2submenu.put(menu, parentMenu);
        return menu;
    }

    protected String getNameStart(MobyService service) {
        String serviceName = service.getName();
        if (serviceName.length() <= 9) {
            return serviceName;
        }
        return serviceName.substring(0, 8) + "...";
    }

    public JMenu addNameDivSubMenu(JMenu parentMenu, MobyService[] services) {
        if (services == null || services.length == 0) {
            return null;
        }
        JMenu menu = new JMenu("Service name " + this.getNameStart(services[0]) + "-" + this.getNameStart(services[services.length - 1]) + ":");
        parentMenu.add(menu);
        while (this.service2submenu.containsKey(parentMenu)) {
            parentMenu = this.service2submenu.get(parentMenu);
        }
        this.service2submenu.put(menu, parentMenu);
        return menu;
    }

    public JMenu addOutputTypeSubMenu(JMenu parentMenu, MobyDataType type) {
        String desc;
        JMenu menu = new JMenu("Result type: " + type.getName());
        MobyDataType[] typeLineage = type.getLineage();
        String commonAncestorDesc = "";
        for (int i = 0; i < typeLineage.length; ++i) {
            if (typeLineage == null) {
                commonAncestorDesc = "No details available";
                break;
            }
            commonAncestorDesc = commonAncestorDesc + typeLineage[i].getName() + " > ";
        }
        if ((desc = type.getDescription()) == null || desc.length() == 0) {
            desc = type.getComment();
        }
        String menuToolTip = commonAncestorDesc + desc;
        menuToolTip = HTMLUtils.htmlifyToolTipText(menuToolTip, 50);
        menu.setToolTipText(menuToolTip);
        parentMenu.add(menu);
        while (this.service2submenu.containsKey(parentMenu)) {
            parentMenu = this.service2submenu.get(parentMenu);
        }
        this.service2submenu.put(menu, parentMenu);
        return menu;
    }

    public JMenu createObjectSubMenu(MobyDataInstance mdi) {
        MobyNamespace[] namespaces;
        if (!(mdi instanceof MobyPrimaryData)) {
            logger.warn("Ignoring non-primary data object submitted to menu creation: " + mdi);
            return null;
        }
        MobyPrimaryData targetData = (MobyPrimaryData)((Object)mdi);
        String id = targetData.getId();
        if (id == null) {
            id = "";
        } else if (id.length() > 33) {
            id = id.substring(0, 30) + "...";
        }
        MobyDataType mobyDataType = targetData.getDataType();
        String name = null;
        if (mobyDataType == null) {
            logger.warn("PG: Warning: no datatype associated with service " + targetData.getName());
        } else {
            name = mobyDataType.getName();
        }
        if ("Object".equals(name) && (namespaces = targetData.getNamespaces()) != null && namespaces.length > 0 && namespaces[0] != null) {
            name = namespaces[0].getName();
        }
        mobyDataType = MobyDataType.getDataType(targetData.getDataType().getName(), SeahawkOptions.getRegistry());
        String desc = null;
        String datatype = null;
        if (mobyDataType == null) {
            logger.warn("PG: Warning (submenu): no datatype associated with service " + targetData.getName());
        } else {
            datatype = mobyDataType.getName();
            desc = mobyDataType.getDescription();
            if (desc == null || desc.length() == 0) {
                desc = mobyDataType.getComment();
            }
        }
        if (datatype != null && datatype.indexOf("objectclass:") != -1) {
            datatype = datatype.substring(datatype.indexOf("objectclass:") + 12);
        }
        JMenu submenu = null;
        MobyNamespace[] namespaces2 = targetData.getNamespaces();
        if (mobyDataType == null) {
            desc = "Unknown datatype";
            submenu = new JMenu("Services for unknown datatype");
            this.assignMenuDataIndex(submenu);
        } else if ("Object".equals(mobyDataType.getName())) {
            String mobydesc = "?";
            if (namespaces2 != null) {
                for (int j = 0; j < namespaces2.length; ++j) {
                    if (namespaces2[j] == null || namespaces2[j].getDescription() == null || namespaces2[j].getDescription().length() <= mobydesc.length()) continue;
                    mobydesc = namespaces2[j].getDescription();
                    datatype = namespaces2[j].getName();
                }
            }
            desc = "Record Identifier - " + mobydesc;
            submenu = new JMenu("Services for " + datatype + ":" + id);
            this.assignMenuDataIndex(submenu);
        } else if ("String".equals(mobyDataType.getName())) {
            String sample = targetData.getName();
            if (sample == null) {
                sample = targetData.toString();
            }
            if (sample.length() > 33) {
                sample = sample.substring(0, 30) + "...";
            }
            desc = "A piece of text";
            submenu = new JMenu("Services for String \"" + sample + "\"");
            this.assignMenuDataIndex(submenu);
        } else {
            String objectLabel = datatype;
            if (namespaces2 != null && namespaces2.length > 0 && namespaces2[0] != null) {
                objectLabel = objectLabel + ":" + namespaces2[0].getName();
                String namespaceDesc = namespaces2[0].getDescription();
                if (namespaceDesc != null && namespaceDesc.length() > 0) {
                    desc = desc + "[" + namespaceDesc + "]";
                }
            }
            if (targetData instanceof MobyDataObject && id != null && id.length() > 0) {
                objectLabel = objectLabel + ":" + id;
            } else if (targetData instanceof MobyDataObjectSet) {
                objectLabel = objectLabel + " collection";
            }
            submenu = new JMenu("Services for " + objectLabel);
            this.assignMenuDataIndex(submenu);
        }
        desc = "Input data: " + desc;
        desc = HTMLUtils.htmlifyToolTipText(desc, 50);
        submenu.setToolTipText(desc);
        submenu.setName(SERVICE_SUBMENU_NAME);
        return submenu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int assignMenuDataIndex(JMenu submenu) {
        MobyDataServiceAssocInstance[] mobyDataServiceAssocInstanceArray = this.ms;
        synchronized (this.ms) {
            MobyDataServiceAssocInstance[] mss = new MobyDataServiceAssocInstance[this.ms.length + 1];
            if (this.ms != null) {
                System.arraycopy(this.ms, 0, mss, 0, this.ms.length);
            }
            this.ms = mss;
            this.submenu2msIndex.put(submenu, this.ms.length - 1);
            this.submenu2msIndex.put(submenu.getPopupMenu(), this.ms.length - 1);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.ms.length - 1;
        }
    }

    private JMenuItem getWaitItem(JMenu menu) {
        if (menu == null) {
            logger.warn("Cannot get wait menu item, passed in menu was null");
            return null;
        }
        if (this.submenu2waitItem.containsKey(menu)) {
            return this.submenu2waitItem.get(menu);
        }
        JMenuItem waitMsg = new JMenuItem("Retrieving Web services, please wait...");
        this.submenu2waitItem.put(menu, waitMsg);
        return waitMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void addClipboardItem(JMenu menu, MobyDataInstance mobyData) {
        MobyDataServiceAssocInstance[] mobyDataServiceAssocInstanceArray;
        if (menu == null) {
            logger.warn("Cannot add clipboard option, menu reference passed in was null");
            return;
        }
        if (this.clipboard == null) {
            logger.warn("No clipboard has been registered yet, cannot add clipboard option for menu " + menu.getText());
            return;
        }
        if (!this.submenu2msIndex.containsKey(menu)) {
            logger.warn("Cannot add clipboard option, cannot find moby object list index for menu " + menu.getText());
            return;
        }
        int dataIndex = this.submenu2msIndex.get(menu);
        if (mobyData instanceof MobyDataObjectSet) {
            mobyDataServiceAssocInstanceArray = this.ms;
            // MONITORENTER : this.ms
            this.ms[dataIndex] = new MobyDataObjectSetSAI((MobyDataObjectSet)((MobyDataObjectSet)mobyData).clone(), (MobyService[])null);
            // MONITOREXIT : mobyDataServiceAssocInstanceArray
        } else {
            if (!(mobyData instanceof MobyDataObject)) {
                logger.warn("Clipboard option for objects other than MobyDataObject and MobyDataObjectSet are not yet supported:" + mobyData);
                return;
            }
            mobyDataServiceAssocInstanceArray = this.ms;
            // MONITORENTER : this.ms
            this.ms[dataIndex] = new MobyDataObjectSAI((MobyDataObject)((MobyDataObject)mobyData).clone(), (MobyService[])null);
            // MONITOREXIT : mobyDataServiceAssocInstanceArray
        }
        JMenuItem clipItem = new JMenuItem("Add to clipboard");
        clipItem.setActionCommand("MOBY:" + dataIndex + ":" + CLIPBOARD_CMD);
        clipItem.addActionListener(this);
        menu.add(clipItem);
    }

    public void sortServicesByName(MobyService[] services) {
        try {
            Arrays.sort(services, this);
        }
        catch (ClassCastException cce) {
            logger.error("ClassCastException: Warning: Could not alphabetically sort services by name,got exception (some input was not of type MobyService):" + cce);
        }
    }

    @Override
    public int compare(MobyService o1, MobyService o2) {
        return this.textCollator.compare(o1.getName(), o2.getName());
    }

    @Override
    public boolean equals(Object obj) {
        return this.textCollator.equals(obj);
    }

    class OptionLoaderThread
    extends Thread {
        Node targetNode = null;
        MobyRequestEventHandler handler = null;
        MobyDataInstance mobyData = null;
        JPopupMenu popupList;

        public OptionLoaderThread(Node targetNode, JPopupMenu popupList, MobyRequestEventHandler handler) {
            this.targetNode = targetNode;
            this.popupList = popupList;
            this.handler = handler;
        }

        public OptionLoaderThread(MobyDataInstance mobyData, JPopupMenu popupList, MobyRequestEventHandler handler) {
            this.mobyData = mobyData;
            this.popupList = popupList;
            this.handler = handler;
        }

        public void run() {
            if (this.targetNode != null) {
                MobyServicesGUI.this.addPopupOptions(this.targetNode, this.popupList, false, this.handler);
            } else if (this.mobyData != null) {
                MobyServicesGUI.this.addPopupOptions(this.mobyData, this.popupList, false, this.handler);
            } else {
                logger.warn("Warning: OptionLoaderThread has no data to work with");
            }
        }
    }
}

