/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.seahawk.gui;

import ca.ucalgary.seahawk.util.HTMLUtils;
import ca.ucalgary.seahawk.util.SeahawkOptions;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.biomoby.registry.meta.RegistriesList;
import org.biomoby.registry.meta.Registry;
import org.biomoby.registry.meta.RegistryCache;

public class SeahawkOptionsGUI
extends JDialog
implements ActionListener,
WindowListener {
    public static final String CUSTOM_REGISTRY_SYNONYM = "Custom (set your own location & namespace)";
    public static final String CUSTOM_REGISTRY_DESC = "User-defined MOBY Central registry.";
    public static final String DIALOG_TITLE = "Seahawk User Preferences";
    public static final boolean DIALOG_MODAL = true;
    private static final int MAX_DESC_WIDTH = 60;
    private JComboBox registryComboBox;
    private JTextPane registryDescTextArea;
    private JTextField registryEndpoint;
    private JTextField registryNamespace;
    private JButton deleteCacheButton;
    private JButton selectCacheDirButton;
    private JTextField converterHostTextField;
    private JTextField converterPortTextField;
    private JTextField cacheExpiryTextField;
    private JFileChooser cacheDirFileChooser;
    private JCheckBox sendReferrerCheckBox;
    private JButton resetButton;
    private JButton okButton;
    private JButton cancelButton;
    private RegistriesList registriesList;
    private String[] registryNames;
    private String lastCustomEndpoint = "http://yourdomain.org/cgi-bin/MOBY-Central.pl";
    private String lastCustomNamespace = "http://yourdomain.org/MOBY/Central";

    public SeahawkOptionsGUI(Frame owner) {
        super(owner, DIALOG_TITLE, true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        this.setLayout(gridbag);
        this.registriesList = new RegistriesList();
        Registry[] registries = this.registriesList.getAll();
        this.registryNames = new String[registries.length + 1];
        for (int i = 0; i < registries.length; ++i) {
            this.registryNames[i] = registries[i].getSynonym();
        }
        this.registryNames[i] = CUSTOM_REGISTRY_SYNONYM;
        c.insets = new Insets(3, 2, 3, 2);
        c.gridwidth = 2;
        c.fill = 2;
        JLabel label = new JLabel("Registry server:", 4);
        this.add((Component)label, c);
        this.registryComboBox = new JComboBox<String>(this.registryNames);
        this.registryComboBox.addActionListener(this);
        this.add((Component)this.registryComboBox, c);
        c.gridheight = 4;
        c.fill = 0;
        JPanel bPanel = new JPanel(new GridLayout(3, 0, 3, 3));
        this.resetButton = new JButton("Restore program defaults");
        this.resetButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.okButton = new JButton("Apply changes");
        this.okButton.addActionListener(this);
        bPanel.add(this.resetButton);
        bPanel.add(this.cancelButton);
        bPanel.add(this.okButton);
        this.add((Component)bPanel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridheight = 1;
        c.fill = 1;
        label = new JLabel("Description:", 4);
        label.setVerticalAlignment(1);
        this.add((Component)label, c);
        c.gridx = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.registryDescTextArea = new JTextPane();
        this.registryDescTextArea.setEditable(false);
        this.add((Component)this.registryDescTextArea, c);
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        label = new JLabel("Location:", 4);
        this.add((Component)label, c);
        c.gridx = 2;
        this.registryEndpoint = new JTextField(50);
        this.registryEndpoint.setEditable(false);
        this.add((Component)this.registryEndpoint, c);
        c.gridx = 0;
        c.gridy = 3;
        label = new JLabel("Namespace:", 4);
        this.add((Component)label, c);
        c.gridx = 2;
        this.registryNamespace = new JTextField(50);
        this.registryNamespace.setEditable(false);
        this.add((Component)this.registryNamespace, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 5;
        JSeparator line = new JSeparator();
        this.add((Component)line, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 2;
        label = new JLabel("OpenOffice Service Host & Port:", 4);
        label.setToolTipText(HTMLUtils.htmlifyToolTipText("Used to convert Word documents and other formats for display in Seahawk.  If left blank, no conversions will be performed, restricting data import.", 50));
        this.add((Component)label, c);
        c.gridx = 2;
        c.gridwidth = 1;
        this.converterHostTextField = new JTextField(12);
        this.converterHostTextField.setMinimumSize(this.converterHostTextField.getPreferredSize());
        this.add((Component)this.converterHostTextField, c);
        c.gridx = 3;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        this.converterPortTextField = new JTextField(5);
        this.converterPortTextField.setMinimumSize(this.converterPortTextField.getPreferredSize());
        this.add((Component)this.converterPortTextField, c);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 5;
        line = new JSeparator();
        this.add((Component)line, c);
        c.gridx = 0;
        c.gridy = 7;
        c.gridwidth = 4;
        c.gridheight = 1;
        this.sendReferrerCheckBox = new JCheckBox("Send referrer data to services");
        this.add((Component)this.sendReferrerCheckBox, c);
        c.gridy = 8;
        c.gridwidth = 5;
        line = new JSeparator();
        this.add((Component)line, c);
        c.gridy = 9;
        c.gridwidth = 2;
        label = new JLabel("Cache expiry (in hours)", 4);
        this.add((Component)label, c);
        c.gridx = 2;
        c.gridwidth = 1;
        c.fill = 0;
        this.cacheExpiryTextField = new JTextField(3);
        this.cacheExpiryTextField.setMinimumSize(this.cacheExpiryTextField.getPreferredSize());
        this.add((Component)this.cacheExpiryTextField, c);
        c.gridx = 3;
        c.gridwidth = 2;
        c.fill = 0;
        JPanel cbPanel = new JPanel(new GridLayout(1, 0, 4, 2));
        this.deleteCacheButton = new JButton("Delete cached items");
        this.deleteCacheButton.addActionListener(this);
        this.selectCacheDirButton = new JButton("Change cache directory");
        this.selectCacheDirButton.addActionListener(this);
        cbPanel.add(this.deleteCacheButton);
        cbPanel.add(this.selectCacheDirButton);
        this.cacheDirFileChooser = new JFileChooser();
        this.cacheDirFileChooser.setFileSelectionMode(1);
        this.add((Component)cbPanel, c);
        this.setCurrentValues();
        this.pack();
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.cancelButton) {
            this.setCurrentValues();
            this.setVisible(false);
        } else if (source == this.okButton) {
            this.saveSettings();
        } else if (source == this.resetButton) {
            this.setDefaultValues();
        } else if (source == this.selectCacheDirButton) {
            int choice = this.cacheDirFileChooser.showOpenDialog(this);
            if (choice != 0) {
                this.cacheDirFileChooser.setSelectedFile(SeahawkOptions.getTempDir());
            }
        } else if (source == this.deleteCacheButton) {
            RegistryCache.deleteAllCacheFiles();
        } else if (source == this.registryComboBox) {
            this.updateRegistryFields();
        }
    }

    private void setCurrentValues() {
        Registry currentRegistry = SeahawkOptions.getRegistry();
        if (currentRegistry == null) {
            this.registryComboBox.setSelectedItem("default");
        } else if (currentRegistry.getSynonym().equals("custom")) {
            this.registryComboBox.setSelectedItem(CUSTOM_REGISTRY_SYNONYM);
            this.lastCustomEndpoint = currentRegistry.getEndpoint();
            this.lastCustomNamespace = currentRegistry.getNamespace();
        } else {
            this.registryComboBox.setSelectedItem(currentRegistry.getSynonym());
        }
        this.updateRegistryFields();
        this.converterHostTextField.setText("" + SeahawkOptions.getDocConverterHost());
        this.converterPortTextField.setText("" + SeahawkOptions.getDocConverterPort());
        this.sendReferrerCheckBox.setSelected(SeahawkOptions.getSendReferrerPolicy());
        this.cacheExpiryTextField.setText("" + SeahawkOptions.getCacheExpiry());
        this.cacheDirFileChooser.setSelectedFile(SeahawkOptions.getTempDir());
    }

    private void saveSettings() {
        double expiry = SeahawkOptions.getCacheExpiry();
        try {
            expiry = Double.parseDouble(this.cacheExpiryTextField.getText());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "The cache expiry field is not a number,\nplease correct it to continue", "Invalid Number Formatting", 0);
            return;
        }
        int port = SeahawkOptions.getDocConverterPort();
        try {
            port = Integer.parseInt(this.converterPortTextField.getText());
            SeahawkOptions.setDocConverterPort(port);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "The converter port field is not an positive integer,\nplease correct it to continue", "Invalid Integer Formatting", 0);
            return;
        }
        Registry previousRegistry = SeahawkOptions.getRegistry();
        String selectedRegistryName = this.registryComboBox.getSelectedItem().toString();
        if (selectedRegistryName.equals(CUSTOM_REGISTRY_SYNONYM)) {
            SeahawkOptions.setRegistry(new Registry("custom", this.registryEndpoint.getText(), this.registryNamespace.getText()));
        } else {
            try {
                SeahawkOptions.setRegistry(this.registriesList.get(selectedRegistryName));
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "The registry information could not be saved properly,\nsee the console for more details.  Aborting save.", "Registry Specification Error", 0);
                return;
            }
        }
        try {
            SeahawkOptions.setTempDir(this.cacheDirFileChooser.getSelectedFile());
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Please select another directory for the cache.\nThe specified cache directory (" + this.cacheDirFileChooser.getSelectedFile() + ") is not suitable:\n" + e.getMessage(), "Cache Specification Error", 0);
            SeahawkOptions.setRegistry(previousRegistry);
            return;
        }
        SeahawkOptions.setDocConverterHost(this.converterHostTextField.getText().trim());
        SeahawkOptions.setSendReferrerPolicy(this.sendReferrerCheckBox.isSelected());
        SeahawkOptions.setCacheExpiry(expiry);
        if (!SeahawkOptions.saveSettings()) {
            JOptionPane.showMessageDialog(null, "Sorry, but there was an error saving your preferences.\nPlease see the console for more details.", "Error Saving Preferences", 0);
        }
        this.setVisible(false);
    }

    private void setDefaultValues() {
        File defaultsFile = SeahawkOptions.getDefaultsFile();
        if (defaultsFile.exists()) {
            defaultsFile.delete();
        }
        JOptionPane.showMessageDialog(null, "Please restart Seahawk to continue with the default settings.", "Custom Settings Deleted", 1);
        this.setVisible(false);
    }

    private void updateRegistryFields() {
        String selectedRegistryName = this.registryComboBox.getSelectedItem().toString();
        if (selectedRegistryName.equals(CUSTOM_REGISTRY_SYNONYM)) {
            this.registryDescTextArea.setText(CUSTOM_REGISTRY_DESC);
            this.registryEndpoint.setEditable(true);
            this.registryEndpoint.setText(this.lastCustomEndpoint);
            this.registryNamespace.setEditable(true);
            this.registryNamespace.setText(this.lastCustomNamespace);
            this.pack();
            return;
        }
        if (this.registryDescTextArea.getText().equals(CUSTOM_REGISTRY_DESC)) {
            this.lastCustomEndpoint = this.registryEndpoint.getText();
            this.lastCustomNamespace = this.registryNamespace.getText();
        }
        try {
            Registry selectedRegistry = this.registriesList.get(this.registryComboBox.getSelectedItem().toString());
            String desc = selectedRegistry.getDescription();
            String newDesc = "";
            if (desc != null) {
                int charCount = 0;
                int curLine = 0;
                for (String word : desc.split(" ")) {
                    if ((charCount += word.length() + 1) / 60 > curLine) {
                        ++curLine;
                        --charCount;
                        newDesc = newDesc + "\n";
                    }
                    newDesc = newDesc + word + " ";
                }
            }
            this.registryDescTextArea.setText(newDesc);
            this.registryEndpoint.setText(selectedRegistry.getEndpoint());
            this.registryEndpoint.setEditable(false);
            this.registryNamespace.setText(selectedRegistry.getNamespace());
            this.registryNamespace.setEditable(false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.pack();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.setCurrentValues();
        this.setVisible(false);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("test");
        frame.setDefaultCloseOperation(2);
        SeahawkOptionsGUI dialog = new SeahawkOptionsGUI(frame);
        frame.pack();
        frame.setVisible(true);
        dialog.setVisible(true);
    }
}

