/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.seahawk.services;

import java.util.regex.Pattern;

public class RegexParser {
    public static boolean isPosixCharacterClass(String className) {
        if (className == null) {
            return false;
        }
        return className.equals("Lower") || className.equals("Upper") || className.equals("ASCII") || className.equals("Alpha") || className.equals("Digit") || className.equals("Alnum") || className.equals("Punct") || className.equals("Graph") || className.equals("Print") || className.equals("Blank") || className.equals("Cntrl") || className.equals("XDigit") || className.equals("Space") || className.equals("javaLowerCase") || className.equals("javaUpperCase") || className.equals("javaWhitespace") || className.equals("javaMirrored") || className.equals("InGreek") || className.equals("Lu") || className.equals("Sc") || className.equals("InGreek");
    }

    public static int locationToCaptureGroupNumber(String seahawkPattern, int targetPosition) throws Exception {
        int groupCount;
        for (int i = groupCount = RegexParser.groupCount(seahawkPattern); i > 0; --i) {
            int[] groupRange = RegexParser.getCaptureGroupRange(seahawkPattern, i, true);
            if (groupRange[0] > targetPosition || groupRange[1] < targetPosition) continue;
            return i;
        }
        return 0;
    }

    public static String getCaptureGroupRegex(Pattern pat, int groupNumber) throws Exception {
        int[] range = RegexParser.getCaptureGroupRange(pat, groupNumber, false);
        return pat.pattern().substring(range[0], range[1] + 1);
    }

    public static int[] getCaptureGroupRange(Pattern pat, int groupNumber) throws Exception {
        return RegexParser.getCaptureGroupRange(pat, groupNumber, false);
    }

    public static int groupCount(Pattern pat) {
        if (pat == null) {
            return 0;
        }
        return RegexParser.groupCount(pat.pattern());
    }

    protected static int groupCount(String pattern) {
        if (pattern == null) {
            return 0;
        }
        int groupCount = 0;
        for (int i = 0; i < pattern.length(); ++i) {
            if (pattern.charAt(i) != '(' || i - 1 > 0 && pattern.charAt(i - 1) == '\\' || i + 1 < pattern.length() && pattern.charAt(i + 1) == '?') continue;
            ++groupCount;
        }
        return groupCount;
    }

    public static int[] getCaptureGroupRange(Pattern pat, int groupNumber, boolean includeQuantifier) throws Exception {
        if (pat == null) {
            return null;
        }
        return RegexParser.getCaptureGroupRange(pat.pattern(), groupNumber, includeQuantifier);
    }

    static int[] getCaptureGroupRange(String pattern, int groupNumber, boolean includeQuantifier) throws Exception {
        int i;
        if (groupNumber < 0) {
            throw new IllegalArgumentException("The capture group to parse out (" + groupNumber + ") was not zero or a positive integer as required");
        }
        if (groupNumber > RegexParser.groupCount(pattern)) {
            throw new IllegalArgumentException("Was asked for capture group " + groupNumber + ", but there are only " + RegexParser.groupCount(pattern) + " in the match for regex " + pattern);
        }
        if (groupNumber == 0) {
            return new int[]{0, pattern.length() - 1};
        }
        int groupCount = 0;
        for (i = 0; i < pattern.length() && (pattern.charAt(i) != '(' || i - 1 > 0 && pattern.charAt(i - 1) == '\\' || i + 1 < pattern.length() && pattern.charAt(i + 1) == '?' || ++groupCount != groupNumber); ++i) {
        }
        int openParenthesisIndex = i++;
        int nestedParentheses = 0;
        while (i < pattern.length()) {
            if (pattern.charAt(i) == '(') {
                if (i - 1 <= 0 || pattern.charAt(i - 1) != '\\') {
                    nestedParentheses = i + 1 < pattern.length() && pattern.charAt(i + 1) == '?' ? ++nestedParentheses : ++nestedParentheses;
                }
            } else if (pattern.charAt(i) == ')' && (i - 1 <= 0 || pattern.charAt(i - 1) != '\\') && nestedParentheses-- == 0) break;
            ++i;
        }
        int closeParenthesisIndex = i++;
        if (includeQuantifier) {
            boolean hasQuantifier = true;
            char nextChar = pattern.charAt(i);
            if (nextChar == '{') {
                ++i;
                while (i < pattern.length()) {
                    if (pattern.charAt(i) == '}') {
                        closeParenthesisIndex = i;
                        break;
                    }
                    ++i;
                }
            } else if (nextChar == '*') {
                ++closeParenthesisIndex;
            } else if (nextChar == '+') {
                ++closeParenthesisIndex;
            } else if (nextChar == '?') {
                ++closeParenthesisIndex;
            } else {
                hasQuantifier = false;
            }
            if (hasQuantifier && i < pattern.length() - 1 && pattern.charAt(++i) == '?') {
                ++closeParenthesisIndex;
            }
        }
        if (openParenthesisIndex >= pattern.length()) {
            throw new Exception("Parsing error: Could not find the start of the regex capture group #" + groupNumber);
        }
        if (closeParenthesisIndex >= pattern.length()) {
            throw new Exception("Parsing error: Could not find the end of the regex capture group #" + groupNumber);
        }
        if (includeQuantifier) {
            return new int[]{openParenthesisIndex, closeParenthesisIndex};
        }
        return new int[]{openParenthesisIndex + 1, closeParenthesisIndex - 1};
    }
}

