/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.seahawk.util;

import ca.ucalgary.seahawk.util.SeahawkOptions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.biomoby.registry.meta.Registry;
import org.biomoby.shared.data.MobyContentInstance;
import org.biomoby.shared.data.MobyDataBytes;
import org.biomoby.shared.data.MobyDataInstance;
import org.biomoby.shared.data.MobyDataJob;
import org.biomoby.shared.data.MobyDataObject;
import org.biomoby.shared.data.MobyDataObjectSet;
import org.biomoby.shared.data.MobyDataObjectVector;
import org.biomoby.shared.data.MobyDataUtils;
import org.w3c.dom.Element;

public class HTMLUtils {
    public static final String BINARY_DATA_LABEL = "[binary data not shown]";
    public static final String ACCEPTABLE_IMAGE_DATATYPE = "WebFormatImage";

    public static String encapsulateBinaryData(URL sourceMobyData, String html) throws Exception {
        return HTMLUtils.encapsulateBinaryData(sourceMobyData, html, null);
    }

    public static String encapsulateBinaryData(URL sourceMobyData, String html, Registry registry) throws Exception {
        MobyContentInstance dataPackage = MobyDataUtils.fromXMLDocument(sourceMobyData, registry);
        for (MobyDataJob job : dataPackage.values()) {
            for (MobyDataInstance primary : job.values()) {
                Vector<MobyDataObject> values = null;
                if (primary instanceof MobyDataObjectSet || primary instanceof MobyDataObjectVector) {
                    values = (Vector<MobyDataObject>)((Object)primary);
                } else {
                    if (!(primary instanceof MobyDataObject)) continue;
                    values = new Vector<MobyDataObject>();
                    values.add((MobyDataObject)primary);
                }
                for (MobyDataObject data : values) {
                    if (!(data instanceof MobyDataBytes)) continue;
                    MobyDataBytes binaryMobyObject = (MobyDataBytes)data;
                    String encodedData = binaryMobyObject.get("content").getValue().toString();
                    if (html.indexOf(encodedData) == -1) {
                        System.err.println("Could not find the encoded data in the html given!!!");
                    }
                    if (binaryMobyObject.getDataType().inheritsFrom(ACCEPTABLE_IMAGE_DATATYPE)) {
                        String imgSuffix = binaryMobyObject.getDataType().getName();
                        imgSuffix = imgSuffix.length() < 3 ? ".img" : "." + imgSuffix.substring(0, 3).toLowerCase();
                        File imageFile = File.createTempFile("seahawkSavedImage", imgSuffix);
                        imageFile.deleteOnExit();
                        FileOutputStream fos = new FileOutputStream(imageFile);
                        fos.write(binaryMobyObject.getBytes());
                        fos.close();
                        html = html.replace(encodedData, "<br><img src=\"" + imageFile.toURI().toURL() + "\">");
                        continue;
                    }
                    html = html.replace(encodedData, BINARY_DATA_LABEL);
                }
            }
        }
        return html;
    }

    public static String checkForHyperlinkText(String text) {
        if (text.indexOf("<html><a href=\"") == 0 && text.indexOf("</a></html>") == text.length() - 11) {
            return text.substring(15, text.indexOf("\"", 15));
        }
        if (text.indexOf("<a href=\"") == 0 && text.indexOf("</a>") == text.length() - 4) {
            return text.substring(9, text.indexOf("\"", 9));
        }
        if (text.indexOf("<!--StartFragment--><a href=\"") != -1 && text.indexOf("</a><!--EndFragment-->") != -1) {
            int startHref = text.indexOf("<!--StartFragment--><a href=\"");
            return text.substring(startHref + 29, text.indexOf("\"", startHref + 29));
        }
        return null;
    }

    public static URL checkForURLShortcut(File file) throws Exception {
        URL u = null;
        String fileString = file.toURI().toURL().toString().toLowerCase();
        if (fileString.lastIndexOf(".url") == fileString.length() - 4) {
            LineNumberReader in = new LineNumberReader(new InputStreamReader(file.toURI().toURL().openStream()));
            String line = in.readLine();
            while (line != null) {
                int urlIndex = line.indexOf("URL=");
                if (line.indexOf("URL=") == 0) {
                    try {
                        u = new URL(line.substring(4));
                    }
                    catch (MalformedURLException murle) {
                        System.err.println("Could not format " + line);
                        murle.printStackTrace();
                    }
                    break;
                }
                line = in.readLine();
            }
        }
        return u;
    }

    public static String htmlifyToolTipText(String text, int maxLineLength) {
        String[] tokens;
        if (text == null) {
            // empty if block
        }
        if (text.length() < maxLineLength || maxLineLength < 2) {
            return "<html>" + text + "</html>";
        }
        StringBuffer result = new StringBuffer("<html>");
        int lineCharCount = 0;
        for (String word : tokens = text.split("[ \t\n]")) {
            while (word.length() + 1 > maxLineLength) {
                int cutPoint = maxLineLength - lineCharCount - 1;
                if (cutPoint < word.length() - 1) {
                    cutPoint = word.length() - 1;
                }
                if (cutPoint < 0) break;
                result.append(word.substring(0, cutPoint) + "-<br>");
                lineCharCount = 0;
                word = word.substring(cutPoint);
            }
            if (lineCharCount != 0 && lineCharCount + word.length() > maxLineLength) {
                result.append("<br>" + word + " ");
                lineCharCount = word.length() + 1;
                continue;
            }
            result.append(word + " ");
            lineCharCount += word.length() + 1;
        }
        result.append("</html>");
        return result.toString();
    }

    public static MobyContentInstance checkForMobyXML(String text) {
        int preStart;
        if (text.indexOf("namespace=\"") == -1 || text.indexOf("id=\"") == -1) {
            return null;
        }
        MobyContentInstance content = null;
        String xmltext = text;
        if (xmltext.indexOf("??") == 0) {
            xmltext = xmltext.substring(2);
        }
        if ((preStart = xmltext.indexOf("<pre")) == 0 || preStart == 2 || xmltext.indexOf("--StartFragment--") != -1) {
            xmltext = xmltext.substring(preStart, xmltext.indexOf("</pre"));
            xmltext = xmltext.substring(xmltext.indexOf(">") + 1);
            xmltext = xmltext.replaceAll("&gt;", ">");
            xmltext = xmltext.replaceAll("&lt;", "<");
            xmltext = xmltext.replaceAll("&amp;", "&");
        }
        xmltext = xmltext.trim();
        try {
            Element data;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            if (xmltext.indexOf("xmlns:moby") == -1) {
                xmltext = xmltext.replaceFirst("<([A-Za-z0-9_][^> \t\n]*)", "<$1 xmlns:moby=\"http://www.biomoby.org/moby\"");
            }
            if (xmltext.indexOf("<?xml") != 0) {
                xmltext = "<?xml version=\"1.0\"?>\n" + xmltext;
            }
            if ((data = db.parse(new ByteArrayInputStream(xmltext.getBytes())).getDocumentElement()).getLocalName().equals("MOBY")) {
                content = MobyDataUtils.fromXMLDocument(data, SeahawkOptions.getRegistry());
            } else if (data.getLocalName().equals("mobyContent")) {
                content = new MobyContentInstance(data, SeahawkOptions.getRegistry());
            } else if (data.getLocalName().equals("mobyData")) {
                content = new MobyContentInstance();
                content.parseDataGroup(data, SeahawkOptions.getRegistry());
            } else {
                content = new MobyContentInstance(MobyDataObject.createInstanceFromDOM(data, SeahawkOptions.getRegistry()), "Drag 'n' Drop data");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("This issue may or may not be related to your choice of registry (" + (SeahawkOptions.getRegistry() == null ? "MOBY default" : SeahawkOptions.getRegistry().getSynonym()) + ")");
            System.err.println(xmltext);
        }
        return content;
    }

    public static String getURLContents(URL u) throws IOException {
        StringBuffer buffer = new StringBuffer();
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(u.openStream()));
        String line = reader.readLine();
        while (line != null) {
            buffer.append(line + "\n");
            line = reader.readLine();
        }
        return buffer.toString();
    }

    public static byte[] getURLContentBytes(URL u) throws IOException {
        InputStream urlStream = u.openStream();
        byte[] byteBufferChunk = new byte[1024];
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
        int r = urlStream.read(byteBufferChunk, 0, 1024);
        while (r != -1) {
            byteBuffer.write(byteBufferChunk, 0, r);
            r = urlStream.read(byteBufferChunk, 0, 1024);
        }
        return byteBuffer.toByteArray();
    }

    public static String getInputStreamContents(InputStream resourceStream) throws IOException {
        StringBuffer xml = new StringBuffer();
        byte[] dataBuffer = new byte[1024];
        int numBytesRead = resourceStream.read(dataBuffer);
        while (numBytesRead != -1) {
            xml.append(new String(dataBuffer, 0, numBytesRead));
            numBytesRead = resourceStream.read(dataBuffer);
        }
        return xml.toString();
    }
}

