/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.seahawk.util;

public class Sequence {
    public static boolean isNucleicAcid(String sequence) {
        sequence = sequence.replaceAll("\\s", "");
        String naChars = sequence.replaceAll("[^acgtunxACGTUNX]", "");
        String nonNAChars = sequence.replaceAll("[acgtumrwsykvhdbnxACGTUMRWSYKVHDBNX \\-\t\r\n]", "");
        double seqLen = sequence.length();
        return (double)naChars.length() / seqLen > 0.66 && (double)nonNAChars.length() / seqLen < 0.05;
    }

    public static boolean isDNA(String sequence) {
        sequence = sequence.replaceAll("\\s", "");
        String dnaChars = sequence.replaceAll("[^acgtnxACGTNX]", "");
        String nonDNAChars = sequence.replaceAll("[acgtmrwsykvhdbnxACGTMRWSYKVHDBNX \\-\t\r\n]", "");
        double seqLen = sequence.length();
        return (double)dnaChars.length() / seqLen > 0.66 && (double)nonDNAChars.length() / seqLen < 0.05;
    }

    public static boolean isRNA(String sequence) {
        sequence = sequence.replaceAll("\\s", "");
        String rnaChars = sequence.replaceAll("[^acgunxACGUNX]", "");
        String nonRNAChars = sequence.replaceAll("[acgumrwsykvhdbnxACGUMRWSYKVHDBNX \\-\t\r\n]", "");
        double seqLen = sequence.length();
        return (double)rnaChars.length() / seqLen > 0.66 && (double)nonRNAChars.length() / seqLen < 0.05;
    }

    public static boolean isProtein(String sequence) {
        sequence = sequence.replaceAll("\\s", "");
        String protChars = sequence.replaceAll("[^ARNDCQEGHILKMFPSTWYVBZXarndcqeghilkmfpstwyvbz*]", "");
        String nonProtChars = sequence.replaceAll("[ARNDCQEGHILKMFPSTWYVBZXarndcqeghilkmfpstwyvbz \\-\t\r\n]", "");
        double seqLen = sequence.length();
        return (double)protChars.length() / seqLen > 0.95 && (double)nonProtChars.length() / seqLen < 0.02;
    }

    public static String reverseComplement(String sequence) {
        if (sequence == null) {
            return null;
        }
        char aComp = 't';
        char AComp = 'T';
        if (Sequence.isRNA(sequence)) {
            aComp = 'u';
            AComp = 'U';
        }
        int seqLen = sequence.length();
        StringBuffer revComp = new StringBuffer(seqLen);
        revComp.setLength(seqLen);
        for (int i = 0; i < seqLen; ++i) {
            char compChar = 'X';
            switch (sequence.charAt(i)) {
                case 'a': {
                    compChar = aComp;
                    break;
                }
                case 'A': {
                    compChar = AComp;
                    break;
                }
                case 'c': {
                    compChar = 'g';
                    break;
                }
                case 'C': {
                    compChar = 'G';
                    break;
                }
                case 'g': {
                    compChar = 'c';
                    break;
                }
                case 'G': {
                    compChar = 'C';
                    break;
                }
                case 't': 
                case 'u': {
                    compChar = 'a';
                    break;
                }
                case 'T': 
                case 'U': {
                    compChar = 'A';
                    break;
                }
                case 'b': {
                    compChar = 'v';
                    break;
                }
                case 'B': {
                    compChar = 'V';
                    break;
                }
                case 'd': {
                    compChar = 'h';
                    break;
                }
                case 'D': {
                    compChar = 'H';
                    break;
                }
                case 'h': {
                    compChar = 'd';
                    break;
                }
                case 'H': {
                    compChar = 'd';
                    break;
                }
                case 'k': {
                    compChar = 'm';
                    break;
                }
                case 'K': {
                    compChar = 'M';
                    break;
                }
                case 'm': {
                    compChar = 'k';
                    break;
                }
                case 'M': {
                    compChar = 'K';
                    break;
                }
                case 'r': {
                    compChar = 'y';
                    break;
                }
                case 'R': {
                    compChar = 'Y';
                    break;
                }
                case 's': {
                    compChar = 's';
                    break;
                }
                case 'S': {
                    compChar = 'S';
                    break;
                }
                case 'v': {
                    compChar = 'b';
                    break;
                }
                case 'V': {
                    compChar = 'B';
                    break;
                }
                case 'w': {
                    compChar = 'w';
                    break;
                }
                case 'W': {
                    compChar = 'W';
                    break;
                }
                case 'y': {
                    compChar = 'r';
                    break;
                }
                case 'Y': {
                    compChar = 'R';
                    break;
                }
                case 'n': {
                    compChar = 'n';
                    break;
                }
                case 'N': {
                    compChar = 'N';
                    break;
                }
                case 'x': {
                    compChar = 'x';
                }
            }
            revComp.setCharAt(seqLen - i - 1, compChar);
        }
        return revComp.toString();
    }
}

