/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.BufferPipe;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.ExpressionSet;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.Pattern;
import com.hp.hpl.jena.graph.query.PatternCompiler;
import com.hp.hpl.jena.graph.query.PatternStageCompiler;
import com.hp.hpl.jena.graph.query.Pipe;
import com.hp.hpl.jena.graph.query.Stage;
import com.hp.hpl.jena.graph.query.Util;
import com.hp.hpl.jena.graph.query.ValuatorSet;
import com.hp.hpl.jena.graph.query.VariableIndexes;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PatternStage
extends Stage {
    protected Graph graph;
    protected Pattern[] compiled;
    protected ValuatorSet[] guards;
    protected Set[] boundVariables;
    private static final PatternCompiler compiler = new PatternStageCompiler();

    public PatternStage(Graph graph, Mapping mapping, ExpressionSet expressionSet, Triple[] tripleArray) {
        this.graph = graph;
        this.compiled = this.compile(mapping, tripleArray);
        this.boundVariables = this.makeBoundVariables(tripleArray);
        this.guards = this.makeGuards(mapping, expressionSet, tripleArray.length);
    }

    protected Set[] makeBoundVariables(Triple[] tripleArray) {
        int n = tripleArray.length;
        Set[] setArray = new Set[n];
        Set set = new HashSet();
        for (int i = 0; i < n; ++i) {
            setArray[i] = Util.union(set, (Set)Util.variablesOf((Triple)tripleArray[i]));
            set = setArray[i];
        }
        return setArray;
    }

    protected ValuatorSet[] makeGuards(Mapping mapping, ExpressionSet expressionSet, int n) {
        ValuatorSet[] valuatorSetArray = new ValuatorSet[n];
        for (int i = 0; i < n; ++i) {
            valuatorSetArray[i] = new ValuatorSet();
        }
        Iterator iterator = expressionSet.iterator();
        while (iterator.hasNext()) {
            this.plantWhereFullyBound((Expression)iterator.next(), iterator, mapping, valuatorSetArray);
        }
        return valuatorSetArray;
    }

    protected void plantWhereFullyBound(Expression expression, Iterator iterator, Mapping mapping, ValuatorSet[] valuatorSetArray) {
        for (int i = 0; i < this.boundVariables.length; ++i) {
            if (!this.canEval(expression, i)) continue;
            valuatorSetArray[i].add(expression.prepare((VariableIndexes)mapping));
            iterator.remove();
            return;
        }
    }

    protected boolean canEval(Expression expression, int n) {
        return this.boundVariables[n].containsAll(Expression.Util.variablesOf((Expression)expression));
    }

    protected Pattern[] compile(Mapping mapping, Triple[] tripleArray) {
        return this.compile(compiler, mapping, tripleArray);
    }

    protected Pattern[] compile(PatternCompiler patternCompiler, Mapping mapping, Triple[] tripleArray) {
        return PatternStageCompiler.compile((PatternCompiler)patternCompiler, (Mapping)mapping, (Triple[])tripleArray);
    }

    public Pipe deliver(Pipe pipe) {
        Pipe pipe2 = this.previous.deliver((Pipe)new BufferPipe());
        new /* Unavailable Anonymous Inner Class!! */.start();
        return pipe;
    }

    protected void run(Pipe pipe, Pipe pipe2) {
        while (this.stillOpen && pipe.hasNext()) {
            this.nest(pipe2, pipe.get(), 0);
        }
        pipe2.close();
    }

    protected void nest(Pipe pipe, Domain domain, int n) {
        if (n == this.compiled.length) {
            pipe.put(domain.copy());
        } else {
            Pattern pattern = this.compiled[n];
            ValuatorSet valuatorSet = this.guards[n];
            ExtendedIterator extendedIterator = this.graph.find(pattern.asTripleMatch(domain));
            while (this.stillOpen && extendedIterator.hasNext()) {
                if (!pattern.match(domain, (Triple)extendedIterator.next()) || !valuatorSet.evalBool((IndexValues)domain)) continue;
                this.nest(pipe, domain, n + 1);
            }
            extendedIterator.close();
        }
    }
}

