/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.daml.DAMLCommon;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.ontology.daml.DAMLProperty;
import com.hp.hpl.jena.ontology.daml.LiteralAccessor;
import com.hp.hpl.jena.ontology.daml.PropertyAccessor;
import com.hp.hpl.jena.ontology.daml.impl.DAMLCommonImpl;
import com.hp.hpl.jena.ontology.daml.impl.PropertyAccessorImpl;
import com.hp.hpl.jena.ontology.daml.impl.VocabularyManager;
import com.hp.hpl.jena.ontology.impl.OntPropertyImpl;
import com.hp.hpl.jena.ontology.impl.OntResourceImpl;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ConcatenatedIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.DAMLVocabulary;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashSet;
import java.util.Iterator;

public class DAMLPropertyImpl
extends OntPropertyImpl
implements DAMLProperty {
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            if (this.canWrap(node, enhGraph)) {
                return new DAMLPropertyImpl(node, enhGraph);
            }
            throw new ConversionException("Cannot convert node " + node.toString() + " to DAMLProperty");
        }

        public boolean canWrap(Node node, EnhGraph enhGraph) {
            return DAMLPropertyImpl.hasType(node, enhGraph, DAML_OIL.Property) || DAMLPropertyImpl.hasType(node, enhGraph, DAML_OIL.DatatypeProperty) || DAMLPropertyImpl.hasType(node, enhGraph, DAML_OIL.ObjectProperty);
        }
    };
    private DAMLVocabulary m_vocabulary = VocabularyManager.getDefaultVocabulary();
    private PropertyAccessor m_propDomain = new PropertyAccessorImpl(this.getVocabulary().domain(), (OntResource)this);
    private PropertyAccessor m_propRange = new PropertyAccessorImpl(this.getVocabulary().range(), (OntResource)this);
    private PropertyAccessor m_propSubPropertyOf = new PropertyAccessorImpl(this.getVocabulary().subPropertyOf(), (OntResource)this);
    private PropertyAccessor m_propSamePropertyAs = new PropertyAccessorImpl(this.getVocabulary().samePropertyAs(), (OntResource)this);
    private DAMLCommon m_common = null;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$daml$DAMLProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$daml$DAMLClass;

    public DAMLPropertyImpl(Node node, EnhGraph enhGraph) {
        super(node, enhGraph);
        this.m_common = new DAMLCommonImpl(node, enhGraph);
    }

    public void setRDFType(Resource resource, boolean bl) {
        this.m_common.setRDFType(resource, bl);
    }

    public DAMLModel getDAMLModel() {
        return this.m_common.getDAMLModel();
    }

    public ExtendedIterator getRDFTypes(boolean bl) {
        return this.m_common.getRDFTypes(bl);
    }

    public DAMLVocabulary getVocabulary() {
        return this.m_vocabulary;
    }

    public LiteralAccessor prop_label() {
        return this.m_common.prop_label();
    }

    public LiteralAccessor prop_comment() {
        return this.m_common.prop_comment();
    }

    public PropertyAccessor prop_equivalentTo() {
        return this.m_common.prop_equivalentTo();
    }

    public PropertyAccessor prop_type() {
        return this.m_common.prop_type();
    }

    public ExtendedIterator getEquivalentValues() {
        ConcatenatedIterator concatenatedIterator = new ConcatenatedIterator((Iterator)this.m_common.getEquivalentValues(), (Iterator)this.getSameProperties());
        return UniqueExtendedIterator.create((Iterator)concatenatedIterator).mapWith((Map1)new OntResourceImpl.AsMapper((OntResourceImpl)this, class$com$hp$hpl$jena$ontology$daml$DAMLProperty == null ? (class$com$hp$hpl$jena$ontology$daml$DAMLProperty = DAMLPropertyImpl.class$("com.hp.hpl.jena.ontology.daml.DAMLProperty")) : class$com$hp$hpl$jena$ontology$daml$DAMLProperty));
    }

    public ExtendedIterator getEquivalenceSet() {
        HashSet<DAMLPropertyImpl> hashSet = new HashSet<DAMLPropertyImpl>();
        hashSet.add(this);
        ExtendedIterator extendedIterator = this.getEquivalentValues();
        while (extendedIterator.hasNext()) {
            hashSet.add((DAMLPropertyImpl)extendedIterator.next());
        }
        hashSet.remove(this);
        return WrappedIterator.create(hashSet.iterator());
    }

    public void setIsUnique(boolean bl) {
        if (bl) {
            this.addRDFType(this.getVocabulary().UniqueProperty());
        } else {
            this.removeProperty(RDF.type, this.getVocabulary().UniqueProperty());
        }
    }

    public boolean isUnique() {
        return this.hasRDFType(this.getVocabulary().UniqueProperty());
    }

    public PropertyAccessor prop_domain() {
        return this.m_propDomain;
    }

    public PropertyAccessor prop_subPropertyOf() {
        return this.m_propSubPropertyOf;
    }

    public PropertyAccessor prop_samePropertyAs() {
        return this.m_propSamePropertyAs;
    }

    public PropertyAccessor prop_range() {
        return this.m_propRange;
    }

    public ExtendedIterator getSameProperties() {
        return WrappedIterator.create(super.listEquivalentProperties()).mapWith((Map1)new OntResourceImpl.AsMapper((OntResourceImpl)this, class$com$hp$hpl$jena$ontology$daml$DAMLProperty == null ? (class$com$hp$hpl$jena$ontology$daml$DAMLProperty = DAMLPropertyImpl.class$("com.hp.hpl.jena.ontology.daml.DAMLProperty")) : class$com$hp$hpl$jena$ontology$daml$DAMLProperty));
    }

    public ExtendedIterator getSuperProperties() {
        return this.getSuperProperties(true);
    }

    public ExtendedIterator getSuperProperties(boolean bl) {
        return WrappedIterator.create(this.listSuperProperties(!bl)).mapWith((Map1)new OntResourceImpl.AsMapper((OntResourceImpl)this, class$com$hp$hpl$jena$ontology$daml$DAMLProperty == null ? (class$com$hp$hpl$jena$ontology$daml$DAMLProperty = DAMLPropertyImpl.class$("com.hp.hpl.jena.ontology.daml.DAMLProperty")) : class$com$hp$hpl$jena$ontology$daml$DAMLProperty));
    }

    public ExtendedIterator getSubProperties() {
        return this.getSubProperties(true);
    }

    public ExtendedIterator getSubProperties(boolean bl) {
        return WrappedIterator.create(this.listSubProperties(!bl)).mapWith((Map1)new OntResourceImpl.AsMapper((OntResourceImpl)this, class$com$hp$hpl$jena$ontology$daml$DAMLProperty == null ? (class$com$hp$hpl$jena$ontology$daml$DAMLProperty = DAMLPropertyImpl.class$("com.hp.hpl.jena.ontology.daml.DAMLProperty")) : class$com$hp$hpl$jena$ontology$daml$DAMLProperty));
    }

    public ExtendedIterator getDomainClasses() {
        return WrappedIterator.create(this.listPropertyValues(this.getProfile().DOMAIN())).mapWith((Map1)new OntResourceImpl.AsMapper((OntResourceImpl)this, class$com$hp$hpl$jena$ontology$daml$DAMLClass == null ? (class$com$hp$hpl$jena$ontology$daml$DAMLClass = DAMLPropertyImpl.class$("com.hp.hpl.jena.ontology.daml.DAMLClass")) : class$com$hp$hpl$jena$ontology$daml$DAMLClass));
    }

    public ExtendedIterator getRangeClasses() {
        return WrappedIterator.create(this.listPropertyValues(this.getProfile().RANGE())).mapWith((Map1)new OntResourceImpl.AsMapper((OntResourceImpl)this, class$com$hp$hpl$jena$ontology$daml$DAMLClass == null ? (class$com$hp$hpl$jena$ontology$daml$DAMLClass = DAMLPropertyImpl.class$("com.hp.hpl.jena.ontology.daml.DAMLClass")) : class$com$hp$hpl$jena$ontology$daml$DAMLClass));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

