/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.biomoby.client.MobyRequest;
import org.biomoby.shared.MobyService;
import org.biomoby.shared.data.MobyContentInstance;
import org.biomoby.shared.data.MobyDataUtils;

public class MobyRequestEvent {
    protected boolean done = false;
    protected boolean consumed = false;
    protected int eventID;
    protected MobyContentInstance contents;
    protected MobyRequest originatingMobyRequest;
    protected String dataPayloadXML;
    protected MobyService service;
    protected Throwable exception;
    private static int nextEventID = 0;

    public MobyRequestEvent(MobyContentInstance mci, MobyRequest requestSource, MobyService serv, Throwable e, int id) {
        this.contents = mci;
        this.originatingMobyRequest = requestSource;
        this.exception = e;
        this.eventID = id;
        this.service = serv;
    }

    public MobyService getService() {
        return this.service;
    }

    public MobyContentInstance getContent() {
        if (this.contents != null) {
            return this.contents;
        }
        if (this.dataPayloadXML != null) {
            ByteArrayInputStream inBuffer = new ByteArrayInputStream(this.dataPayloadXML.getBytes());
            try {
                return MobyDataUtils.fromXMLDocument(inBuffer);
            }
            catch (Exception e) {
                System.err.println("Moby payload XML provided could not be parsed into a valid MobyContentInstance (returning null):" + e);
                return null;
            }
        }
        return null;
    }

    public void setContent(MobyContentInstance mci) {
        if (this.done) {
            return;
        }
        this.contents = mci;
        this.originatingMobyRequest.sendResponse(this);
        this.done = true;
    }

    public int getID() {
        return this.eventID;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable e) {
        if (this.done) {
            return;
        }
        this.exception = e;
        this.originatingMobyRequest.sendResponse(this);
        this.done = true;
    }

    public MobyRequest getSource() {
        return this.originatingMobyRequest;
    }

    public String getContentsXML() {
        if (this.dataPayloadXML != null) {
            return this.dataPayloadXML;
        }
        if (this.contents != null) {
            ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
            try {
                MobyDataUtils.toXMLDocument(outBuffer, this.contents);
            }
            catch (Exception e) {
                System.err.println("MobyContentInstance provided could not be turned into XML by MobyDataUtils (returning null):" + e);
                return null;
            }
            return outBuffer.toString();
        }
        return null;
    }

    public void setContentsXML(String xml) {
        this.dataPayloadXML = xml;
    }

    public void consume() {
        this.consumed = true;
    }

    public boolean isConsumed() {
        return this.consumed;
    }
}

