/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.shared;

import java.util.Enumeration;
import java.util.Vector;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyNamespace;
import org.biomoby.shared.MobyPrimaryData;
import org.biomoby.shared.MobyPrimaryDataSimple;
import org.biomoby.shared.Utils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MobyPrimaryDataSet
extends MobyPrimaryData {
    protected Vector<MobyPrimaryDataSimple> elements = new Vector();
    protected MobyDataType defaultDataType = new MobyDataType("Object");

    public MobyPrimaryDataSet(String name) {
        super(name);
    }

    public MobyPrimaryDataSet(Element elem) {
        super(elem.getAttribute("articleName"));
        NodeList children = elem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String childName = children.item(i).getNodeName();
            if (!childName.equals("Simple")) continue;
            this.addElement(new MobyPrimaryDataSimple((Element)children.item(i)));
        }
    }

    public MobyPrimaryDataSimple[] getElements() {
        Object[] result = new MobyPrimaryDataSimple[this.elements.size()];
        this.elements.copyInto(result);
        return result;
    }

    public void setElements(MobyPrimaryDataSimple[] value) {
        if (value == null) {
            this.elements.clear();
        } else {
            for (int i = 0; i < value.length; ++i) {
                this.elements.addElement(value[i]);
            }
        }
    }

    public void addElement(MobyPrimaryDataSimple value) {
        this.elements.addElement(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MobyDataType getDataType() {
        Vector<MobyPrimaryDataSimple> vector = this.elements;
        synchronized (vector) {
            if (this.elements.size() > 0) {
                return this.elements.firstElement().getDataType();
            }
            return this.defaultDataType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataType(MobyDataType dataType) {
        this.defaultDataType = dataType;
        Vector<MobyPrimaryDataSimple> vector = this.elements;
        synchronized (vector) {
            Enumeration<MobyPrimaryDataSimple> en = this.elements.elements();
            while (en.hasMoreElements()) {
                en.nextElement().setDataType(dataType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MobyNamespace[] getNamespaces() {
        Vector<MobyPrimaryDataSimple> vector = this.elements;
        synchronized (vector) {
            if (this.elements.size() > 0) {
                return this.elements.firstElement().getNamespaces();
            }
            return new MobyNamespace[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNamespaces(MobyNamespace[] value) {
        Vector<MobyPrimaryDataSimple> vector = this.elements;
        synchronized (vector) {
            Enumeration<MobyPrimaryDataSimple> en = this.elements.elements();
            while (en.hasMoreElements()) {
                en.nextElement().setNamespaces(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNamespace(MobyNamespace value) {
        Vector<MobyPrimaryDataSimple> vector = this.elements;
        synchronized (vector) {
            Enumeration<MobyPrimaryDataSimple> en = this.elements.elements();
            while (en.hasMoreElements()) {
                en.nextElement().addNamespace(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNamespace(String namespaceName) {
        Vector<MobyPrimaryDataSimple> vector = this.elements;
        synchronized (vector) {
            Enumeration<MobyPrimaryDataSimple> en = this.elements.elements();
            while (en.hasMoreElements()) {
                en.nextElement().removeNamespace(namespaceName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNamespace(MobyNamespace value) {
        Vector<MobyPrimaryDataSimple> vector = this.elements;
        synchronized (vector) {
            Enumeration<MobyPrimaryDataSimple> en = this.elements.elements();
            while (en.hasMoreElements()) {
                en.nextElement().removeNamespace(value);
            }
        }
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("<Collection articleName=\"");
        buf.append(this.name);
        buf.append("\">\n");
        if (this.elements.size() > 0) {
            Enumeration<MobyPrimaryDataSimple> en = this.elements.elements();
            while (en.hasMoreElements()) {
                buf.append(en.nextElement().toXML());
            }
        } else {
            MobyPrimaryDataSimple template = new MobyPrimaryDataSimple();
            template.setDataType(this.defaultDataType);
            buf.append(template.toXML());
        }
        buf.append("</Collection>");
        buf.append("\n");
        return new String(buf);
    }

    public String format(int indent) {
        return Utils.format((Object)this, (int)indent);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.name != null && this.name.length() != 0) {
            buf.append("Name:    " + this.name + "\n");
        }
        if (this.id != null) {
            buf.append("ID:      " + this.id + "\n");
        }
        buf.append("Elements in collection:\n");
        Enumeration<MobyPrimaryDataSimple> en = this.elements.elements();
        while (en.hasMoreElements()) {
            buf.append(en.nextElement().format(1));
        }
        buf.append("\n");
        return new String(buf);
    }
}

