/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.shared.data;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.biomoby.registry.meta.Registry;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyNamespace;
import org.biomoby.shared.data.MobyDataObject;
import org.w3c.dom.Element;

public class MobyDataFloat
extends MobyDataObject {
    private BigDecimal value;

    public MobyDataFloat(Element element) throws IllegalArgumentException {
        this(element, null);
    }

    public MobyDataFloat(Element element, Registry registry) throws IllegalArgumentException {
        this(MobyDataFloat.getName(element), MobyDataFloat.getTextContents(element), registry);
        this.setId(MobyDataFloat.getId(element));
        this.addNamespace(MobyDataFloat.getNamespace(element, registry));
    }

    public MobyDataFloat(String articleName, Number n) {
        this(articleName, n, null);
    }

    public MobyDataFloat(String articleName, Number n, Registry r) {
        super(articleName, r);
        this.setDataType(MobyDataType.getDataType("Float", r));
        this.value = n instanceof BigDecimal ? (BigDecimal)n : (n instanceof BigInteger ? new BigDecimal(((BigInteger)n).toString()) : new BigDecimal(n.doubleValue()));
    }

    public MobyDataFloat(Number n, Registry r) {
        this("", n, r);
    }

    public MobyDataFloat(Number n) {
        this("", n, null);
    }

    public MobyDataFloat(String articleName, double d) {
        this(articleName, d, (Registry)null);
    }

    public MobyDataFloat(String articleName, double d, Registry registry) {
        super(articleName);
        this.setDataType(MobyDataType.getDataType("Float", registry));
        this.value = new BigDecimal(d);
    }

    public MobyDataFloat(double d, Registry r) {
        this("", d, r);
    }

    public MobyDataFloat(double d) {
        this("", d, (Registry)null);
    }

    public MobyDataFloat(String articleName, String stringNumber) throws NumberFormatException {
        this(articleName, stringNumber, null);
    }

    public MobyDataFloat(String articleName, String stringNumber, Registry registry) throws NumberFormatException {
        super(articleName, registry);
        this.setDataType(MobyDataType.getDataType("Float", registry));
        this.value = new BigDecimal(stringNumber.trim());
    }

    public MobyDataFloat(String stringNumber) {
        this("", stringNumber, null);
    }

    public MobyDataFloat(String stringNumber, Registry registry) {
        this("", stringNumber, registry);
    }

    public Object clone() {
        MobyDataFloat copy = new MobyDataFloat(this.getName(), this.value, this.getDataType().getRegistry());
        copy.setDataType(this.getDataType());
        copy.setId(this.getId());
        copy.setNamespaces(this.getNamespaces());
        return copy;
    }

    public void add(Number n) {
        this.value = n instanceof BigInteger ? this.value.add(new BigDecimal((BigInteger)n)) : (n instanceof BigDecimal ? this.value.add((BigDecimal)n) : this.value.add(new BigDecimal("" + n)));
    }

    public void subtract(Number n) {
        this.value = n instanceof BigInteger ? this.value.subtract(new BigDecimal((BigInteger)n)) : (n instanceof BigDecimal ? this.value.subtract((BigDecimal)n) : this.value.subtract(new BigDecimal("" + n)));
    }

    public void multiply(Number n) {
        this.value = n instanceof BigInteger ? this.value.multiply(new BigDecimal((BigInteger)n)) : (n instanceof BigDecimal ? this.value.multiply((BigDecimal)n) : this.value.multiply(new BigDecimal("" + n)));
    }

    public void divide(Number n) {
        this.divide(n, 6);
    }

    public void divide(Number n, int mode) {
        this.value = n instanceof BigInteger ? this.value.divide(new BigDecimal((BigInteger)n), mode) : (n instanceof BigDecimal ? this.value.divide((BigDecimal)n, mode) : this.value.divide(new BigDecimal("" + n), mode));
    }

    public void pow(Number n) {
        boolean powerIsInteger = (double)n.longValue() == n.doubleValue();
        double ourDoubleValue = this.value.doubleValue();
        if (ourDoubleValue == Double.POSITIVE_INFINITY || ourDoubleValue == Double.NEGATIVE_INFINITY || powerIsInteger) {
            if (!powerIsInteger) {
                return;
            }
            long power = n.longValue();
            if (power == 0L) {
                this.value = new BigDecimal(1);
                return;
            }
            if (power < 0L) {
                for (long i = 1L; i >= power; --i) {
                    this.divide(this.value);
                }
            } else {
                for (long i = 1L; i <= power; ++i) {
                    this.multiply(this.value);
                }
            }
        } else {
            double pow = StrictMath.pow(ourDoubleValue, n.doubleValue());
            if (pow == Double.POSITIVE_INFINITY || pow == Double.NEGATIVE_INFINITY) {
                return;
            }
            this.value = new BigDecimal(pow);
        }
    }

    public Object getObject() {
        return this.value;
    }

    public double doubleValue() {
        return this.value.doubleValue();
    }

    public String getValue() {
        return "" + this.value;
    }

    public int compareTo(Object object) {
        if (object instanceof BigInteger) {
            return this.value.compareTo(new BigDecimal((BigInteger)object));
        }
        if (object instanceof BigDecimal) {
            return this.value.compareTo((BigDecimal)object);
        }
        if (object instanceof MobyDataObject) {
            return this.compareTo(((MobyDataObject)object).getObject());
        }
        if (object instanceof Number) {
            if (this.value.compareTo(new BigDecimal("1.7976931348623157E308")) > 0) {
                return 1;
            }
            if (this.value.compareTo(new BigDecimal("4.9E-324")) < 0) {
                return -1;
            }
            double diff = this.value.doubleValue() - ((Number)object).doubleValue();
            if (diff == 0.0) {
                return 0;
            }
            if (diff < 0.0) {
                return -1;
            }
            return 1;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (object instanceof BigDecimal) {
            return this.value.equals(object);
        }
        if (object instanceof BigInteger) {
            return this.value.equals(new BigDecimal((BigInteger)object));
        }
        if (object instanceof MobyDataObject) {
            return this.equals(((MobyDataObject)object).getObject());
        }
        if (object instanceof Number && this.value.compareTo(new BigDecimal("1.7976931348623157E308")) <= 0 && this.value.compareTo(new BigDecimal("4.9E-324")) >= 0) {
            return this.value.doubleValue() == ((Number)object).doubleValue();
        }
        return false;
    }

    public String toXML() {
        MobyNamespace[] ns = this.getNamespaces();
        if (this.xmlMode == 891) {
            return "<Float " + this.getAttrXML() + ">" + this.value.toString() + "</" + "Float" + ">";
        }
        return super.toXML();
    }
}

