/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.shared.data;

import java.io.StringWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.biomoby.registry.meta.Registry;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyNamespace;
import org.biomoby.shared.MobyObjectDecompositionImpl;
import org.biomoby.shared.MobyPrefixResolver;
import org.biomoby.shared.MobyPrimaryDataSimple;
import org.biomoby.shared.data.MobyDataBoolean;
import org.biomoby.shared.data.MobyDataBytes;
import org.biomoby.shared.data.MobyDataComposite;
import org.biomoby.shared.data.MobyDataDateTime;
import org.biomoby.shared.data.MobyDataFloat;
import org.biomoby.shared.data.MobyDataInstance;
import org.biomoby.shared.data.MobyDataInt;
import org.biomoby.shared.data.MobyDataObjectSet;
import org.biomoby.shared.data.MobyDataSecondaryInstance;
import org.biomoby.shared.data.MobyDataString;
import org.biomoby.shared.data.MobyDataXref;
import org.biomoby.shared.data.MobyProvisionInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MobyDataObject
extends MobyPrimaryDataSimple
implements MobyDataInstance,
Cloneable,
Comparable {
    protected int xmlMode = 124;
    private Object object = new Object();
    private Vector<MobyDataObject> CRIBVector = null;
    private MobyProvisionInfo provisionInfo = null;

    public MobyDataObject(Element element) throws MobyException {
        this(element, null);
    }

    public MobyDataObject(Element element, Registry registry) throws MobyException {
        this(MobyDataObject.getNamespace(element, registry).getName(), MobyDataObject.getId(element), registry);
        this.setName(MobyDataObject.getName(element));
    }

    public MobyDataObject(String name) {
        this(name, (Registry)null);
    }

    public MobyDataObject(String name, Registry registry) {
        super(name);
        this.setDataType(MobyDataType.getDataType("Object", registry));
    }

    public MobyDataObject(String namespace, String id) {
        this(namespace, id, null);
    }

    public MobyDataObject(String namespace, String id, Registry registry) {
        super("");
        this.setDataType(MobyDataType.getDataType("Object", registry));
        this.setId(id);
        MobyNamespace nsObj = MobyNamespace.getNamespace(namespace, registry);
        if (nsObj == null) {
            nsObj = new MobyNamespace(namespace == null ? "" : namespace);
        }
        this.addNamespace(nsObj);
    }

    public MobyDataObject(MobyDataObject mobj) {
        this(mobj.getName(), mobj.getDataType().getRegistry());
        this.setId(mobj.getId());
        this.setNamespaces(mobj.getNamespaces());
    }

    public static MobyDataObject createInstanceFromString(String typeName, String value) throws MobyException {
        return MobyDataObject.createInstanceFromString(typeName, value, null);
    }

    public static MobyDataObject createInstanceFromString(String typeName, String value, Registry registry) throws MobyException {
        if (typeName == null) {
            return null;
        }
        if ("Object".equals(typeName)) {
            return new MobyDataObject("", value, registry);
        }
        if ("Integer".equals(typeName)) {
            return new MobyDataInt("", value, registry);
        }
        if ("Float".equals(typeName)) {
            return new MobyDataFloat("", value, registry);
        }
        if ("String".equals(typeName)) {
            return new MobyDataString("", (CharSequence)value, registry);
        }
        if ("Boolean".equals(typeName)) {
            return new MobyDataBoolean("", value, registry);
        }
        if ("DateTime".equals(typeName)) {
            return new MobyDataDateTime("", value, registry);
        }
        MobyDataType type = MobyDataType.getDataType(typeName, registry);
        if (type != null && type.inheritsFrom("text-base64")) {
            return new MobyDataBytes("", (CharSequence)value, type);
        }
        throw new MobyException("Attempted to construct a data instance from a string value for a non-primitive data type (" + typeName + ")");
    }

    public static MobyDataInstance createInstanceFromDOM(Element objectTag) throws MobyException {
        return MobyDataObject.createInstanceFromDOM(objectTag, null);
    }

    public static MobyDataInstance createInstanceFromDOM(Element objectTag, Registry registry) throws MobyException {
        Object object = null;
        if (objectTag == null) {
            return null;
        }
        String objectClass = objectTag.getLocalName();
        if ("Simple".equals(objectClass)) {
            Element elementChild = MobyPrefixResolver.getChildElement(objectTag, "*");
            if (elementChild == null) {
                throw new IllegalArgumentException("Simple element has no MOBY child element, there is no instance to create");
            }
            return MobyDataObject.createInstanceFromDOM(elementChild, registry);
        }
        if ("Object".equals(objectClass)) {
            return new MobyDataObject(objectTag, registry);
        }
        if ("Integer".equals(objectClass)) {
            return new MobyDataInt(objectTag, registry);
        }
        if ("Float".equals(objectClass)) {
            return new MobyDataFloat(objectTag, registry);
        }
        if ("String".equals(objectClass)) {
            return new MobyDataString(objectTag, registry);
        }
        if ("Boolean".equals(objectClass)) {
            return new MobyDataBoolean(objectTag, registry);
        }
        if ("DateTime".equals(objectClass)) {
            return new MobyDataDateTime(objectTag, registry);
        }
        if ("Collection".equals(objectClass)) {
            return new MobyDataObjectSet(objectTag, registry);
        }
        if ("Parameter".equals(objectClass)) {
            return new MobyDataSecondaryInstance(objectTag);
        }
        MobyDataType type = MobyDataType.getDataType(objectClass, registry);
        if (type != null && type.inheritsFrom(MobyDataType.getDataType("text-base64", registry))) {
            return new MobyDataBytes(objectTag, registry);
        }
        return new MobyDataComposite(objectTag, registry);
    }

    public void setName(String name) {
        super.setName(name);
    }

    public static String getTextContents(Element element) {
        return MobyObjectDecompositionImpl.getTextContent(element, false);
    }

    protected static MobyNamespace getNamespace(Element e) {
        return MobyDataObject.getNamespace(e, null);
    }

    protected static MobyNamespace getNamespace(Element e, Registry registry) {
        String namespace = MobyPrefixResolver.getAttr(e, "namespace");
        MobyNamespace nsObj = MobyNamespace.getNamespace(namespace, registry);
        if (nsObj == null) {
            nsObj = new MobyNamespace(namespace == null ? "" : namespace);
            nsObj.setRegistry(registry);
        }
        return nsObj;
    }

    public static String getName(Element e) {
        Node p = e.getParentNode();
        String name = null;
        if (p != null && p instanceof Element && ((Element)p).getTagName().equals("Simple")) {
            name = MobyPrefixResolver.getAttr((Element)p, "articleName");
            if (name != null && name.length() > 0) {
                return name;
            }
            name = MobyPrefixResolver.getAttr(e, "articleName");
            return name == null ? "" : name;
        }
        name = MobyPrefixResolver.getAttr(e, "articleName");
        return name == null ? "" : name;
    }

    public static String getId(Element e) {
        String id = MobyPrefixResolver.getAttr(e, "id");
        return id == null ? "" : id;
    }

    public static MobyDataInstance createInstanceFromXML(String mobyXML) throws IllegalArgumentException {
        MobyDataInstance object = null;
        return object;
    }

    public boolean equals(Object passedInObject) throws ClassCastException {
        Object ourObject = this.getObject();
        if (passedInObject != null && passedInObject instanceof MobyDataObject) {
            if (((MobyDataObject)passedInObject).getDataType() == this.getDataType()) {
                int ourOldXMLMode = this.getXmlMode();
                int itsOldXMLMode = ((MobyDataObject)passedInObject).getXmlMode();
                this.setXmlMode(891);
                ((MobyDataObject)passedInObject).setXmlMode(891);
                boolean equality = ((MobyDataObject)passedInObject).toXML().equals(this.toXML());
                this.setXmlMode(ourOldXMLMode);
                ((MobyDataObject)passedInObject).setXmlMode(itsOldXMLMode);
                return equality;
            }
            passedInObject = ((MobyDataObject)passedInObject).getObject();
        }
        return ourObject.equals(passedInObject);
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof MobyDataObject)) {
            return -1;
        }
        MobyDataObject mdsi = (MobyDataObject)o;
        if (this.getValue() == null && mdsi.getValue() != null) {
            return 1;
        }
        if (this.getValue() != null && this.getValue().compareTo(mdsi.getValue()) != 0) {
            return this.getValue().compareTo(mdsi.getValue());
        }
        if (this.getId() == null && mdsi.getId() != null) {
            return 1;
        }
        if (this.getId() != null && this.getId().compareTo(mdsi.getId()) != 0) {
            return this.getId().compareTo(mdsi.getId());
        }
        if (this.getName() == null && mdsi.getName() != null) {
            return 1;
        }
        if (this.getName() != null) {
            return this.getName().compareTo(mdsi.getName());
        }
        return 0;
    }

    public void setXmlMode(int mode) throws IllegalArgumentException {
        if (mode != 124 && mode != 891) {
            throw new IllegalArgumentException("Value passed to setXmlMode was neither MobyDataInstance.CENTRAL_XML_MODE nor MobyDataInstance.SERVICE_XML_MODE");
        }
        this.xmlMode = mode;
    }

    public int getXmlMode() {
        return this.xmlMode;
    }

    private String domToXMLString(Node domnode) throws TransformerException {
        DOMSource domSource = new DOMSource(domnode);
        StringWriter stringout = new StringWriter();
        StreamResult streamResult = new StreamResult(stringout);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer serializer = tf.newTransformer();
        serializer.setOutputProperty("omit-xml-declaration", "yes");
        serializer.setOutputProperty("indent", "yes");
        serializer.transform(domSource, streamResult);
        return stringout.toString();
    }

    public Object getObject() {
        return this.object;
    }

    public String getValue() {
        return "[Object]";
    }

    public void addCrossReferences(Element e) throws MobyException {
        this.addCrossReferences(e, null);
    }

    public void addCrossReferences(Element e, Registry reg) throws MobyException {
        if (e == null) {
            throw new NullPointerException("Cannot add a null cross-reference element to an object");
        }
        if (e.getLocalName() == null) {
            throw new NullPointerException("Element name is null when trying to add cross-reference element");
        }
        if (!e.getLocalName().equals("CrossReference")) {
            throw new NullPointerException("Cannot add an element named '" + e.getLocalName() + "' as a CrossReference element");
        }
        NodeList substructures = MobyPrefixResolver.getChildElements(e, "*");
        int numSubstructures = substructures.getLength();
        for (int i = 0; i < numSubstructures; ++i) {
            Element child = (Element)substructures.item(i);
            String objectClass = child.getLocalName();
            if ("Object".equals(objectClass)) {
                this.addCrossReference(new MobyDataObject(child, reg));
                continue;
            }
            if ("Xref".equals(objectClass)) {
                this.addCrossReference(new MobyDataXref(child, reg));
                continue;
            }
            throw new MobyException("Cross-reference block contained an illegal child element (" + objectClass + "), only '" + "Object" + "' and '" + "Xref" + "' are allowed");
        }
    }

    public void addCrossReference(MobyDataObject mdsi) throws NullPointerException {
        if (mdsi == null) {
            throw new NullPointerException("Cannot add a null cross-reference to an object");
        }
        if (this.CRIBVector == null) {
            this.CRIBVector = new Vector();
        }
        if (mdsi instanceof MobyDataXref || mdsi.getClass().getName().equals("MobyDataObject")) {
            this.CRIBVector.add(mdsi);
        } else {
            this.CRIBVector.add(new MobyDataObject(mdsi));
        }
    }

    public Collection getCrossReferences() {
        if (this.CRIBVector == null) {
            this.CRIBVector = new Vector();
        }
        return this.CRIBVector;
    }

    public boolean hasCrossReferences() {
        return this.CRIBVector != null && !this.CRIBVector.isEmpty();
    }

    public void addProvisionInfo(Element e) throws MobyException {
        if (e == null) {
            throw new NullPointerException("Cannot add a null provision information element to an object");
        }
        if (e.getLocalName() == null) {
            throw new NullPointerException("Element name is null when trying to add provision information element");
        }
        if (!e.getLocalName().equals("ProvisionInformation")) {
            throw new NullPointerException("Cannot add an element named '" + e.getLocalName() + "' as a ProvisionInformation element");
        }
        this.setProvisionInfo(new MobyProvisionInfo(e));
    }

    public void setProvisionInfo(MobyProvisionInfo info) {
        this.provisionInfo = info;
    }

    public MobyProvisionInfo getProvisionInfo() {
        return this.provisionInfo;
    }

    public void setId(String value) {
        super.setId(value);
    }

    public String toString() {
        return this.toXML();
    }

    public Object clone() {
        MobyDataObject copy = null;
        copy = new MobyDataObject(this.getName(), this.getDataType().getRegistry());
        copy.setNamespaces(this.getNamespaces());
        copy.setId(this.getId());
        return copy;
    }

    public void setPrimaryNamespace(MobyNamespace ns) {
        MobyNamespace[] nss = this.getNamespaces();
        if (nss == null || nss.length == 0 || nss[0].getName().length() == 0) {
            this.addNamespace(ns);
            return;
        }
        for (int i = 0; i < nss.length; ++i) {
            if (nss[i] != ns) continue;
            if (i != 0) {
                nss[i] = nss[0];
                nss[0] = ns;
                this.setNamespaces(null);
                this.setNamespaces(nss);
            }
            return;
        }
        MobyNamespace[] newnss = new MobyNamespace[nss.length + 1];
        newnss[0] = ns;
        System.arraycopy(nss, 0, newnss, 1, nss.length);
        this.setNamespaces(null);
        this.setNamespaces(newnss);
    }

    public MobyNamespace getPrimaryNamespace() {
        MobyNamespace[] ns = this.getNamespaces();
        if (ns == null || ns.length == 0) {
            return null;
        }
        return ns[0];
    }

    protected String getCRIBXML() {
        if (!this.hasCrossReferences()) {
            return "";
        }
        StringBuffer crib = new StringBuffer();
        crib.append("<CrossReference>\n");
        for (MobyDataObject obj : this.CRIBVector) {
            if (obj == null) continue;
            if (obj instanceof MobyDataXref) {
                ((MobyDataXref)obj).setXmlMode(6766);
                crib.append(obj.toXML() + "\n");
                ((MobyDataXref)obj).setXmlMode(6767);
                continue;
            }
            if (!(obj instanceof MobyDataObject)) continue;
            int oldXMLMode = obj.getXmlMode();
            obj.setXmlMode(this.xmlMode);
            crib.append(obj.toXML() + "\n");
            obj.setXmlMode(oldXMLMode);
        }
        crib.append("</CrossReference>\n");
        return crib.toString();
    }

    public String toXML() {
        if (this.xmlMode == 891) {
            String pibXML;
            String cribXML = this.getCRIBXML();
            String string = pibXML = this.provisionInfo == null ? "" : this.provisionInfo.toXML();
            if (cribXML.length() != 0 || pibXML.length() != 0) {
                return "<" + this.getDataType().getName() + " " + this.getAttrXML() + ">\n" + cribXML + pibXML + "\"</" + this.getDataType().getName() + ">";
            }
            if (this.getDataType() == null) {
                return "<Object " + this.getAttrXML() + "/>";
            }
            return "<" + this.getDataType().getName() + " " + this.getAttrXML() + "/>";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<Simple articleName=\"not_important\">\n");
        buf.append("<objectType>");
        if (this.getDataType() != null) {
            buf.append(this.getDataType().getName());
        }
        buf.append("</objectType>\n");
        if (this.namespaces.size() > 0) {
            Enumeration en = this.namespaces.elements();
            while (en.hasMoreElements()) {
                MobyNamespace ns = (MobyNamespace)en.nextElement();
                if (ns == null) continue;
                buf.append("<Namespace>");
                buf.append(ns.getName());
                buf.append("</Namespace>");
            }
        }
        buf.append("</Simple>");
        buf.append("\n");
        return buf.toString();
    }

    protected String getAttrXML() {
        MobyNamespace[] ns = this.getNamespaces();
        String namespace = "";
        if (ns != null && ns.length != 0) {
            namespace = ns[0].getName();
        }
        return (this.getName() == null ? "" : "articleName=\"" + this.getName() + "\"") + " namespace=\"" + namespace + "\" id=\"" + (this.getId() == null ? "" : this.getId()) + "\"";
    }
}

