/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.shared.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.biomoby.registry.meta.Registry;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.data.MobyContentInstance;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MobyDataUtils {
    public static boolean toXMLDocument(OutputStream os, MobyContentInstance mci) throws Exception {
        return MobyDataUtils.toXMLDocument(os, mci, true);
    }

    public static boolean toXMLDocument(OutputStream os, MobyContentInstance mci, boolean includeXMLDeclaration) throws Exception {
        os.write("<?xml version=\"1.0\"?>\n".getBytes());
        os.write("<moby:MOBY xmlns:moby=\"http://www.biomoby.org/moby\" xmlns=\"http://www.biomoby.org/moby\" >\n".getBytes());
        os.write(mci.toXML().getBytes());
        os.write("\n</moby:MOBY>\n".getBytes());
        return true;
    }

    public static boolean toXMLDocument(Writer writer, MobyContentInstance mci) throws Exception {
        return MobyDataUtils.toXMLDocument(writer, mci, true);
    }

    public static boolean toXMLDocument(Writer writer, MobyContentInstance mci, boolean includeXMLDeclaration) throws Exception {
        writer.write("<?xml version=\"1.0\"?>\n");
        writer.write("<moby:MOBY xmlns:moby=\"http://www.biomoby.org/moby\" xmlns=\"http://www.biomoby.org/moby\">\n");
        writer.write(mci.toXML());
        writer.write("\n</moby:MOBY>\n");
        return true;
    }

    public static MobyContentInstance fromXMLDocument(String xmlData) throws Exception {
        return MobyDataUtils.fromXMLDocument(new StringReader(xmlData), null);
    }

    public static MobyContentInstance fromXMLDocument(String xmlData, Registry registry) throws Exception {
        return MobyDataUtils.fromXMLDocument(new StringReader(xmlData), registry);
    }

    public static MobyContentInstance fromXMLDocument(InputStream is) throws Exception {
        return MobyDataUtils.fromXMLDocument(is, null);
    }

    public static MobyContentInstance fromXMLDocument(InputStream is, Registry registry) throws Exception {
        DocumentBuilder docBuilder = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            docBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new Exception("An XML parser could not be found or configured: " + pce);
        }
        Document domDoc = null;
        try {
            domDoc = docBuilder.parse(is);
        }
        catch (SAXException saxe) {
            throw new Exception("The XML data could not be parsed (not well-formed): " + saxe);
        }
        catch (IOException ioe) {
            throw new Exception("The XML data could not be loaded (I/O problem): " + ioe);
        }
        Element doc_root = domDoc.getDocumentElement();
        return MobyDataUtils.fromXMLDocument(doc_root, registry);
    }

    public static MobyContentInstance fromXMLDocument(URL url) throws Exception {
        return MobyDataUtils.fromXMLDocument(url, null);
    }

    public static MobyContentInstance fromXMLDocument(URL url, Registry registry) throws Exception {
        DocumentBuilder docBuilder = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            docBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new Exception("An XML parser could not be found or configured: " + pce);
        }
        Document domDoc = null;
        try {
            domDoc = docBuilder.parse(url.toURI().toString());
        }
        catch (SAXException saxe) {
            throw new Exception("The XML data could not be parsed (not well-formed): " + saxe);
        }
        catch (IOException ioe) {
            throw new Exception("The XML data could not be loaded (I/O problem): " + ioe);
        }
        Element doc_root = domDoc.getDocumentElement();
        return MobyDataUtils.fromXMLDocument(doc_root, registry);
    }

    public static MobyContentInstance fromXMLDocument(Reader reader) throws Exception {
        return MobyDataUtils.fromXMLDocument(reader, null);
    }

    public static MobyContentInstance fromXMLDocument(Reader reader, Registry registry) throws Exception {
        DocumentBuilder docBuilder = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            docBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new Exception("An XML parser could not be found or configured: " + pce);
        }
        Document domDoc = null;
        try {
            domDoc = docBuilder.parse(new InputSource(reader));
        }
        catch (SAXException saxe) {
            throw new Exception("The XML data could not be parsed (not well-formed): " + saxe);
        }
        catch (IOException ioe) {
            throw new Exception("The XML data could not be loaded (I/O problem): " + ioe);
        }
        Element doc_root = domDoc.getDocumentElement();
        return MobyDataUtils.fromXMLDocument(doc_root, registry);
    }

    public static MobyContentInstance fromXMLDocument(Element doc_root) throws Exception {
        return MobyDataUtils.fromXMLDocument(doc_root, null);
    }

    public static MobyContentInstance fromXMLDocument(Element doc_root, Registry registry) throws Exception {
        if (doc_root == null) {
            throw new MobyException("The passed in element was null");
        }
        if (!"MOBY".equals(doc_root.getLocalName())) {
            throw new MobyException("The XML document's root element (" + doc_root.getLocalName() + ") was not " + "MOBY");
        }
        NodeList envelope = null;
        if (!"http://www.biomoby.org/moby".equals(doc_root.getNamespaceURI())) {
            if (!"http://www.biomoby.org/moby-s".equals(doc_root.getNamespaceURI())) {
                throw new MobyException("The XML document's root element namespace (" + doc_root.getNamespaceURI() + ") is not the MOBY namespace " + "http://www.biomoby.org/moby");
            }
            System.err.println("Invalid namespace used for root element (was " + doc_root.getNamespaceURI() + ", but should be " + "http://www.biomoby.org/moby" + ", proceeding anyway");
            envelope = doc_root.getElementsByTagNameNS("http://www.biomoby.org/moby-s", "mobyContent");
        } else {
            envelope = doc_root.getElementsByTagNameNS("http://www.biomoby.org/moby", "mobyContent");
        }
        if (envelope.getLength() == 0) {
            throw new MobyException("The document's MOBY element does not contain a mobyContent tag in the namspace http://www.biomoby.org/moby");
        }
        if (envelope.getLength() > 1) {
            throw new MobyException("The document's MOBY element contains more than one (" + envelope.getLength() + ") " + "mobyContent" + " tag in the namspace " + "http://www.biomoby.org/moby");
        }
        MobyContentInstance contents = new MobyContentInstance((Element)envelope.item(0), registry);
        return contents;
    }
}

