/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.shared.data;

import org.biomoby.registry.meta.Registry;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyNamespace;
import org.biomoby.shared.MobyPrefixResolver;
import org.biomoby.shared.MobyService;
import org.biomoby.shared.data.MobyDataObject;
import org.biomoby.shared.data.MobyDataObjectSAI;
import org.w3c.dom.Element;

public class MobyDataXref
extends MobyDataObjectSAI {
    private String serviceDescription;
    private String xrefType;
    private String evidenceCode;
    private boolean isCRIBXML = false;
    public static final int CRIB_XML_MODE_ON = 6766;
    public static final int CRIB_XML_MODE_OFF = 6767;
    public static final String IC = "Inferred by Curator";
    public static final String IDA = "Inferred from Direct Assay";
    public static final String IEA = "Inferred from Electronic Annotation";
    public static final String IEP = "Inferred from Expression Pattern";
    public static final String IGI = "Inferred from Genetic Interaction";
    public static final String IMP = "Inferred from Mutant Phenotype";
    public static final String IPI = "Inferred from Physical Interaction";
    public static final String ISS = "Inferred from Sequence or Structral similarity";
    public static final String NAS = "Non-traceable Author Statement";
    public static final String ND = "No biological Data available";
    public static final String RCA = "inferred from Reviewed Computational Analysis";
    public static final String TAS = "Traceable Author Statement";
    public static final String NR = "Not Recorded";

    public MobyDataXref(MobyNamespace namespace, String id, MobyService service) {
        super("", id, new MobyService[]{service}, service.getServiceType().getRegistry());
        this.addNamespace(namespace);
    }

    public MobyDataXref(String namespace, String id, MobyService service) {
        super("", id, new MobyService[]{service}, service.getServiceType().getRegistry());
        this.addNamespace(MobyNamespace.getNamespace(namespace));
    }

    public MobyDataXref(String namespace, String id, String serviceName, String authURI) {
        this(namespace, id, serviceName, authURI, null);
    }

    public MobyDataXref(String namespace, String id, String serviceName, String authURI, Registry registry) {
        super("", id, new MobyService[]{MobyService.getService(serviceName, authURI)}, registry);
        this.addNamespace(MobyNamespace.getNamespace(namespace));
        this.getService().setAuthority(authURI);
    }

    public MobyDataXref(Element e) throws MobyException {
        this(e, (Registry)null);
    }

    public MobyDataXref(Element e, Registry registry) throws MobyException {
        this(MobyDataXref.getNamespace(e).getName(), MobyDataXref.getId(e), MobyPrefixResolver.getAttr(e, "serviceName"), MobyPrefixResolver.getAttr(e, "authURI"), registry);
        this.setEvidenceCodeByAbbrev(MobyPrefixResolver.getAttr(e, "evidenceCode"));
        this.setXrefType(MobyPrefixResolver.getAttr(e, "xrefType"));
        String d = e.getTextContent();
        if (d != null && d.length() > 0) {
            this.setDescription(d);
        }
    }

    public MobyDataXref(MobyDataObject mdsi, MobyService service) {
        super(new MobyDataObject(mdsi), new MobyService[]{service});
    }

    public String getDescription() {
        return this.serviceDescription;
    }

    public void setDescription(String desc) {
        this.serviceDescription = desc;
    }

    public void setEvidenceCodeByAbbrev(String abbrev) throws IllegalArgumentException {
        this.setEvidenceCode(MobyDataXref.evidenceAbbrevToCode(abbrev));
    }

    public void setEvidenceCode(String code) throws IllegalArgumentException {
        if (code == null || code.length() == 0) {
            throw new IllegalArgumentException("Evidence code for an Xref cannot be blank");
        }
        if (!(code.equals(IC) || code.equals(IDA) || code.equals(IEA) || code.equals(IEP) || code.equals(IGI) || code.equals(IMP) || code.equals(IPI) || code.equals(ISS) || code.equals(NAS) || code.equals(ND) || code.equals(RCA) || code.equals(TAS) || code.equals(NR))) {
            throw new IllegalArgumentException("Evidence code to be set (" + code + ") was not a valid GO code");
        }
        this.evidenceCode = code;
    }

    public static String evidenceAbbrevToCode(String abbrev) throws IllegalArgumentException {
        if (abbrev == null || abbrev.length() == 0) {
            throw new IllegalArgumentException("Evidence code abbreviation for an Xref cannot be blank");
        }
        if (abbrev.equals("IC")) {
            return IC;
        }
        if (abbrev.equals("IDA")) {
            return IDA;
        }
        if (abbrev.equals("IEA")) {
            return IEA;
        }
        if (abbrev.equals("IEP")) {
            return IEP;
        }
        if (abbrev.equals("IGI")) {
            return IGI;
        }
        if (abbrev.equals("IMP")) {
            return IMP;
        }
        if (abbrev.equals("IPI")) {
            return IPI;
        }
        if (abbrev.equals("ISS")) {
            return ISS;
        }
        if (abbrev.equals("NAS")) {
            return NAS;
        }
        if (abbrev.equals("ND")) {
            return ND;
        }
        if (abbrev.equals("RCA")) {
            return RCA;
        }
        if (abbrev.equals("TAS")) {
            return TAS;
        }
        if (abbrev.equals("NR")) {
            return NR;
        }
        throw new IllegalArgumentException("Evidence abbreviation to expand (" + abbrev + " was not a valid GO code abbreviation");
    }

    public static String evidenceCodeToAbbrev(String code) throws IllegalArgumentException {
        if (code == null || code.length() == 0) {
            throw new IllegalArgumentException("Evidence code for an Xref cannot be blank");
        }
        if (code.equals(IC)) {
            return "IC";
        }
        if (code.equals(IDA)) {
            return "IDA";
        }
        if (code.equals(IEA)) {
            return "IEA";
        }
        if (code.equals(IEP)) {
            return "IEP";
        }
        if (code.equals(IGI)) {
            return "IGI";
        }
        if (code.equals(IMP)) {
            return "IMP";
        }
        if (code.equals(IPI)) {
            return "IPI";
        }
        if (code.equals(ISS)) {
            return "ISS";
        }
        if (code.equals(NAS)) {
            return "NAS";
        }
        if (code.equals(ND)) {
            return "ND";
        }
        if (code.equals(RCA)) {
            return "RCA";
        }
        if (code.equals(TAS)) {
            return "TAS";
        }
        if (code.equals(NR)) {
            return "NR";
        }
        throw new IllegalArgumentException("Evidence code to be abbreviated (" + code + " was not a valid GO code");
    }

    public String getEvidenceCode() {
        return this.evidenceCode;
    }

    public void setXrefType(String type) {
        this.xrefType = type;
    }

    public String getXrefType() {
        return this.xrefType;
    }

    public Object clone() {
        return new MobyDataXref(this.getNamespace(), this.getId(), this.getService());
    }

    public MobyService getService() {
        return this.mobyServices == null ? null : this.mobyServices[0];
    }

    public void setServices(MobyService[] services) {
        if (services == null) {
            this.mobyServices = null;
        } else if (services.length == 1) {
            this.mobyServices = services;
        } else {
            MobyService[] service = new MobyService[]{services[0]};
            this.mobyServices = service;
        }
    }

    public void setXmlMode(int mode) throws IllegalArgumentException {
        if (mode == 6766) {
            this.isCRIBXML = true;
        } else if (mode == 6767) {
            this.isCRIBXML = false;
        } else {
            this.dataInstance.setXmlMode(mode);
        }
    }

    public void addNamespace(MobyNamespace ns) {
        this.dataInstance.addNamespace(ns);
    }

    public MobyNamespace[] getNamespaces() {
        return this.dataInstance.getNamespaces();
    }

    public MobyNamespace getNamespace() {
        MobyNamespace[] mn = this.getNamespaces();
        return mn == null ? null : mn[0];
    }

    public String toString() {
        return this.dataInstance.toString();
    }

    public String toXML() {
        if (this.isCRIBXML) {
            MobyService service = this.getService();
            MobyNamespace[] myNamespaces = this.getNamespaces();
            return "<Xref namespace='" + (myNamespaces == null ? null : myNamespaces[0]) + "' id='" + this.getId() + "' authURI='" + (service == null ? null : service.getAuthority()) + "' serviceName='" + (service == null ? null : service.getName()) + "' evidenceCode='" + MobyDataXref.evidenceCodeToAbbrev(this.evidenceCode) + "' xrefType='" + this.xrefType + "'>" + this.serviceDescription + "</Xref>";
        }
        return super.toXML();
    }
}

