/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.shared.parser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.Utils;
import org.biomoby.shared.parser.JDOMUtils;
import org.biomoby.shared.parser.MobyJob;
import org.biomoby.shared.parser.MobyPackage;
import org.jdom.Element;

public class ServiceException
extends MobyException {
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFO = 3;
    public static final int OK = 700;
    public static final int UNKNOWN_NAME = 200;
    public static final int INPUTS_INVALID = 201;
    public static final int INPUT_NOT_ACCEPTED = 202;
    public static final int INPUT_REQUIRED_PARAMETER = 221;
    public static final int INPUT_INCORRECT_PARAMETER = 222;
    public static final int INPUT_INCORRECT_SIMPLE = 223;
    public static final int INPUT_REQUIRED_PARAMETERS = 224;
    public static final int INPUT_INCORRECT_COLLECTION = 225;
    public static final int INPUT_EMPTY_OBJECT = 226;
    public static final int INPUT_INCORRECT_NAMESPACE = 227;
    public static final int NOT_RUNNABLE = 300;
    public static final int NOT_RUNNING = 301;
    public static final int NOT_TERMINATED = 302;
    public static final int NO_METADATA_AVAILABLE = 400;
    public static final int PROTOCOLS_UNACCEPTED = 500;
    public static final int INTERNAL_PROCESSING_ERROR = 600;
    public static final int COMMUNICATION_FAILURE = 601;
    public static final int UNKNOWN_STATE = 602;
    public static final int NOT_IMPLEMENTED = 603;
    protected String refQueryID;
    protected String refElement;
    protected int severity = 3;
    protected int code = 700;
    protected String description;
    static HashMap<Integer, String> severityNames = new HashMap();
    static HashMap<Integer, String> codeNames;

    public ServiceException() {
    }

    public ServiceException(int severity, int code, String message) {
        this.setSeverity(severity);
        this.setErrorCode(code);
        this.setMessage(message);
    }

    public ServiceException(int severity, int code, String jobId, String dataName) {
        this.setSeverity(severity);
        this.setErrorCode(code);
        this.setJobId(jobId);
        this.setDataName(dataName);
    }

    public ServiceException(int severity, int code, String jobId, String dataName, String msg) {
        this.setSeverity(severity);
        this.setErrorCode(code);
        this.setJobId(jobId);
        this.setDataName(dataName);
        this.setMessage(msg);
    }

    public static ServiceException error(int code, String msg) {
        ServiceException ex = new ServiceException();
        ex.setSeverity(1);
        ex.setErrorCode(code);
        ex.setMessage(msg);
        return ex;
    }

    public static ServiceException error(String msg) {
        ServiceException ex = new ServiceException();
        ex.setSeverity(1);
        ex.setMessage(msg);
        ex.setErrorCode(600);
        return ex;
    }

    public static ServiceException warning(String msg) {
        ServiceException ex = new ServiceException();
        ex.setSeverity(2);
        ex.setMessage(msg);
        return ex;
    }

    public static ServiceException info(String msg) {
        ServiceException ex = new ServiceException();
        ex.setSeverity(3);
        ex.setMessage(msg);
        return ex;
    }

    public String getJobId() {
        return this.refQueryID;
    }

    public void setJobId(String id) {
        this.refQueryID = id;
    }

    public void setJobId(MobyJob job) {
        this.refQueryID = job.getId();
    }

    public String getDataName() {
        return this.refElement;
    }

    public void setDataName(String name) {
        this.refElement = name;
    }

    public String getMessage() {
        if (this.description != null) {
            return this.description;
        }
        return codeNames.get(new Integer(this.code));
    }

    public void setMessage(String msg) {
        this.description = msg;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getSeverityAsString() {
        return severityNames.get(new Integer(this.severity));
    }

    public void setSeverity(int severity) {
        this.severity = severityNames.containsKey(new Integer(severity)) ? severity : 700;
    }

    public void setSeverity(String severityName) {
        for (Map.Entry<Integer, String> entry : severityNames.entrySet()) {
            String name = entry.getValue();
            if (!name.equals(severityName)) continue;
            this.severity = entry.getKey();
            return;
        }
        this.severity = 700;
    }

    public int getErrorCode() {
        return this.code;
    }

    public String getErrorCodeAsString() {
        String str = codeNames.get(new Integer(this.code));
        return str == null ? "" : str;
    }

    public void setErrorCode(int code) {
        this.code = code;
    }

    public String toString() {
        String desc;
        StringBuffer buf = new StringBuffer();
        buf.append("Exception: ");
        buf.append(this.getSeverityAsString());
        buf.append(", ");
        String str = this.getErrorCodeAsString();
        buf.append("".equals(str) ? "" + this.code : str);
        if (this.refQueryID != null) {
            buf.append(", in job: ");
            buf.append(this.refQueryID);
        }
        if (this.refElement != null) {
            buf.append(", concerning: ");
            buf.append(this.refElement);
        }
        if ((desc = this.getMessage()) != null) {
            buf.append("\n\t");
            buf.append(desc);
        }
        return new String(buf);
    }

    public String format(int indent) {
        return Utils.format((Object)this, (int)indent);
    }

    public Element toXML() {
        Element elem = MobyPackage.getXMLElement((String)"mobyException");
        MobyPackage.setXMLAttribute((Element)elem, (String)"severity", (String)this.getSeverityAsString());
        if (this.refQueryID != null) {
            MobyPackage.setXMLAttribute((Element)elem, (String)"refQueryID", (String)this.refQueryID);
        }
        if (this.refElement != null) {
            MobyPackage.setXMLAttribute((Element)elem, (String)"refElement", (String)this.refElement);
        }
        Element elemCode = MobyPackage.getXMLElement((String)"exceptionCode");
        elemCode.setText("" + this.code);
        elem.addContent(elemCode);
        String desc = this.getMessage();
        if (desc != null) {
            Element elemDesc = MobyPackage.getXMLElement((String)"exceptionMessage");
            elemDesc.setText(desc);
            elem.addContent(elemDesc);
        }
        return elem;
    }

    public static ServiceException[] extractExceptions(Element serviceNotes) {
        ServiceException ex;
        if (serviceNotes == null) {
            return new ServiceException[0];
        }
        Vector<ServiceException> v = new Vector<ServiceException>();
        Iterator it = serviceNotes.getChildren("mobyException").iterator();
        while (it.hasNext()) {
            ex = ServiceException.extractException((Element)it.next());
            if (ex == null) continue;
            v.addElement(ex);
        }
        it = serviceNotes.getChildren("mobyException", JDOMUtils.MOBY_NS).iterator();
        while (it.hasNext()) {
            ex = ServiceException.extractException((Element)it.next());
            if (ex == null) continue;
            v.addElement(ex);
        }
        Object[] result = new ServiceException[v.size()];
        v.copyInto(result);
        return result;
    }

    protected static ServiceException extractException(Element elem) {
        ServiceException ex = new ServiceException();
        String severity = elem.getAttributeValue("severity");
        if (severity == null) {
            severity = elem.getAttributeValue("severity", JDOMUtils.MOBY_NS);
        }
        ex.setSeverity(severity);
        String codeStr = JDOMUtils.getChildText((Element)elem, (String)"exceptionCode");
        try {
            ex.setErrorCode(new Integer(codeStr));
        }
        catch (Exception e) {
            // empty catch block
        }
        ex.setMessage(JDOMUtils.getChildText((Element)elem, (String)"exceptionMessage"));
        return ex;
    }

    public String toXMLString() {
        StringBuffer xml = new StringBuffer("          <moby:mobyException severity=\"" + this.severity + "\" ");
        if (this.refQueryID != null) {
            xml.append("refQueryID=\"" + this.refQueryID + "\" ");
        }
        if (this.refElement != null) {
            xml.append("refElement=\"" + this.refElement + "\" ");
        }
        xml.append(">\n");
        xml.append("<moby:exceptionCode>" + this.code + "</moby:" + "exceptionCode" + ">");
        if (this.getMessage() != null) {
            xml.append("            <moby:exceptionMessage>" + this.getMessage() + "</moby:" + "exceptionMessage" + ">");
        }
        xml.append("          </moby:mobyException>");
        return xml.toString();
    }

    static {
        severityNames.put(new Integer(1), "error");
        severityNames.put(new Integer(2), "warning");
        severityNames.put(new Integer(3), "information");
        codeNames = new HashMap();
        codeNames.put(new Integer(700), "OK");
        codeNames.put(new Integer(200), "UNKNOWN_NAME");
        codeNames.put(new Integer(201), "INPUTS_INVALID");
        codeNames.put(new Integer(202), "INPUT_NOT_ACCEPTED");
        codeNames.put(new Integer(221), "INPUT_REQUIRED_PARAMETER");
        codeNames.put(new Integer(222), "INPUT_INCORRECT_PARAMETER");
        codeNames.put(new Integer(223), "INPUT_INCORRECT_SIMPLE");
        codeNames.put(new Integer(224), "INPUT_REQUIRED_PARAMETERS");
        codeNames.put(new Integer(225), "INPUT_INCORRECT_COLLECTION");
        codeNames.put(new Integer(226), "INPUT_EMPTY_OBJECT");
        codeNames.put(new Integer(227), "INPUT_INCORRECT_NAMESPACE");
        codeNames.put(new Integer(300), "NOT_RUNNABLE");
        codeNames.put(new Integer(301), "NOT_RUNNING");
        codeNames.put(new Integer(302), "NOT_TERMINATED");
        codeNames.put(new Integer(400), "NO_METADATA_AVAILABLE");
        codeNames.put(new Integer(500), "PROTOCOLS_UNACCEPTED");
        codeNames.put(new Integer(600), "INTERNAL_PROCESSING_ERROR");
        codeNames.put(new Integer(601), "COMMUNICATION_FAILURE");
        codeNames.put(new Integer(602), "UNKNOWN_STATE");
        codeNames.put(new Integer(603), "NOT_IMPLEMENTED");
    }
}

