/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.w3c.addressing;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import org.biomoby.shared.MobyException;
import org.w3c.addressing.sax.EndpointReferenceParser;

public class EndpointReference {
    private String address = "";
    private String serviceInvocationId = "";

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address.trim();
    }

    public String getServiceInvocationId() {
        return this.serviceInvocationId;
    }

    public void setServiceInvocationId(String serviceInvocationId) {
        this.serviceInvocationId = serviceInvocationId.trim();
    }

    public static EndpointReference createFromXML(Object xmlData) throws MobyException {
        EndpointReferenceParser parser = new EndpointReferenceParser();
        if (xmlData instanceof byte[]) {
            return parser.parse(new ByteArrayInputStream((byte[])xmlData));
        }
        if (xmlData instanceof File) {
            try {
                return parser.parse(new FileInputStream((File)xmlData));
            }
            catch (IOException e) {
                throw new MobyException(e.toString());
            }
        }
        if (xmlData instanceof String) {
            return parser.parse(new StringReader((String)xmlData));
        }
        throw new MobyException("The EPR data should be sent/received either as type String or base64/byte[]. But they are of type '" + xmlData.getClass().getName() + "'.");
    }

    public String toString() {
        return "EPR {To: " + this.getAddress() + ", id: " + this.getServiceInvocationId() + "}";
    }
}

