/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.addressing.sax;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashSet;
import org.biomoby.shared.MobyException;
import org.biomoby.w3c.addressing.EndpointReference;
import org.tulsoft.shared.GException;
import org.tulsoft.tools.debug.DGUtils;
import org.tulsoft.tools.xml.XMLUtils2;
import org.w3c.addressing.sax.EprTags;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class EndpointReferenceParser
extends DefaultHandler
implements EprTags {
    private static String[] eventNamesArray = new String[]{"Address", "ReferenceParameters"};
    private static HashSet<String> eventNames = new HashSet();
    private boolean parsingEpr = false;
    private boolean parsingAddress = false;
    private boolean parsingReferenceParameters = false;
    private boolean parsingSvcId = false;
    private StringBuffer addressBuf;
    private StringBuffer idBuf;
    private Locator locator;
    private XMLReader parser = null;
    private EndpointReference result = null;

    public void startDocument() throws SAXException {
        this.addressBuf = new StringBuffer();
        this.idBuf = new StringBuffer();
    }

    public void endDocument() throws SAXException {
        this.parsingEpr = false;
        this.parsingAddress = false;
        this.parsingReferenceParameters = false;
        this.parsingSvcId = false;
        if (this.result != null) {
            this.result.setAddress(this.addressBuf.toString());
            this.result.setServiceInvocationId(this.idBuf.toString());
        }
        this.idBuf = null;
        this.addressBuf = null;
    }

    public void startElement(String namespaceURI, String name, String qName, Attributes attrs) throws SAXException {
        if (name.equals("EndpointReference")) {
            this.parsingEpr = true;
            this.result = new EndpointReference();
            return;
        }
        if (this.parsingEpr) {
            if (eventNames.contains(name)) {
                if (name.equals("Address")) {
                    this.parsingAddress = true;
                    return;
                }
                if (name.equals("ReferenceParameters")) {
                    this.parsingReferenceParameters = true;
                    return;
                }
            }
            if (this.parsingReferenceParameters && name.equals("ServiceInvocationId")) {
                this.parsingSvcId = true;
                return;
            }
        }
    }

    public void endElement(String namespaceURI, String name, String qName) throws SAXException {
        if (name.equals("Address")) {
            this.parsingAddress = false;
            this.parsingSvcId = false;
            return;
        }
        if (name.equals("ServiceInvocationId")) {
            this.parsingSvcId = false;
            this.parsingAddress = false;
            return;
        }
        if (name.equals("ReferenceParameters")) {
            this.parsingSvcId = false;
            this.parsingAddress = false;
            this.parsingReferenceParameters = false;
            return;
        }
        if (name.equals("EndpointReference")) {
            this.parsingSvcId = false;
            this.parsingAddress = false;
            this.parsingReferenceParameters = false;
            this.parsingEpr = false;
            return;
        }
    }

    public void setDocumentLocator(Locator l) {
        this.locator = l;
    }

    public void characters(char[] ch, int start, int length) {
        StringBuffer sb = new StringBuffer();
        sb.append(ch, start, length);
        if (this.parsingAddress) {
            this.addressBuf.append(sb.toString().trim());
            return;
        }
        if (this.parsingSvcId) {
            this.idBuf.append(sb.toString().trim());
            return;
        }
    }

    protected SAXParseException error(String message) {
        return new SAXParseException("", this.locator, new MobyException(message));
    }

    public EndpointReference parse(String xmlFilename) throws MobyException {
        return this._parse(new InputSource(xmlFilename));
    }

    public EndpointReference parse(InputStream xml) throws MobyException {
        return this._parse(new InputSource(xml));
    }

    public EndpointReference parse(Reader xmlReader) throws MobyException {
        return this._parse(new InputSource(xmlReader));
    }

    private synchronized EndpointReference _parse(InputSource xmlSource) throws MobyException {
        try {
            if (this.parser == null) {
                this.parser = XMLUtils2.makeXMLParser(this);
            }
            this.parser.parse(xmlSource);
            if (this.result == null) {
                throw new MobyException("Parsing XML failed, and I do not know why. \nPanic... (or send the XML to a jMoby developer)\n");
            }
            return this.result;
        }
        catch (GException e) {
            throw new MobyException("Error in creating XML parser " + e.getMessage());
        }
        catch (SAXException e) {
            throw new MobyException("Error in the XML input.\n" + XMLUtils2.getFormattedError(e));
        }
        catch (IOException e) {
            throw new MobyException("Error by reading XML input: " + e.toString());
        }
        catch (Error e) {
            throw new MobyException("Serious or unexpected error!\n" + e.toString() + "\n" + DGUtils.stackTraceToString((Throwable)e));
        }
    }

    static {
        for (int i = 0; i < eventNamesArray.length; ++i) {
            eventNames.add(eventNamesArray[i]);
        }
    }
}

