/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import javax.sql.DataSource;
import org.apache.log4j.Category;
import uk.ac.sanger.jcon.JobControlException;
import uk.ac.sanger.jcon.dao.HostNameDAO;
import uk.ac.sanger.jcon.dao.SQLDAOBaseImpl;

public class HostNameSQLDAO
extends SQLDAOBaseImpl
implements HostNameDAO {
    static Category cat = Category.getInstance((String)(class$uk$ac$sanger$jcon$dao$HostNameSQLDAO == null ? (class$uk$ac$sanger$jcon$dao$HostNameSQLDAO = HostNameSQLDAO.class$("uk.ac.sanger.jcon.dao.HostNameSQLDAO")) : class$uk$ac$sanger$jcon$dao$HostNameSQLDAO).getName());
    static ResourceBundle sqlStatements = ResourceBundle.getBundle((class$uk$ac$sanger$jcon$dao$HostNameSQLDAO == null ? (class$uk$ac$sanger$jcon$dao$HostNameSQLDAO = HostNameSQLDAO.class$("uk.ac.sanger.jcon.dao.HostNameSQLDAO")) : class$uk$ac$sanger$jcon$dao$HostNameSQLDAO).getName());
    private HashMap canonical = new HashMap(50);
    private String[] stringProto = new String[0];
    static /* synthetic */ Class class$uk$ac$sanger$jcon$dao$HostNameSQLDAO;

    public HostNameSQLDAO() {
    }

    public HostNameSQLDAO(DataSource datasource) {
        super(datasource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void createHostName(String name) throws Exception {
        String sql = sqlStatements.getString("createHostName");
        Connection c = this.getManagedConnection();
        PreparedStatement ps = null;
        boolean rollback = false;
        try {
            try {
                int newId = this.createNewHostId();
                cat.debug((Object)("Preparing SQL: " + sql));
                ps = c.prepareStatement(sql);
                ps.setInt(1, newId);
                ps.setString(2, name);
                cat.debug((Object)("Executing SQL: " + ps));
                ps.executeUpdate();
            }
            catch (Exception e) {
                cat.error((Object)"Caught an Exception; rolling back transaction", (Throwable)e);
                rollback = true;
                throw e;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.cSupport.close(ps);
            if (rollback) {
                this.cSupport.rollback(c);
            } else {
                this.cSupport.commit(c);
            }
            if (!this.isManagingConnections()) throw throwable;
            this.cSupport.close(c);
            throw throwable;
        }
        this.cSupport.close((Statement)ps);
        if (rollback) {
            this.cSupport.rollback(c);
        } else {
            this.cSupport.commit(c);
        }
        if (!this.isManagingConnections()) return;
        this.cSupport.close(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection readAllHostNames() throws SQLException {
        String sql = sqlStatements.getString("readAllHostNames");
        Connection c = this.getManagedConnection();
        Statement s = null;
        ResultSet r = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            s = c.createStatement();
            cat.debug((Object)("Executing SQL: " + s));
            r = s.executeQuery(sql);
            while (r.next()) {
                names.add(r.getString("name"));
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.cSupport.close(r);
            this.cSupport.close(s);
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close(s);
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String readHostNameById(int hostId) throws SQLException, JobControlException {
        Integer canonKey = new Integer(hostId);
        if (this.canonical.containsKey(canonKey)) {
            cat.debug((Object)("Fetching canonical host name [" + canonKey + "] from cache"));
            return (String)this.canonical.get(canonKey);
        }
        String sql = sqlStatements.getString("readHostNameById");
        Connection c = this.getManagedConnection();
        PreparedStatement ps = null;
        ResultSet r = null;
        String name = null;
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setInt(1, hostId);
            cat.debug((Object)("Executing SQL: " + ps));
            r = ps.executeQuery();
            if (!r.next()) {
                throw new JobControlException("Requested a non-existent host name with ID '" + hostId + "'");
            }
            name = r.getString("name");
            this.canonical.put(canonKey, name);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.cSupport.close(r);
            this.cSupport.close(ps);
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ps);
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized int readHostIdByName(String name) throws SQLException, JobControlException {
        int hostId = 0;
        if (this.canonical.containsValue(name)) {
            Iterator ei = this.canonical.entrySet().iterator();
            while (ei.hasNext()) {
                Map.Entry e = ei.next();
                if (!((String)e.getValue()).equals(name)) continue;
                hostId = (Integer)e.getKey();
            }
            return hostId;
        }
        String sql = sqlStatements.getString("readHostIdByName");
        Connection c = this.getManagedConnection();
        PreparedStatement ps = null;
        ResultSet r = null;
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setString(1, name);
            cat.debug((Object)("Executing SQL: " + ps));
            r = ps.executeQuery();
            if (!r.next()) {
                throw new JobControlException("Requested a non-existent host name with ID '" + hostId + "'");
            }
            hostId = r.getInt("host_id");
            this.canonical.put(new Integer(hostId), name);
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.cSupport.close(r);
            this.cSupport.close(ps);
            if (!this.isManagingConnections()) throw throwable;
            this.cSupport.close(c);
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ps);
        if (!this.isManagingConnections()) return hostId;
        this.cSupport.close(c);
        return hostId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String[] readHostNamesByJobId(int jobId) throws SQLException {
        String sql = sqlStatements.getString("readHostNamesByJobId");
        Connection c = this.getManagedConnection();
        PreparedStatement ps = null;
        ResultSet r = null;
        ArrayList<String> hosts = new ArrayList<String>();
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setInt(1, jobId);
            cat.debug((Object)("Executing SQL: " + ps));
            r = ps.executeQuery();
            while (r.next()) {
                hosts.add(r.getString("name"));
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.cSupport.close(r);
            this.cSupport.close(ps);
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ps);
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        return hosts.toArray(this.stringProto);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void deleteHostName(String name) throws SQLException, JobControlException {
        String sql = sqlStatements.getString("deleteHostName");
        Connection c = this.getManagedConnection();
        PreparedStatement ps = null;
        boolean rollback = false;
        int hostId = this.readHostIdByName(name);
        try {
            try {
                cat.debug((Object)("Preparing SQL: " + sql));
                ps = c.prepareStatement(sql);
                ps.setInt(1, hostId);
                cat.debug((Object)("Executing SQL: " + ps));
                ps.executeUpdate();
            }
            catch (SQLException e) {
                cat.error((Object)"Caught an Exception; rolling back transaction", (Throwable)e);
                rollback = true;
                throw e;
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.cSupport.close(ps);
            if (rollback) {
                this.cSupport.rollback(c);
                throw throwable;
            }
            this.cSupport.commit(c);
            this.canonical.remove(new Integer(hostId));
            throw throwable;
        }
        this.cSupport.close((Statement)ps);
        if (rollback) {
            this.cSupport.rollback(c);
            return;
        }
        this.cSupport.commit(c);
        this.canonical.remove(new Integer(hostId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createNewHostId() throws Exception {
        String sql = sqlStatements.getString("createNewHostId");
        Connection c = this.getConnection();
        Statement s = null;
        ResultSet r = null;
        int id = 0;
        try {
            s = c.createStatement();
            cat.debug((Object)("Executing SQL: " + s));
            r = s.executeQuery(sql);
            if (!r.next()) {
                throw new Exception("Failed to retrieve a new host ID");
            }
            id = r.getInt("host_id");
        }
        catch (Throwable throwable) {
            this.cSupport.close(r);
            this.cSupport.close(s);
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close(s);
        return id;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

