/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.job;

import java.sql.Timestamp;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import uk.ac.sanger.jcon.dao.JobSQLDAO;
import uk.ac.sanger.jcon.job.Job;
import uk.ac.sanger.jcon.job.Owner;
import uk.ac.sanger.jcon.job.Status;
import uk.ac.sanger.jcon.job.Task;

public class TaskDefaultImpl
implements Task {
    private int id;
    protected String name;
    protected String description;
    protected Owner owner;
    protected Job[] jobs;
    protected int priority;
    protected Timestamp submissionTime;

    public TaskDefaultImpl(String name, String description, Owner owner) {
        if (name == null) {
            throw new IllegalArgumentException("Failed to set name as it was null");
        }
        if (description == null) {
            throw new IllegalArgumentException("Failed to set description as it was null");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Failed to set Owner as it was null");
        }
        this.checkFieldLength(name, 32);
        this.checkFieldLength(description, 255);
        this.name = name;
        this.description = description;
        this.owner = owner;
        this.priority = 4;
    }

    public TaskDefaultImpl(String name, String description, Owner owner, Job[] jobs) {
        if (name == null) {
            throw new IllegalArgumentException("Failed to set name as it was null");
        }
        if (description == null) {
            throw new IllegalArgumentException("Failed to set description as it was null");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Failed to set Owner as it was null");
        }
        if (jobs == null || jobs.length == 0) {
            throw new IllegalArgumentException("Jobs array must contain at least one Job");
        }
        this.checkFieldLength(name, 32);
        this.checkFieldLength(description, 255);
        this.name = name;
        this.description = description;
        this.owner = owner;
        this.jobs = jobs;
        this.priority = 4;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Failed to set name as it was null");
        }
        this.checkFieldLength(name, 32);
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (description == null) {
            throw new IllegalArgumentException("Failed to set description as it was null");
        }
        this.checkFieldLength(description, 255);
        this.description = description;
    }

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Failed to set Owner as it was null");
        }
        this.owner = owner;
    }

    public Status getStatus() {
        try {
            InitialContext context = new InitialContext();
            DataSource datasource = (DataSource)context.lookup("jdbc/JobControl");
            JobSQLDAO jobSQLDAO = new JobSQLDAO(datasource);
            Job job_zero = jobSQLDAO.readJobById(this.jobs[0].getId());
            return job_zero.getStatus();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Job[] getJobs() {
        return this.jobs;
    }

    public void setJobs(Job[] jobs) {
        if (jobs == null || jobs.length == 0) {
            throw new IllegalArgumentException("Jobs array must contain at least one Job");
        }
        this.jobs = jobs;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) throws IllegalArgumentException {
        if (priority < 1 || priority > 10) {
            throw new IllegalArgumentException("Invalid priority '" + priority + "' passed to method. Valid range is " + 1 + " >= priority <= " + 10);
        }
        this.priority = priority;
    }

    public Timestamp getSubmissionTime() {
        return this.submissionTime;
    }

    public void setSubmissionTime(Timestamp submissionTime) {
        this.submissionTime = submissionTime;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Task [");
        sb.append(this.id);
        sb.append("] '");
        sb.append(this.name);
        sb.append("'\n");
        sb.append(this.owner);
        if (this.submissionTime == null) {
            sb.append("\nNot submitted");
        } else {
            sb.append("\nSubmitted: ");
            sb.append(this.submissionTime);
        }
        for (int i = 0; i < this.jobs.length; ++i) {
            sb.append("\n" + this.jobs[i]);
        }
        return sb.substring(0);
    }

    protected void checkFieldLength(String field, int maxLength) {
        if (field.length() > maxLength) {
            throw new IllegalArgumentException("Field " + field + " is longer than the permitted maximum of " + maxLength + " characters");
        }
    }
}

