/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.lsf;

import java.io.Serializable;

public final class LSFJobInfo
implements Serializable {
    public static final int NULL = 0;
    public static final int PEND = 1;
    public static final int PSUSP = 2;
    public static final int RUN = 4;
    public static final int SSUSP = 8;
    public static final int USUSP = 16;
    public static final int EXIT = 32;
    public static final int DONE = 64;
    public static final int PDONE = 128;
    public static final int PERR = 256;
    public static final int WAIT = 512;
    public static final int UNKWN = 65536;
    private int jobId;
    private String user;
    private int status;
    private int exitValue;
    private String fromHost;
    private String[] exHosts;

    public LSFJobInfo(int jobId, String user, int status, int exitValue, String fromHost, String[] exHosts) {
        this.jobId = jobId;
        this.user = user;
        this.status = status;
        this.exitValue = exitValue;
        this.fromHost = fromHost;
        this.exHosts = exHosts;
    }

    public int getJobId() {
        return this.jobId;
    }

    public String getUser() {
        return this.user;
    }

    public int getStatus() {
        return this.status;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public String getFromHost() {
        return this.fromHost;
    }

    public String[] getExHosts() {
        return this.exHosts;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Job [");
        sb.append(this.jobId);
        sb.append("] status '");
        sb.append(this.status);
        sb.append("' for user <");
        sb.append(this.user);
        sb.append("> from host <");
        sb.append(this.fromHost);
        sb.append("> exec host <");
        int last = this.exHosts.length - 1;
        for (int i = 0; i <= last; ++i) {
            sb.append(this.exHosts[i]);
            if (i == last) continue;
            sb.append(" ");
        }
        sb.append(">");
        return sb.substring(0);
    }
}

