/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.protocol;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Map;
import org.apache.log4j.Category;
import org.apache.velocity.VelocityContext;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.io.SeqIOTools;
import uk.ac.sanger.jcon.JobControlException;
import uk.ac.sanger.jcon.job.BatchJob;
import uk.ac.sanger.jcon.job.Job;
import uk.ac.sanger.jcon.job.Owner;
import uk.ac.sanger.jcon.job.TaskDefaultImpl;
import uk.ac.sanger.jcon.protocol.ConfigurableProtocol;
import uk.ac.sanger.jcon.util.Configuration;

public class DdiscoideumDNABlast
extends ConfigurableProtocol {
    static Category cat = Category.getInstance((String)(class$uk$ac$sanger$jcon$protocol$DdiscoideumDNABlast == null ? (class$uk$ac$sanger$jcon$protocol$DdiscoideumDNABlast = DdiscoideumDNABlast.class$("uk.ac.sanger.jcon.protocol.DdiscoideumDNABlast")) : class$uk$ac$sanger$jcon$protocol$DdiscoideumDNABlast).getName());
    static /* synthetic */ Class class$uk$ac$sanger$jcon$protocol$DdiscoideumDNABlast;

    public void apply(String ownerName, Map config, String[] data) throws Exception {
        if (ownerName == null) {
            throw new IllegalArgumentException("ownerName was null");
        }
        Owner owner = this.admin.getOwnerByUserName(ownerName);
        for (int i = 0; i < data.length; ++i) {
            try {
                this.applySingle(owner, data[i]);
                continue;
            }
            catch (Exception e) {
                System.err.println("Exception while processing '" + data[i] + "'. Skipping this element");
                e.printStackTrace();
            }
        }
    }

    private void applySingle(Owner owner, String arg) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(arg));
        SequenceIterator seqI = SeqIOTools.readFastaDNA((BufferedReader)br);
        String ntSuffix = this.config.getString(Configuration.FASTA_NT_EXTENSION_KEY);
        String tabSuffix = this.config.getString(Configuration.FTABLE_EXTENSION_KEY);
        String inpSuffix = this.config.getString(Configuration.INPUT_EXTENSION_KEY);
        String outSuffix = this.config.getString(Configuration.OUTPUT_EXTENSION_KEY);
        String errSuffix = this.config.getString(Configuration.ERROR_EXTENSION_KEY);
        String queue = this.config.getString(Configuration.EXEC_QUEUE_KEY);
        String workDirectory = System.getProperty("user.dir");
        String repeatsLogName = "blastn_repeats.log";
        String rdnaLogName = "blastn_rdna.log";
        String estsLogName = "blastn_ests.log";
        String happymapLogName = "blastn_happymap.log";
        String swallLogName = "blastx_swall.log";
        String blast2tabLogName = "blast2tab.log";
        BatchJob rootJob = this.createEmptyBatchJob(queue);
        rootJob.setWorkDirectoryName(workDirectory);
        while (seqI.hasNext()) {
            Sequence seq = seqI.nextSequence();
            String name = seq.getName();
            if (name.equals("")) {
                throw new JobControlException("Sequence used empty string as identifier");
            }
            String ntFileName = name + "." + ntSuffix;
            File ntFile = new File(workDirectory, ntFileName);
            if (!ntFile.exists()) {
                this.writeFasta(seq, ntFile);
            }
            String repeatsOutName = name + ".repeats.bln." + outSuffix;
            String rdnaOutName = name + ".rdna.bln." + outSuffix;
            String estsOutName = name + ".ests.bln." + outSuffix;
            String happymapOutName = name + ".happymap.bln." + outSuffix;
            String swallOutName = name + ".swall.blx." + outSuffix;
            VelocityContext context = new VelocityContext();
            context.put("executable", (Object)"<Error: this should not have been expanded>");
            context.put("output_name", (Object)repeatsOutName);
            Job repeatsRun = this.createJob(new String[]{ntFileName, repeatsLogName, null}, context, "d_discoideum", "blastn_v_repeats");
            repeatsRun.setWorkDirectoryName(workDirectory);
            context.put("output_name", (Object)(repeatsOutName + "." + tabSuffix));
            context.put("ident_filter", (Object)"0");
            context.put("score_filter", (Object)"100");
            context.put("eval_filter", (Object)"1");
            context.put("feature_key", (Object)"repeat_region");
            Job repeatsParse = this.createJob(new String[]{repeatsOutName, blast2tabLogName, null}, context, "d_discoideum", "blast2tab");
            repeatsParse.setWorkDirectoryName(workDirectory);
            repeatsParse.add(repeatsRun);
            rootJob.add(repeatsParse);
            context.put("output_name", (Object)rdnaOutName);
            Job rdnaRun = this.createJob(new String[]{ntFileName, rdnaLogName, null}, context, "d_discoideum", "blastn_v_rdna");
            rdnaRun.setWorkDirectoryName(workDirectory);
            context.put("output_name", (Object)(rdnaOutName + "." + tabSuffix));
            context.put("ident_filter", (Object)"90");
            context.put("feature_key", (Object)"rRNA");
            Job rdnaParse = this.createJob(new String[]{rdnaOutName, blast2tabLogName, null}, context, "d_discoideum", "blast2tab");
            rdnaParse.setWorkDirectoryName(workDirectory);
            rdnaParse.add(rdnaRun);
            rootJob.add(rdnaParse);
            context.put("output_name", (Object)estsOutName);
            Job estsRun = this.createJob(new String[]{ntFileName, estsLogName, null}, context, "d_discoideum", "blastn_v_ests");
            estsRun.setWorkDirectoryName(workDirectory);
            context.put("output_name", (Object)(estsOutName + "." + tabSuffix));
            context.put("ident_filter", (Object)"0");
            context.put("feature_key", (Object)"misc_feature");
            Job estsParse = this.createJob(new String[]{estsOutName, blast2tabLogName, null}, context, "d_discoideum", "blast2tab");
            estsParse.setWorkDirectoryName(workDirectory);
            estsParse.add(estsRun);
            rootJob.add(estsParse);
            context.put("output_name", (Object)happymapOutName);
            Job happymapRun = this.createJob(new String[]{ntFileName, happymapLogName, null}, context, "d_discoideum", "blastn_v_happymap");
            happymapRun.setWorkDirectoryName(workDirectory);
            context.put("output_name", (Object)(happymapOutName + "." + tabSuffix));
            context.put("ident_filter", (Object)"90");
            context.put("feature_key", (Object)"misc_feature");
            Job happymapParse = this.createJob(new String[]{happymapOutName, blast2tabLogName, null}, context, "d_discoideum", "blast2tab");
            happymapParse.setWorkDirectoryName(workDirectory);
            happymapParse.add(happymapRun);
            rootJob.add(happymapParse);
            context.put("output_name", (Object)swallOutName);
            Job swallRun = this.createJob(new String[]{ntFileName, swallLogName, null}, context, "d_discoideum", "blastx_v_swall");
            swallRun.setWorkDirectoryName(workDirectory);
            context.put("output_name", (Object)(swallOutName + "." + tabSuffix));
            context.put("ident_filter", (Object)"0");
            context.put("feature_key", (Object)"BLASTCDS");
            Job swallParse = this.createJob(new String[]{swallOutName, blast2tabLogName, null}, context, "d_discoideum", "blast2tab");
            swallParse.setWorkDirectoryName(workDirectory);
            swallParse.add(swallRun);
            rootJob.add(swallParse);
        }
        TaskDefaultImpl task = new TaskDefaultImpl("d_discoideum_dnablast", "D. discoideum DNA contig Blast searches", owner);
        task.setJobs(new Job[]{rootJob});
        int taskId = this.manager.createTask(task);
        this.manager.submitTask(taskId);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

