/*
 * Decompiled with CFR 0.152.
 */
package forester.atv;

import forester.atv.ATVgraphic;
import forester.atv.ATVpanel;
import forester.tree.Tree;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class ATVcontrol
extends JPanel
implements ActionListener {
    ATVpanel atvpanel;
    JCheckBox userealbl;
    JCheckBox seqnameextnodes;
    JCheckBox seqnameintnodes;
    JCheckBox speciesextnodes;
    JCheckBox speciesintnodes;
    JCheckBox ecintnodes;
    JCheckBox ecextnodes;
    JCheckBox writelnl;
    JCheckBox writebl;
    JCheckBox writebootstrap;
    JCheckBox writed_s;
    JCheckBox colorbranches;
    JCheckBox color_orthos;
    JCheckBox color_super_orthos;
    JCheckBox editable;
    JButton zoom_in_x;
    JButton zoom_in_y;
    JButton zoom_out_x;
    JButton zoom_out_y;
    JButton show_whole;
    JButton order;
    JButton uncollapse_all;
    JButton collapse_to_deepest_annot;
    JRadioButton display_info;
    JRadioButton collapse;
    JRadioButton reroot;
    JRadioButton swap;
    JRadioButton subtree;
    ButtonGroup group;
    JLabel click_to;
    boolean order_of_appearance;
    static final Font jcb_font = new Font("Helvetica", 0, 9);
    static Color background_color;
    static Color jcb_text_color;
    static Color jcb_background_color;
    static Color button_text_color;
    static Color button_background_color;

    ATVcontrol() {
    }

    ATVcontrol(ATVpanel aTVpanel) {
        this.atvpanel = aTVpanel;
        this.setColors1();
        this.setBackground(background_color);
        this.setLayout(new GridLayout(0, 1, 2, 2));
        this.order_of_appearance = true;
        this.userealbl = new JCheckBox("Real branch lengths");
        this.seqnameextnodes = new JCheckBox("Seq. name ext. nodes");
        this.seqnameintnodes = new JCheckBox("Seq. name int. nodes");
        this.speciesextnodes = new JCheckBox("Species ext. nodes");
        this.speciesintnodes = new JCheckBox("Species int. nodes");
        this.ecextnodes = new JCheckBox("EC ext. nodes");
        this.ecintnodes = new JCheckBox("EC int. nodes");
        this.writelnl = new JCheckBox("log L values");
        this.writebl = new JCheckBox("Branch length values");
        this.writebootstrap = new JCheckBox("Bootstrap values");
        this.writed_s = new JCheckBox("Duplic. vs. spec.");
        this.colorbranches = new JCheckBox("Color accord. to log L");
        this.color_orthos = new JCheckBox("Display orthology");
        this.color_super_orthos = new JCheckBox("Display s-orthology");
        this.editable = new JCheckBox("Editable");
        this.addJCB(this.userealbl);
        this.addJCB(this.seqnameextnodes);
        this.addJCB(this.seqnameintnodes);
        this.addJCB(this.speciesextnodes);
        this.addJCB(this.speciesintnodes);
        this.addJCB(this.ecextnodes);
        this.addJCB(this.ecintnodes);
        this.addJCB(this.writebl);
        this.addJCB(this.writebootstrap);
        this.addJCB(this.writed_s);
        this.addJCB(this.color_orthos);
        this.addJCB(this.color_super_orthos);
        this.addJCB(this.colorbranches);
        this.addJCB(this.writelnl);
        this.addJCB(this.editable);
        this.click_to = new JLabel("Click on Node to:");
        this.click_to.setFont(jcb_font);
        this.click_to.setForeground(jcb_text_color);
        this.click_to.setBackground(background_color);
        this.add(this.click_to);
        this.display_info = new JRadioButton("Display/Edit information");
        this.collapse = new JRadioButton("Collapse/Uncollapse");
        this.reroot = new JRadioButton("Root/Reroot");
        this.swap = new JRadioButton("Swap children");
        this.subtree = new JRadioButton("Subtree/Parent tree");
        this.group = new ButtonGroup();
        this.addJRB(this.display_info);
        this.addJRB(this.collapse);
        this.addJRB(this.reroot);
        this.addJRB(this.subtree);
        this.addJRB(this.swap);
        this.zoom_in_x = new JButton("Zoom in X");
        this.zoom_in_y = new JButton("Zoom in Y");
        this.zoom_out_x = new JButton("Zoom out X");
        this.zoom_out_y = new JButton("Zoom out Y");
        this.show_whole = new JButton("Show whole");
        this.order = new JButton("Order subtrees");
        this.uncollapse_all = new JButton("Uncollapse all");
        this.collapse_to_deepest_annot = new JButton("Collapse to deepest");
        this.collapse_to_deepest_annot.setToolTipText("Collapses to the deepest nodes annotated with either a species or a sequence name.");
        this.uncollapse_all.setToolTipText("Uncollapses all nodes.");
        this.order.setToolTipText("Orders (swaps children of) each subtree according to its sum of external nodes.");
        this.addJB(this.zoom_in_x);
        this.addJB(this.zoom_out_x);
        this.addJB(this.zoom_in_y);
        this.addJB(this.zoom_out_y);
        this.addJB(this.show_whole);
        this.addJB2(this.order);
        this.addJB2(this.uncollapse_all);
        this.addJB2(this.collapse_to_deepest_annot);
        this.setCheckBoxes();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ATVgraphic aTVgraphic = this.atvpanel.getATVgraphic();
        if (actionEvent.getSource() == this.color_orthos) {
            this.color_super_orthos.setSelected(false);
        }
        if (actionEvent.getSource() == this.color_super_orthos) {
            this.color_orthos.setSelected(false);
        }
        if (aTVgraphic.getTree() != null) {
            if (this.userealbl.isSelected()) {
                aTVgraphic.setUseRealBranchLenghts(true);
            } else {
                aTVgraphic.setUseRealBranchLenghts(false);
            }
            if (actionEvent.getSource() == this.userealbl) {
                this.showWhole();
            }
            aTVgraphic.setSeqNameExtNodes(this.seqnameextnodes.isSelected());
            aTVgraphic.setSeqNameInternalNodes(this.seqnameintnodes.isSelected());
            aTVgraphic.setSpeciesExtNodes(this.speciesextnodes.isSelected());
            aTVgraphic.setSpeciesInternalNodes(this.speciesintnodes.isSelected());
            aTVgraphic.setECExtNodes(this.ecextnodes.isSelected());
            aTVgraphic.setECInternalNodes(this.ecintnodes.isSelected());
            aTVgraphic.setWriteLnLValues(this.writelnl.isSelected());
            aTVgraphic.setWriteBranchLengthValues(this.writebl.isSelected());
            aTVgraphic.setWriteBootstrapValues(this.writebootstrap.isSelected());
            aTVgraphic.setWriteDupSpec(this.writed_s.isSelected());
            aTVgraphic.setColorBranchesAccToLnL(this.colorbranches.isSelected());
            aTVgraphic.setColorOrthologous(this.color_orthos.isSelected());
            aTVgraphic.setColorSuperOrthologous(this.color_super_orthos.isSelected());
            aTVgraphic.setEditable(this.editable.isSelected());
            if (this.display_info.isSelected()) {
                this.atvpanel.getATVgraphic().setActionWhenNodeClicked(0);
            } else if (this.collapse.isSelected()) {
                this.atvpanel.getATVgraphic().setActionWhenNodeClicked(1);
            } else if (this.reroot.isSelected()) {
                this.atvpanel.getATVgraphic().setActionWhenNodeClicked(3);
            } else if (this.subtree.isSelected()) {
                this.atvpanel.getATVgraphic().setActionWhenNodeClicked(4);
            } else if (this.swap.isSelected()) {
                this.atvpanel.getATVgraphic().setActionWhenNodeClicked(5);
            }
            if (actionEvent.getSource() == this.zoom_in_x) {
                this.atvpanel.getATVgraphic().setXdistance((int)(this.atvpanel.getATVgraphic().getXdistance() * 1.05) + 1);
                this.atvpanel.getATVgraphic().setXcorrectionFactor(this.atvpanel.getATVgraphic().getXcorrectionFactor() * 1.1);
                this.atvpanel.getATVgraphic().resetPreferredSize();
            } else if (actionEvent.getSource() == this.zoom_in_y) {
                this.atvpanel.getATVgraphic().setYdistance((int)(this.atvpanel.getATVgraphic().getYdistance() * 1.05) + 1);
                this.atvpanel.getATVgraphic().resetPreferredSize();
            } else if (actionEvent.getSource() == this.zoom_out_x) {
                this.atvpanel.getATVgraphic().setXdistance((int)(this.atvpanel.getATVgraphic().getXdistance() * 0.95));
                this.atvpanel.getATVgraphic().setXcorrectionFactor(this.atvpanel.getATVgraphic().getXcorrectionFactor() * 0.9);
                this.atvpanel.getATVgraphic().resetPreferredSize();
            } else if (actionEvent.getSource() == this.zoom_out_y) {
                this.atvpanel.getATVgraphic().setYdistance((int)(this.atvpanel.getATVgraphic().getYdistance() * 0.95));
                this.atvpanel.getATVgraphic().resetPreferredSize();
            } else if (actionEvent.getSource() == this.show_whole) {
                this.showWhole();
            } else if (actionEvent.getSource() == this.order) {
                aTVgraphic.getTree().orderAppearance(this.order_of_appearance);
                this.order_of_appearance ^= true;
            } else if (actionEvent.getSource() == this.uncollapse_all) {
                this.uncollapseAll(aTVgraphic);
            } else if (actionEvent.getSource() == this.collapse_to_deepest_annot) {
                this.collapseToDeepestAnnot(aTVgraphic);
            }
            this.atvpanel.adjustJScrollPane();
            this.atvpanel.getATVgraphic().repaint();
        }
    }

    void addJB(JButton jButton) {
        jButton.setBackground(button_background_color);
        jButton.setForeground(button_text_color);
        jButton.setFont(jcb_font);
        this.add(jButton);
        jButton.addActionListener(this);
    }

    void addJB2(JButton jButton) {
        jButton.setBackground(background_color);
        jButton.setForeground(button_text_color);
        jButton.setFont(jcb_font);
        this.add(jButton);
        jButton.addActionListener(this);
    }

    void addJCB(JCheckBox jCheckBox) {
        jCheckBox.setBackground(jcb_background_color);
        jCheckBox.setForeground(jcb_text_color);
        jCheckBox.setFont(jcb_font);
        this.add(jCheckBox);
        jCheckBox.addActionListener(this);
    }

    void addJRB(JRadioButton jRadioButton) {
        jRadioButton.setBackground(jcb_background_color);
        jRadioButton.setForeground(jcb_text_color);
        jRadioButton.setFont(jcb_font);
        this.add(jRadioButton);
        this.group.add(jRadioButton);
        jRadioButton.addActionListener(this);
    }

    void collapseToDeepestAnnot(ATVgraphic aTVgraphic) {
        Tree tree = aTVgraphic.getTree();
        if (tree != null && !tree.isEmpty()) {
            tree.collapseToDeepestAnotNodes();
            this.showWhole();
        }
    }

    void setCheckBoxes() {
        ATVgraphic aTVgraphic = this.atvpanel.getATVgraphic();
        if (aTVgraphic.getTree() != null) {
            this.display_info.setSelected(true);
            this.userealbl.setSelected(aTVgraphic.useRealBranchLenghts());
            this.seqnameextnodes.setSelected(aTVgraphic.seqNameExtNodes());
            this.seqnameintnodes.setSelected(aTVgraphic.seqNameInternalNodes());
            this.speciesextnodes.setSelected(aTVgraphic.speciesExtNodes());
            this.speciesintnodes.setSelected(aTVgraphic.speciesInternalNodes());
            this.ecextnodes.setSelected(aTVgraphic.ECExtNodes());
            this.ecintnodes.setSelected(aTVgraphic.ECInternalNodes());
            this.writelnl.setSelected(aTVgraphic.writeLnLValues());
            this.writebl.setSelected(aTVgraphic.writeBranchLengthValues());
            this.writebootstrap.setSelected(aTVgraphic.writeBootstrapValues());
            this.colorbranches.setSelected(aTVgraphic.colorBranchesAccToLnL());
            this.color_orthos.setSelected(aTVgraphic.colorOrthologous());
            this.color_super_orthos.setSelected(aTVgraphic.colorSuperOrthologous());
            this.editable.setSelected(aTVgraphic.isEditable());
            if (this.atvpanel.getATVgraphic().getActionWhenNodeClicked() == 0) {
                this.display_info.setSelected(true);
            } else if (this.atvpanel.getATVgraphic().getActionWhenNodeClicked() == 1) {
                this.collapse.setSelected(true);
            } else if (this.atvpanel.getATVgraphic().getActionWhenNodeClicked() == 3) {
                this.reroot.setSelected(true);
            } else if (this.atvpanel.getATVgraphic().getActionWhenNodeClicked() == 4) {
                this.subtree.setSelected(true);
            } else if (this.atvpanel.getATVgraphic().getActionWhenNodeClicked() == 5) {
                this.swap.setSelected(true);
            }
        }
    }

    void setColors1() {
        background_color = new Color(215, 215, 215);
        jcb_text_color = new Color(0, 0, 0);
        jcb_background_color = background_color;
        button_text_color = new Color(0, 0, 0);
        button_background_color = new Color(165, 165, 165);
    }

    void showWhole() {
        this.atvpanel.getATVgraphic().setParametersForPainting(this.atvpanel.getSizeOfViewport().width, this.atvpanel.getSizeOfViewport().height);
        this.atvpanel.getATVgraphic().resetPreferredSize();
        this.atvpanel.adjustJScrollPane();
    }

    void uncollapseAll(ATVgraphic aTVgraphic) {
        Tree tree = aTVgraphic.getTree();
        if (tree != null && !tree.isEmpty()) {
            tree.setAllNodesToNotCollapse();
            tree.adjustNodeCount(false);
            tree.recalculateAndReset();
            this.showWhole();
        }
    }
}

