/*
 * Decompiled with CFR 0.152.
 */
package forester.atv;

import forester.atv.ATVpanel;
import forester.atv.ATVprinter;
import forester.atv.ATVtextframe;
import forester.atv.NHFilter;
import forester.atv.NHXFilter;
import forester.tools.SDI;
import forester.tools.SDIse;
import forester.tools.SDIunrooted;
import forester.tree.Node;
import forester.tree.Tree;
import forester.tree.TreeHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSlider;

public class ATVjframe
extends JFrame
implements ActionListener {
    private Tree reload_tree_ = null;
    private Tree species_tree_ = null;
    private File treefile = null;
    private JMenuBar jmenubar;
    private JMenu file_jmenu;
    private JMenu edit_jmenu;
    private JMenu view_jmenu;
    private JMenu options_jmenu;
    private JMenu help_jmenu;
    private JMenu print_size_jmenu;
    private JMenu SDI_jmenu;
    private JMenu search_jmenu;
    private JMenuItem open_item;
    private JMenuItem open_url_item;
    private JMenuItem save_item;
    private JMenuItem saveas_item;
    private JMenuItem print_item;
    private JMenuItem close_item;
    private JMenuItem reload_item;
    private JMenuItem exit_item;
    private JMenuItem remove_root_item;
    private JMenuItem remove_root_tri_item;
    private JMenuItem tiny_fonts_item;
    private JMenuItem small_fonts_item;
    private JMenuItem medium_fonts_item;
    private JMenuItem large_fonts_item;
    private JMenuItem switch_colors_item;
    private JMenuItem view_as_NH_item;
    private JMenuItem view_as_NHX_item;
    private JMenuItem about_item;
    private JMenuItem help_item;
    private JMenuItem load_species_tree_item;
    private JMenuItem infer_dups_item;
    private JMenuItem root_min_dups_height_item;
    private JMenuItem root_min_L_height_item;
    private JMenuItem root_min_height_item;
    private JMenuItem find_item;
    private JMenuItem find_reset_item;
    private ATVpanel atvpanel;
    private Container contentpane;
    private ATVtextframe atvtextframe;
    private JFileChooser open_jfilechooser;
    private JFileChooser saveas_jfilechooser;
    private JSlider x_slider;
    private JSlider y_slider;
    private JLabel xs_label;
    private JLabel ys_label;
    private JCheckBox print_in_color;
    private static final int SLIDER_MIN = 0;
    private static final int SLIDER_MAX = 200;
    private static final int SLIDER_VAL = 100;
    private static final int SLIDER_MAJS = 50;
    private static final int SLIDER_MINS = 10;
    private static final Color menu_background_color = new Color(215, 215, 215);
    private static final Color menu_text_color = new Color(0, 0, 0);
    private static final Font menu_font = new Font("Helvetica", 0, 10);
    private static final int FRAME_X_SIZE = 640;
    private static final int FRAME_Y_SIZE = 580;
    private static final int PRINT_X_SIZE = 580;
    private static final int PRINT_Y_SIZE = 700;
    private static final NHXFilter nhxfilter = new NHXFilter();
    private static final NHFilter nhfilter = new NHFilter();

    public ATVjframe(Tree tree) {
        ((Component)this).setVisible(false);
        if (tree != null && !tree.isEmpty()) {
            this.reload_tree_ = tree.copyTree();
        }
        this.atvtextframe = null;
        this.species_tree_ = null;
        this.setTitle("ATV");
        this.open_jfilechooser = new JFileChooser();
        this.open_jfilechooser.setCurrentDirectory(new File("."));
        this.open_jfilechooser.setMultiSelectionEnabled(false);
        this.open_jfilechooser.setFileFilter(nhxfilter);
        this.open_jfilechooser.addChoosableFileFilter(nhfilter);
        this.open_jfilechooser.addChoosableFileFilter(this.open_jfilechooser.getAcceptAllFileFilter());
        this.saveas_jfilechooser = new JFileChooser();
        this.saveas_jfilechooser.setCurrentDirectory(new File("."));
        this.saveas_jfilechooser.setMultiSelectionEnabled(false);
        this.saveas_jfilechooser.setFileFilter(nhxfilter);
        this.saveas_jfilechooser.addChoosableFileFilter(nhfilter);
        this.saveas_jfilechooser.addChoosableFileFilter(this.saveas_jfilechooser.getAcceptAllFileFilter());
        this.atvpanel = new ATVpanel(tree);
        this.jmenubar = new JMenuBar();
        this.jmenubar.setBackground(menu_background_color);
        this.file_jmenu = new JMenu("File");
        this.edit_jmenu = new JMenu("Edit");
        this.search_jmenu = new JMenu("Search");
        this.SDI_jmenu = new JMenu("SDI");
        this.view_jmenu = new JMenu("View");
        this.options_jmenu = new JMenu("Options");
        this.help_jmenu = new JMenu("Help");
        this.print_size_jmenu = new JMenu("Print Options");
        this.file_jmenu.setFont(menu_font);
        this.file_jmenu.setBackground(menu_background_color);
        this.file_jmenu.setForeground(menu_text_color);
        this.edit_jmenu.setFont(menu_font);
        this.edit_jmenu.setBackground(menu_background_color);
        this.edit_jmenu.setForeground(menu_text_color);
        this.search_jmenu.setFont(menu_font);
        this.search_jmenu.setBackground(menu_background_color);
        this.search_jmenu.setForeground(menu_text_color);
        this.SDI_jmenu.setFont(menu_font);
        this.SDI_jmenu.setBackground(menu_background_color);
        this.SDI_jmenu.setForeground(menu_text_color);
        this.view_jmenu.setFont(menu_font);
        this.view_jmenu.setBackground(menu_background_color);
        this.view_jmenu.setForeground(menu_text_color);
        this.options_jmenu.setFont(menu_font);
        this.options_jmenu.setBackground(menu_background_color);
        this.options_jmenu.setForeground(menu_text_color);
        this.help_jmenu.setFont(menu_font);
        this.help_jmenu.setBackground(menu_background_color);
        this.help_jmenu.setForeground(menu_text_color);
        this.print_size_jmenu.setFont(menu_font);
        this.print_size_jmenu.setBackground(menu_background_color);
        this.print_size_jmenu.setForeground(menu_text_color);
        this.reload_item = new JMenuItem("Reload");
        this.file_jmenu.add(this.reload_item);
        this.file_jmenu.addSeparator();
        this.open_item = new JMenuItem("Open");
        this.file_jmenu.add(this.open_item);
        this.open_url_item = new JMenuItem("Open URL to read a NH/NHX tree");
        this.file_jmenu.add(this.open_url_item);
        this.saveas_item = new JMenuItem("Save As");
        this.file_jmenu.add(this.saveas_item);
        this.save_item = new JMenuItem("Save");
        this.file_jmenu.add(this.save_item);
        this.file_jmenu.addSeparator();
        this.file_jmenu.add(this.print_size_jmenu);
        this.print_item = new JMenuItem("Print");
        this.file_jmenu.add(this.print_item);
        this.file_jmenu.addSeparator();
        this.close_item = new JMenuItem("Close");
        this.file_jmenu.add(this.close_item);
        this.file_jmenu.addSeparator();
        this.exit_item = new JMenuItem("Exit");
        this.file_jmenu.add(this.exit_item);
        this.x_slider = new JSlider(0, 200, 100);
        this.y_slider = new JSlider(0, 200, 100);
        this.xs_label = new JLabel("X size:");
        this.ys_label = new JLabel("Y size:");
        this.xs_label.setFont(menu_font);
        this.xs_label.setForeground(menu_text_color);
        this.ys_label.setFont(menu_font);
        this.ys_label.setForeground(menu_text_color);
        ((JComponent)this.x_slider).setFont(menu_font);
        ((JComponent)this.y_slider).setFont(menu_font);
        this.print_in_color = new JCheckBox("Print in color");
        this.print_in_color.setFont(menu_font);
        this.print_in_color.setForeground(menu_text_color);
        this.print_size_jmenu.add(this.print_in_color);
        this.x_slider.setMajorTickSpacing(50);
        this.x_slider.setMinorTickSpacing(10);
        this.x_slider.setPaintTicks(true);
        this.x_slider.setPaintLabels(true);
        this.x_slider.setSnapToTicks(true);
        this.print_size_jmenu.add(this.xs_label);
        this.print_size_jmenu.add(this.x_slider);
        this.y_slider.setMajorTickSpacing(50);
        this.y_slider.setMinorTickSpacing(10);
        this.y_slider.setPaintTicks(true);
        this.y_slider.setPaintLabels(true);
        this.y_slider.setSnapToTicks(true);
        this.print_size_jmenu.add(this.ys_label);
        this.print_size_jmenu.add(this.y_slider);
        this.remove_root_item = new JMenuItem("Remove root");
        this.edit_jmenu.add(this.remove_root_item);
        this.remove_root_tri_item = new JMenuItem("Remove root and trifurcate");
        this.edit_jmenu.add(this.remove_root_tri_item);
        this.find_item = new JMenuItem("Search");
        this.search_jmenu.add(this.find_item);
        this.search_jmenu.addSeparator();
        this.find_reset_item = new JMenuItem("Reset");
        this.search_jmenu.add(this.find_reset_item);
        this.infer_dups_item = new JMenuItem("SDI (Speciation Duplication Inference)");
        this.SDI_jmenu.add(this.infer_dups_item);
        this.SDI_jmenu.addSeparator();
        this.root_min_dups_height_item = new JMenuItem("SDI and root by minimizing duplications | height");
        this.SDI_jmenu.add(this.root_min_dups_height_item);
        this.root_min_L_height_item = new JMenuItem("SDI and root by minimizing cost L | height");
        this.SDI_jmenu.add(this.root_min_L_height_item);
        this.root_min_height_item = new JMenuItem("SDI and root by minimizing height");
        this.SDI_jmenu.add(this.root_min_height_item);
        this.SDI_jmenu.addSeparator();
        this.load_species_tree_item = new JMenuItem("Load species tree");
        this.SDI_jmenu.add(this.load_species_tree_item);
        this.view_as_NH_item = new JMenuItem("View as NH");
        this.view_jmenu.add(this.view_as_NH_item);
        this.view_as_NHX_item = new JMenuItem("View as NHX");
        this.view_jmenu.add(this.view_as_NHX_item);
        this.switch_colors_item = new JMenuItem("Switch colors");
        this.options_jmenu.add(this.switch_colors_item);
        this.options_jmenu.addSeparator();
        this.tiny_fonts_item = new JMenuItem("Tiny fonts");
        this.options_jmenu.add(this.tiny_fonts_item);
        this.small_fonts_item = new JMenuItem("Small fonts");
        this.options_jmenu.add(this.small_fonts_item);
        this.medium_fonts_item = new JMenuItem("Medium fonts");
        this.options_jmenu.add(this.medium_fonts_item);
        this.large_fonts_item = new JMenuItem("Large fonts");
        this.options_jmenu.add(this.large_fonts_item);
        this.help_item = new JMenuItem("Help");
        this.help_jmenu.add(this.help_item);
        this.about_item = new JMenuItem("About");
        this.help_jmenu.add(this.about_item);
        this.customizeJMenuItem(this.reload_item);
        this.customizeJMenuItem(this.open_item);
        this.customizeJMenuItem(this.open_url_item);
        this.customizeJMenuItem(this.save_item);
        this.customizeJMenuItem(this.saveas_item);
        this.customizeJMenuItem(this.print_item);
        this.customizeJMenuItem(this.close_item);
        this.customizeJMenuItem(this.exit_item);
        this.customizeJMenuItem(this.remove_root_item);
        this.customizeJMenuItem(this.remove_root_tri_item);
        this.customizeJMenuItem(this.tiny_fonts_item);
        this.customizeJMenuItem(this.small_fonts_item);
        this.customizeJMenuItem(this.medium_fonts_item);
        this.customizeJMenuItem(this.large_fonts_item);
        this.customizeJMenuItem(this.switch_colors_item);
        this.customizeJMenuItem(this.view_as_NH_item);
        this.customizeJMenuItem(this.view_as_NHX_item);
        this.customizeJMenuItem(this.about_item);
        this.customizeJMenuItem(this.help_item);
        this.customizeJMenuItem(this.load_species_tree_item);
        this.customizeJMenuItem(this.infer_dups_item);
        this.customizeJMenuItem(this.root_min_dups_height_item);
        this.customizeJMenuItem(this.root_min_L_height_item);
        this.customizeJMenuItem(this.root_min_height_item);
        this.customizeJMenuItem(this.find_item);
        this.customizeJMenuItem(this.find_reset_item);
        this.jmenubar.add(this.file_jmenu);
        this.jmenubar.add(this.edit_jmenu);
        this.jmenubar.add(this.search_jmenu);
        this.jmenubar.add(this.SDI_jmenu);
        this.jmenubar.add(this.view_jmenu);
        this.jmenubar.add(this.options_jmenu);
        this.jmenubar.add(this.help_jmenu);
        this.setJMenuBar(this.jmenubar);
        this.contentpane = this.getContentPane();
        this.contentpane.setLayout(new BorderLayout());
        this.contentpane.add((Component)this.atvpanel, "Center");
        ((Component)this).setSize(640, 580);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ATVjframe.this.close();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ATVjframe.this.atvpanel.getATVgraphic().setParametersForPainting(ATVjframe.this.atvpanel.getATVgraphic().getWidth(), ATVjframe.this.atvpanel.getATVgraphic().getHeight());
            }
        });
        ((Component)this).setVisible(true);
    }

    private boolean GAndSDoHaveMoreThanOneSpeciesInComman(Tree tree) {
        if (tree == null || tree.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Gene tree and species tree have no species in common.", "Error during SDI", 0);
            return false;
        }
        if (tree.getNumberOfExtNodes() < 2) {
            JOptionPane.showMessageDialog(this, "Gene tree and species tree have only one species in common.", "Error during SDI", 0);
            return false;
        }
        return true;
    }

    private void about() {
        String string = "ATV (A Tree Viewer)\nVersion 1.91\n";
        string = String.valueOf(string) + "Copyright (C) 1999-2001 Washington University School of Medicine\n";
        string = String.valueOf(string) + "and Howard Hughes Medical Institute\n";
        string = String.valueOf(string) + "All Rights Reserved\n";
        string = String.valueOf(string) + "Author: Christian M. Zmasek\n";
        string = String.valueOf(string) + "Last modified: 10/08/01\n";
        string = String.valueOf(string) + "Reference: Zmasek C.M. and Eddy S.R. Bioinformatics, 17, 383 (2001)\n";
        string = String.valueOf(string) + "For more information & download:\n";
        string = String.valueOf(string) + "http://www.genetics.wustl.edu/eddy/atv/\n";
        string = String.valueOf(string) + "Comments: zmasek@genetics.wustl.edu";
        JOptionPane.showMessageDialog(this, string, "ATV application (Java 1.2 or greater)", -1);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.reload_item) {
            this.reLoad();
        } else if (object == this.open_item) {
            this.openFile();
        } else if (object == this.open_url_item) {
            this.openURL();
        } else if (object == this.save_item) {
            this.save(this.atvpanel.getATVgraphic().getTree());
        } else if (object == this.saveas_item) {
            this.saveAs(this.atvpanel.getATVgraphic().getTree());
        } else if (object == this.print_item) {
            this.printTree();
        } else if (object == this.close_item) {
            this.close();
        } else if (object == this.exit_item) {
            this.exit();
        } else if (object == this.remove_root_item) {
            this.removeRoot();
        } else if (object == this.remove_root_tri_item) {
            this.removeRootTri();
        } else if (object == this.switch_colors_item) {
            this.switchColors();
        } else if (object == this.tiny_fonts_item) {
            this.atvpanel.getATVgraphic().tinyFonts();
            this.atvpanel.getATVgraphic().repaint();
        } else if (object == this.small_fonts_item) {
            this.atvpanel.getATVgraphic().smallFonts();
            this.atvpanel.getATVgraphic().repaint();
        } else if (object == this.medium_fonts_item) {
            this.atvpanel.getATVgraphic().mediumFonts();
            this.atvpanel.getATVgraphic().repaint();
        } else if (object == this.large_fonts_item) {
            this.atvpanel.getATVgraphic().largeFonts();
            this.atvpanel.getATVgraphic().repaint();
        } else if (object == this.view_as_NH_item) {
            this.viewAsNH();
        } else if (object == this.view_as_NHX_item) {
            this.viewAsNHX();
        } else if (object == this.about_item) {
            this.about();
        } else if (object == this.help_item) {
            this.help();
        } else if (object == this.load_species_tree_item) {
            this.openSpeciesTreeFile();
        } else if (object == this.infer_dups_item) {
            this.inferDups();
        } else if (object == this.root_min_dups_height_item) {
            this.rootMinDupsHeight();
        } else if (object == this.root_min_L_height_item) {
            this.rootMinLHeight();
        } else if (object == this.root_min_height_item) {
            this.rootMinHeight();
        } else if (object == this.find_item) {
            this.find();
        } else if (object == this.find_reset_item) {
            this.findReset();
        }
    }

    private void close() {
        this.removeatvtextframe();
        this.atvpanel.terminate();
        this.contentpane.removeAll();
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void customizeJMenuItem(JMenuItem jMenuItem) {
        jMenuItem.setFont(menu_font);
        jMenuItem.setBackground(menu_background_color);
        jMenuItem.setForeground(menu_text_color);
        jMenuItem.addActionListener(this);
    }

    private void exceptionOccuredDuringOpenFile(Exception exception) {
        JOptionPane.showMessageDialog(this, "Exception: " + exception, "Error during File|Open", 0);
    }

    private void exceptionOccuredDuringSaveAs(Exception exception) {
        JOptionPane.showMessageDialog(this, "Exception" + exception, "Error during File|SaveAs", 0);
    }

    private void exit() {
        System.exit(0);
    }

    private void find() {
        if (this.atvpanel.getATVgraphic().getTree() == null || this.atvpanel.getATVgraphic().getTree().isEmpty()) {
            return;
        }
        String string = "String to search for in sequence and species names,\nEC numbers; or integer for taxonomy IDs:";
        String string2 = JOptionPane.showInputDialog(this, string, "Search", 3);
        if (string2 != null && !(string2 = string2.trim()).equals("")) {
            Vector vector = null;
            try {
                vector = this.atvpanel.getATVgraphic().getTree().findInNameSpecECid(string2);
            }
            catch (Exception exception) {
                System.err.println("Unexpected exception: " + exception);
            }
            if (vector != null && vector.size() > 0) {
                this.atvpanel.getATVgraphic().setFoundNodes(vector);
            } else {
                JOptionPane.showMessageDialog(this, "Could not find \"" + string2 + "\"", "Search", 0);
            }
        }
        this.contentpane.repaint();
    }

    private void findReset() {
        if (this.atvpanel.getATVgraphic().getTree() == null || this.atvpanel.getATVgraphic().getTree().isEmpty()) {
            return;
        }
        this.atvpanel.getATVgraphic().setFoundNodes(null);
        this.contentpane.repaint();
    }

    private void help() {
        String string = "(Left) click on nodes of the tree to:\n";
        string = String.valueOf(string) + "o  Display and edit information of a node.\n";
        string = String.valueOf(string) + "    To edit information, box \"Editable\" needs to be checked.\n";
        string = String.valueOf(string) + "o  Collapse and uncollapse subtrees.\n";
        string = String.valueOf(string) + "o  Go to SWISS-PROT and display its entry for the corresponding sequence.\n";
        string = String.valueOf(string) + "    Only available in JApplet version.\n";
        string = String.valueOf(string) + "    Seq names need to be proper SWISS-PROT names for this to work.\n";
        string = String.valueOf(string) + "o  Place a root in the middle of the parent branch.\n";
        string = String.valueOf(string) + "o  Display a subtree.\n";
        string = String.valueOf(string) + "    To go back to the parent tree, click on the root node of the subtree.\n";
        string = String.valueOf(string) + "o  Swap the children of a node (a pure cosmetic operation).\n\n";
        string = String.valueOf(string) + "Right clicking always displays the information of a node.\n\n";
        string = String.valueOf(string) + "\"SaveAs\" \"Save\" save the (sub)tree which is currently shown in the frame.\n";
        string = String.valueOf(string) + "\"Print\" prints the (sub)tree which is currently shown in the frame.\n\n";
        string = String.valueOf(string) + "For more information: http://www.genetics.wustl.edu/eddy/atv/\n";
        string = String.valueOf(string) + "Email: zmasek@genetics.wustl.edu\n\n";
        string = String.valueOf(string) + "General remarks:\n";
        string = String.valueOf(string) + "o  ATV can deal with trees with an arbitrary number of \n";
        string = String.valueOf(string) + "    children per parent (except for SDI).\n";
        string = String.valueOf(string) + "o  The application version allows to copy to the clipboard \n";
        string = String.valueOf(string) + "    in the \"View\"|\"View as ...\" frame (either by control-c or button press).\n";
        string = String.valueOf(string) + "o  Changes made to a subtree affect this subtree and its subtrees,\n";
        string = String.valueOf(string) + "    but not any of its parent tree(s).\n";
        string = String.valueOf(string) + "o  ATV tries to detect whether the numerical values in a NH tree\n";
        string = String.valueOf(string) + "    are likely to be bootstrap values instead of branch length values.\n\n";
        string = String.valueOf(string) + "Remarks regarding SDI (Speciation Duplication Inference):\n";
        string = String.valueOf(string) + "o  Each external node of the gene tree (in display) needs to be associated with\n";
        string = String.valueOf(string) + "    a species: either directly through the \"Species\" field, or the species\n";
        string = String.valueOf(string) + "    is part of the sequence name in the form \"XXXX_SPECIES\"\n";
        string = String.valueOf(string) + "    (e.g. \"ACON_DROME\" or \"ACON_DROME/123-4489\" which is also acceptable).\n";
        string = String.valueOf(string) + "o  A species tree for each species of the gene tree needs to be loaded with\n";
        string = String.valueOf(string) + "   \"SDI\"|\"Load species tree\" prior the SDI execution.\n";
        string = String.valueOf(string) + "   Duplications and speciations on the gene tree are a function of the species tree.\n";
        string = String.valueOf(string) + "o  !External nodes of the gene tree associated with species not present in\n";
        string = String.valueOf(string) + "    the species tree are REMOVED prior to SDI execution!\n";
        string = String.valueOf(string) + "o  Both the gene tree and the species tree must be completely binary.\n";
        string = String.valueOf(string) + "o  Duplications and speciations are a function of the position of the root.\n";
        string = String.valueOf(string) + "    Hence, after each manual \"Root/Reroot\"ing some duplications will be\n";
        string = String.valueOf(string) + "    incorrect and need to be inferred again\n";
        string = String.valueOf(string) + "    with: \"SDI\"|\"SDI (Speciation Duplication Inference)\".\n";
        JOptionPane.showMessageDialog(this, string, "Help", -1);
    }

    private void inferDups() {
        if (!this.isOKforSDI()) {
            return;
        }
        if (!this.atvpanel.getATVgraphic().getTree().isRooted()) {
            JOptionPane.showMessageDialog(this, "Gene tree is not rooted.", "Error during SDI", 0);
            return;
        }
        Tree tree = this.atvpanel.getATVgraphic().getTree().copyTree();
        SDIse sDIse = null;
        int n = -1;
        tree.setAllNodesToNotCollapse();
        tree.adjustNodeCount(false);
        tree.recalculateAndReset();
        TreeHelper.extractSpeciesNameFromSeqName(tree);
        SDI.stripTree(this.species_tree_, tree);
        if (!this.GAndSDoHaveMoreThanOneSpeciesInComman(tree)) {
            return;
        }
        try {
            sDIse = new SDIse(tree, this.species_tree_.copyTree());
            n = ((SDI)sDIse).infer(true);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "Exception during SDI", 0);
        }
        String string = this.getTitle();
        if (string.indexOf(" [") > -1) {
            string = string.substring(0, string.indexOf(" ["));
        }
        if (n >= 0) {
            string = String.valueOf(string) + " [" + n + " duplications]";
        }
        this.setTitle(string);
        this.atvpanel.getATVgraphic().setTree(tree);
        this.showWhole();
        this.contentpane.repaint();
    }

    private boolean isOKforSDI() {
        if (this.atvpanel.getATVgraphic().getTree() == null || this.atvpanel.getATVgraphic().getTree().isEmpty()) {
            return false;
        }
        if (this.species_tree_ == null || this.species_tree_.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No species tree loaded.", "Error during SDI", 0);
            return false;
        }
        if (!this.atvpanel.getATVgraphic().getTree().isCompletelyBinary()) {
            JOptionPane.showMessageDialog(this, "Gene tree is not completely binary.", "Error during SDI", 0);
            return false;
        }
        return true;
    }

    private void openFile() {
        boolean bl = false;
        Tree tree = null;
        int n = this.open_jfilechooser.showOpenDialog(this.contentpane);
        File file = this.open_jfilechooser.getSelectedFile();
        if (file != null && n == 0) {
            if (this.open_jfilechooser.getFileFilter() == nhfilter || this.open_jfilechooser.getFileFilter() == nhxfilter) {
                try {
                    tree = TreeHelper.readNHtree(file);
                }
                catch (Exception exception) {
                    bl = true;
                    this.exceptionOccuredDuringOpenFile(exception);
                }
            } else {
                try {
                    tree = TreeHelper.readNHtree(file);
                }
                catch (Exception exception) {
                    bl = true;
                    this.exceptionOccuredDuringOpenFile(exception);
                }
            }
            if (!bl && tree != null && !tree.isEmpty()) {
                this.reload_tree_ = tree.copyTree();
                this.removeatvtextframe();
                this.atvpanel.terminate();
                this.contentpane.removeAll();
                this.atvpanel = new ATVpanel(tree);
                this.contentpane.add((Component)this.atvpanel, "Center");
                ((Component)this).setVisible(true);
                this.treefile = file;
                this.setTitle("ATV: " + this.treefile);
                this.atvpanel.getATVgraphic().setParametersForPainting(this.atvpanel.getATVgraphic().getWidth(), this.atvpanel.getATVgraphic().getHeight());
                this.atvpanel.getATVcontrol().showWhole();
            }
            this.contentpane.repaint();
        }
    }

    private void openSpeciesTreeFile() {
        Tree tree = null;
        boolean bl = false;
        int n = this.open_jfilechooser.showOpenDialog(this.contentpane);
        File file = this.open_jfilechooser.getSelectedFile();
        if (file != null && n == 0) {
            if (this.open_jfilechooser.getFileFilter() == nhfilter || this.open_jfilechooser.getFileFilter() == nhxfilter) {
                try {
                    tree = TreeHelper.readNHtree(file);
                }
                catch (Exception exception) {
                    bl = true;
                    this.exceptionOccuredDuringOpenFile(exception);
                }
            } else {
                try {
                    tree = TreeHelper.readNHtree(file);
                }
                catch (Exception exception) {
                    bl = true;
                    this.exceptionOccuredDuringOpenFile(exception);
                }
            }
            if (!bl && tree != null && !tree.isRooted()) {
                bl = true;
                tree = null;
                JOptionPane.showMessageDialog(this, "Species tree is not rooted.", "Species tree not loaded", 0);
            }
            if (!bl && tree != null && !tree.isCompletelyBinary()) {
                bl = true;
                tree = null;
                JOptionPane.showMessageDialog(this, "Species tree is not completely binary.", "Species tree not loaded", 0);
            }
            if (!bl && tree != null) {
                TreeHelper.cleanSpeciesNamesInExtNodes(tree);
                String string = "";
                Vector vector = tree.getRoot().getAllExternalChildren();
                Vector<String> vector2 = new Vector<String>();
                int n2 = 0;
                while (n2 < vector.size()) {
                    string = ((Node)vector.elementAt(n2)).getSpecies();
                    if (string == null || string == "") {
                        bl = true;
                        tree = null;
                        JOptionPane.showMessageDialog(this, "Species tree contains empty species fields.", "Species tree not loaded", 0);
                        break;
                    }
                    vector2.addElement(string);
                    ++n2;
                }
                int n3 = 0;
                while (n3 < vector2.size()) {
                    string = (String)vector2.elementAt(n3);
                    if (vector2.indexOf(string) != vector2.lastIndexOf(string)) {
                        bl = true;
                        tree = null;
                        JOptionPane.showMessageDialog(this, "Species tree contains duplicate species.", "Species tree not loaded", 0);
                        break;
                    }
                    ++n3;
                }
            }
            if (!bl && tree != null) {
                this.species_tree_ = tree;
                JOptionPane.showMessageDialog(this, "Species tree successfully loaded.", "SDI", 1);
            }
            this.contentpane.repaint();
        }
    }

    private void openURL() {
        URL uRL = null;
        Tree tree = null;
        String string = "Please enter a complete URL";
        String string2 = JOptionPane.showInputDialog(this, string, "Open URL to read a NH/NHX tree", 3);
        if (string2 != null && string2.length() > 4) {
            try {
                uRL = new URL(string2);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "TreeJAppletJFrame: openURL(): Exception: " + exception, "Malformed URL", 0);
            }
            if (uRL != null) {
                try {
                    tree = TreeHelper.readNHtree(uRL);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, "TreeJAppletJFrame: openURL(): \nException: " + exception, "Could not read Tree", 0);
                }
                if (tree != null && !tree.isEmpty()) {
                    this.reload_tree_ = tree.copyTree();
                    this.removeatvtextframe();
                    this.atvpanel.terminate();
                    this.contentpane.removeAll();
                    this.atvpanel = new ATVpanel(tree);
                    this.contentpane.add((Component)this.atvpanel, "Center");
                    ((Component)this).setVisible(true);
                    this.contentpane.repaint();
                    this.setTitle("ATV: " + uRL);
                    this.treefile = null;
                    this.atvpanel.getATVgraphic().setParametersForPainting(this.atvpanel.getATVgraphic().getWidth(), this.atvpanel.getATVgraphic().getHeight());
                }
            }
            this.contentpane.repaint();
        }
    }

    private void printTree() {
        if (this.atvpanel.getATVgraphic().getTree() == null || this.atvpanel.getATVgraphic().getTree().isEmpty()) {
            return;
        }
        ATVprinter aTVprinter = null;
        this.atvpanel.getATVgraphic().setParametersForPainting(580 * this.x_slider.getValue() / 100, 700 * this.y_slider.getValue() / 100);
        aTVprinter = this.treefile != null ? new ATVprinter(this.atvpanel.getATVgraphic(), this.treefile.toString(), this.print_in_color.isSelected()) : new ATVprinter(this.atvpanel.getATVgraphic(), "ATVprinter", this.print_in_color.isSelected());
        this.atvpanel.getATVgraphic().setParametersForPainting(this.atvpanel.getATVgraphic().getWidth(), this.atvpanel.getATVgraphic().getHeight());
        this.contentpane.repaint();
    }

    private void reLoad() {
        if (this.reload_tree_ != null && !this.reload_tree_.isEmpty()) {
            Tree tree = this.reload_tree_.copyTree();
            this.removeatvtextframe();
            this.atvpanel.terminate();
            this.contentpane.removeAll();
            this.atvpanel = new ATVpanel(tree);
            this.contentpane.add((Component)this.atvpanel, "Center");
            ((Component)this).setVisible(true);
            if (this.treefile != null) {
                this.setTitle("ATV: " + this.treefile);
            } else {
                this.setTitle("ATV");
            }
            this.atvpanel.getATVgraphic().setParametersForPainting(this.atvpanel.getATVgraphic().getWidth(), this.atvpanel.getATVgraphic().getHeight());
            this.atvpanel.getATVcontrol().showWhole();
            this.contentpane.repaint();
        }
    }

    private void removeRoot() {
        this.atvpanel.getATVgraphic().removeRoot();
    }

    private void removeRootTri() {
        this.atvpanel.getATVgraphic().removeRootTri();
    }

    private void removeatvtextframe() {
        if (this.atvtextframe != null) {
            this.atvtextframe.close();
            this.atvtextframe = null;
        }
    }

    private void rootMinDupsHeight() {
        if (!this.isOKforSDI()) {
            return;
        }
        Tree tree = this.atvpanel.getATVgraphic().getTree().copyTree();
        SDIunrooted sDIunrooted = new SDIunrooted();
        tree.setAllNodesToNotCollapse();
        tree.adjustNodeCount(false);
        tree.recalculateAndReset();
        TreeHelper.extractSpeciesNameFromSeqName(tree);
        SDI.stripTree(this.species_tree_, tree);
        if (!this.GAndSDoHaveMoreThanOneSpeciesInComman(tree)) {
            return;
        }
        try {
            tree = sDIunrooted.infer(tree, this.species_tree_, false, true, true, true, 1)[0];
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "Exception during SDI", 0);
            return;
        }
        int n = sDIunrooted.getMinimalDuplications();
        String string = this.getTitle();
        if (string.indexOf(" [") > -1) {
            string = string.substring(0, string.indexOf(" ["));
        }
        if (n >= 0) {
            string = String.valueOf(string) + " [" + n + " duplications]";
        }
        this.setTitle(string);
        this.atvpanel.getATVgraphic().setTree(tree);
        this.showWhole();
        this.contentpane.repaint();
    }

    private void rootMinHeight() {
        if (!this.isOKforSDI()) {
            return;
        }
        Tree tree = this.atvpanel.getATVgraphic().getTree().copyTree();
        SDIunrooted sDIunrooted = new SDIunrooted();
        tree.setAllNodesToNotCollapse();
        tree.adjustNodeCount(false);
        tree.recalculateAndReset();
        TreeHelper.extractSpeciesNameFromSeqName(tree);
        SDI.stripTree(this.species_tree_, tree);
        if (!this.GAndSDoHaveMoreThanOneSpeciesInComman(tree)) {
            return;
        }
        try {
            tree = sDIunrooted.infer(tree, this.species_tree_, false, false, true, true, 1)[0];
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "Exception during SDI", 0);
            return;
        }
        int n = sDIunrooted.getMinimalDuplications();
        String string = this.getTitle();
        if (string.indexOf(" [") > -1) {
            string = string.substring(0, string.indexOf(" ["));
        }
        if (n >= 0) {
            string = String.valueOf(string) + " [" + n + " duplications]";
        }
        this.setTitle(string);
        this.atvpanel.getATVgraphic().setTree(tree);
        this.showWhole();
        this.contentpane.repaint();
    }

    private void rootMinLHeight() {
        if (!this.isOKforSDI()) {
            return;
        }
        Tree tree = this.atvpanel.getATVgraphic().getTree().copyTree();
        SDIunrooted sDIunrooted = new SDIunrooted();
        tree.setAllNodesToNotCollapse();
        tree.adjustNodeCount(false);
        tree.recalculateAndReset();
        TreeHelper.extractSpeciesNameFromSeqName(tree);
        SDI.stripTree(this.species_tree_, tree);
        if (!this.GAndSDoHaveMoreThanOneSpeciesInComman(tree)) {
            return;
        }
        try {
            tree = sDIunrooted.infer(tree, this.species_tree_, true, false, true, true, 1)[0];
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "Exception during SDI", 0);
            return;
        }
        int n = sDIunrooted.getMinimalDuplications();
        int n2 = sDIunrooted.getMinimalMappingCost();
        String string = this.getTitle();
        if (string.indexOf(" [") > -1) {
            string = string.substring(0, string.indexOf(" ["));
        }
        if (n >= 0 && n2 >= 0) {
            string = String.valueOf(string) + " [" + n + " duplications  L=" + n2 + "]";
        }
        this.setTitle(string);
        this.atvpanel.getATVgraphic().setTree(tree);
        this.showWhole();
        this.contentpane.repaint();
    }

    void save(Tree tree) {
        int n;
        if (this.treefile == null) {
            if (tree != null) {
                this.saveAs(tree);
            }
            return;
        }
        if (this.treefile.exists() && (n = JOptionPane.showConfirmDialog(this, String.valueOf(String.valueOf(this.treefile)) + " already exists. Overwrite?", "File|Save", 2, 2)) != 0) {
            return;
        }
        try {
            TreeHelper.writeNHtree(tree, this.treefile, true, true, true);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Exception: " + exception, "Error during File|Save", 0);
        }
    }

    void saveAs(Tree tree) {
        if (tree == null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = this.saveas_jfilechooser.showSaveDialog(this.contentpane);
        File file = this.saveas_jfilechooser.getSelectedFile();
        if (file != null && n == 0) {
            if (file.exists()) {
                int n2 = JOptionPane.showConfirmDialog(this, String.valueOf(String.valueOf(file)) + " already exists. Overwrite?", "File|SaveAs", 2, 2);
                if (n2 == 0) {
                    bl2 = true;
                    bl = true;
                } else {
                    return;
                }
            }
            if (this.saveas_jfilechooser.getFileFilter() == nhfilter) {
                try {
                    TreeHelper.writeNHtree(tree, file, false, bl, bl2);
                }
                catch (Exception exception) {
                    bl3 = true;
                    this.exceptionOccuredDuringSaveAs(exception);
                }
            } else if (this.saveas_jfilechooser.getFileFilter() == nhxfilter) {
                try {
                    TreeHelper.writeNHtree(tree, file, true, bl, bl2);
                }
                catch (Exception exception) {
                    bl3 = true;
                    this.exceptionOccuredDuringSaveAs(exception);
                }
            } else if (file.getName().trim().toLowerCase().endsWith(".nh")) {
                try {
                    TreeHelper.writeNHtree(tree, file, false, bl, bl2);
                }
                catch (Exception exception) {
                    bl3 = true;
                    this.exceptionOccuredDuringSaveAs(exception);
                }
            } else {
                try {
                    TreeHelper.writeNHtree(tree, file, true, bl, bl2);
                }
                catch (Exception exception) {
                    bl3 = true;
                    this.exceptionOccuredDuringSaveAs(exception);
                }
            }
            if (!bl3) {
                this.treefile = file;
                this.setTitle("ATV: " + this.treefile);
            }
        }
    }

    public void setMaxOrtho(int n) {
        this.atvpanel.getATVgraphic().setMaxOrtho(n);
    }

    public void showWhole() {
        this.atvpanel.getATVcontrol().showWhole();
    }

    private void switchColors() {
        this.atvpanel.getATVgraphic().switchColors();
    }

    private void viewAsNH() {
        this.removeatvtextframe();
        if (this.atvpanel.getATVgraphic().getTree() == null) {
            return;
        }
        if (this.atvpanel.getATVgraphic().getTree().isEmpty()) {
            return;
        }
        this.atvtextframe = new ATVtextframe(this.atvpanel.getATVgraphic().getTree().toNewHampshire(false));
    }

    private void viewAsNHX() {
        this.removeatvtextframe();
        if (this.atvpanel.getATVgraphic().getTree() == null) {
            return;
        }
        if (this.atvpanel.getATVgraphic().getTree().isEmpty()) {
            return;
        }
        this.atvtextframe = new ATVtextframe(this.atvpanel.getATVgraphic().getTree().toNewHampshireX());
    }
}

