/*
 * Decompiled with CFR 0.152.
 */
package forester.atv;

import forester.atv.ATVgraphic;
import forester.tree.Node;
import forester.tree.Tree;
import forester.tree.TreeHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.text.NumberFormat;

class ATVprinter
extends Frame {
    private Tree tree;
    private Node node;
    private Node n;
    private String title;
    private ATVgraphic ag;
    private static final boolean DRAW_NODES_AS_BOXES = false;
    private static final double FACTOR_TO_FILL_SHEET = 1.0;
    private static final int BOX_SIZE = 3;
    private static final int CIRCLE_SIZE = 6;
    private static final int MOVE = 30;
    private static final int TITLE = 60;
    private static final int HALF_BOX_SIZE = 1;
    private static final int HALF_CIRCLE_SIZE = 3;
    private int longest_ext_node_info = 0;
    private int y_current = 0;
    private int x1 = 0;
    private int y1 = 0;
    private int x2 = 0;
    private int y2 = 0;
    private int factor = 0;
    private int green = 0;
    private int red = 0;
    private int x = 0;
    private int ext_nodes_x = 0;
    private double x_current = 0.0;
    private double x2double = 0.0;
    private double x_correction_factor = 0.0;
    private double x_distance = 0.0;
    private double y_distance = 0.0;
    private double d = 0.0;
    private boolean done = false;
    private boolean color = false;
    private static Color ext_node_seq_name_color;
    private static Color int_node_seq_name_color;
    private static Color species_color;
    private static Color bootstrap_color;
    private static Color ec_color;
    private static Color dub_spec_color;
    private static Color lnL_color;
    private static Color branch_length_color;
    private static Color branch_color;
    private static Color box_color;
    private static Color duplication_box_color;
    private static Color background_color;
    private static Color seq_x_color;
    private static final Font small_font;
    private static final Font large_font;
    private static final Font small_italic_font;
    private static final Font large_italic_font;
    private final FontMetrics fm_small = this.getFontMetrics(small_font);
    private final FontMetrics fm_large = this.getFontMetrics(large_font);
    private final FontMetrics fm_small_italic = this.getFontMetrics(small_italic_font);
    private final FontMetrics fm_large_italic = this.getFontMetrics(large_italic_font);
    private final int small_maxDescent = this.fm_small.getMaxDescent();
    private final int small_maxAscent = this.fm_small.getMaxAscent() + 2;
    private NumberFormat lnL_nf = NumberFormat.getNumberInstance();
    private NumberFormat dist_nf = NumberFormat.getNumberInstance();

    static {
        small_font = new Font("Helvetica", 0, 5);
        large_font = new Font("Helvetica", 0, 6);
        small_italic_font = new Font("Helvetica", 2, 5);
        large_italic_font = new Font("Helvetica", 2, 6);
    }

    ATVprinter(ATVgraphic aTVgraphic, String string, boolean bl) {
        this.ag = aTVgraphic;
        this.tree = this.ag.getTree();
        this.title = string;
        this.color = bl;
        this.x_distance = this.ag.x_distance;
        this.y_distance = this.ag.y_distance;
        this.x_correction_factor = this.ag.getXcorrectionFactor();
        if (!this.color) {
            ext_node_seq_name_color = new Color(0, 0, 0);
            int_node_seq_name_color = new Color(0, 0, 0);
            species_color = new Color(0, 0, 0);
            bootstrap_color = new Color(0, 0, 0);
            ec_color = new Color(0, 0, 0);
            dub_spec_color = new Color(0, 0, 0);
            lnL_color = new Color(0, 0, 0);
            branch_length_color = new Color(0, 0, 0);
            branch_color = new Color(0, 0, 0);
            box_color = new Color(0, 0, 0);
            duplication_box_color = new Color(0, 0, 0);
            background_color = new Color(255, 255, 255);
            seq_x_color = new Color(0, 0, 0);
        } else {
            ext_node_seq_name_color = new Color(0, 0, 0);
            int_node_seq_name_color = new Color(255, 0, 0);
            species_color = new Color(40, 40, 40);
            bootstrap_color = new Color(0, 160, 0);
            ec_color = new Color(255, 100, 0);
            dub_spec_color = new Color(255, 0, 0);
            lnL_color = new Color(40, 40, 40);
            branch_length_color = new Color(70, 70, 0);
            branch_color = new Color(0, 0, 0);
            box_color = new Color(0, 0, 0);
            duplication_box_color = new Color(0, 0, 0);
            background_color = new Color(255, 255, 255);
            seq_x_color = new Color(0, 0, 255);
        }
        ((Component)this).setBackground(background_color);
        ((Component)this).setVisible(true);
        this.printTree();
        this.ag = null;
        this.tree = null;
        this.dispose();
    }

    private Color calculateColorForOrthologous(Node node) {
        int n = node.getOrthologous();
        if (n == -11) {
            return seq_x_color;
        }
        if (n > this.ag.getMaxOrtho()) {
            n = this.ag.getMaxOrtho();
        } else if (n < 0) {
            n = 0;
        }
        int n2 = n * 240 / this.ag.getMaxOrtho();
        return new Color(ext_node_seq_name_color.getRed(), n2, ext_node_seq_name_color.getBlue());
    }

    private Color calculateColorForSuperOrthologous(Node node) {
        int n = node.getSuperOrthologous();
        if (n == -11) {
            return seq_x_color;
        }
        if (n > this.ag.getMaxOrtho()) {
            n = this.ag.getMaxOrtho();
        } else if (n < 0) {
            n = 0;
        }
        int n2 = n * 255 / this.ag.getMaxOrtho();
        return new Color(n2, ext_node_seq_name_color.getGreen(), ext_node_seq_name_color.getBlue());
    }

    void drawCollapsedNode(int n, int n2, Graphics graphics, Node node) {
        int n3 = 0;
        graphics.setColor(branch_color);
        graphics.drawRect(n - 1 + 1, n2 - 1, 3, 3);
        graphics.setColor(background_color);
        graphics.fillRect(n - 1 + 2, n2 - 1 + 1, 1, 1);
        if (this.ag.speciesExtNodes() && !node.getSpecies().equals("")) {
            graphics.setFont(large_italic_font);
            graphics.setColor(species_color);
            if (this.ag.seqNameExtNodes() && !node.getSeqName().equals("")) {
                graphics.drawString(String.valueOf(node.getSpecies()) + ": ", n + 3 + 1, n2 + this.fm_large_italic.getAscent() / 2);
                n3 = this.fm_large_italic.stringWidth(String.valueOf(node.getSpecies()) + ": ");
            } else {
                graphics.drawString(node.getSpecies(), n + 3 + 1, n2 + this.fm_large_italic.getAscent() / 2);
            }
        }
        if (this.ag.seqNameExtNodes() && !node.getSeqName().equals("")) {
            graphics.setFont(large_font);
            graphics.setColor(int_node_seq_name_color);
            graphics.drawString(node.getSeqName(), n + 3 + 1 + n3, n2 + this.fm_large.getAscent() / 2);
        }
    }

    private void drawDuplicationNode(int n, int n2, Graphics graphics) {
        graphics.setColor(duplication_box_color);
        graphics.fillOval(n - 3, n2 - 3, 6, 6);
    }

    private void printTree() {
        PrintJob printJob;
        if (this.tree == null || this.tree.isEmpty()) {
            return;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit != null && (printJob = toolkit.getPrintJob(this, this.title, null)) != null) {
            Graphics graphics = printJob.getGraphics();
            if (graphics != null) {
                this.done = false;
                this.lnL_nf.setMaximumFractionDigits(6);
                this.lnL_nf.setMinimumFractionDigits(1);
                this.dist_nf.setMaximumFractionDigits(6);
                this.dist_nf.setMinimumFractionDigits(1);
                this.node = this.tree.getRoot();
                this.tree.setIndicatorsToZero();
                this.x_current = !this.tree.isRooted() ? 30.0 : (this.tree.getRoot().getDistanceToParent() > 0.0 && this.ag.useRealBranchLenghts() ? 30.0 + this.tree.getRoot().getDistanceToParent() * this.x_correction_factor : 30.0 + this.x_distance);
                graphics.setFont(large_font);
                graphics.drawString(this.title, 30, 30);
                this.y_current = TreeHelper.roundToInt(this.y_distance * (double)this.tree.getNumberOfExtNodes() + 60.0 + 15.0);
                this.ext_nodes_x = 30 + TreeHelper.roundToInt(this.x_distance * (double)this.tree.getNumberOfExtNodes());
                do {
                    if (!this.node.isPseudoNode()) {
                        if (this.ag.writeBranchLengthValues() && this.node.getIndicator() == 0 && this.node.getDistanceToParent() >= 0.0) {
                            graphics.setFont(small_font);
                            graphics.setColor(branch_length_color);
                            if (!this.node.isRoot()) {
                                graphics.drawString(this.dist_nf.format(this.node.getDistanceToParent()), this.node.getParent().getXcoord() + 3, this.y_current - this.small_maxDescent);
                            } else {
                                graphics.drawString(this.dist_nf.format(this.node.getDistanceToParent()), 3, this.y_current - this.small_maxDescent);
                            }
                        }
                        if (this.ag.writeLnLValues() && this.node.getIndicator() == 0 && this.node.isLnLonParentBranchAssigned()) {
                            graphics.setFont(small_font);
                            graphics.setColor(lnL_color);
                            if (!this.node.isRoot()) {
                                graphics.drawString(String.valueOf(this.lnL_nf.format(this.tree.getHighestLnL() - (double)this.node.getLnLonParentBranch())) + " (" + this.lnL_nf.format(this.node.getLnLonParentBranch()) + ")", this.node.getParent().getXcoord() + 3, this.y_current + this.small_maxAscent);
                            } else if (this.tree.getNumberOfExtNodes() >= 2) {
                                graphics.drawString(String.valueOf(this.lnL_nf.format(this.tree.getHighestLnL() - (double)this.node.getLnLonParentBranch())) + " (" + this.lnL_nf.format(this.node.getLnLonParentBranch()) + ")", 3, this.y_current + this.small_maxAscent);
                            } else {
                                graphics.drawString(" (" + this.lnL_nf.format(this.node.getLnLonParentBranch()) + ")", 3, this.y_current + this.small_maxAscent);
                            }
                        }
                        if (this.ag.writeBootstrapValues() && this.node.getIndicator() == 0 && this.node.getBootstrap() > 0 && this.tree.getNumberOfExtNodes() >= 2 && !this.node.collapse()) {
                            graphics.setFont(small_font);
                            graphics.setColor(bootstrap_color);
                            graphics.drawString(Integer.toString(this.node.getBootstrap()), TreeHelper.roundToInt(this.x_current) - this.fm_small.stringWidth(Integer.toString(this.node.getBootstrap())) - 1 - 1, this.y_current + this.small_maxAscent);
                        }
                    }
                    if (this.node.isRoot() && this.tree.isRooted() && this.node.getIndicator() == 0) {
                        this.x1 = TreeHelper.roundToInt(this.x_current);
                        if (!this.ag.colorBranchesAccToLnL() || !this.node.isLnLonParentBranchAssigned()) {
                            graphics.setColor(branch_color);
                        } else {
                            this.green = (int)(((double)this.node.getLnLonParentBranch() - this.tree.getLowestLnL()) * 254.0 / Math.abs(this.tree.getHighestLnL() - this.tree.getLowestLnL()));
                            this.red = 255 - this.green;
                            graphics.setColor(new Color(this.red, this.green, 0));
                        }
                        if (this.ag.useRealBranchLenghts() && this.tree.getRoot().getDistanceToParent() > 0.0) {
                            this.d = this.x_correction_factor * this.tree.getRoot().getDistanceToParent();
                            graphics.drawLine(this.x1, this.y_current, this.x1 - TreeHelper.roundToInt(this.d), this.y_current);
                        } else {
                            graphics.drawLine(this.x1, this.y_current, this.x1 - TreeHelper.roundToInt(this.x_distance), this.y_current);
                            if (this.ag.colorBranchesAccToLnL() && !this.node.significantlyWorse()) {
                                graphics.drawLine(this.x1, this.y_current - 1, this.x1 - TreeHelper.roundToInt(this.x_distance), this.y_current - 1);
                                graphics.drawLine(this.x1, this.y_current + 1, this.x1 - TreeHelper.roundToInt(this.x_distance), this.y_current + 1);
                            }
                        }
                        if (!this.node.collapse()) {
                            if (!this.ag.writeDupSpec() && this.node.isDuplicationOrSpecAssigned() && this.node.isDuplication()) {
                                this.drawDuplicationNode(TreeHelper.roundToInt(this.x_current), this.y_current, graphics);
                            }
                        } else {
                            this.drawCollapsedNode(TreeHelper.roundToInt(this.x_current), this.y_current, graphics, this.node);
                        }
                    }
                    if (this.node.getIndicator() == 0 && !this.node.isExternal()) {
                        this.node.setIndicator(1);
                        this.factor = this.node.getSumExtNodes() - this.node.getChild1().getSumExtNodes();
                        this.x1 = TreeHelper.roundToInt(this.x_current);
                        this.node.setXcoord(this.x1);
                        this.y1 = this.y_current;
                        this.node.setYcoord(this.y1);
                        this.y2 = this.y_current - TreeHelper.roundToInt(this.y_distance * (double)this.factor);
                        if (!this.node.isPseudoNode()) {
                            if (this.ag.speciesInternalNodes() && !this.node.collapse() && !this.node.getSpecies().equals("")) {
                                graphics.setFont(small_italic_font);
                                graphics.setColor(species_color);
                                graphics.drawString(this.node.getSpecies(), this.x1 + 3 + 1, this.y_current + this.fm_small_italic.getAscent() / 2);
                            }
                            if (this.ag.seqNameInternalNodes() && !this.node.getSeqName().equals("") && !this.node.collapse()) {
                                graphics.setColor(int_node_seq_name_color);
                                graphics.setFont(large_font);
                                graphics.drawString(this.node.getSeqName(), this.x1 - this.fm_large.stringWidth(this.node.getSeqName()) - 3 - 1, this.y_current - this.fm_large.getMaxDescent());
                            }
                            if (this.ag.ECInternalNodes() && !this.node.getECnumber().equals("") && !this.node.collapse()) {
                                graphics.setColor(ec_color);
                                graphics.setFont(large_font);
                                this.x = this.ag.seqNameInternalNodes() && !this.node.getSeqName().equals("") ? this.fm_large.stringWidth(String.valueOf(this.node.getSeqName()) + " ") : 0;
                                graphics.drawString(this.node.getECnumber(), this.x1 - this.x - this.fm_large.stringWidth(this.node.getECnumber()) - 4 - 1, this.y_current - this.fm_large.getMaxDescent());
                            }
                            if (this.ag.writeDupSpec() && this.node.isDuplicationOrSpecAssigned() && !this.node.collapse()) {
                                graphics.setColor(dub_spec_color);
                                graphics.setFont(large_font);
                                this.x = this.ag.speciesInternalNodes() ? this.fm_large.getMaxAscent() : 0;
                                if (this.node.isDuplication()) {
                                    graphics.drawString("D", this.x1 + 3 + 1, this.y_current + this.fm_large.getAscent() / 2 + this.x);
                                } else {
                                    graphics.drawString("S", this.x1 + 3 + 1, this.y_current + this.fm_large.getAscent() / 2 + this.x);
                                }
                            }
                        }
                        if (!this.node.collapse()) {
                            if (this.ag.useRealBranchLenghts()) {
                                this.d = this.node.getChild1().getDistanceToParent();
                                if (this.d < 0.0) {
                                    this.d = 0.0;
                                }
                                this.x2double = this.x_current + this.x_correction_factor * this.d;
                            } else {
                                this.x2double = this.node.getChild1().isExternal() || this.node.getChild1().collapse() ? (double)this.ext_nodes_x : (this.node.getChild1().isPseudoNode() ? this.x_current : this.x_current + this.x_distance * (double)this.factor);
                            }
                            if (!(this.ag.useRealBranchLenghts() || !this.node.isPseudoNode() || this.node.getChild1().isPseudoNode() || this.node.getChild1().isExternal() || this.node.getChild1().collapse())) {
                                this.n = this.node.getParent();
                                while (this.n.isPseudoNode()) {
                                    this.n = this.n.getParent();
                                }
                                this.x2double += (double)(this.n.getSumExtNodes() - this.node.getSumExtNodes()) * this.x_distance;
                            }
                            this.x2 = TreeHelper.roundToInt(this.x2double);
                            graphics.setColor(branch_color);
                            graphics.drawLine(this.x1, this.y1, this.x1, this.y2);
                            if (!this.ag.colorBranchesAccToLnL() || !this.node.getChild1().isLnLonParentBranchAssigned() || this.tree.getHighestLnL() == this.tree.getLowestLnL()) {
                                graphics.setColor(branch_color);
                                graphics.drawLine(this.x1, this.y2, this.x2, this.y2);
                            } else {
                                this.green = (int)(((double)this.node.getChild1().getLnLonParentBranch() - this.tree.getLowestLnL()) * 254.0 / Math.abs(this.tree.getHighestLnL() - this.tree.getLowestLnL()));
                                this.red = 255 - this.green;
                                graphics.setColor(new Color(this.red, this.green, 0));
                                graphics.drawLine(this.x1, this.y2, this.x2, this.y2);
                                if (!this.node.getChild1().significantlyWorse()) {
                                    graphics.drawLine(this.x1, this.y2 - 1, this.x2, this.y2 - 1);
                                    graphics.drawLine(this.x1, this.y2 + 1, this.x2, this.y2 + 1);
                                }
                            }
                            if (!this.node.getChild1().isPseudoNode()) {
                                if (!this.node.getChild1().collapse()) {
                                    if (!this.ag.writeDupSpec() && this.node.getChild1().isDuplicationOrSpecAssigned() && this.node.getChild1().isDuplication()) {
                                        this.drawDuplicationNode(this.x2, this.y2, graphics);
                                    }
                                } else {
                                    this.drawCollapsedNode(this.x2, this.y2, graphics, this.node.getChild1());
                                }
                            }
                            this.x_current = this.x2double;
                            this.y_current = this.y2;
                            this.node = this.node.getChild1();
                        }
                    }
                    if (this.node.getIndicator() == 1 && !this.node.isExternal()) {
                        this.node.setIndicator(2);
                        if (!this.node.collapse()) {
                            this.factor = this.node.getSumExtNodes() - this.node.getChild2().getSumExtNodes();
                            this.x1 = TreeHelper.roundToInt(this.x_current);
                            this.y1 = this.y_current;
                            this.y2 = this.y_current + TreeHelper.roundToInt(this.y_distance * (double)this.factor);
                            if (this.ag.useRealBranchLenghts()) {
                                this.d = this.node.getChild2().getDistanceToParent();
                                if (this.d < 0.0) {
                                    this.d = 0.0;
                                }
                                this.x2double = this.x_current + this.x_correction_factor * this.d;
                            } else {
                                this.x2double = this.node.getChild2().isExternal() || this.node.getChild2().collapse() ? (double)this.ext_nodes_x : (this.node.getChild2().isPseudoNode() ? this.x_current : this.x_current + this.x_distance * (double)this.factor);
                            }
                            if (!(this.ag.useRealBranchLenghts() || !this.node.isPseudoNode() || this.node.getChild2().isPseudoNode() || this.node.getChild2().isExternal() || this.node.getChild2().collapse())) {
                                this.n = this.node.getParent();
                                while (this.n.isPseudoNode()) {
                                    this.n = this.n.getParent();
                                }
                                this.x2double += (double)(this.n.getSumExtNodes() - this.node.getSumExtNodes()) * this.x_distance;
                            }
                            this.x2 = TreeHelper.roundToInt(this.x2double);
                            graphics.setColor(branch_color);
                            graphics.drawLine(this.x1, this.y1, this.x1, this.y2);
                            if (!this.ag.colorBranchesAccToLnL() || !this.node.getChild2().isLnLonParentBranchAssigned() || this.tree.getHighestLnL() == this.tree.getLowestLnL()) {
                                graphics.setColor(branch_color);
                                graphics.drawLine(this.x1, this.y2, this.x2, this.y2);
                            } else {
                                this.green = (int)(((double)this.node.getChild2().getLnLonParentBranch() - this.tree.getLowestLnL()) * 254.0 / Math.abs(this.tree.getHighestLnL() - this.tree.getLowestLnL()));
                                this.red = 255 - this.green;
                                graphics.setColor(new Color(this.red, this.green, 0));
                                graphics.drawLine(this.x1, this.y2, this.x2, this.y2);
                                if (!this.node.getChild2().significantlyWorse()) {
                                    graphics.drawLine(this.x1, this.y2 - 1, this.x2, this.y2 - 1);
                                    graphics.drawLine(this.x1, this.y2 + 1, this.x2, this.y2 + 1);
                                }
                            }
                            if (!this.node.getChild2().isPseudoNode()) {
                                if (!this.node.getChild2().collapse()) {
                                    if (!this.ag.writeDupSpec() && this.node.getChild2().isDuplicationOrSpecAssigned() && this.node.getChild2().isDuplication()) {
                                        this.drawDuplicationNode(this.x2, this.y2, graphics);
                                    }
                                } else {
                                    this.drawCollapsedNode(this.x2, this.y2, graphics, this.node.getChild2());
                                }
                            }
                            this.x_current = this.x2double;
                            this.y_current = this.y2;
                            this.node = this.node.getChild2();
                        }
                    }
                    if (this.node.isRoot()) {
                        this.done = true;
                    } else if (this.node.getIndicator() == 2 && !this.node.isExternal()) {
                        this.node = this.node.getParent();
                        this.x_current = this.node.getXcoord();
                        this.y_current = this.node.getYcoord();
                    }
                    if (!this.node.isExternal()) continue;
                    this.x1 = TreeHelper.roundToInt(this.x_current);
                    if (this.ag.speciesExtNodes() && !this.node.getSpecies().equals("")) {
                        graphics.setFont(large_italic_font);
                        if (this.ag.colorOrthologous() && this.node.getOrthologous() != 0) {
                            graphics.setColor(this.calculateColorForOrthologous(this.node));
                        } else if (this.ag.colorSuperOrthologous() && this.node.getSuperOrthologous() != 0) {
                            graphics.setColor(this.calculateColorForSuperOrthologous(this.node));
                        } else {
                            graphics.setColor(species_color);
                        }
                        graphics.drawString(String.valueOf(this.node.getSpecies()) + " ", this.x1 + 3 + 1, this.y_current + this.fm_large.getAscent() / 2);
                    }
                    if (this.ag.seqNameExtNodes() && !this.node.getSeqName().equals("")) {
                        graphics.setFont(large_font);
                        if (this.ag.colorOrthologous() && this.node.getOrthologous() != 0) {
                            graphics.setColor(this.calculateColorForOrthologous(this.node));
                        } else if (this.ag.colorSuperOrthologous() && this.node.getSuperOrthologous() != 0) {
                            graphics.setColor(this.calculateColorForSuperOrthologous(this.node));
                        } else {
                            graphics.setColor(ext_node_seq_name_color);
                        }
                        this.x = this.ag.speciesExtNodes() && !this.node.getSpecies().equals("") ? this.fm_large_italic.stringWidth(String.valueOf(this.node.getSpecies()) + " ") : 0;
                        graphics.drawString(this.node.getSeqName(), this.x1 + this.x + 3 + 1, this.y_current + this.fm_large.getAscent() / 2);
                    }
                    if (this.ag.ECExtNodes() && !this.node.getECnumber().equals("")) {
                        graphics.setFont(large_font);
                        graphics.setColor(ec_color);
                        this.x = this.ag.speciesExtNodes() && !this.node.getSpecies().equals("") ? this.fm_large_italic.stringWidth(String.valueOf(this.node.getSpecies()) + " ") : 0;
                        if (this.ag.seqNameExtNodes() && !this.node.getSeqName().equals("")) {
                            this.x += this.fm_large.stringWidth(String.valueOf(this.node.getSeqName()) + " ");
                        }
                        graphics.drawString(this.node.getECnumber(), this.x1 + this.x + 3 + 1, this.y_current + this.fm_large.getAscent() / 2);
                    }
                    if (this.ag.colorOrthologous() && this.node.getOrthologous() != 0 || this.ag.colorSuperOrthologous() && this.node.getSuperOrthologous() != 0) {
                        graphics.setColor(this.calculateColorForOrthologous(this.node));
                        graphics.setFont(large_font);
                        this.x = this.ag.speciesExtNodes() && !this.node.getSpecies().equals("") ? this.fm_large_italic.stringWidth(String.valueOf(this.node.getSpecies()) + " ") : 0;
                        if (this.ag.seqNameExtNodes() && !this.node.getSeqName().equals("")) {
                            this.x += this.fm_large.stringWidth(String.valueOf(this.node.getSeqName()) + " ");
                        }
                        if (this.ag.ECExtNodes() && !this.node.getECnumber().equals("")) {
                            this.x += this.fm_large.stringWidth(String.valueOf(this.node.getECnumber()) + " ");
                        }
                        if (this.ag.colorOrthologous()) {
                            graphics.setColor(this.calculateColorForOrthologous(this.node));
                            if (this.node.getOrthologous() == -11) {
                                graphics.drawString(" [ Q ]", this.x1 + this.x + 3 + 1, this.y_current + this.fm_large.getAscent() / 2);
                            } else {
                                graphics.drawString(" [ " + this.node.getOrthologous() + " ]", this.x1 + this.x + 3 + 1, this.y_current + this.fm_large.getAscent() / 2);
                            }
                        }
                        if (this.ag.colorSuperOrthologous()) {
                            graphics.setColor(this.calculateColorForSuperOrthologous(this.node));
                            if (this.node.getSuperOrthologous() == -11) {
                                graphics.drawString(" [ Q ]", this.x1 + this.x + 3 + 1, this.y_current + this.fm_large.getAscent() / 2);
                            } else {
                                graphics.drawString(" [ " + this.node.getSuperOrthologous() + " ]", this.x1 + this.x + 3 + 1, this.y_current + this.fm_large.getAscent() / 2);
                            }
                        }
                    }
                    if (this.ag.writeBranchLengthValues() && !this.node.isRoot() && this.node.getDistanceToParent() >= 0.0) {
                        graphics.setFont(small_font);
                        graphics.setColor(branch_length_color);
                        graphics.drawString(this.dist_nf.format(this.node.getDistanceToParent()), this.node.getParent().getXcoord() + 3, this.y_current - this.small_maxDescent);
                    }
                    if (this.ag.writeLnLValues() && !this.node.isRoot() && this.node.isLnLonParentBranchAssigned()) {
                        graphics.setFont(small_font);
                        graphics.setColor(lnL_color);
                        graphics.drawString(String.valueOf(this.lnL_nf.format(this.tree.getHighestLnL() - (double)this.node.getLnLonParentBranch())) + " (" + this.lnL_nf.format(this.node.getLnLonParentBranch()) + ")", this.node.getParent().getXcoord() + 3, this.y_current + this.small_maxAscent);
                    }
                    this.node.setXcoord(this.x1);
                    this.node.setYcoord(this.y_current);
                    if (this.node.getNextExtNode() == null) {
                        this.done = true;
                    }
                    if (this.node.isRoot()) continue;
                    this.node = this.node.getParent();
                    this.x_current = this.node.getXcoord();
                    this.y_current = this.node.getYcoord();
                } while (!this.done);
                this.tree.setIndicatorsToZero();
                graphics.dispose();
            }
            printJob.end();
        }
    }
}

