/*
 * Decompiled with CFR 0.152.
 */
package forester.tools;

import forester.atv.ATVjframe;
import forester.tools.SDI;
import forester.tools.SDIse;
import forester.tree.Branch;
import forester.tree.Node;
import forester.tree.Tree;
import forester.tree.TreeHelper;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Vector;

public class SDIunrooted {
    private static final int TREES_TO_RETURN = 5;
    private static final double ZERO_DIFF = 1.0E-10;
    private int count_ = -1;
    private int min_dup_ = Integer.MAX_VALUE;
    private int min_cost_ = Integer.MAX_VALUE;
    private double min_height_ = Double.MAX_VALUE;
    private double min_diff_ = Double.MAX_VALUE;
    private long time_sdi = -1L;

    private static void errorInCommandLine() {
        System.out.println("\nSDIunrooted: Error in command line.\n");
        System.out.println("Usage: \"SDIunrooted  [-options] <species tree file name> <gene tree file name>\"");
        System.out.println("\nOptions:");
        System.out.println(" -n input trees are in New Hampshire format instead of NHX -- or");
        System.out.println("    the gene tree is in NHX, but species information is");
        System.out.println("    only present in the form of SWISS-PROT sequence names");
        System.out.println(" -l to root by minimizing the mapping cost L (and also the sum of duplications)");
        System.out.println(" -d to root by minimizing the sum of duplications");
        System.out.println(" -h to root by minimizing tree height (can be used together with -l or -d)");
        System.out.println(" -x use fast infer, always minimizes sum of duplications|height");
        System.out.println("\nSpecies tree file");
        System.out.println(" In NHX format, with species names in species name fields; unless -n option");
        System.out.println(" is used.");
        System.out.println("\nGene tree file");
        System.out.println(" In NHX format, with species names in species name fields and sequence names");
        System.out.println(" in sequence name fields; unless -n option is used.");
        System.out.println("");
        System.exit(-1);
    }

    Tree fastInfer(Tree tree, Tree tree2) throws Exception {
        SDIse sDIse = null;
        Tree tree3 = null;
        Tree tree4 = null;
        Node node = null;
        Node node2 = null;
        Node node3 = null;
        Branch[] branchArray = null;
        boolean bl = false;
        double d = 0.0;
        double d2 = Double.MAX_VALUE;
        int n = 0;
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        if (tree.getNumberOfExtNodes() <= 1) {
            tree.setRooted(true);
            this.setMinimalDuplications(0);
            this.setMinimalTreeHeight(0.0);
            return tree.copyTree();
        }
        tree4 = tree2.copyTree();
        SDI.stripTree(tree, tree4);
        tree.reRootSkeleton(tree.getExtNode0());
        branchArray = this.getBranchesInOrder(tree);
        if (branchArray == null) {
            throw new Exception("fastInfer: Unexpected error: Failed to create array of branches.");
        }
        sDIse = new SDIse(tree, tree4);
        sDIse.infer(false);
        n = 0;
        while (n < branchArray.length) {
            node = tree.getRoot();
            node2 = node.getChild1();
            node3 = node.getChild2();
            bl = node.isDuplication();
            tree.reRootSkeleton(branchArray[n]);
            n2 = sDIse.updateM(bl, node2, node3);
            if (n2 <= n3) {
                d = this.moveRootOnBranchToMinHeight(tree)[0];
                if (n2 == n3) {
                    if (d < d2) {
                        d2 = d;
                        tree3 = tree.copyTree();
                    }
                } else {
                    d2 = d;
                    n3 = n2;
                    tree3 = tree.copyTree();
                }
            }
            ++n;
        }
        this.setMinimalDuplications(n3);
        this.setMinimalTreeHeight(d2);
        return tree3;
    }

    private Branch[] getBranchesInOrder(Tree tree) throws Exception {
        Node node = tree.getRoot();
        Branch[] branchArray = null;
        int n = 0;
        if (tree == null || tree.isEmpty() || tree.getNumberOfExtNodes() <= 1) {
            return null;
        }
        branchArray = node.getChild1().isExternal() || node.getChild2().isExternal() ? new Branch[3 * tree.getNumberOfExtNodes() - 5] : new Branch[3 * tree.getNumberOfExtNodes() - 6];
        if (tree.getNumberOfExtNodes() == 2) {
            branchArray[0] = new Branch(tree.getRoot().getChild1(), tree.getRoot().getChild2());
            return branchArray;
        }
        tree.setIndicatorsToZero();
        while (!node.isRoot() || node.getIndicator() != 2) {
            if (!node.isExternal() && node.getIndicator() != 2) {
                if (node.getIndicator() == 0) {
                    node.setIndicator(1);
                    node = node.getChild1();
                } else {
                    node.setIndicator(2);
                    node = node.getChild2();
                }
                if (!node.getParent().isRoot()) {
                    branchArray[n++] = new Branch(node, node.getParent());
                    continue;
                }
                branchArray[n++] = new Branch(tree.getRoot().getChild1(), tree.getRoot().getChild2());
                continue;
            }
            if (!node.getParent().isRoot() && !node.isExternal()) {
                branchArray[n++] = new Branch(node, node.getParent());
            }
            node = node.getParent();
        }
        return branchArray;
    }

    public int getCount() {
        return this.count_;
    }

    public double getMinimalDiffInSubTreeHeights() {
        return this.min_diff_;
    }

    public int getMinimalDuplications() {
        return this.min_dup_;
    }

    public int getMinimalMappingCost() {
        return this.min_cost_;
    }

    public double getMinimalTreeHeight() {
        return this.min_height_;
    }

    public long getTimeSumSDI() {
        return this.time_sdi;
    }

    public Tree[] infer(Tree tree, Tree tree2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n) throws Exception {
        SDIse sDIse = null;
        Vector<Tree> vector = new Vector<Tree>();
        Tree[] treeArray = null;
        Branch[] branchArray = null;
        Tree tree3 = null;
        Tree tree4 = null;
        Node node = null;
        Node node2 = null;
        Node node3 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MAX_VALUE;
        int n7 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = Double.MAX_VALUE;
        double d4 = 0.0;
        double[] dArray = new double[2];
        boolean bl5 = true;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        if (n < 1) {
            n = 1;
        }
        if (bl && bl2) {
            bl2 = false;
        }
        if (!(bl || bl2 || bl3)) {
            n = 1;
            bl5 = false;
        }
        if ((tree3 = tree.copyTree()).getNumberOfExtNodes() <= 1) {
            tree3.setRooted(true);
            this.setMinimalDuplications(0);
            this.setMinimalTreeHeight(0.0);
            treeArray = new Tree[]{tree3};
            return treeArray;
        }
        tree4 = tree2.copyTree();
        SDI.stripTree(tree3, tree4);
        if (bl5) {
            tree3.reRoot(tree3.getExtNode0());
            branchArray = this.getBranchesInOrder(tree3);
            if (branchArray == null) {
                throw new Exception("SDIunrooted: Infer: Unexpected error: Failed to create array of branches.");
            }
        } else {
            if (!tree3.isRooted()) {
                throw new Exception("\nSDIunrooted: Infer: Error: Gene tree must be rooted if no rooting is performed.\n");
            }
            branchArray = new Branch[1];
        }
        if (bl || bl2 || !bl5) {
            sDIse = new SDIse(tree3, tree4);
            n2 = sDIse.infer(false);
        }
        n7 = 0;
        while (n7 < branchArray.length) {
            if (bl5) {
                node = tree3.getRoot();
                node2 = node.getChild1();
                node3 = node.getChild2();
                bl8 = node.isDuplication();
                tree3.reRoot(branchArray[n7]);
            }
            if (bl || bl2) {
                n2 = sDIse.updateM(bl8, node2, node3);
            }
            if (bl) {
                n3 = sDIse.computeMappingCost();
                if (bl3 && (n3 == n6 || n3 < n6)) {
                    dArray = this.moveRootOnBranchToMinHeight(tree3);
                    d = dArray[0];
                    d2 = dArray[1];
                }
                if (n3 == n6) {
                    if (bl3) {
                        bl7 = false;
                        bl6 = false;
                        if (d < d3) {
                            d3 = d;
                            n4 = 1;
                            bl6 = true;
                        } else if (d == d3) {
                            ++n4;
                            bl7 = true;
                        }
                        if (Math.abs(d2) < d4) {
                            d4 = Math.abs(d2);
                        }
                    }
                    if (bl4) {
                        if (bl3) {
                            if (bl6) {
                                vector.removeAllElements();
                                vector.addElement(tree3.copyTree());
                            } else if (bl7 && vector.size() < n) {
                                vector.addElement(tree3.copyTree());
                            }
                        } else {
                            ++n4;
                            if (vector.size() < n) {
                                vector.addElement(tree3.copyTree());
                            }
                        }
                    } else if (!bl3) {
                        ++n4;
                    }
                } else if (n3 < n6) {
                    if (bl3) {
                        d3 = d;
                        d4 = Math.abs(d2);
                    }
                    if (bl4) {
                        vector.removeAllElements();
                        vector.addElement(tree3.copyTree());
                    }
                    n4 = 1;
                    n6 = n3;
                }
                if (n2 < n5) {
                    n5 = n2;
                }
            } else if (bl2) {
                if (bl3 && (n2 == n5 || n2 < n5)) {
                    dArray = this.moveRootOnBranchToMinHeight(tree3);
                    d = dArray[0];
                    d2 = dArray[1];
                }
                if (n2 == n5) {
                    if (bl3) {
                        bl7 = false;
                        bl6 = false;
                        if (d < d3) {
                            d3 = d;
                            n4 = 1;
                            bl6 = true;
                        } else if (d == d3) {
                            ++n4;
                            bl7 = true;
                        }
                        if (Math.abs(d2) < d4) {
                            d4 = Math.abs(d2);
                        }
                    }
                    if (bl4) {
                        if (bl3) {
                            if (bl6) {
                                vector.removeAllElements();
                                vector.addElement(tree3.copyTree());
                            } else if (bl7 && vector.size() < n) {
                                vector.addElement(tree3.copyTree());
                            }
                        } else {
                            ++n4;
                            if (vector.size() < n) {
                                vector.addElement(tree3.copyTree());
                            }
                        }
                    } else if (!bl3) {
                        ++n4;
                    }
                } else if (n2 < n5) {
                    if (bl3) {
                        d3 = d;
                        d4 = Math.abs(d2);
                    }
                    if (bl4) {
                        vector.removeAllElements();
                        vector.addElement(tree3.copyTree());
                    }
                    n4 = 1;
                    n5 = n2;
                }
            } else if (bl3) {
                dArray = this.moveRootOnBranchToMinHeight(tree3);
                d = dArray[0];
                d2 = dArray[1];
                if (Math.abs(d2) < 1.0E-10) {
                    sDIse = new SDIse(tree3, tree4);
                    n5 = sDIse.infer(false);
                    d3 = d;
                    d4 = Math.abs(d2);
                    n4 = 1;
                    if (!bl4) break;
                    vector.addElement(tree3.copyTree());
                    break;
                }
            } else {
                n5 = n2;
                if (bl4) {
                    vector.addElement(tree3.copyTree());
                }
            }
            ++n7;
        }
        if (bl4) {
            vector.trimToSize();
            treeArray = new Tree[vector.size()];
            int n8 = 0;
            while (n8 < vector.size()) {
                treeArray[n8] = (Tree)vector.elementAt(n8);
                treeArray[n8].adjustNodeCount(false);
                treeArray[n8].recalculateAndReset();
                ++n8;
            }
        }
        this.setCount(n4);
        this.setMinimalDuplications(n5);
        this.setMinimalMappingCost(n6);
        this.setMinimalTreeHeight(d3);
        this.setMinimalDiffInSubTreeHeights(Math.abs(d4));
        return treeArray;
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = 0;
        File file = null;
        File file2 = null;
        Tree tree = null;
        Tree tree2 = null;
        Tree[] treeArray = null;
        SDIunrooted sDIunrooted = new SDIunrooted();
        DecimalFormat decimalFormat = new DecimalFormat("0.0#####");
        decimalFormat.setDecimalSeparatorAlwaysShown(true);
        if (stringArray.length < 2 || stringArray.length > 3) {
            SDIunrooted.errorInCommandLine();
        }
        if (stringArray[0].startsWith("-")) {
            if (stringArray.length < 3) {
                SDIunrooted.errorInCommandLine();
            }
            if (stringArray[0].toLowerCase().indexOf("l") != -1) {
                bl = true;
            }
            if (stringArray[0].toLowerCase().indexOf("d") != -1) {
                bl2 = true;
            }
            if (stringArray[0].toLowerCase().indexOf("h") != -1) {
                bl3 = true;
            }
            if (stringArray[0].toLowerCase().indexOf("x") != -1) {
                bl5 = true;
            }
            if (stringArray[0].toLowerCase().indexOf("n") != -1) {
                bl4 = true;
            }
            file = new File(stringArray[1]);
            file2 = new File(stringArray[2]);
        } else {
            if (stringArray.length > 2) {
                SDIunrooted.errorInCommandLine();
            }
            file = new File(stringArray[0]);
            file2 = new File(stringArray[1]);
        }
        if (bl && bl2) {
            bl2 = false;
        }
        if (bl5) {
            bl2 = true;
            bl3 = true;
            bl = false;
        }
        try {
            tree = TreeHelper.readNHtree(file2);
        }
        catch (Exception exception) {
            System.err.println("\nFailed to read " + file2 + ". Terminating.\n");
            System.exit(-1);
        }
        try {
            tree2 = TreeHelper.readNHtree(file);
        }
        catch (Exception exception) {
            System.err.println("\nFailed to read " + file + ". Terminating.\n");
            System.exit(-1);
        }
        if (bl4) {
            TreeHelper.extractSpeciesNameFromSeqName(tree2);
            TreeHelper.extractSpeciesNameFromSeqName(tree);
        }
        TreeHelper.cleanSpeciesNamesInExtNodes(tree2);
        if (!(bl || bl2 || bl3)) {
            tree.setRooted(true);
        }
        n = SDI.stripTree(tree2, tree);
        System.out.println("\nRemoved " + n + " external nodes from gene tree.\n");
        try {
            if (bl5) {
                treeArray = new Tree[]{sDIunrooted.fastInfer(tree.copyTree(), tree2)};
                treeArray[0].adjustNodeCount(false);
            } else {
                treeArray = sDIunrooted.infer(tree, tree2, bl, bl2, bl3, true, 5);
            }
        }
        catch (Exception exception) {
            System.err.println("Unexpected error during calculation of duplications.");
            System.err.println("Stack trace: ");
            exception.printStackTrace();
            System.exit(-1);
        }
        System.out.println("");
        if (bl5) {
            System.out.println("Used fast infer.");
        }
        if (bl) {
            System.out.println("Rooted by minimizing mapping cost L.");
            if (bl3) {
                System.out.println("Selected tree(s) with minimal height out of resulting trees.");
            }
            System.out.println("Number differently rooted trees minimizing criterion  : " + sDIunrooted.getCount());
            System.out.println("Minimal cost                                          : " + sDIunrooted.getMinimalMappingCost());
            System.out.println("Minimal duplications                                  : " + sDIunrooted.getMinimalDuplications());
            if (bl3) {
                System.out.println("Tree height                                           : " + decimalFormat.format(sDIunrooted.getMinimalTreeHeight()));
                System.out.println("Difference in subtree heights                         : " + decimalFormat.format(sDIunrooted.getMinimalDiffInSubTreeHeights()));
            }
            System.out.println("");
        } else if (bl2) {
            System.out.println("Rooted by minimizing sum of duplications.");
            if (bl3) {
                System.out.println("Selected tree(s) with minimal height out of resulting trees.");
            }
            if (!bl5) {
                System.out.println("Number differently rooted trees minimizing criterion        : " + sDIunrooted.getCount());
            }
            System.out.println("Minimal duplications                                        : " + sDIunrooted.getMinimalDuplications());
            if (bl3) {
                System.out.println("Tree height                                                 : " + decimalFormat.format(sDIunrooted.getMinimalTreeHeight()));
                if (!bl5) {
                    System.out.println("Difference in subtree heights                               : " + decimalFormat.format(sDIunrooted.getMinimalDiffInSubTreeHeights()));
                }
            }
            System.out.println("");
        } else if (bl3) {
            System.out.println("Rooted by minimizing tree height (midpoint rooting).");
            System.out.println("Minimal tree height                  : " + decimalFormat.format(sDIunrooted.getMinimalTreeHeight()));
            System.out.println("Minimal difference in subtree heights: " + decimalFormat.format(sDIunrooted.getMinimalDiffInSubTreeHeights()));
            System.out.println("Duplications in midpoint rooted tree : " + sDIunrooted.getMinimalDuplications());
            System.out.println("");
        } else {
            System.out.println("No (re) rooting was performed.");
            System.out.println("Duplications in tree: " + sDIunrooted.getMinimalDuplications());
            System.out.println("");
        }
        ATVjframe[] aTVjframeArray = new ATVjframe[treeArray.length];
        int n2 = 0;
        while (n2 < treeArray.length) {
            aTVjframeArray[n2] = new ATVjframe(treeArray[n2]);
            aTVjframeArray[n2].setTitle("gene tree " + n2);
            aTVjframeArray[n2].showWhole();
            ++n2;
        }
        ATVjframe aTVjframe = new ATVjframe(tree);
        aTVjframe.setTitle("original gene tree");
        aTVjframe.showWhole();
    }

    private double[] moveRootOnBranchToMinHeight(Tree tree) throws Exception {
        Node node = tree.getRoot();
        Node node2 = node.getChild1();
        Node node3 = node.getChild2();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double[] dArray = new double[2];
        if (tree == null || tree.isEmpty() || tree.getNumberOfExtNodes() <= 1) {
            return null;
        }
        d = node2.getDistanceToParent();
        if (Math.abs(d - node3.getDistanceToParent()) > 1.0E-10) {
            throw new Exception("Unexpected error: Root is not in the mid point of its branch.");
        }
        d2 = tree.calculateRealHeight();
        d3 = tree.getRealHeight();
        if (d > 0.0) {
            if (2.0 * d > Math.abs(d2)) {
                node2.setDistanceToParent(d - d2 / 2.0);
                node3.setDistanceToParent(d + d2 / 2.0);
                dArray[0] = d3 - Math.abs(d2 / 2.0);
                dArray[1] = 0.0;
            } else {
                if (d2 > 0.0) {
                    node2.setDistanceToParent(0.0);
                    node3.setDistanceToParent(2.0 * d);
                    dArray[1] = d2 - 2.0 * d;
                } else {
                    node2.setDistanceToParent(2.0 * d);
                    node3.setDistanceToParent(0.0);
                    dArray[1] = d2 + 2.0 * d;
                }
                dArray[0] = d3 - d;
            }
        } else {
            dArray[0] = d3;
            dArray[1] = d2;
        }
        return dArray;
    }

    private void setCount(int n) {
        this.count_ = n;
    }

    private void setMinimalDiffInSubTreeHeights(double d) {
        this.min_diff_ = d;
    }

    private void setMinimalDuplications(int n) {
        this.min_dup_ = n;
    }

    private void setMinimalMappingCost(int n) {
        this.min_cost_ = n;
    }

    private void setMinimalTreeHeight(double d) {
        this.min_height_ = d;
    }
}

