/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.files;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.filechooser.FileFilter;
import org.biolegato.gdesupport.data.ColourMask;
import org.biolegato.main.BLMain;

public final class GDEColourMaskFile
extends FileFilter {
    private static final Color[] stdcolours = new Color[]{new Color(255, 0, 0), new Color(240, 180, 20), new Color(0, 0, 255), new Color(0, 0, 0), new Color(0, 200, 0), new Color(255, 0, 160), new Color(0, 160, 200), new Color(0, 127, 255), new Color(105, 139, 30), new Color(128, 0, 255), new Color(125, 158, 192), new Color(205, 205, 0), new Color(139, 10, 80), new Color(233, 116, 81), new Color(0, 180, 127), new Color(127, 230, 0)};

    public boolean accept(File f) {
        return true;
    }

    public String getDescription() {
        return "GDE colour mask file";
    }

    public static ColourMask readColourMaskFile(File file) throws IOException {
        int number = 1;
        int length = 0;
        String line = "";
        String name = file.getName();
        int colourNumber = 0;
        Color[] colours = null;
        BufferedReader reader = null;
        reader = new BufferedReader(new FileReader(file.getPath()));
        line = reader.readLine();
        if (line != null && line.toLowerCase().startsWith("name:")) {
            name = line.substring(5);
            line = reader.readLine();
        }
        if (line != null && line.toLowerCase().startsWith("length:")) {
            try {
                length = Integer.parseInt(line.substring(7));
                colours = new Color[length];
            }
            catch (Throwable nfe) {
                nfe.printStackTrace(System.err);
            }
            line = reader.readLine();
        } else {
            BLMain.error((String)"Invalid colour GDE mask file - missing \"length:\" field!", (String)"GDEColourMaskColourMask");
        }
        if (line != null && line.toLowerCase().startsWith("nodash:")) {
            BLMain.warning((String)"Biolegato does not support \"nodash:\" in GDE colour mask files", (String)"GDEColourMaskColourMask");
            line = reader.readLine();
        }
        if (line != null && line.toLowerCase().startsWith("start:")) {
            line = reader.readLine();
            for (number = 0; line != null && number < length; ++number) {
                block15: {
                    if (BLMain.testNumber((String)(line = line.trim()))) {
                        try {
                            colourNumber = Integer.parseInt(line);
                            if (colourNumber > 0 && colourNumber <= stdcolours.length) {
                                colours[number] = stdcolours[colourNumber - 1];
                                break block15;
                            }
                            BLMain.error((String)("Invalid colour #" + colourNumber), (String)"GDEColourMaskColourMask");
                        }
                        catch (NumberFormatException nfe) {
                            nfe.printStackTrace(System.err);
                            colourNumber = -1;
                        }
                    } else {
                        BLMain.error((String)("\"" + line + "\" is not a colour"), (String)"GDEColourMaskColourMask");
                    }
                }
                line = reader.readLine();
            }
            if (number < length) {
                Color[] temp = colours;
                colours = new Color[number];
                System.arraycopy(temp, 0, colours, 0, colours.length);
                BLMain.error((String)"Reached end of file before end of colour", (String)"GDEColourMaskColourMask");
            }
        } else {
            BLMain.error((String)"Missing GDE colour mask data!", (String)"GDEColourMaskColourMask");
        }
        return new ColourMask(ColourMask.MaskType.POSITION, name, colours);
    }

    public static int stringToInt(String s) {
        int i = 0;
        if (BLMain.testNumber((String)s)) {
            try {
                i = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return i;
    }
}

