/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.files;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import org.biolegato.gdesupport.data.Dataset;
import org.biolegato.gdesupport.data.Seq;
import org.biolegato.gdesupport.files.DataFormat;
import org.biolegato.main.BLMain;

public class GenBankFile2008
extends DataFormat {
    private static final String SPACE_FILL = "                                 ";
    public static final int AVG_SEQ_LENGTH = 2000;

    public void translateTo(Appendable result, Seq seq, int offset, int length) throws IOException {
        int sequencemax = offset + length;
        if (seq != null && offset >= 0 && length >= 0) {
            int digits;
            int sequenceLength;
            StringBuffer sequence = seq.getSequence();
            int n = sequenceLength = sequencemax > sequence.length() ? sequence.length() : sequencemax;
            if (seq.getOriginal() == null || offset != 0 || length != sequence.length()) {
                result.append("LOCUS       ");
                int namelength = seq.getName().length();
                if (namelength < 16) {
                    result.append(seq.getName()).append(SPACE_FILL, 0, 16 - namelength);
                } else {
                    result.append(seq.getName().substring(0, 16));
                }
                result.append(" ");
                digits = BLMain.numberDigits((int)length);
                if (digits < 9) {
                    result.append(SPACE_FILL, 0, 11 - digits);
                }
                result.append(Integer.toString(length));
                if (!Seq.Type.PROTEIN.equals((Object)seq.getType())) {
                    result.append(" bp ");
                    if (seq.getStrandedness() != null) {
                        result.append(GenBankFile2008.getGBStrandedness(seq.getStrandedness())).append("-");
                        result.append(!Seq.Type.RNA.equals((Object)seq.getType()) ? "DNA     " : "RNA     ");
                    } else {
                        result.append(!Seq.Type.RNA.equals((Object)seq.getType()) ? "DNA        " : "RNA        ");
                    }
                } else {
                    result.append(" aa            ");
                }
                result.append(!Seq.Topology.CIRCULAR.equals((Object)seq.getTopology()) ? "linear   " : "circular ");
                result.append("CON ");
                result.append(new SimpleDateFormat("dd-MMM-yyyy").format(new Date()).toUpperCase());
                result.append("\n");
                if (!"".equals(seq.getDescription())) {
                    result.append("DESCRIPTION ").append(seq.getDescription()).append("\n");
                }
            } else {
                result.append(seq.getOriginal());
            }
            result.append("ORIGIN");
            for (int count = offset; count < sequenceLength; count += 60) {
                digits = BLMain.numberDigits((int)(count + 1));
                result.append("\n");
                if (digits < 9) {
                    result.append(SPACE_FILL, 0, 9 - digits);
                }
                result.append(Integer.toString(count + 1));
                int spaceCount = count;
                int next = count + 10;
                while (spaceCount < count + 60 && spaceCount < sequenceLength) {
                    result.append(" ").append(sequence, spaceCount, sequenceLength < next ? sequenceLength : next);
                    spaceCount = next;
                    next += 10;
                }
            }
            result.append("\n//\n");
        }
    }

    public void translateFrom(Dataset datamodel, BufferedReader data) throws IOException {
        int length = 0;
        int y = datamodel.getSize();
        String line = "";
        String temp = "";
        Seq.Type type = Seq.Type.DNA;
        String name = "";
        Seq.Direction direction = Seq.Direction.FROM5TO3;
        Seq.Strandedness strandedness = Seq.Strandedness.SINGLE;
        Seq.Topology topology = Seq.Topology.LINEAR;
        StringBuilder original = new StringBuilder();
        while ((line = data.readLine()) != null) {
            if (line.length() >= 6 && "ORIGIN".equalsIgnoreCase(line.substring(0, 6))) {
                StringBuffer sequencebuffer = new StringBuffer(length > 0 ? length : 2000);
                while ((line = data.readLine()) != null && !"//".equals(line)) {
                    sequencebuffer.append(line.replaceAll("[\\d\\s]", ""));
                }
                datamodel.addSequence(y, new Seq(type, name, sequencebuffer, direction, topology, strandedness, original));
                ++y;
                type = Seq.Type.DNA;
                name = "";
                direction = Seq.Direction.FROM5TO3;
                strandedness = Seq.Strandedness.SINGLE;
                topology = Seq.Topology.LINEAR;
                original = new StringBuilder();
                continue;
            }
            original.append(line).append("\n");
            if (line.length() <= 5 || !"LOCUS".equalsIgnoreCase(line.substring(0, 5))) continue;
            StringTokenizer tokenz = new StringTokenizer(line.substring(6).trim());
            if (tokenz.hasMoreTokens()) {
                name = tokenz.nextToken();
            }
            if (tokenz.hasMoreTokens() && BLMain.testNumber((String)(temp = tokenz.nextToken()))) {
                try {
                    length = Integer.parseInt(temp);
                }
                catch (NumberFormatException nfe) {
                    BLMain.error((String)"Invalid sequence length", (String)"GenBank file parser");
                }
            }
            if (tokenz.hasMoreTokens()) {
                temp = tokenz.nextToken();
                if ("aa".equals(temp)) {
                    type = Seq.Type.PROTEIN;
                } else if ("bp".equals(temp) && tokenz.hasMoreTokens()) {
                    temp = tokenz.nextToken();
                    int dashindex = temp.indexOf(45);
                    if (dashindex >= 0) {
                        strandedness = GenBankFile2008.toStrandedness(temp.substring(0, dashindex));
                        type = GenBankFile2008.toType(temp.substring(dashindex + 1));
                    } else {
                        type = GenBankFile2008.toType(temp);
                    }
                }
            }
            if (!tokenz.hasMoreTokens()) continue;
            temp = tokenz.nextToken();
            if ("circular".equals(temp.toLowerCase())) {
                topology = Seq.Topology.CIRCULAR;
                continue;
            }
            topology = Seq.Topology.LINEAR;
        }
    }

    public boolean accept(File file) {
        return file.isDirectory() || file.getAbsolutePath().toLowerCase().endsWith(".gen") || file.getAbsolutePath().toLowerCase().endsWith(".gp") || file.getAbsolutePath().toLowerCase().endsWith(".gb");
    }

    public String getDescription() {
        return "GenBank file (*.gb,*.gp,*.gen)";
    }

    private static String getGBStrandedness(Seq.Strandedness value) {
        String result = "ss";
        switch (value) {
            case DOUBLE: {
                result = "ds";
                break;
            }
            case MIXED: {
                result = "ms";
            }
        }
        return result;
    }

    private static Seq.Strandedness toStrandedness(String test) {
        Seq.Strandedness result = Seq.Strandedness.MIXED;
        if ("ss".equalsIgnoreCase(test)) {
            result = Seq.Strandedness.SINGLE;
        } else if ("ds".equalsIgnoreCase(test)) {
            result = Seq.Strandedness.DOUBLE;
        }
        return result;
    }

    private static Seq.Type toType(String string) {
        Seq.Type result = Seq.Type.DNA;
        if (string.toLowerCase().contains("rna")) {
            result = Seq.Type.RNA;
        }
        return result;
    }

    public boolean isFormat(Reader test) {
        int check = 32;
        boolean result = false;
        try {
            while (check == 32 || check == 9 || check == 10 || check == 13) {
                test.mark(10);
                check = test.read();
            }
            if (!(check != 76 && check != 108 || (check = test.read()) != 79 && check != 111 || (check = test.read()) != 67 && check != 99 || (check = test.read()) != 85 && check != 117 || (check = test.read()) != 83 && check != 115)) {
                result = true;
            }
            test.reset();
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
        return result;
    }
}

