/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.image;

import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelGrabber;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;

public class TextureLoader {
    public static final int GENERATE_MIPMAP = 1;
    public static final int BY_REFERENCE = 2;
    public static final int Y_UP = 4;
    private Texture2D tex = null;
    private BufferedImage bufferedImage = null;
    private ImageComponent2D imageComponent = null;
    private ImageComponent2D[] scaledImageComponents = null;
    private BufferedImage[] scaledBufferedImages = null;
    private int textureFormat = 6;
    private int imageComponentFormat = 2;
    private int flags;
    private boolean byRef;
    private boolean yUp;

    public TextureLoader(Image image, int n, Component component) {
        this(image, new String("RGBA"), n, component);
    }

    public TextureLoader(Image image, Component component) {
        this(image, new String("RGBA"), 0, component);
    }

    public TextureLoader(Image image, String string, int n, Component component) {
        if (component == null) {
            component = new Container();
        }
        this.parseFormat(string);
        this.flags = n;
        this.bufferedImage = this.createBufferedImage(image, component);
        if ((n & 2) != 0) {
            this.byRef = true;
        }
        if ((n & 4) != 0) {
            this.yUp = true;
        }
    }

    public TextureLoader(Image image, String string, Component component) {
        this(image, string, 0, component);
    }

    public TextureLoader(BufferedImage bufferedImage) {
        this(bufferedImage, new String("RGBA"), 0);
    }

    public TextureLoader(BufferedImage bufferedImage, int n) {
        this(bufferedImage, new String("RGBA"), n);
    }

    public TextureLoader(BufferedImage bufferedImage, String string) {
        this(bufferedImage, string, 0);
    }

    public TextureLoader(BufferedImage bufferedImage, String string, int n) {
        this.parseFormat(string);
        this.flags = n;
        this.bufferedImage = bufferedImage;
        if ((n & 2) != 0) {
            this.byRef = true;
        }
        if ((n & 4) != 0) {
            this.yUp = true;
        }
    }

    public TextureLoader(String string, int n, Component component) {
        this(string, new String("RGBA"), n, component);
    }

    public TextureLoader(String string, Component component) {
        this(string, new String("RGBA"), 0, component);
    }

    public TextureLoader(String string, String string2, int n, Component component) {
        if (component == null) {
            component = new Container();
        }
        final Toolkit toolkit = Toolkit.getDefaultToolkit();
        final Image[] imageArray = new Image[1];
        final String string3 = string;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                imageArray[0] = toolkit.getImage(string3);
                return null;
            }
        });
        this.parseFormat(string2);
        this.flags = n;
        this.bufferedImage = this.createBufferedImage(imageArray[0], component);
        if ((n & 2) != 0) {
            this.byRef = true;
        }
        if ((n & 4) != 0) {
            this.yUp = true;
        }
    }

    public TextureLoader(String string, String string2, Component component) {
        this(string, string2, 0, component);
    }

    public TextureLoader(URL uRL, int n, Component component) {
        this(uRL, new String("RGBA"), n, component);
    }

    public TextureLoader(URL uRL, Component component) {
        this(uRL, new String("RGBA"), 0, component);
    }

    public TextureLoader(URL uRL, String string, int n, Component component) {
        if (component == null) {
            component = new Container();
        }
        final Toolkit toolkit = Toolkit.getDefaultToolkit();
        final Image[] imageArray = new Image[1];
        final URL uRL2 = uRL;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                imageArray[0] = toolkit.getImage(uRL2);
                return null;
            }
        });
        this.parseFormat(string);
        this.flags = n;
        this.bufferedImage = this.createBufferedImage(imageArray[0], component);
        if ((n & 2) != 0) {
            this.byRef = true;
        }
        if ((n & 4) != 0) {
            this.yUp = true;
        }
    }

    public TextureLoader(URL uRL, String string, Component component) {
        this(uRL, string, 0, component);
    }

    private int computeLog(int n) {
        int n2 = 0;
        if (n == 0) {
            return -1;
        }
        while (n != 1) {
            n >>= 1;
            ++n2;
        }
        return n2;
    }

    private BufferedImage createBufferedImage(Image image, Component component) {
        component.prepareImage(image, null);
        while (true) {
            int n;
            if (((n = component.checkImage(image, null)) & 0x40) != 0) {
                System.out.println("Error: in loading image");
                return null;
            }
            if ((n & 0x20) != 0) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        int n = image.getWidth(component);
        int n2 = image.getHeight(component);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {}
        return bufferedImage;
    }

    private int getClosestPowerOf2(int n) {
        if (n < 1) {
            return n;
        }
        int n2 = 1;
        while (n >= (n2 *= 2)) {
        }
        int n3 = n2 / 2;
        if (n2 - n > n - n3) {
            return n3;
        }
        return n2;
    }

    public ImageComponent2D getImage() {
        if (this.imageComponent == null) {
            this.imageComponent = new ImageComponent2D(this.imageComponentFormat, this.bufferedImage, this.byRef, this.yUp);
        }
        return this.imageComponent;
    }

    public ImageComponent2D getScaledImage(float f, float f2) {
        if (f == 1.0f && f2 == 1.0f) {
            return this.getImage();
        }
        return new ImageComponent2D(this.imageComponentFormat, this.getScaledImage(this.bufferedImage, f, f2), this.byRef, this.yUp);
    }

    public ImageComponent2D getScaledImage(int n, int n2) {
        if (this.bufferedImage.getWidth() == n && this.bufferedImage.getHeight() == n2) {
            return this.getImage();
        }
        return new ImageComponent2D(this.imageComponentFormat, this.getScaledImage(this.bufferedImage, n, n2), this.byRef, this.yUp);
    }

    private BufferedImage getScaledImage(BufferedImage bufferedImage, float f, float f2) {
        if (f == 1.0f && f2 == 1.0f) {
            return bufferedImage;
        }
        AffineTransform affineTransform = AffineTransform.getScaleInstance(f, f2);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
        BufferedImage bufferedImage2 = affineTransformOp.filter(bufferedImage, null);
        return bufferedImage2;
    }

    private BufferedImage getScaledImage(BufferedImage bufferedImage, int n, int n2) {
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        float f = (float)n / (float)n3;
        float f2 = (float)n2 / (float)n4;
        return this.getScaledImage(bufferedImage, f, f2);
    }

    public Texture getTexture() {
        if (this.tex == null) {
            int n = this.getClosestPowerOf2(this.bufferedImage.getWidth());
            int n2 = this.getClosestPowerOf2(this.bufferedImage.getHeight());
            if ((this.flags & 1) != 0) {
                BufferedImage bufferedImage = this.bufferedImage;
                int n3 = n;
                int n4 = n2;
                int n5 = Math.max(this.computeLog(n), this.computeLog(n2)) + 1;
                this.scaledImageComponents = new ImageComponent2D[n5];
                this.scaledBufferedImages = new BufferedImage[n5];
                this.tex = new Texture2D(2, this.textureFormat, n, n2);
                int n6 = 0;
                while (n6 < n5) {
                    this.scaledBufferedImages[n6] = this.getScaledImage(bufferedImage, n3, n4);
                    this.scaledImageComponents[n6] = new ImageComponent2D(this.imageComponentFormat, this.scaledBufferedImages[n6], this.byRef, this.yUp);
                    this.tex.setImage(n6, (ImageComponent)this.scaledImageComponents[n6]);
                    if (n3 > 1) {
                        n3 >>= 1;
                    }
                    if (n4 > 1) {
                        n4 >>= 1;
                    }
                    bufferedImage = this.scaledBufferedImages[n6];
                    ++n6;
                }
            } else {
                this.scaledImageComponents = new ImageComponent2D[1];
                this.scaledBufferedImages = new BufferedImage[1];
                this.scaledBufferedImages[0] = this.getScaledImage(this.bufferedImage, n, n2);
                this.scaledImageComponents[0] = new ImageComponent2D(this.imageComponentFormat, this.scaledBufferedImages[0], this.byRef, this.yUp);
                this.tex = new Texture2D(1, this.textureFormat, n, n2);
                this.tex.setImage(0, (ImageComponent)this.scaledImageComponents[0]);
            }
            this.tex.setMinFilter(3);
            this.tex.setMagFilter(3);
        }
        return this.tex;
    }

    private void parseFormat(String string) {
        if (string.equals("RGBA")) {
            this.imageComponentFormat = 2;
            this.textureFormat = 6;
        } else if (string.equals("RGBA4")) {
            this.imageComponentFormat = 6;
            this.textureFormat = 6;
        } else if (string.equals("RGB5_A1")) {
            this.imageComponentFormat = 4;
            this.textureFormat = 6;
        } else if (string.equals("RGB")) {
            this.imageComponentFormat = 1;
            this.textureFormat = 5;
        } else if (string.equals("RGB4")) {
            this.imageComponentFormat = 5;
            this.textureFormat = 5;
        } else if (string.equals("RGB5")) {
            this.imageComponentFormat = 3;
            this.textureFormat = 5;
        } else if (string.equals("R3_G3_B2")) {
            this.imageComponentFormat = 9;
            this.textureFormat = 5;
        } else if (string.equals("LUM8_ALPHA8")) {
            this.imageComponentFormat = 8;
            this.textureFormat = 4;
        } else if (string.equals("LUM4_ALPHA4")) {
            this.imageComponentFormat = 7;
            this.textureFormat = 4;
        } else if (string.equals("LUMINANCE")) {
            this.imageComponentFormat = 10;
            this.textureFormat = 2;
        } else if (string.equals("ALPHA")) {
            this.imageComponentFormat = 10;
            this.textureFormat = 3;
        }
    }
}

