/*
 * Decompiled with CFR 0.152.
 */
package ExpDesigner;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.Scrollable;

public class ScrollablePicture
extends JLabel
implements Scrollable,
MouseMotionListener {
    private int maxUnitIncrement = 1;
    private boolean missingPicture = false;
    private static int maxX = 0;
    private static int maxY = 14;

    public ScrollablePicture(ImageIcon i, int m) {
        super(i);
        if (i == null) {
            this.missingPicture = true;
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
            this.setBackground(Color.white);
        }
        this.maxUnitIncrement = m;
        this.setAutoscrolls(true);
        this.addMouseMotionListener(this);
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void changeMaxX(int newMax) {
        if (newMax > maxX) {
            maxX = newMax;
        }
    }

    public int getMaxX() {
        return maxX;
    }

    public int getMaxY() {
        return maxY;
    }

    public void changeMaxY(int newMax) {
        if (newMax > maxY) {
            maxY = newMax;
        }
    }

    public void resetMaximums() {
        maxX = 0;
        maxY = 14;
    }

    public void mouseDragged(MouseEvent e) {
        Rectangle r = new Rectangle(e.getX(), e.getY(), 1, 1);
        this.scrollRectToVisible(r);
    }

    public Dimension getPreferredSize() {
        if (this.missingPicture) {
            return new Dimension(maxX, maxY);
        }
        return super.getPreferredSize();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int currentPosition = 0;
        currentPosition = orientation == 0 ? visibleRect.x : visibleRect.y;
        if (direction < 0) {
            int newPosition = currentPosition - currentPosition / this.maxUnitIncrement * this.maxUnitIncrement;
            return newPosition == 0 ? this.maxUnitIncrement : newPosition;
        }
        return (currentPosition / this.maxUnitIncrement + 1) * this.maxUnitIncrement - currentPosition;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return visibleRect.width - this.maxUnitIncrement;
        }
        return visibleRect.height - this.maxUnitIncrement;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void setMaxUnitIncrement(int pixels) {
        this.maxUnitIncrement = pixels;
    }
}

