/*
 * Decompiled with CFR 0.152.
 */
package birchconfig;

import birchconfig.BirchProperties;
import birchconfig.BufferedTextOutputFile;
import birchconfig.mv;
import birchconfig.runCommand;
import birchconfig.screenMsg;
import java.util.Date;

public class install {
    static runCommand runner = new runCommand();

    public install() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static void progressMessage(BufferedTextOutputFile logfile, String S) {
        logfile.PW.println(S);
    }

    static boolean runNobirch(BufferedTextOutputFile logfile) {
        boolean OKAY = true;
        String MSG = "Temporarily removing BIRCH access for this account";
        logfile.PW.print("nobirch: " + MSG + ": ");
        screenMsg scr = new screenMsg();
        screenMsg.printSubHeading("nobirch", MSG);
        String COMMAND = "../admin/nobirch -Q";
        OKAY = runCommand.runCommand(COMMAND);
        if (OKAY) {
            logfile.PW.println("Succeeded");
        } else {
            logfile.PW.println("FAILED!");
        }
        return OKAY;
    }

    static boolean makeLinks(String BirchMasterCopy, BufferedTextOutputFile logfile) {
        boolean OKAY = true;
        String MSG = "Creating links to master copy of BIRCH";
        logfile.PW.print("Running makelinks.sh: " + MSG);
        screenMsg scr = new screenMsg();
        screenMsg.printSubHeading("makelinks.sh", MSG);
        OKAY = runCommand.runCommand("./makelinks.sh " + BirchMasterCopy);
        if (OKAY) {
            logfile.PW.println("Succeeded");
        } else {
            logfile.PW.println("FAILED!");
        }
        return OKAY;
    }

    static boolean makeLocal(String BIRCH, BufferedTextOutputFile logfile) {
        boolean OKAY = true;
        mv mover = new mv();
        String oldname = BIRCH + "/local-generic";
        String newname = BIRCH + "/local";
        String MSG = "Move " + oldname + " to " + newname;
        logfile.PW.print(MSG);
        screenMsg scr = new screenMsg();
        screenMsg.printSubHeading("", MSG);
        try {
            OKAY = mv.mv(oldname, newname);
        }
        catch (Exception e) {
            OKAY = false;
            logfile.PW.println(e);
        }
        if (OKAY) {
            logfile.PW.println("Succeeded");
        } else {
            logfile.PW.println("FAILED!");
        }
        return OKAY;
    }

    static boolean copyLocal(BufferedTextOutputFile logfile) {
        boolean OKAY = true;
        String MSG = "Copying new files from local-generic to local";
        logfile.PW.print(MSG);
        screenMsg scr = new screenMsg();
        screenMsg.printSubHeading("update-local.sh", MSG);
        OKAY = runCommand.runCommand("./update-local.sh ");
        if (OKAY) {
            logfile.PW.println("Succeeded");
        } else {
            logfile.PW.println("FAILED!");
        }
        return OKAY;
    }

    static boolean BirchHome(String BIRCH, BufferedTextOutputFile logfile) {
        boolean OKAY = true;
        String MSG = "Set BIRCH homedirectory to " + BIRCH + ": ";
        logfile.PW.print(MSG);
        screenMsg scr = new screenMsg();
        screenMsg.printSubHeading("birchhome.sh", MSG);
        OKAY = runCommand.runCommand("./birchhome.sh");
        if (OKAY) {
            logfile.PW.println("Succeeded");
        } else {
            logfile.PW.println("FAILED!");
        }
        return OKAY;
    }

    static boolean setPlatform(String platform, BufferedTextOutputFile logfile) {
        boolean OKAY = true;
        String MSG = "setplatform.sh: Set default platform to " + platform + ": ";
        logfile.PW.print(MSG);
        String COMMAND = "./setplatform.sh " + platform;
        screenMsg scr = new screenMsg();
        screenMsg.printSubHeading("setplatform.sh", MSG);
        OKAY = runCommand.runCommand(COMMAND);
        if (OKAY) {
            logfile.PW.println("Succeeded");
        } else {
            logfile.PW.println("FAILED!");
        }
        return OKAY;
    }

    static void makeParamFile(BirchProperties tempBP, BufferedTextOutputFile logfile) {
        BirchProperties BP = tempBP;
        BufferedTextOutputFile outfile = new BufferedTextOutputFile();
        String FN = BP.homedir + "/local/admin/newstr.param";
        if (outfile.WriteOkay(FN)) {
            logfile.PW.println("Create substitution strings for customdoc.py: ");
            try {
                String S = "~";
                outfile.PW.println(S);
                S = "file://" + BP.homedir + "/public_html";
                outfile.PW.println(S);
                BP.birchURL = S;
                S = "file://" + BP.homedir;
                outfile.PW.println(S);
                BP.birchHomeURL = S;
                S = BP.adminEmail;
                outfile.PW.println(S);
                S = BP.homedir;
                outfile.PW.println(S);
                S = BP.adminUserid;
                outfile.PW.println(S);
                outfile.PW.flush();
                outfile.FW.close();
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    static boolean customDoc(BufferedTextOutputFile logfile) {
        boolean OKAY = true;
        String MSG = "birchconfig: Changing HMTL documentation to correspond to local directory structure: ";
        logfile.PW.print(MSG);
        screenMsg scr = new screenMsg();
        screenMsg.printSubHeading("customdoc.py", MSG);
        String COMMAND = "python ./customdoc.py oldstr.param newstr.param htmldir.param";
        OKAY = runCommand.runCommand(COMMAND);
        if (OKAY) {
            logfile.PW.println("Succeeded");
        } else {
            logfile.PW.println("FAILED!");
        }
        return OKAY;
    }

    static boolean htmlDoc(String BIRCH, BufferedTextOutputFile logfile) {
        boolean OKAY = true;
        String MSG = "Creating web pages that index documentation for all programs";
        logfile.PW.print("htmldoc.py: : " + MSG);
        screenMsg scr = new screenMsg();
        screenMsg.printSubHeading("htmldoc.py", MSG);
        String COMMAND = "python ./htmldoc.py";
        OKAY = runCommand.runCommand(COMMAND);
        if (OKAY) {
            logfile.PW.println("Succeeded");
        } else {
            logfile.PW.println("FAILED!");
        }
        return OKAY;
    }

    static boolean makemenus(String BIRCH, BufferedTextOutputFile logfile) {
        boolean OKAY = true;
        String MSG = "Creating GDE menus";
        logfile.PW.print("makemenus.py: " + MSG + ": ");
        screenMsg scr = new screenMsg();
        screenMsg.printSubHeading("makemenus.py", MSG);
        String COMMAND = "./runmakemenus.sh";
        OKAY = runCommand.runCommand(COMMAND);
        if (OKAY) {
            logfile.PW.println("Succeeded");
        } else {
            logfile.PW.println("FAILED!");
        }
        return OKAY;
    }

    static boolean makefasta(String BIRCH, BufferedTextOutputFile logfile) {
        boolean OKAY = true;
        String MSG = "Downloading and compiling fasta2 package";
        logfile.PW.print("installfasta2.sh: " + MSG + ": ");
        screenMsg scr = new screenMsg();
        screenMsg.printSubHeading("installfasta2.sh", MSG);
        String COMMAND = "./installfasta2.sh";
        OKAY = runCommand.runCommand(COMMAND);
        if (OKAY) {
            logfile.PW.println("Succeeded");
        } else {
            logfile.PW.println("FAILED!");
        }
        MSG = "Downloading and compiling fasta3 package";
        logfile.PW.print("installfasta3.sh: " + MSG + ": ");
        screenMsg.printSubHeading("installfasta3.sh", MSG);
        COMMAND = "./installfasta3.sh";
        OKAY = runCommand.runCommand(COMMAND);
        if (OKAY) {
            logfile.PW.println("Succeeded");
        } else {
            logfile.PW.println("FAILED!");
        }
        return OKAY;
    }

    static boolean runNewUser(BufferedTextOutputFile logfile) {
        boolean OKAY = true;
        String MSG = "Setting up your account to use BIRCH ";
        logfile.PW.print("newuser: " + MSG);
        screenMsg scr = new screenMsg();
        screenMsg.printSubHeading("newuser", MSG);
        String COMMAND = "../admin/newuser";
        OKAY = runCommand.runCommand(COMMAND);
        if (OKAY) {
            logfile.PW.println("Succeeded");
        } else {
            logfile.PW.println("FAILED!");
        }
        return OKAY;
    }

    public static boolean main(String[] args) {
        String userid;
        BufferedTextOutputFile logfile = new BufferedTextOutputFile();
        boolean OKAY = true;
        boolean newInstallation = false;
        BirchProperties BP = new BirchProperties();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-new")) {
                newInstallation = true;
                continue;
            }
            BP.loadProps(args[i]);
        }
        System.out.println("BirchProperties read. BIRCH home dir: " + BP.homedir);
        if (logfile.WriteOkay("../birchconfig.install.log")) {
            if (newInstallation) {
                install.progressMessage(logfile, "New BIRCH Installation");
            } else {
                install.progressMessage(logfile, "Updating BIRCH");
            }
            Date D = new Date();
            String TimeStamp = D.toString();
            install.progressMessage(logfile, TimeStamp);
            install.progressMessage(logfile, "");
        }
        if ((userid = System.getProperty("user.name")).equals("psgendb")) {
            install.progressMessage(logfile, "UPDATE ABORTED! - psgendb can't run install");
            System.out.println("UPDATE ABORTED! - psgendb can't run install");
        } else {
            if (!newInstallation) {
                install.runNobirch(logfile);
            }
            if (BP.minibirch.equals("true")) {
                install.makeLinks(BP.BirchMasterCopy, logfile);
            }
            OKAY = newInstallation ? install.makeLocal(BP.homedir, logfile) : install.copyLocal(logfile);
            if (OKAY && (OKAY = install.BirchHome(BP.homedir, logfile))) {
                if (newInstallation) {
                    OKAY = install.setPlatform(BP.platform, logfile);
                }
                if (OKAY) {
                    if (newInstallation) {
                        install.makeParamFile(BP, logfile);
                    }
                    if ((OKAY = install.customDoc(logfile)) && (OKAY = install.htmlDoc(BP.homedir, logfile)) && (OKAY = install.makemenus(BP.homedir, logfile)) && OKAY) {
                        OKAY = install.runNewUser(logfile);
                    }
                }
            }
        }
        logfile.PW.close();
        return OKAY;
    }

    private void jbInit() throws Exception {
    }
}

