/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codec;

import com.sun.media.jai.codec.JaiI18N;
import com.sun.media.jai.codec.SeekableStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileSeekableStream
extends SeekableStream {
    private RandomAccessFile file;
    private long markPos = -1L;
    private static final int PAGE_SHIFT = 9;
    private static final int PAGE_SIZE = 512;
    private static final int PAGE_MASK = 511;
    private static final int NUM_PAGES = 32;
    private static final int READ_CACHE_LIMIT = 512;
    private byte[][] pageBuf = new byte[512][32];
    private int[] currentPage = new int[32];
    private long length = 0L;
    private long pointer = 0L;

    public FileSeekableStream(File file) throws IOException {
        this(new RandomAccessFile(file, "r"));
    }

    public FileSeekableStream(RandomAccessFile randomAccessFile) throws IOException {
        this.file = randomAccessFile;
        randomAccessFile.seek(0L);
        this.length = randomAccessFile.length();
        int n = 0;
        while (n < 32) {
            this.pageBuf[n] = new byte[512];
            this.currentPage[n] = -1;
            ++n;
        }
    }

    public FileSeekableStream(String string) throws IOException {
        this(new RandomAccessFile(string, "r"));
    }

    public final boolean canSeekBackwards() {
        return true;
    }

    public final void close() throws IOException {
        this.file.close();
    }

    public final long getFilePointer() throws IOException {
        return this.pointer;
    }

    public final synchronized void mark(int n) {
        this.markPos = this.pointer;
    }

    public boolean markSupported() {
        return true;
    }

    public final int read() throws IOException {
        if (this.pointer >= this.length) {
            return -1;
        }
        byte[] byArray = this.readPage(this.pointer);
        return byArray[(int)(this.pointer++ & 0x1FFL)] & 0xFF;
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if ((n2 = (int)Math.min((long)n2, this.length - this.pointer)) <= 0) {
            return -1;
        }
        if (n2 > 512) {
            this.file.seek(this.pointer);
            int n3 = this.file.read(byArray, n, n2);
            this.pointer += (long)n3;
            return n3;
        }
        byte[] byArray2 = this.readPage(this.pointer);
        int n4 = 512 - (int)(this.pointer & 0x1FFL);
        int n5 = n2 < n4 ? n2 : n4;
        System.arraycopy(byArray2, (int)(this.pointer & 0x1FFL), byArray, n, n5);
        this.pointer += (long)n5;
        return n5;
    }

    private byte[] readPage(long l) throws IOException {
        int n = (int)(l >> 9);
        int n2 = 0;
        while (n2 < 32) {
            if (this.currentPage[n2] == n) {
                return this.pageBuf[n2];
            }
            ++n2;
        }
        int n3 = (int)(Math.random() * 32.0);
        this.currentPage[n3] = n;
        long l2 = n << 9;
        long l3 = this.length - l2;
        int n4 = l3 > 512L ? 512 : (int)l3;
        this.file.seek(l2);
        this.file.readFully(this.pageBuf[n3], 0, n4);
        return this.pageBuf[n3];
    }

    public final synchronized void reset() throws IOException {
        if (this.markPos != -1L) {
            this.pointer = this.markPos;
        }
    }

    public final void seek(long l) throws IOException {
        if (l < 0L) {
            throw new IOException(JaiI18N.getString("FileSeekableStream0"));
        }
        this.pointer = l;
    }

    public final int skip(int n) throws IOException {
        this.pointer += (long)n;
        return n;
    }
}

