/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.DataBufferProxy;
import com.sun.media.jai.rmi.SampleModelProxy;
import java.awt.Point;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class RasterProxy
implements Serializable {
    private transient Raster raster;

    public RasterProxy(Raster raster) {
        this.raster = raster;
    }

    public Raster getRaster() {
        return this.raster;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        SampleModelProxy sampleModelProxy = null;
        DataBufferProxy dataBufferProxy = null;
        Point point = null;
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        sampleModelProxy = (SampleModelProxy)objectInputStream.readObject();
        dataBufferProxy = (DataBufferProxy)objectInputStream.readObject();
        point = (Point)objectInputStream.readObject();
        SampleModel sampleModel = sampleModelProxy.getSampleModel();
        if (sampleModel == null) {
            this.raster = null;
            return;
        }
        DataBuffer dataBuffer = dataBufferProxy.getDataBuffer();
        this.raster = Raster.createRaster(sampleModel, dataBuffer, point);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Raster raster = this.raster.getParent();
        if (raster != null) {
            raster = raster.createCompatibleWritableRaster(this.raster.getBounds());
            ((WritableRaster)raster).setRect(this.raster);
        } else {
            raster = this.raster;
        }
        objectOutputStream.writeInt(raster.getWidth());
        objectOutputStream.writeInt(raster.getHeight());
        objectOutputStream.writeObject(new SampleModelProxy(raster.getSampleModel()));
        objectOutputStream.writeObject(new DataBufferProxy(raster.getDataBuffer()));
        objectOutputStream.writeObject(new Point(raster.getMinX(), raster.getMinY()));
    }
}

