/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.BranchGroupRetained;
import javax.media.j3d.ContainsNodes;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent2DRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.SceneGraphObjectRetained;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.Transform3D;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;

class BackgroundRetained
extends LeafRetained {
    static final int COLOR_CHANGED = 1;
    static final int IMAGE_CHANGED = 2;
    static final int GEOMETRY_CHANGED = 4;
    static final int BOUNDS_CHANGED = 8;
    static final int BOUNDINGLEAF_CHANGED = 16;
    Color3f color = new Color3f(0.0f, 0.0f, 0.0f);
    ImageComponent2DRetained image = null;
    Bounds applicationRegion = null;
    BoundingLeafRetained boundingLeaf = null;
    BranchGroup geometryBranch = null;
    Bounds transformedRegion = null;
    SetLiveState setLiveState = null;
    Locale cachedLocale = null;
    boolean inImmCtx = false;
    ArrayList lights = new ArrayList();
    ArrayList fogs = new ArrayList();
    ArrayList modelClips = new ArrayList();
    ArrayList bgGeometryAtomList = new ArrayList();
    boolean bgGeometryAtomListDirty = true;
    GeometryAtom[] bgGeometryAtoms = null;
    static final int targetThreads = 4224;

    BackgroundRetained() {
        this.nodeType = 1;
        this.localBounds = new BoundingBox();
        ((BoundingBox)this.localBounds).setLower(1.0, 1.0, 1.0);
        ((BoundingBox)this.localBounds).setUpper(-1.0, -1.0, -1.0);
    }

    void addBgGeometryAtomList(GeometryAtom geometryAtom) {
        this.bgGeometryAtomList.add(geometryAtom);
    }

    void clearGeometryBranch(BranchGroupRetained branchGroupRetained) {
        this.setLiveState.reset(this.locale);
        this.setLiveState.inBackgroundGroup = true;
        this.setLiveState.geometryBackground = this;
        branchGroupRetained.clearLive(this.setLiveState);
        branchGroupRetained.setParent(null);
        branchGroupRetained.setLocale(null);
    }

    void clearLive(SetLiveState setLiveState) {
        super.clearLive(setLiveState);
        setLiveState.nodeList.add(this);
        if (this.geometryBranch != null) {
            BranchGroupRetained branchGroupRetained = (BranchGroupRetained)this.geometryBranch.retained;
            this.clearGeometryBranch((BranchGroupRetained)this.geometryBranch.retained);
            setLiveState.nodeList.addAll(this.setLiveState.nodeList);
            setLiveState.notifyThreads |= this.setLiveState.notifyThreads;
            this.lights.clear();
            this.fogs.clear();
            this.modelClips.clear();
        }
        if (this.image != null) {
            this.image.freeSurface();
        }
        setLiveState.notifyThreads |= 0x1080;
    }

    BoundingLeaf getApplicationBoundingLeaf() {
        return this.boundingLeaf != null ? (BoundingLeaf)this.boundingLeaf.source : null;
    }

    final Bounds getApplicationBounds() {
        return this.applicationRegion != null ? (Bounds)this.applicationRegion.clone() : null;
    }

    GeometryAtom[] getBackgroundGeometryAtoms() {
        if (this.bgGeometryAtomListDirty) {
            int n = this.bgGeometryAtomList.size();
            if (n == 0) {
                this.bgGeometryAtoms = null;
            } else {
                this.bgGeometryAtoms = new GeometryAtom[n];
                int n2 = 0;
                while (n2 < this.bgGeometryAtoms.length) {
                    this.bgGeometryAtoms[n2] = (GeometryAtom)this.bgGeometryAtomList.get(n2);
                    ++n2;
                }
                this.bgGeometryAtomListDirty = false;
            }
        }
        return this.bgGeometryAtoms;
    }

    final void getColor(Color3f color3f) {
        color3f.set((Tuple3f)this.color);
    }

    final BranchGroup getGeometry() {
        return this.geometryBranch;
    }

    final ImageComponent2D getImage() {
        return this.image == null ? null : (ImageComponent2D)this.image.source;
    }

    boolean getInImmCtx() {
        return this.inImmCtx;
    }

    void initApplicationBoundingLeaf(BoundingLeaf boundingLeaf) {
        this.boundingLeaf = boundingLeaf != null ? (BoundingLeafRetained)boundingLeaf.retained : null;
    }

    final void initApplicationBounds(Bounds bounds) {
        this.applicationRegion = bounds != null ? (Bounds)bounds.clone() : null;
    }

    final void initColor(float f, float f2, float f3) {
        this.color.x = f;
        this.color.y = f2;
        this.color.z = f3;
    }

    final void initColor(Color3f color3f) {
        this.color.set((Tuple3f)color3f);
    }

    final void initGeometry(BranchGroup branchGroup) {
        this.geometryBranch = branchGroup;
    }

    final void initImage(ImageComponent2D imageComponent2D) {
        if (imageComponent2D != null) {
            ImageComponent2DRetained imageComponent2DRetained = (ImageComponent2DRetained)imageComponent2D.retained;
            imageComponent2DRetained.setRasterRef();
            this.image = imageComponent2DRetained;
        } else {
            this.image = null;
        }
    }

    void removeBgGeometryAtomList(GeometryAtom geometryAtom) {
        this.bgGeometryAtomList.remove(this.bgGeometryAtomList.indexOf(geometryAtom));
    }

    final void sendMessage(int n, Object object) {
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 4224;
        j3dMessage.universe = this.universe;
        j3dMessage.type = 20;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void setApplicationBoundingLeaf(BoundingLeaf boundingLeaf) {
        if (this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.removeUser(this);
        }
        if (boundingLeaf != null) {
            this.boundingLeaf = (BoundingLeafRetained)boundingLeaf.retained;
            this.boundingLeaf.mirrorBoundingLeaf.addUser(this);
        } else {
            this.boundingLeaf = null;
        }
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 4224;
        j3dMessage.type = 20;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(16);
        if (this.boundingLeaf != null) {
            j3dMessage.args[2] = this.boundingLeaf.mirrorBoundingLeaf;
            j3dMessage.args[3] = null;
        } else {
            j3dMessage.args[2] = null;
            j3dMessage.args[3] = this.applicationRegion != null ? this.applicationRegion.clone() : null;
        }
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    final void setApplicationBounds(Bounds bounds) {
        this.initApplicationBounds(bounds);
        if (this.boundingLeaf == null) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 4224;
            j3dMessage.type = 20;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(8);
            j3dMessage.args[2] = bounds != null ? bounds.clone() : null;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    final void setColor(float f, float f2, float f3) {
        this.setColor(new Color3f(f, f2, f3));
    }

    final void setColor(Color3f color3f) {
        this.initColor(color3f);
        this.sendMessage(1, new Color3f(color3f));
    }

    final void setGeometry(BranchGroup branchGroup) {
        int n = 0;
        if (this.source.isLive()) {
            if (this.geometryBranch != null) {
                ++n;
            }
            if (branchGroup != null) {
                ++n;
            }
            J3dMessage[] j3dMessageArray = new J3dMessage[n];
            int n2 = 0;
            while (n2 < n) {
                j3dMessageArray[n2] = VirtualUniverse.mc.getMessage();
                ++n2;
            }
            n2 = 0;
            if (this.geometryBranch != null) {
                this.clearGeometryBranch((BranchGroupRetained)this.geometryBranch.retained);
                j3dMessageArray[n2].threads = this.setLiveState.notifyThreads;
                j3dMessageArray[n2].type = 1;
                j3dMessageArray[n2].universe = this.universe;
                j3dMessageArray[n2].args[0] = this.setLiveState.nodeList.toArray();
                ++n2;
            }
            if (branchGroup != null) {
                this.setGeometryBranch((BranchGroupRetained)branchGroup.retained);
                j3dMessageArray[n2].threads = this.setLiveState.notifyThreads;
                j3dMessageArray[n2].type = 0;
                j3dMessageArray[n2].universe = this.universe;
                j3dMessageArray[n2].args[0] = this.setLiveState.nodeList.toArray();
            }
            VirtualUniverse.mc.processMessage(j3dMessageArray);
        }
        this.initGeometry(branchGroup);
    }

    void setGeometryBranch(BranchGroupRetained branchGroupRetained) {
        this.setLiveState.reset(this.locale);
        this.setLiveState.inBackgroundGroup = true;
        this.setLiveState.geometryBackground = this;
        this.setLiveState.currentTransforms[0] = new Transform3D();
        this.setLiveState.currentTransforms[0].setIdentity();
        this.setLiveState.lastTransforms[0] = new Transform3D();
        this.setLiveState.lastTransforms[0].setIdentity();
        this.setLiveState.parentTransformGroups[0] = new ArrayList();
        branchGroupRetained.setLive(this.setLiveState);
    }

    final void setImage(ImageComponent2D imageComponent2D) {
        this.initImage(imageComponent2D);
        this.sendMessage(2, this.image != null ? this.image.clone() : null);
    }

    void setInImmCtx(boolean bl) {
        this.inImmCtx = bl;
    }

    void setLive(SetLiveState setLiveState) {
        Object object;
        super.doSetLive(setLiveState);
        if (this.inImmCtx) {
            throw new IllegalSharingException(J3dI18N.getString("BackgroundRetained1"));
        }
        if (this.inBackgroundGroup) {
            throw new IllegalSharingException(J3dI18N.getString("BackgroundRetained5"));
        }
        if (this.geometryBranch != null) {
            object = (BranchGroupRetained)this.geometryBranch.retained;
            if (((SceneGraphObjectRetained)object).inBackgroundGroup) {
                throw new IllegalSharingException(J3dI18N.getString("BackgroundRetained0"));
            }
            if (((NodeRetained)object).parent != null) {
                throw new IllegalSharingException(J3dI18N.getString("BackgroundRetained3"));
            }
            if (((GroupRetained)object).locale != null) {
                throw new IllegalSharingException(J3dI18N.getString("BackgroundRetained4"));
            }
            if (this.setLiveState == null) {
                this.setLiveState = new SetLiveState(this.universe);
                this.setLiveState.universe = this.universe;
            }
            this.setGeometryBranch((BranchGroupRetained)this.geometryBranch.retained);
            setLiveState.nodeList.addAll(this.setLiveState.nodeList);
            setLiveState.notifyThreads |= this.setLiveState.notifyThreads;
        }
        setLiveState.nodeList.add(this);
        if (setLiveState.inSharedGroup) {
            int n = 0;
            while (n < setLiveState.keys.length) {
                if (setLiveState.switchLevels[n] >= 0) {
                    this.clearCompositeSwitchMask();
                    this.isNewSwitchLeaf = true;
                    object = setLiveState.containsNodesList.getContainsNodes(setLiveState.keys[n]);
                    ((ContainsNodes)object).envNodes.add(this);
                }
                ++n;
            }
        } else if (setLiveState.switchLevels[0] >= 0) {
            this.clearCompositeSwitchMask();
            this.isNewSwitchLeaf = true;
            object = setLiveState.containsNodesList.getContainsNodes(0);
            ((ContainsNodes)object).envNodes.add(this);
        }
        if (this.boundingLeaf != null) {
            this.transformedRegion = this.boundingLeaf.mirrorBoundingLeaf.transformedRegion;
        } else if (this.applicationRegion != null) {
            this.transformedRegion = (Bounds)this.applicationRegion.clone();
            this.transformedRegion.transform(this.applicationRegion, this.lastLocalToVworld[0]);
        } else {
            this.transformedRegion = null;
        }
        this.cachedLocale = setLiveState.locale;
        if (setLiveState.transformTargets != null) {
            if (!setLiveState.transformTargets.contains(this)) {
                setLiveState.transformTargets.add(this);
            }
            setLiveState.transformTargetThreads |= 0x1080;
        }
        setLiveState.notifyThreads |= 0x1080;
        super.markAsLive();
    }

    void updateBoundingLeaf() {
        if (this.boundingLeaf != null && this.boundingLeaf.mirrorBoundingLeaf.currentSwitchOn) {
            this.transformedRegion = this.boundingLeaf.mirrorBoundingLeaf.transformedRegion;
        } else if (this.applicationRegion != null) {
            this.transformedRegion = (Bounds)this.applicationRegion.clone();
            this.transformedRegion.transform(this.applicationRegion, this.currentLocalToVworld[0]);
        } else {
            this.transformedRegion = null;
        }
    }

    synchronized void updateImmediateMirrorObject(Object[] objectArray) {
        int n = (Integer)objectArray[1];
        if ((n & 8) != 0) {
            if (objectArray[2] != null) {
                this.transformedRegion = (Bounds)((Bounds)objectArray[2]).clone();
                this.transformedRegion.transform((Bounds)objectArray[2], this.currentLocalToVworld[0]);
            } else {
                this.transformedRegion = null;
            }
        } else if ((n & 0x10) != 0) {
            if (objectArray[2] != null) {
                this.transformedRegion = ((BoundingLeafRetained)objectArray[2]).transformedRegion;
            } else {
                Bounds bounds = (Bounds)objectArray[3];
                if (bounds != null) {
                    this.transformedRegion = (Bounds)bounds.clone();
                    this.transformedRegion.transform(bounds, this.currentLocalToVworld[0]);
                } else {
                    this.transformedRegion = null;
                }
            }
        }
    }

    void updateImmediateTransformChange() {
        if (this.boundingLeaf == null && this.applicationRegion != null) {
            this.transformedRegion = (Bounds)this.applicationRegion.clone();
            this.transformedRegion.transform(this.applicationRegion, this.currentLocalToVworld[0]);
        }
    }
}

