/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.AppearanceRetained;
import javax.media.j3d.BHLeafInterface;
import javax.media.j3d.BHLeafNode;
import javax.media.j3d.BHNode;
import javax.media.j3d.BHTree;
import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.BehaviorStructure;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dStructure;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.MRSWLock;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.PickShape;
import javax.media.j3d.UnorderList;
import javax.media.j3d.VirtualUniverse;
import javax.media.j3d.WakeupOnCollisionEntry;
import javax.media.j3d.WakeupOnCollisionExit;
import javax.media.j3d.WakeupOnCollisionMovement;
import javax.vecmath.Vector3d;

class GeometryStructure
extends J3dStructure {
    ArrayList transList = new ArrayList();
    ArrayList transMessageList = new ArrayList();
    private MRSWLock lock = null;
    private Object visLock = new Object();
    private Object collideListLock = new Object();
    private BHTree[] bhTreeArr = null;
    private int bhTreeCount = 0;
    private int bhTreeMax = 1;
    private int bhTreeBlockSize = 5;
    private BHNode[] bhNodeArr = null;
    private int bhNodeCount = 0;
    private int bhNodeMax;
    private int bhNodeBlockSize = 50;
    private Vector3d localeTrans = new Vector3d();
    UnorderList collideEntryList = new UnorderList(class$javax$media$j3d$WakeupOnCollisionEntry != null ? class$javax$media$j3d$WakeupOnCollisionEntry : (class$javax$media$j3d$WakeupOnCollisionEntry = GeometryStructure.class$("javax.media.j3d.WakeupOnCollisionEntry")));
    UnorderList collideExitList = new UnorderList(class$javax$media$j3d$WakeupOnCollisionExit != null ? class$javax$media$j3d$WakeupOnCollisionExit : (class$javax$media$j3d$WakeupOnCollisionExit = GeometryStructure.class$("javax.media.j3d.WakeupOnCollisionExit")));
    UnorderList collideMovementList = new UnorderList(class$javax$media$j3d$WakeupOnCollisionMovement != null ? class$javax$media$j3d$WakeupOnCollisionMovement : (class$javax$media$j3d$WakeupOnCollisionMovement = GeometryStructure.class$("javax.media.j3d.WakeupOnCollisionMovement")));
    UnorderList wakeupOnCollisionEntry = new UnorderList(class$javax$media$j3d$WakeupOnCollisionEntry != null ? class$javax$media$j3d$WakeupOnCollisionEntry : (class$javax$media$j3d$WakeupOnCollisionEntry = GeometryStructure.class$("javax.media.j3d.WakeupOnCollisionEntry")));
    UnorderList wakeupOnCollisionExit = new UnorderList(class$javax$media$j3d$WakeupOnCollisionExit != null ? class$javax$media$j3d$WakeupOnCollisionExit : (class$javax$media$j3d$WakeupOnCollisionExit = GeometryStructure.class$("javax.media.j3d.WakeupOnCollisionExit")));
    UnorderList wakeupOnCollisionMovement = new UnorderList(class$javax$media$j3d$WakeupOnCollisionMovement != null ? class$javax$media$j3d$WakeupOnCollisionMovement : (class$javax$media$j3d$WakeupOnCollisionMovement = GeometryStructure.class$("javax.media.j3d.WakeupOnCollisionMovement")));
    static /* synthetic */ Class class$javax$media$j3d$WakeupOnCollisionEntry;
    static /* synthetic */ Class class$javax$media$j3d$WakeupOnCollisionExit;
    static /* synthetic */ Class class$javax$media$j3d$WakeupOnCollisionMovement;
    static /* synthetic */ Class class$javax$media$j3d$BHNode;

    GeometryStructure(VirtualUniverse virtualUniverse) {
        super(virtualUniverse, 64);
        this.bhNodeMax = this.bhNodeBlockSize;
        this.bhNodeArr = new BHNode[this.bhNodeMax];
        this.bhTreeArr = new BHTree[this.bhTreeMax];
        this.lock = new MRSWLock();
    }

    private void addToBhNodeArr(BHNode bHNode) {
        if (this.bhNodeCount >= this.bhNodeMax) {
            this.bhNodeMax += this.bhNodeBlockSize;
            BHNode[] bHNodeArray = this.bhNodeArr;
            this.bhNodeArr = new BHNode[this.bhNodeMax];
            System.arraycopy(bHNodeArray, 0, this.bhNodeArr, 0, bHNodeArray.length);
        }
        this.bhNodeArr[this.bhNodeCount] = bHNode;
        ++this.bhNodeCount;
    }

    void addWakeupOnCollision(WakeupOnCollisionEntry wakeupOnCollisionEntry) {
        boolean bl = true;
        Object object = this.collideListLock;
        synchronized (object) {
            WakeupOnCollisionEntry[] wakeupOnCollisionEntryArray = (WakeupOnCollisionEntry[])this.collideEntryList.toArray();
            int n = this.collideEntryList.arraySize() - 1;
            while (n >= 0) {
                WakeupOnCollisionEntry wakeupOnCollisionEntry2 = wakeupOnCollisionEntryArray[n];
                if (wakeupOnCollisionEntry2.behav == wakeupOnCollisionEntry.behav && wakeupOnCollisionEntry2.geometryAtoms == wakeupOnCollisionEntry.geometryAtoms) {
                    this.collideEntryList.remove(n);
                    bl = false;
                    break;
                }
                --n;
            }
        }
        this.wakeupOnCollisionEntry.add(wakeupOnCollisionEntry);
        wakeupOnCollisionEntry.updateCollisionBounds();
        object = this.collide(wakeupOnCollisionEntry.behav.locale, wakeupOnCollisionEntry.accuracyMode, wakeupOnCollisionEntry.geometryAtoms, wakeupOnCollisionEntry.vwcBounds, wakeupOnCollisionEntry.boundingLeaf, wakeupOnCollisionEntry.armingNode);
        if (object != null) {
            this.collideEntryList.add(wakeupOnCollisionEntry);
            wakeupOnCollisionEntry.setTarget((BHLeafInterface)object);
        }
        if (object != null && bl) {
            wakeupOnCollisionEntry.setTriggered();
        }
    }

    void addWakeupOnCollision(WakeupOnCollisionExit wakeupOnCollisionExit) {
        WakeupOnCollisionEntry[] wakeupOnCollisionEntryArray;
        boolean bl = true;
        Object object = this.collideListLock;
        synchronized (object) {
            WakeupOnCollisionExit[] wakeupOnCollisionExitArray = (WakeupOnCollisionExit[])this.collideExitList.toArray();
            int n = this.collideExitList.arraySize() - 1;
            while (n >= 0) {
                wakeupOnCollisionEntryArray = wakeupOnCollisionExitArray[n];
                if (wakeupOnCollisionEntryArray.behav == wakeupOnCollisionExit.behav && wakeupOnCollisionEntryArray.geometryAtoms == wakeupOnCollisionExit.geometryAtoms) {
                    this.collideExitList.remove(n);
                    bl = false;
                    break;
                }
                --n;
            }
        }
        this.wakeupOnCollisionExit.add(wakeupOnCollisionExit);
        wakeupOnCollisionExit.updateCollisionBounds();
        object = this.collide(wakeupOnCollisionExit.behav.locale, wakeupOnCollisionExit.accuracyMode, wakeupOnCollisionExit.geometryAtoms, wakeupOnCollisionExit.vwcBounds, wakeupOnCollisionExit.boundingLeaf, wakeupOnCollisionExit.armingNode);
        if (object != null) {
            wakeupOnCollisionExit.setTarget((BHLeafInterface)object);
            this.collideExitList.add(wakeupOnCollisionExit);
        }
        if (!bl) {
            return;
        }
        Object object2 = this.collideListLock;
        synchronized (object2) {
            wakeupOnCollisionEntryArray = (WakeupOnCollisionEntry[])this.collideEntryList.toArray();
            int n = this.collideEntryList.arraySize() - 1;
            while (n >= 0) {
                WakeupOnCollisionEntry wakeupOnCollisionEntry = wakeupOnCollisionEntryArray[n];
                if (wakeupOnCollisionEntry.behav == wakeupOnCollisionExit.behav && wakeupOnCollisionEntry.geometryAtoms == wakeupOnCollisionExit.geometryAtoms) {
                    if (object != null) break;
                    wakeupOnCollisionExit.setTriggered();
                    break;
                }
                --n;
            }
        }
    }

    void addWakeupOnCollision(WakeupOnCollisionMovement wakeupOnCollisionMovement) {
        this.wakeupOnCollisionMovement.add(wakeupOnCollisionMovement);
        wakeupOnCollisionMovement.updateCollisionBounds();
        BHLeafInterface bHLeafInterface = this.collide(wakeupOnCollisionMovement.behav.locale, wakeupOnCollisionMovement.accuracyMode, wakeupOnCollisionMovement.geometryAtoms, wakeupOnCollisionMovement.vwcBounds, wakeupOnCollisionMovement.boundingLeaf, wakeupOnCollisionMovement.armingNode);
        if (bHLeafInterface != null) {
            wakeupOnCollisionMovement.setTarget(bHLeafInterface);
            this.collideMovementList.add(wakeupOnCollisionMovement);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void clearBhNodeArr() {
        this.bhNodeCount = 0;
    }

    BHLeafInterface collide(Locale locale, int n, GeometryAtom[] geometryAtomArray, Bounds bounds, BoundingLeafRetained boundingLeafRetained, NodeRetained nodeRetained) {
        block17: {
            this.lock.readLock();
            int n2 = this.getBHTreeIndex(locale);
            if (n2 < 0) {
                this.lock.readUnlock();
                return null;
            }
            if (geometryAtomArray != null) {
                BHTree bHTree = this.bhTreeArr[n2];
                synchronized (bHTree) {
                    int n3 = geometryAtomArray.length - 1;
                    while (n3 >= 0) {
                        BHLeafInterface bHLeafInterface = this.bhTreeArr[n2].selectAny(geometryAtomArray[n3], n);
                        if (bHLeafInterface != null) {
                            this.lock.readUnlock();
                            BHLeafInterface bHLeafInterface2 = bHLeafInterface;
                            Object var11_18 = null;
                            return bHLeafInterface2;
                        }
                        --n3;
                    }
                    break block17;
                }
            }
            if (bounds == null) {
                if (boundingLeafRetained == null) {
                    this.lock.readUnlock();
                    return null;
                }
                bounds = boundingLeafRetained.transformedRegion;
            }
            if (bounds == null) {
                this.lock.readUnlock();
                return null;
            }
            if (nodeRetained instanceof GroupRetained) {
                BHTree bHTree = this.bhTreeArr[n2];
                synchronized (bHTree) {
                    BHLeafInterface bHLeafInterface = this.bhTreeArr[n2].selectAny(bounds, n, (GroupRetained)nodeRetained);
                    this.lock.readUnlock();
                    BHLeafInterface bHLeafInterface3 = bHLeafInterface;
                    Object var11_19 = null;
                    return bHLeafInterface3;
                }
            }
            BHTree bHTree = this.bhTreeArr[n2];
            synchronized (bHTree) {
                BHLeafInterface bHLeafInterface = this.bhTreeArr[n2].selectAny(bounds, n, nodeRetained);
                this.lock.readUnlock();
                BHLeafInterface bHLeafInterface4 = bHLeafInterface;
                Object var11_20 = null;
                return bHLeafInterface4;
            }
        }
        this.lock.readUnlock();
        return null;
    }

    private int getBHTreeIndex(Locale locale) {
        int n = 0;
        while (n < this.bhTreeCount) {
            if (this.bhTreeArr[n].locale == locale) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private int getOrAddBHTreeIndex(Locale locale) {
        int n = 0;
        while (n < this.bhTreeCount) {
            if (this.bhTreeArr[n].locale == locale) {
                return n;
            }
            ++n;
        }
        if (this.bhTreeCount >= this.bhTreeMax) {
            this.bhTreeMax += this.bhTreeBlockSize;
            BHTree[] bHTreeArray = this.bhTreeArr;
            this.bhTreeArr = new BHTree[this.bhTreeMax];
            System.arraycopy(bHTreeArray, 0, this.bhTreeArr, 0, bHTreeArray.length);
        }
        this.bhTreeArr[this.bhTreeCount] = new BHTree(locale);
        ++this.bhTreeCount;
        return n;
    }

    GeometryAtom[] getVisibleGeometryAtom(BoundingBox boundingBox, Locale locale, boolean bl, int n) {
        GeometryAtom[] geometryAtomArray = null;
        int[] nArray = null;
        this.lock.readLock();
        if (this.bhTreeCount == 1) {
            GeometryAtom[] geometryAtomArray2 = null;
            Object object = this.visLock;
            synchronized (object) {
                geometryAtomArray2 = this.bhTreeArr[0].getVisibleGeometryAtom(boundingBox, bl, n);
            }
            this.lock.readUnlock();
            return geometryAtomArray2;
        }
        nArray = new int[this.bhTreeCount];
        GeometryAtom[][] geometryAtomArray3 = new GeometryAtom[this.bhTreeCount][];
        BoundingBox boundingBox2 = new BoundingBox();
        Object object = this.visLock;
        synchronized (object) {
            int n2 = 0;
            while (n2 < this.bhTreeCount) {
                if (!locale.hiRes.equals(this.bhTreeArr[n2].locale.hiRes)) {
                    this.bhTreeArr[n2].locale.hiRes.difference(locale.hiRes, this.localeTrans);
                    boundingBox2.lower.x = boundingBox.lower.x + this.localeTrans.x;
                    boundingBox2.lower.y = boundingBox.lower.y + this.localeTrans.y;
                    boundingBox2.lower.z = boundingBox.lower.z + this.localeTrans.z;
                    boundingBox2.upper.x = boundingBox.upper.x + this.localeTrans.x;
                    boundingBox2.upper.y = boundingBox.upper.y + this.localeTrans.y;
                    boundingBox2.upper.z = boundingBox.upper.z + this.localeTrans.z;
                }
                geometryAtomArray3[n2] = this.bhTreeArr[n2].getVisibleGeometryAtom(boundingBox2, bl, n);
                nArray[n2] = this.bhTreeArr[n2].visBHNodeCount;
                ++n2;
            }
            int n3 = 0;
            n2 = 0;
            while (n2 < this.bhTreeCount) {
                n3 += nArray[n2];
                ++n2;
            }
            geometryAtomArray = new GeometryAtom[n3];
            n3 = 0;
            n2 = 0;
            while (n2 < this.bhTreeCount) {
                int n4 = 0;
                while (n4 < nArray[n2]) {
                    geometryAtomArray[n3++] = geometryAtomArray3[n2][n4];
                    ++n4;
                }
                ++n2;
            }
        }
        this.lock.readUnlock();
        return geometryAtomArray;
    }

    private void insertNodes(Object[] objectArray) {
        BHTree bHTree = null;
        this.clearBhNodeArr();
        int n = 0;
        while (n < objectArray.length) {
            block14: {
                Object object;
                Object object2;
                Object object3 = objectArray[n];
                if (object3 instanceof GeometryAtom) {
                    object2 = object3;
                    synchronized (object2) {
                        GeometryAtom geometryAtom = (GeometryAtom)object3;
                        if (geometryAtom.source.inBackgroundGroup) {
                            geometryAtom.source.geometryBackground.addBgGeometryAtomList(geometryAtom);
                            Object var7_7 = null;
                        } else {
                            object = (BHLeafNode)VirtualUniverse.mc.getBHNode(2);
                            ((BHLeafNode)object).leafIF = geometryAtom;
                            geometryAtom.bhLeafNode = object;
                            ((BHLeafNode)object).computeBoundingHull();
                            this.addToBhNodeArr((BHNode)object);
                            if (bHTree == null) {
                                int n2 = this.getOrAddBHTreeIndex(geometryAtom.locale);
                                bHTree = this.bhTreeArr[n2];
                                bHTree.geometryAtomsDirty = true;
                            }
                            bHTree.geometryAtomList.add(object3);
                        }
                        break block14;
                    }
                }
                if (object3 instanceof GroupRetained) {
                    object2 = object3;
                    synchronized (object2) {
                        object = (GroupRetained)object3;
                        BHLeafNode bHLeafNode = (BHLeafNode)VirtualUniverse.mc.getBHNode(2);
                        bHLeafNode.leafIF = object;
                        ((GroupRetained)object).bhLeafNode = bHLeafNode;
                        bHLeafNode.computeBoundingHull();
                        this.addToBhNodeArr(bHLeafNode);
                    }
                }
            }
            ++n;
        }
        if (this.bhNodeCount < 1) {
            return;
        }
        if (bHTree == null) {
            bHTree = this.bhTreeArr[this.getOrAddBHTreeIndex(((BHLeafNode)this.bhNodeArr[0]).getLocale())];
        }
        bHTree.insert(this.bhNodeArr, this.bhNodeCount);
    }

    GeometryAtom[] pickAll(Locale locale, PickShape pickShape) {
        UnorderList unorderList = new UnorderList(class$javax$media$j3d$BHNode != null ? class$javax$media$j3d$BHNode : (class$javax$media$j3d$BHNode = GeometryStructure.class$("javax.media.j3d.BHNode")));
        this.lock.readLock();
        int n = this.getBHTreeIndex(locale);
        if (n < 0) {
            this.lock.readUnlock();
            return null;
        }
        this.bhTreeArr[n].select(pickShape, unorderList);
        this.lock.readUnlock();
        int n2 = unorderList.size();
        if (n2 < 1) {
            return null;
        }
        BHNode[] bHNodeArray = (BHNode[])unorderList.toArray(false);
        GeometryAtom[] geometryAtomArray = new GeometryAtom[n2];
        n = 0;
        while (n < n2) {
            geometryAtomArray[n] = (GeometryAtom)((BHLeafNode)bHNodeArray[n]).leafIF;
            ++n;
        }
        return geometryAtomArray;
    }

    GeometryAtom pickAny(Locale locale, PickShape pickShape) {
        BHNode bHNode = null;
        this.lock.readLock();
        int n = this.getBHTreeIndex(locale);
        if (n < 0) {
            this.lock.readUnlock();
            return null;
        }
        bHNode = this.bhTreeArr[n].selectAny(pickShape);
        this.lock.readUnlock();
        if (bHNode == null) {
            return null;
        }
        return (GeometryAtom)((BHLeafNode)bHNode).leafIF;
    }

    private void processBoundsChanged(Object[] objectArray, boolean bl) {
        this.clearBhNodeArr();
        int n = 0;
        while (n < objectArray.length) {
            Object object;
            Object object2 = objectArray[n];
            if (object2 instanceof GeometryAtom) {
                object = object2;
                synchronized (object) {
                    GeometryAtom geometryAtom = (GeometryAtom)object2;
                    if (geometryAtom.bhLeafNode != null) {
                        this.addToBhNodeArr(geometryAtom.bhLeafNode);
                    }
                }
            }
            if (object2 instanceof GroupRetained) {
                object = (GroupRetained)object2;
                Object object3 = object2;
                synchronized (object3) {
                    if (((GroupRetained)object).bhLeafNode != null) {
                        this.addToBhNodeArr(((GroupRetained)object).bhLeafNode);
                    }
                }
            }
            ++n;
        }
        if (this.bhNodeCount < 1) {
            return;
        }
        int n2 = this.getBHTreeIndex(((BHLeafNode)this.bhNodeArr[0]).getLocale());
        if (n2 >= 0) {
            this.bhTreeArr[n2].boundsChanged(this.bhNodeArr, this.bhNodeCount);
            if (bl) {
                this.bhTreeArr[n2].boundsDirty = true;
            }
        }
    }

    void processCollisionDetection() {
        int n;
        BHLeafInterface bHLeafInterface;
        WakeupOnCollisionEntry[] wakeupOnCollisionEntryArray = (WakeupOnCollisionEntry[])this.wakeupOnCollisionEntry.toArray();
        int n2 = this.wakeupOnCollisionEntry.arraySize() - 1;
        while (n2 >= 0) {
            WakeupOnCollisionEntry wakeupOnCollisionEntry = wakeupOnCollisionEntryArray[n2];
            wakeupOnCollisionEntry.updateCollisionBounds();
            bHLeafInterface = this.collide(wakeupOnCollisionEntry.behav.locale, wakeupOnCollisionEntry.accuracyMode, wakeupOnCollisionEntry.geometryAtoms, wakeupOnCollisionEntry.vwcBounds, wakeupOnCollisionEntry.boundingLeaf, wakeupOnCollisionEntry.armingNode);
            n = this.collideEntryList.indexOf(wakeupOnCollisionEntry);
            if (bHLeafInterface != null) {
                if (n < 0) {
                    this.collideEntryList.add(wakeupOnCollisionEntry);
                    wakeupOnCollisionEntry.setTarget(bHLeafInterface);
                    wakeupOnCollisionEntry.setTriggered();
                }
            } else if (n >= 0) {
                this.collideEntryList.remove(n);
            }
            --n2;
        }
        WakeupOnCollisionMovement[] wakeupOnCollisionMovementArray = (WakeupOnCollisionMovement[])this.wakeupOnCollisionMovement.toArray();
        n2 = this.wakeupOnCollisionMovement.arraySize() - 1;
        while (n2 >= 0) {
            WakeupOnCollisionMovement wakeupOnCollisionMovement = wakeupOnCollisionMovementArray[n2];
            wakeupOnCollisionMovement.updateCollisionBounds();
            bHLeafInterface = this.collide(wakeupOnCollisionMovement.behav.locale, wakeupOnCollisionMovement.accuracyMode, wakeupOnCollisionMovement.geometryAtoms, wakeupOnCollisionMovement.vwcBounds, wakeupOnCollisionMovement.boundingLeaf, wakeupOnCollisionMovement.armingNode);
            n = this.collideMovementList.indexOf(wakeupOnCollisionMovement);
            if (bHLeafInterface != null) {
                if (n < 0) {
                    this.collideMovementList.add(wakeupOnCollisionMovement);
                    wakeupOnCollisionMovement.setTarget(bHLeafInterface);
                } else {
                    wakeupOnCollisionMovement.setTriggered();
                }
            } else if (n >= 0) {
                this.collideMovementList.remove(n);
            }
            --n2;
        }
        WakeupOnCollisionExit[] wakeupOnCollisionExitArray = (WakeupOnCollisionExit[])this.wakeupOnCollisionExit.toArray();
        n2 = this.wakeupOnCollisionExit.arraySize() - 1;
        while (n2 >= 0) {
            WakeupOnCollisionExit wakeupOnCollisionExit = wakeupOnCollisionExitArray[n2];
            wakeupOnCollisionExit.updateCollisionBounds();
            bHLeafInterface = this.collide(wakeupOnCollisionExit.behav.locale, wakeupOnCollisionExit.accuracyMode, wakeupOnCollisionExit.geometryAtoms, wakeupOnCollisionExit.vwcBounds, wakeupOnCollisionExit.boundingLeaf, wakeupOnCollisionExit.armingNode);
            n = this.collideExitList.indexOf(wakeupOnCollisionExit);
            if (bHLeafInterface != null) {
                if (n < 0) {
                    this.collideExitList.add(wakeupOnCollisionExit);
                    wakeupOnCollisionExit.setTarget(bHLeafInterface);
                }
            } else if (n >= 0) {
                this.collideExitList.remove(n);
                wakeupOnCollisionExit.setTriggered();
            }
            --n2;
        }
    }

    void processMessages(long l) {
        J3dMessage[] j3dMessageArray = this.getMessages(l);
        if (j3dMessageArray != null) {
            int n = j3dMessageArray.length - 1;
            while (n >= 0) {
                int n2;
                if (j3dMessageArray[n].type == 3 && (n2 = this.transList.indexOf(j3dMessageArray[n].args[1])) < 0) {
                    this.transList.add(j3dMessageArray[n].args[1]);
                    this.transMessageList.add(j3dMessageArray[n]);
                }
                --n;
            }
            if (this.transMessageList.size() > 0) {
                n = this.transMessageList.size() - 1;
                while (n >= 0) {
                    J3dMessage j3dMessage = (J3dMessage)this.transMessageList.get(n);
                    this.lock.writeLock();
                    this.processBoundsChanged((Object[])j3dMessage.args[0], false);
                    this.lock.writeUnlock();
                    --n;
                }
                this.transMessageList.clear();
                this.transList.clear();
            }
            n = 0;
            while (n < j3dMessageArray.length) {
                this.lock.writeLock();
                switch (j3dMessageArray[n].type) {
                    case 0: {
                        this.insertNodes((Object[])j3dMessageArray[n].args[0]);
                        break;
                    }
                    case 1: {
                        this.removeNodes((Object[])j3dMessageArray[n].args[0]);
                        break;
                    }
                    case 24: {
                        int n3 = (Integer)j3dMessageArray[n].args[1];
                        if (n3 == 1) {
                            this.removeNodes((Object[])j3dMessageArray[n].args[2]);
                            this.insertNodes((Object[])j3dMessageArray[n].args[3]);
                            break;
                        }
                        if (n3 != 2) break;
                        this.processVisibleChanged(j3dMessageArray[n].args[3], (ArrayList)j3dMessageArray[n].args[4]);
                        break;
                    }
                    case 26: {
                        this.removeNodes((Object[])j3dMessageArray[n].args[0]);
                        this.insertNodes((Object[])j3dMessageArray[n].args[1]);
                        break;
                    }
                    case 25: {
                        this.processBoundsChanged((Object[])j3dMessageArray[n].args[0], false);
                        break;
                    }
                    case 16: {
                        int n3 = (Integer)j3dMessageArray[n].args[1];
                        if (n3 == 1) {
                            this.processBoundsChanged((Object[])j3dMessageArray[n].args[3], false);
                            break;
                        }
                        if (n3 != 2) break;
                        this.processVisibleChanged(j3dMessageArray[n].args[3], (ArrayList)j3dMessageArray[n].args[4]);
                        break;
                    }
                    case 27: {
                        this.processSwitchChanged(j3dMessageArray[n], l);
                        break;
                    }
                    case 35: 
                    case 37: {
                        this.processBoundsChanged((Object[])j3dMessageArray[n].args[0], true);
                        break;
                    }
                    case 17: {
                        this.processBoundsChanged((Object[])j3dMessageArray[n].args[0], false);
                        break;
                    }
                    case 10: {
                        this.processVisibleChanged(j3dMessageArray[n].args[2], (ArrayList)j3dMessageArray[n].args[3]);
                        break;
                    }
                }
                this.lock.writeUnlock();
                j3dMessageArray[n].decRefcount();
                ++n;
            }
            this.processCollisionDetection();
        }
    }

    private void processSwitchChanged(J3dMessage j3dMessage, long l) {
        Object[] objectArray = (Object[])j3dMessage.args[0];
        Object[] objectArray2 = (Object[])j3dMessage.args[1];
        if (objectArray.length < 1) {
            return;
        }
        int n = this.getBHTreeIndex(((LeafRetained)objectArray[0]).locale);
        this.bhTreeArr[n].geometryAtomsDirty = true;
        int n2 = 0;
        while (n2 < objectArray.length) {
            ((LeafRetained)objectArray[n2]).evalCurrentSwitchOn((long[])objectArray2[n2]);
            ++n2;
        }
    }

    private void processVisibleChanged(Object object, ArrayList arrayList) {
        boolean bl = true;
        if (arrayList == null || arrayList.size() < 1) {
            return;
        }
        int n = this.getBHTreeIndex(((GeometryAtom)arrayList.get((int)0)).locale);
        this.bhTreeArr[n].visibleDirty = true;
        if (object != null) {
            if (object instanceof AppearanceRetained) {
                if (((AppearanceRetained)object).renderingAttributes != null) {
                    bl = ((AppearanceRetained)object).renderingAttributes.visible;
                }
            } else if (object instanceof Boolean) {
                bl = (Boolean)object;
            }
        }
        int n2 = arrayList.size() - 1;
        while (n2 >= 0) {
            ((GeometryAtom)arrayList.get((int)n2)).visible = bl;
            --n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeNodes(Object[] objectArray) {
        int n;
        Object object;
        BHTree bHTree = null;
        this.clearBhNodeArr();
        int n2 = 0;
        while (true) {
            Object object2;
            if (n2 >= objectArray.length) {
                if (this.bhNodeCount >= 1) break;
                return;
            }
            Object object3 = objectArray[n2];
            if (object3 instanceof GeometryAtom) {
                object = object3;
                synchronized (object) {
                    block31: {
                        object2 = (GeometryAtom)object3;
                        if (((GeometryAtom)object2).source != null && ((GeometryAtom)object2).source.inBackgroundGroup) {
                            ((GeometryAtom)object2).source.geometryBackground.removeBgGeometryAtomList((GeometryAtom)object2);
                            Object var7_7 = null;
                            break block31;
                        }
                        if (((GeometryAtom)object2).bhLeafNode != null) {
                            this.addToBhNodeArr(((GeometryAtom)object2).bhLeafNode);
                            ((GeometryAtom)object2).bhLeafNode = null;
                        }
                        if (bHTree == null) {
                            n = this.getBHTreeIndex(((GeometryAtom)object2).locale);
                            if (n < 0) {
                                return;
                            }
                            bHTree = this.bhTreeArr[n];
                            bHTree.geometryAtomsDirty = true;
                        }
                        if ((n = bHTree.geometryAtomList.indexOf(object3)) >= 0) {
                            bHTree.geometryAtomList.remove(n);
                        }
                        break;
                    }
                }
            } else {
                if (object3 instanceof GroupRetained) {
                    object = object3;
                    synchronized (object) {
                        object2 = (GroupRetained)object3;
                        if (((GroupRetained)object2).bhLeafNode != null) {
                            this.addToBhNodeArr(((GroupRetained)object2).bhLeafNode);
                            ((GroupRetained)object2).bhLeafNode = null;
                        }
                    }
                }
                if (object3 instanceof BehaviorRetained) {
                    object = object3;
                    synchronized (object) {
                        object2 = (BehaviorRetained)object3;
                        WakeupOnCollisionEntry[] wakeupOnCollisionEntryArray = (WakeupOnCollisionEntry[])this.collideEntryList.toArray();
                        int n3 = this.collideEntryList.arraySize() - 1;
                        while (true) {
                            if (n3 < 0) break;
                            WakeupOnCollisionEntry wakeupOnCollisionEntry = wakeupOnCollisionEntryArray[n3];
                            if (wakeupOnCollisionEntry.behav == object2) {
                                this.collideEntryList.remove(wakeupOnCollisionEntry);
                            }
                            --n3;
                        }
                        WakeupOnCollisionExit[] wakeupOnCollisionExitArray = (WakeupOnCollisionExit[])this.collideExitList.toArray();
                        int n4 = this.collideExitList.arraySize() - 1;
                        while (n4 >= 0) {
                            WakeupOnCollisionExit wakeupOnCollisionExit = wakeupOnCollisionExitArray[n4];
                            if (wakeupOnCollisionExit.behav == object2) {
                                this.collideExitList.remove(wakeupOnCollisionExit);
                            }
                            --n4;
                        }
                    }
                }
            }
            ++n2;
        }
        if (bHTree == null) {
            n = this.getBHTreeIndex(((BHLeafNode)this.bhNodeArr[0]).getLocale());
            if (n < 0) {
                return;
            }
            bHTree = this.bhTreeArr[n];
        }
        bHTree.delete(this.bhNodeArr, this.bhNodeCount);
        this.wakeupOnCollisionEntry.clearMirror();
        this.wakeupOnCollisionMovement.clearMirror();
        this.wakeupOnCollisionExit.clearMirror();
        object = this.collideListLock;
        synchronized (object) {
            this.collideEntryList.clearMirror();
            this.collideExitList.clearMirror();
            return;
        }
    }

    void removeWakeupOnCollision(WakeupOnCollisionEntry wakeupOnCollisionEntry) {
        this.wakeupOnCollisionEntry.remove(wakeupOnCollisionEntry);
    }

    void removeWakeupOnCollision(WakeupOnCollisionExit wakeupOnCollisionExit) {
        this.wakeupOnCollisionExit.remove(wakeupOnCollisionExit);
    }

    void removeWakeupOnCollision(WakeupOnCollisionMovement wakeupOnCollisionMovement) {
        this.wakeupOnCollisionMovement.remove(wakeupOnCollisionMovement);
        this.collideMovementList.remove(wakeupOnCollisionMovement);
    }

    void resetConditionMet() {
        BehaviorStructure.resetConditionMet(this.wakeupOnCollisionEntry);
        BehaviorStructure.resetConditionMet(this.wakeupOnCollisionExit);
        BehaviorStructure.resetConditionMet(this.wakeupOnCollisionMovement);
    }
}

