/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.j3d.GeometryLock;
import javax.media.j3d.J3dDataInputStream;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponentRetained;

abstract class ImageComponentRetained
extends NodeComponentRetained {
    int format;
    int width;
    int height;
    byte[] imageYdown;
    byte[] imageYup;
    int bytesPerPixel;
    boolean usedByRaster = false;
    boolean usedByTexture = false;
    boolean byReference = false;
    boolean yUp = false;
    RenderedImage[] bImage;
    boolean[] imageDirty;
    float lastAlpha = 1.0f;
    boolean alphaChanged = false;
    int storedFormat;
    int bytesPerPixelStored;
    int internalFormat;
    boolean imageYupAllocated = false;
    boolean imageYdownAllocated = false;
    boolean imageYupCacheDirty = false;
    boolean imageYdownCacheDirty = false;
    static final int BYTE_RGBA = 1;
    static final int BYTE_ABGR = 2;
    static final int BYTE_GRAY = 4;
    static final int USHORT_GRAY = 8;
    static final int BYTE_LA = 16;
    static final int BYTE_BGR = 32;
    static final int BYTE_RGB = 64;
    int imageYupClass = 0;
    int imageYdownClass = 0;
    static final int BUFFERED_IMAGE = 1;
    static final int RENDERED_IMAGE = 2;
    GeometryLock geomLock = new GeometryLock();
    int minTileX = 0;
    int minTileY = 0;
    int minTileZ = 0;
    int tilew = 0;
    int tileh = 0;
    int tiled = 0;
    int numXTiles = 0;
    int numYTiles = 0;
    int numZTiles = 0;

    ImageComponentRetained() {
    }

    final void copyBufferedImageWithFormatConversion(boolean bl, int n) {
        byte[] byArray;
        int n2;
        int n3;
        int n4;
        int n5;
        BufferedImage bufferedImage = (BufferedImage)this.bImage[n];
        int n6 = bufferedImage.getType();
        if (!this.yUp) {
            if (bl) {
                n5 = -1 * this.width;
                n4 = (this.height - 1) * this.width;
                n3 = this.height - 1;
                n2 = -1;
                byArray = this.imageYup;
            } else {
                n5 = this.width;
                n4 = 0;
                n3 = 0;
                n2 = 1;
                byArray = this.imageYdown;
            }
        } else if (bl) {
            n5 = this.width;
            n4 = 0;
            n3 = 0;
            n2 = 1;
            byArray = this.imageYup;
        } else {
            n5 = -1 * this.width;
            n4 = (this.height - 1) * this.width;
            n3 = this.height - 1;
            n2 = -1;
            byArray = this.imageYdown;
        }
        switch (n6) {
            case 2: {
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                int n7 = 0;
                int n8 = 0;
                while (n8 < this.height) {
                    int n9 = n4;
                    int n10 = 0;
                    while (n10 < this.width) {
                        nArray[n9] = (byArray[n7 + 3] & 0xFF) << 24 | (byArray[n7] & 0xFF) << 16 | (byArray[n7 + 1] & 0xFF) << 8 | byArray[n7 + 2] & 0xFF;
                        ++n10;
                        n7 += 4;
                        ++n9;
                    }
                    ++n8;
                    n4 += n5;
                }
                break;
            }
            default: {
                WritableRaster writableRaster = bufferedImage.getRaster();
                ColorModel colorModel = bufferedImage.getColorModel();
                int n11 = 0;
                int n12 = 0;
                while (n12 < this.height) {
                    int n13 = n3;
                    int n14 = 0;
                    while (n14 < this.width) {
                        int n15 = (byArray[n11 + 3] & 0xFF) << 24 | (byArray[n11] & 0xFF) << 16 | (byArray[n11 + 1] & 0xFF) << 8 | byArray[n11 + 2] & 0xFF;
                        bufferedImage.setRGB(n14, n13, n15);
                        ++n14;
                        n11 += 4;
                    }
                    ++n12;
                    n3 += n2;
                }
                break block0;
            }
        }
    }

    final void copyImage(BufferedImage bufferedImage, byte[] byArray, boolean bl, int n) {
        int n2;
        int n3;
        int n4;
        Object[] objectArray = null;
        if (!this.yUp && bl || this.yUp && !bl) {
            n4 = n * this.width * this.height * this.bytesPerPixelStored;
            n3 = -1;
            n2 = this.height - 1;
        } else {
            n4 = 0;
            n3 = 1;
            n2 = 0;
        }
        int n5 = bufferedImage.getType();
        if (!(n5 != 2 && n5 != 1 || this.format != 2 && this.format != 1)) {
            int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            int n6 = n3 * this.width;
            n2 *= this.width;
            int n7 = n4;
            if (n5 == 2 && this.format == 2) {
                int n8 = 0;
                while (n8 < this.height) {
                    int n9 = n2;
                    int n10 = 0;
                    while (n10 < this.width) {
                        int n11 = nArray[n9];
                        byArray[n7++] = (byte)(n11 >> 16 & 0xFF);
                        byArray[n7++] = (byte)(n11 >> 8 & 0xFF);
                        byArray[n7++] = (byte)(n11 & 0xFF);
                        byArray[n7++] = (byte)(n11 >> 24 & 0xFF);
                        ++n10;
                        ++n9;
                    }
                    n2 += n6;
                    ++n8;
                }
            } else {
                int n12 = 0;
                while (n12 < this.height) {
                    int n13 = n2;
                    int n14 = 0;
                    while (n14 < this.width) {
                        int n15 = nArray[n13];
                        byArray[n7++] = (byte)(n15 >> 16 & 0xFF);
                        byArray[n7++] = (byte)(n15 >> 8 & 0xFF);
                        byArray[n7++] = (byte)(n15 & 0xFF);
                        byArray[n7++] = -1;
                        ++n14;
                        ++n13;
                    }
                    n2 += n6;
                    ++n12;
                }
            }
        } else if (n5 == 10 && this.format == 10) {
            byte[] byArray2 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
            int n16 = n3 * this.width;
            n2 *= this.width;
            int n17 = n4;
            int n18 = 0;
            while (n18 < this.height) {
                System.arraycopy(byArray2, n2, byArray, n17, this.width);
                ++n18;
                n17 += this.width;
                n2 += n16;
            }
        } else {
            WritableRaster writableRaster = bufferedImage.getRaster();
            ColorModel colorModel = bufferedImage.getColorModel();
            if (writableRaster.getTransferType() == 3) {
                objectArray = new int[4];
            } else if (writableRaster.getTransferType() == 0) {
                objectArray = new byte[4];
            } else if (writableRaster.getTransferType() == 1) {
                objectArray = new short[4];
            }
            switch (this.format) {
                case 2: 
                case 4: 
                case 6: {
                    int n19 = n4;
                    int n20 = n2;
                    int n21 = 0;
                    while (n21 < this.height) {
                        int n22 = 0;
                        while (n22 < this.width) {
                            writableRaster.getDataElements(n22, n20, objectArray);
                            byArray[n19++] = (byte)colorModel.getRed(objectArray);
                            byArray[n19++] = (byte)colorModel.getGreen(objectArray);
                            byArray[n19++] = (byte)colorModel.getBlue(objectArray);
                            byArray[n19++] = (byte)colorModel.getAlpha(objectArray);
                            ++n22;
                        }
                        ++n21;
                        n20 += n3;
                    }
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 9: {
                    this.lastAlpha = 1.0f;
                    int n23 = n4;
                    int n24 = n2;
                    int n25 = 0;
                    while (n25 < this.height) {
                        int n26 = 0;
                        while (n26 < this.width) {
                            writableRaster.getDataElements(n26, n24, objectArray);
                            byArray[n23++] = (byte)colorModel.getRed(objectArray);
                            byArray[n23++] = (byte)colorModel.getGreen(objectArray);
                            byArray[n23++] = (byte)colorModel.getBlue(objectArray);
                            byArray[n23++] = -1;
                            ++n26;
                        }
                        ++n25;
                        n24 += n3;
                    }
                    break;
                }
                case 7: 
                case 8: {
                    int n27 = n4;
                    int n28 = n2;
                    int n29 = 0;
                    while (n29 < this.height) {
                        int n30 = 0;
                        while (n30 < this.width) {
                            writableRaster.getDataElements(n30, n28, objectArray);
                            byArray[n27++] = (byte)colorModel.getRed(objectArray);
                            byArray[n27++] = (byte)colorModel.getAlpha(objectArray);
                            ++n30;
                        }
                        ++n29;
                        n28 += n3;
                    }
                    break;
                }
                case 10: {
                    int n31 = n4;
                    int n32 = n2;
                    int n33 = 0;
                    while (n33 < this.height) {
                        int n34 = 0;
                        while (n34 < this.width) {
                            writableRaster.getDataElements(n34, n32, objectArray);
                            byArray[n31++] = (byte)colorModel.getRed(objectArray);
                            ++n34;
                        }
                        ++n33;
                        n32 += n3;
                    }
                    break;
                }
            }
        }
    }

    final void copyImage(RenderedImage renderedImage, byte[] byArray, boolean bl, int n) {
        int n2;
        int n3;
        int n4;
        Object[] objectArray = null;
        int n5 = this.width * this.bytesPerPixelStored;
        ColorModel colorModel = renderedImage.getColorModel();
        int n6 = renderedImage.getMinTileX();
        int n7 = renderedImage.getMinTileY();
        this.numXTiles = renderedImage.getNumXTiles();
        this.numYTiles = renderedImage.getNumYTiles();
        this.tilew = renderedImage.getTileWidth();
        this.tileh = renderedImage.getTileHeight();
        int n8 = this.tilew * this.bytesPerPixelStored;
        if (!this.yUp && bl || this.yUp && !bl) {
            n4 = (this.height - 1) * n5;
            n3 = -n5;
            n2 = -(this.tileh * this.tilew * this.numXTiles * this.bytesPerPixelStored);
        } else {
            n4 = 0;
            n3 = n5;
            n2 = this.tileh * this.tilew * this.numXTiles * this.bytesPerPixelStored;
        }
        Raster raster = renderedImage.getTile(n6, n7);
        if (raster.getTransferType() == 3) {
            objectArray = new int[4];
        } else if (raster.getTransferType() == 0) {
            objectArray = new byte[4];
        } else if (raster.getTransferType() == 1) {
            objectArray = new short[4];
        }
        switch (this.format) {
            case 2: 
            case 4: 
            case 6: {
                int n9 = n7;
                while (n9 < n7 + this.numYTiles) {
                    int n10 = n4;
                    int n11 = n6;
                    while (n11 < n6 + this.numXTiles) {
                        raster = renderedImage.getTile(n11, n9);
                        int n12 = n10;
                        int n13 = 0;
                        int n14 = 0;
                        int n15 = 0;
                        while (n15 < this.tileh) {
                            int n16 = 0;
                            while (n16 < this.tilew) {
                                raster.getDataElements(n16, n14, objectArray);
                                byArray[n12++] = (byte)colorModel.getRed(objectArray);
                                byArray[n12++] = (byte)colorModel.getGreen(objectArray);
                                byArray[n12++] = (byte)colorModel.getBlue(objectArray);
                                byArray[n12++] = (byte)colorModel.getAlpha(objectArray);
                                ++n16;
                            }
                            n12 = n10 + (n13 += n3);
                            ++n15;
                            ++n14;
                        }
                        n10 += n8;
                        ++n11;
                    }
                    n4 += n2;
                    ++n9;
                }
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: {
                int n17 = n7;
                while (n17 < n7 + this.numYTiles) {
                    int n18 = n4;
                    int n19 = n6;
                    while (n19 < n6 + this.numXTiles) {
                        raster = renderedImage.getTile(n19, n17);
                        int n20 = n18;
                        int n21 = 0;
                        int n22 = 0;
                        int n23 = 0;
                        while (n23 < this.tileh) {
                            int n24 = 0;
                            while (n24 < this.tilew) {
                                raster.getDataElements(n24, n22, objectArray);
                                byArray[n20++] = (byte)colorModel.getRed(objectArray);
                                byArray[n20++] = (byte)colorModel.getGreen(objectArray);
                                byArray[n20++] = (byte)colorModel.getBlue(objectArray);
                                byArray[n20++] = -1;
                                ++n24;
                            }
                            n20 = n18 + (n21 += n3);
                            ++n23;
                            ++n22;
                        }
                        n18 += n8;
                        ++n19;
                    }
                    n4 += n2;
                    ++n17;
                }
                break;
            }
            case 7: 
            case 8: {
                int n25 = n7;
                while (n25 < n7 + this.numYTiles) {
                    int n26 = n4;
                    int n27 = n6;
                    while (n27 < n6 + this.numXTiles) {
                        raster = renderedImage.getTile(n27, n25);
                        int n28 = n26;
                        int n29 = 0;
                        int n30 = 0;
                        int n31 = 0;
                        while (n31 < this.tileh) {
                            int n32 = 0;
                            while (n32 < this.tilew) {
                                raster.getDataElements(n32, n30, objectArray);
                                byArray[n28++] = (byte)colorModel.getRed(objectArray);
                                byArray[n28++] = (byte)colorModel.getAlpha(objectArray);
                                ++n32;
                            }
                            n28 = n26 + (n29 += n3);
                            ++n31;
                            ++n30;
                        }
                        n26 += n8;
                        ++n27;
                    }
                    n4 += n2;
                    ++n25;
                }
                break;
            }
            case 10: {
                int n33 = n7;
                while (n33 < n7 + this.numYTiles) {
                    int n34 = n4;
                    int n35 = n6;
                    while (n35 < n6 + this.numXTiles) {
                        raster = renderedImage.getTile(n35, n33);
                        int n36 = n34;
                        int n37 = 0;
                        int n38 = 0;
                        int n39 = 0;
                        while (n39 < this.tileh) {
                            int n40 = 0;
                            while (n40 < this.tilew) {
                                raster.getDataElements(n40, n38, objectArray);
                                byArray[n36++] = (byte)colorModel.getRed(objectArray);
                                ++n40;
                            }
                            n36 = n34 + (n37 += n3);
                            ++n39;
                            ++n38;
                        }
                        n34 += n8;
                        ++n35;
                    }
                    n4 += n2;
                    ++n33;
                }
                break;
            }
        }
    }

    final void copyToBufferedImage(byte[] byArray, int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        if (!this.yUp) {
            if (bl) {
                n4 = n * this.width * this.height * this.bytesPerPixelStored;
                n3 = -1 * this.width;
                n2 = (this.height - 1) * this.width;
            } else {
                n4 = 0;
                n3 = this.width;
                n2 = 0;
            }
        } else if (bl) {
            n4 = 0;
            n3 = this.width;
            n2 = 0;
        } else {
            n4 = n * this.width * this.height * this.bytesPerPixelStored;
            n3 = -1 * this.width;
            n2 = (this.height - 1) * this.width;
        }
        int[] nArray = ((DataBufferInt)((BufferedImage)this.bImage[n]).getRaster().getDataBuffer()).getData();
        switch (this.format) {
            case 2: 
            case 4: 
            case 6: {
                int n5 = n4;
                int n6 = 0;
                while (n6 < this.height) {
                    int n7 = n2;
                    int n8 = 0;
                    while (n8 < this.width) {
                        nArray[n7] = (byArray[n5 + 3] & 0xFF) << 24 | (byArray[n5] & 0xFF) << 16 | (byArray[n5 + 1] & 0xFF) << 8 | byArray[n5 + 2] & 0xFF;
                        ++n8;
                        n5 += 4;
                        ++n7;
                    }
                    ++n6;
                    n2 += n3;
                }
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: {
                int n9 = n4;
                int n10 = 0;
                while (n10 < this.height) {
                    int n11 = n2;
                    int n12 = 0;
                    while (n12 < this.width) {
                        nArray[n11] = (byArray[n9] & 0xFF) << 16 | (byArray[n9 + 1] & 0xFF) << 8 | byArray[n9 + 2] & 0xFF;
                        ++n12;
                        n9 += 4;
                        ++n11;
                    }
                    ++n10;
                    n2 += n3;
                }
                break;
            }
            case 7: 
            case 8: {
                int n13 = n4;
                int n14 = 0;
                while (n14 < this.height) {
                    int n15 = n2;
                    int n16 = 0;
                    while (n16 < this.width) {
                        nArray[n15] = (byArray[n13 + 1] & 0xFF) << 24 | (byArray[n13] & 0xFF) << 16;
                        ++n16;
                        n13 += 2;
                        ++n15;
                    }
                    ++n14;
                    n2 += n3;
                }
                break;
            }
            case 10: {
                int n17 = n4;
                int n18 = 0;
                while (n18 < this.height) {
                    int n19 = n2;
                    int n20 = 0;
                    while (n20 < this.width) {
                        nArray[n19] = (byArray[n17] & 0xFF) << 16;
                        ++n20;
                        ++n17;
                        ++n19;
                    }
                    ++n18;
                    n2 += n3;
                }
                break;
            }
        }
    }

    BufferedImage createBufferedImage(J3dDataInputStream j3dDataInputStream, int n, int n2, int n3) {
        BufferedImage bufferedImage = new BufferedImage(n2, n3, n);
        DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
        Object object = this.getData(dataBuffer);
        j3dDataInputStream.readArray(object);
        return bufferedImage;
    }

    final int getBytesStored(int n) {
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = 4;
                break;
            }
            case 2: {
                n2 = 4;
                break;
            }
            case 4: {
                n2 = 1;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
            case 16: {
                n2 = 2;
                break;
            }
            case 32: {
                n2 = 3;
                break;
            }
            case 64: {
                n2 = 3;
                break;
            }
        }
        return n2;
    }

    Object getData(DataBuffer dataBuffer) {
        Object[] objectArray = null;
        switch (dataBuffer.getDataType()) {
            case 0: {
                objectArray = ((DataBufferByte)dataBuffer).getData();
                break;
            }
            case 3: {
                objectArray = ((DataBufferInt)dataBuffer).getData();
                break;
            }
            case 2: {
                objectArray = ((DataBufferShort)dataBuffer).getData();
                break;
            }
        }
        return objectArray;
    }

    final int getFormat() {
        return this.format;
    }

    final int getHeight() {
        return this.height;
    }

    final int getWidth() {
        return this.width;
    }

    final boolean isByReference() {
        return this.byReference;
    }

    final boolean isYUp() {
        return this.yUp;
    }

    void processParams(int n, int n2, int n3, int n4) {
        if (n2 < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponentRetained0"));
        }
        if (n3 < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponentRetained1"));
        }
        if (n4 < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponentRetained2"));
        }
        if (n < 1 || n > 10) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponentRetained3"));
        }
        this.format = n;
        this.width = n2;
        this.height = n3;
        this.imageDirty = new boolean[n4];
        int n5 = 0;
        while (n5 < n4) {
            this.imageDirty[n5] = false;
            ++n5;
        }
        this.bImage = new RenderedImage[n4];
        switch (n) {
            case 1: {
                this.bytesPerPixel = 3;
                this.bytesPerPixelStored = 4;
                this.internalFormat = 1;
                break;
            }
            case 2: {
                this.bytesPerPixel = 4;
                this.bytesPerPixelStored = 4;
                this.internalFormat = 1;
                break;
            }
            case 3: {
                this.bytesPerPixel = 2;
                this.bytesPerPixelStored = 4;
                this.internalFormat = 1;
                break;
            }
            case 4: {
                this.bytesPerPixel = 2;
                this.bytesPerPixelStored = 4;
                this.internalFormat = 1;
                break;
            }
            case 5: {
                this.bytesPerPixel = 2;
                this.bytesPerPixelStored = 4;
                this.internalFormat = 1;
                break;
            }
            case 6: {
                this.bytesPerPixel = 2;
                this.bytesPerPixelStored = 4;
                this.internalFormat = 1;
                break;
            }
            case 9: {
                this.bytesPerPixel = 1;
                this.bytesPerPixelStored = 4;
                this.internalFormat = 1;
                break;
            }
            case 7: {
                this.bytesPerPixel = 1;
                this.bytesPerPixelStored = 2;
                this.internalFormat = 16;
                break;
            }
            case 8: {
                this.bytesPerPixel = 2;
                this.bytesPerPixelStored = 2;
                this.internalFormat = 16;
                break;
            }
            case 10: {
                this.bytesPerPixel = 1;
                this.bytesPerPixelStored = 1;
                this.internalFormat = 4;
                break;
            }
        }
    }

    final void retrieveBufferedImage(int n) {
        if (this.bImage[n] == null) {
            this.bImage[n] = this.format == 2 || this.format == 6 || this.format == 4 || this.format == 7 || this.format == 8 ? new BufferedImage(this.width, this.height, 2) : new BufferedImage(this.width, this.height, 1);
        }
        if (this.usedByTexture || !this.usedByRaster) {
            this.copyToBufferedImage(this.imageYup, n, true);
        } else {
            this.copyToBufferedImage(this.imageYdown, n, false);
        }
        this.imageDirty[n] = false;
    }

    final void retrieveImage(byte[] byArray, int n, int n2) {
        this.retrieveImage(byArray, 0, 0, n, n2);
    }

    final void retrieveImage(byte[] byArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n3 * this.bytesPerPixelStored;
        int n7 = this.width * this.bytesPerPixelStored;
        this.imageDirty[0] = true;
        if (this.storedFormat == this.internalFormat) {
            if ((this.usedByTexture || !this.usedByRaster) && this.imageYup == null) {
                this.imageYup = new byte[this.height * n7];
            }
            if (this.usedByRaster && this.imageYdown == null) {
                this.imageYdown = new byte[this.height * n7];
            }
        }
        int n8 = n2 * n7 + n * this.bytesPerPixelStored;
        int n9 = (this.height - n2 - 1) * n7 + n * this.bytesPerPixelStored;
        if (this.usedByRaster) {
            n5 = 0;
            while (n5 < n4) {
                System.arraycopy(byArray, n8, this.imageYdown, n9, n6);
                ++n5;
                n8 += n7;
                n9 -= n7;
            }
        }
        if (this.usedByTexture || !this.usedByRaster) {
            n9 = n8;
            n5 = 0;
            while (n5 < n4) {
                System.arraycopy(byArray, n8, this.imageYup, n9, n6);
                ++n5;
                n8 += n7;
                n9 += n7;
            }
        }
    }

    final void setByReference(boolean bl) {
        this.byReference = bl;
    }

    void setRasterRef() {
        this.usedByRaster = true;
    }

    void setTextureRef() {
        this.usedByTexture = true;
    }

    final void setYUp(boolean bl) {
        this.yUp = bl;
    }
}

