/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.AmbientLightRetained;
import javax.media.j3d.BackgroundRetained;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.EnvironmentSet;
import javax.media.j3d.LightRetained;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.OrderedBin;
import javax.media.j3d.PointLightRetained;
import javax.media.j3d.RenderBin;

class LightBin
implements ObjectUpdate {
    int maxLights = -1;
    LightRetained[] lights = null;
    int[] lightsRef = null;
    int numEmptySlots = -1;
    RenderBin renderBin = null;
    LightBin next = null;
    LightBin prev = null;
    EnvironmentSet environmentSetList = null;
    ArrayList insertEnvSet = new ArrayList();
    int canvasDirty = 0;
    int lightDirtyMaskCache = 0;
    int lightDirtyMask = 0;
    ArrayList pointLts = new ArrayList();
    OrderedBin orderedBin = null;
    int orderedChildId = -1;
    boolean onUpdateList = false;
    BackgroundRetained geometryBackground = null;

    LightBin(int n, RenderBin renderBin) {
        this.maxLights = n;
        this.numEmptySlots = n;
        this.lights = new LightRetained[n];
        this.lightsRef = new int[n];
        this.renderBin = renderBin;
    }

    void addEnvironmentSet(EnvironmentSet environmentSet, RenderBin renderBin) {
        int n = environmentSet.lights.size();
        int n2 = 0;
        while (n2 < n) {
            LightRetained lightRetained = (LightRetained)environmentSet.lights.get(n2);
            if (!(lightRetained instanceof AmbientLightRetained)) {
                int n3 = 0;
                while (n3 < this.maxLights) {
                    if (this.lights[n3] == lightRetained) {
                        if (lightRetained.lightOn) {
                            environmentSet.enableMask |= (long)(1 << n3);
                        }
                        int n4 = n3;
                        this.lightsRef[n4] = this.lightsRef[n4] + 1;
                        environmentSet.ltPos[n2] = n3;
                        break;
                    }
                    ++n3;
                }
                if (n3 == this.maxLights) {
                    n3 = 0;
                    while (n3 < this.maxLights) {
                        if (this.lights[n3] == null) {
                            this.lights[n3] = lightRetained;
                            this.lightsRef[n3] = 1;
                            if (lightRetained instanceof PointLightRetained) {
                                this.pointLts.add(lightRetained);
                            }
                            if (lightRetained.lightOn) {
                                environmentSet.enableMask |= (long)(1 << n3);
                            }
                            environmentSet.ltPos[n2] = n3;
                            --this.numEmptySlots;
                            break;
                        }
                        ++n3;
                    }
                }
            }
            ++n2;
        }
        environmentSet.lightBin = this;
        environmentSet.enableMaskCache = environmentSet.enableMask;
        this.insertEnvSet.add(environmentSet);
        if (!this.onUpdateList) {
            renderBin.objUpdateList.add(this);
            this.onUpdateList = true;
        }
    }

    void removeEnvironmentSet(EnvironmentSet environmentSet) {
        environmentSet.lightBin = null;
        int n = environmentSet.lights.size();
        int n2 = 0;
        while (n2 < n) {
            LightRetained lightRetained = (LightRetained)environmentSet.lights.get(n2);
            int n3 = 0;
            while (n3 < this.maxLights) {
                if (this.lights[n3] == lightRetained) {
                    int n4 = n3;
                    this.lightsRef[n4] = this.lightsRef[n4] - 1;
                    if (this.lightsRef[n3] != 0) break;
                    if (lightRetained instanceof PointLightRetained) {
                        this.pointLts.remove(this.pointLts.indexOf(lightRetained));
                    }
                    this.lights[n3] = null;
                    this.lightDirtyMaskCache &= ~(1 << n3);
                    this.lightDirtyMask &= ~(1 << n3);
                    ++this.numEmptySlots;
                    break;
                }
                ++n3;
            }
            ++n2;
        }
        if (environmentSet.prev == null) {
            this.environmentSetList = environmentSet.next;
            if (environmentSet.next != null) {
                environmentSet.next.prev = null;
            }
        } else {
            environmentSet.prev.next = environmentSet.next;
            if (environmentSet.next != null) {
                environmentSet.next.prev = environmentSet.prev;
            }
        }
        environmentSet.prev = null;
        environmentSet.next = null;
        Canvas3D[] canvas3DArray = this.renderBin.view.getCanvases();
        n2 = 0;
        while (n2 < canvas3DArray.length) {
            canvas3DArray[n2].environmentSet = null;
            ++n2;
        }
        this.renderBin.envSetFreelist.add(environmentSet);
        if (this.environmentSetList == null && this.insertEnvSet.size() == 0) {
            this.renderBin.removeLightBin(this);
        }
    }

    void render(Canvas3D canvas3D) {
        int n;
        double d;
        if (canvas3D.lightBin != this) {
            if (this.geometryBackground == null) {
                d = canvas3D.canvasViewCache.getVworldToCoexistenceScale();
                canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vpcToEc.mat, this.renderBin.vworldToVpc.mat);
            } else {
                d = canvas3D.canvasViewCache.getInfVworldToCoexistenceScale();
                canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vpcToEc.mat, this.renderBin.infVworldToVpc.mat);
            }
            n = 0;
            while (n < this.maxLights) {
                if (this.lights[n] != null) {
                    this.lights[n].update(canvas3D.ctx, n, d);
                }
                ++n;
            }
            canvas3D.lightBin = this;
            canvas3D.canvasDirty &= 0xFFFFFFBF;
        } else if ((canvas3D.canvasDirty & 0x40) != 0) {
            if (this.geometryBackground == null) {
                d = canvas3D.canvasViewCache.getVworldToCoexistenceScale();
                canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vpcToEc.mat, this.renderBin.vworldToVpc.mat);
            } else {
                d = canvas3D.canvasViewCache.getInfVworldToCoexistenceScale();
                canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vpcToEc.mat, this.renderBin.infVworldToVpc.mat);
            }
            n = 0;
            int n2 = this.lightDirtyMask;
            while (n2 != 0) {
                if ((n2 & 1) != 0) {
                    this.lights[n].update(canvas3D.ctx, n, d);
                }
                n2 >>= 1;
                ++n;
            }
            canvas3D.canvasDirty &= 0xFFFFFFBF;
        } else if (this.pointLts.size() > 0 && (canvas3D.canvasDirty & 0x8000) != 0) {
            if (this.geometryBackground == null) {
                d = canvas3D.canvasViewCache.getVworldToCoexistenceScale();
                canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vpcToEc.mat, this.renderBin.vworldToVpc.mat);
            } else {
                d = canvas3D.canvasViewCache.getInfVworldToCoexistenceScale();
                canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vpcToEc.mat, this.renderBin.infVworldToVpc.mat);
            }
            n = 0;
            while (n < this.pointLts.size()) {
                LightRetained lightRetained = (LightRetained)this.pointLts.get(n);
                lightRetained.update(canvas3D.ctx, n, d);
                ++n;
            }
        }
        EnvironmentSet environmentSet = this.environmentSetList;
        while (environmentSet != null) {
            environmentSet.render(canvas3D);
            environmentSet = environmentSet.next;
        }
    }

    void reset() {
        this.prev = null;
        this.next = null;
        this.orderedBin = null;
        this.orderedChildId = -1;
        this.environmentSetList = null;
        this.onUpdateList = false;
        this.geometryBackground = null;
    }

    void setOrderedInfo(OrderedBin orderedBin, int n) {
        this.orderedBin = orderedBin;
        this.orderedChildId = n;
    }

    public void updateObject() {
        int n;
        if (this.insertEnvSet.size() > 0) {
            EnvironmentSet environmentSet = (EnvironmentSet)this.insertEnvSet.get(0);
            if (this.environmentSetList == null) {
                this.environmentSetList = environmentSet;
            } else {
                environmentSet.next = this.environmentSetList;
                this.environmentSetList.prev = environmentSet;
                this.environmentSetList = environmentSet;
            }
            n = 1;
            while (n < this.insertEnvSet.size()) {
                environmentSet = (EnvironmentSet)this.insertEnvSet.get(n);
                environmentSet.next = this.environmentSetList;
                this.environmentSetList.prev = environmentSet;
                this.environmentSetList = environmentSet;
                ++n;
            }
        }
        this.insertEnvSet.clear();
        if (this.canvasDirty != 0) {
            Canvas3D[] canvas3DArray = this.renderBin.view.getCanvases();
            n = 0;
            while (n < canvas3DArray.length) {
                canvas3DArray[n].canvasDirty |= this.canvasDirty;
                ++n;
            }
            this.lightDirtyMask = this.lightDirtyMaskCache;
            this.canvasDirty = 0;
            this.lightDirtyMaskCache = 0;
        }
        this.onUpdateList = false;
    }

    boolean willEnvironmentSetFit(EnvironmentSet environmentSet) {
        int n;
        int n2 = n = environmentSet.lights.size();
        int n3 = 0;
        while (n3 < n) {
            LightRetained lightRetained = (LightRetained)environmentSet.lights.get(n3);
            if (!(lightRetained instanceof AmbientLightRetained)) {
                int n4 = 0;
                while (n4 < this.maxLights) {
                    if (this.lights[n4] == lightRetained) {
                        --n2;
                        break;
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        return n2 <= this.numEmptySlots;
    }
}

