/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.ContainsNodes;
import javax.media.j3d.Group;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;

abstract class LightRetained
extends LeafRetained {
    static final int ENABLE_CHANGED = 1;
    static final int SCOPE_CHANGED = 2;
    static final int BOUNDS_CHANGED = 4;
    static final int COLOR_CHANGED = 8;
    static final int BOUNDINGLEAF_CHANGED = 16;
    static final int LAST_DEFINED_BIT = 16;
    boolean lightOn = true;
    Color3f color = new Color3f(1.0f, 1.0f, 1.0f);
    Vector scopes = new Vector();
    Bounds regionOfInfluence = null;
    BoundingLeafRetained boundingLeaf = null;
    Bounds region = null;
    int lightDirty = 65535;
    int sgLightDirty = 65535;
    int lightType = -1;
    boolean isNeeded = false;
    boolean inImmCtx = false;
    LightRetained sgLight = null;
    HashKey key = null;
    LightRetained[] mirrorLights = new LightRetained[1];
    int numMirrorLights = 0;
    boolean isScoped = false;
    HashKey tempKey = new HashKey(250);
    ArrayList environmentSets = new ArrayList();
    static final int targetThreads = 4224;

    LightRetained() {
    }

    void addScope(Group group) {
        Object[] objectArray = new Object[3];
        ArrayList arrayList = new ArrayList();
        GroupRetained groupRetained = (GroupRetained)group.retained;
        this.initAddScope(group);
        this.tempKey.reset();
        groupRetained.getAllScopedNodes(arrayList, this.tempKey);
        objectArray[0] = arrayList;
        objectArray[1] = null;
        objectArray[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, objectArray);
    }

    void clearLive(SetLiveState setLiveState) {
        super.clearLive(setLiveState);
        if (this.inSharedGroup) {
            int n = 0;
            while (n < setLiveState.keys.length) {
                LightRetained lightRetained = this.getMirrorLight(setLiveState.keys[n]);
                setLiveState.nodeList.add(lightRetained);
                lightRetained.boundingLeaf.removeUser(lightRetained);
                ++n;
            }
        } else {
            LightRetained lightRetained = this.getMirrorLight(null);
            if (lightRetained.boundingLeaf != null) {
                lightRetained.boundingLeaf.removeUser(lightRetained);
            }
            setLiveState.nodeList.add(lightRetained);
        }
        setLiveState.notifyThreads |= 0x1080;
    }

    protected Object clone() {
        LightRetained lightRetained = (LightRetained)super.clone();
        lightRetained.color = new Color3f(this.color);
        lightRetained.scopes = (Vector)this.scopes.clone();
        lightRetained.initInfluencingBoundingLeaf(this.getInfluencingBoundingLeaf());
        lightRetained.region = null;
        lightRetained.lightDirty = 65535;
        lightRetained.sgLightDirty = 65535;
        lightRetained.universe = null;
        lightRetained.isNeeded = false;
        lightRetained.inImmCtx = false;
        lightRetained.sgLight = null;
        lightRetained.key = null;
        lightRetained.mirrorLights = new LightRetained[1];
        lightRetained.numMirrorLights = 0;
        lightRetained.environmentSets = new ArrayList();
        return lightRetained;
    }

    Enumeration getAllScopes() {
        Enumeration enumeration = this.scopes.elements();
        Vector<SceneGraphObject> vector = new Vector<SceneGraphObject>(this.scopes.size());
        while (enumeration.hasMoreElements()) {
            vector.add(((GroupRetained)enumeration.nextElement()).source);
        }
        return vector.elements();
    }

    void getColor(Color3f color3f) {
        color3f.set((Tuple3f)this.color);
    }

    boolean getEnable() {
        return this.lightOn;
    }

    boolean getInImmCtx() {
        return this.inImmCtx;
    }

    BoundingLeaf getInfluencingBoundingLeaf() {
        return this.boundingLeaf != null ? (BoundingLeaf)this.boundingLeaf.source : null;
    }

    Bounds getInfluencingBounds() {
        return this.regionOfInfluence != null ? (Bounds)this.regionOfInfluence.clone() : null;
    }

    LightRetained getMirrorLight(HashKey hashKey) {
        if (this.inSharedGroup) {
            int n = 0;
            while (n < this.numMirrorLights) {
                if (this.mirrorLights[n].key.equals(hashKey)) {
                    return this.mirrorLights[n];
                }
                ++n;
            }
            if (this.numMirrorLights == this.mirrorLights.length) {
                LightRetained[] lightRetainedArray = new LightRetained[this.numMirrorLights * 2];
                n = 0;
                while (n < this.numMirrorLights) {
                    lightRetainedArray[n] = this.mirrorLights[n];
                    ++n;
                }
                this.mirrorLights = lightRetainedArray;
            }
            this.mirrorLights[this.numMirrorLights] = (LightRetained)this.clone();
            if (this.boundingLeaf != null) {
                this.mirrorLights[this.numMirrorLights].boundingLeaf = this.boundingLeaf.mirrorBoundingLeaf;
                if (this.mirrorLights[this.numMirrorLights].boundingLeaf != null) {
                    this.mirrorLights[this.numMirrorLights].boundingLeaf.addUser(this.mirrorLights[this.numMirrorLights]);
                }
            }
            this.mirrorLights[this.numMirrorLights].key = hashKey;
            this.mirrorLights[this.numMirrorLights].sgLight = this;
            return this.mirrorLights[this.numMirrorLights++];
        }
        if (this.mirrorLights[0] == null) {
            this.mirrorLights[0] = (LightRetained)this.clone();
            if (this.boundingLeaf != null) {
                this.mirrorLights[0].boundingLeaf = this.boundingLeaf.mirrorBoundingLeaf;
                if (this.mirrorLights[0].boundingLeaf != null) {
                    this.mirrorLights[0].boundingLeaf.addUser(this.mirrorLights[0]);
                }
            }
            this.mirrorLights[0].sgLight = this;
        }
        return this.mirrorLights[0];
    }

    Group getScope(int n) {
        return (Group)((GroupRetained)this.scopes.elementAt((int)n)).source;
    }

    void initAddScope(Group group) {
        GroupRetained groupRetained = (GroupRetained)group.retained;
        this.scopes.addElement(groupRetained);
    }

    void initColor(Color3f color3f) {
        this.color.set((Tuple3f)color3f);
    }

    void initEnable(boolean bl) {
        this.lightOn = bl;
    }

    void initInfluencingBoundingLeaf(BoundingLeaf boundingLeaf) {
        this.boundingLeaf = boundingLeaf != null ? (BoundingLeafRetained)boundingLeaf.retained : null;
    }

    void initInfluencingBounds(Bounds bounds) {
        this.regionOfInfluence = bounds != null ? (Bounds)bounds.clone() : null;
    }

    void initInsertScope(Group group, int n) {
        GroupRetained groupRetained = (GroupRetained)group.retained;
        this.scopes.insertElementAt(groupRetained, n);
    }

    synchronized void initMirrorObject(LightRetained lightRetained) {
        Object var8_2 = null;
        lightRetained.inBackgroundGroup = this.inBackgroundGroup;
        lightRetained.geometryBackground = this.geometryBackground;
        lightRetained.lightOn = this.lightOn;
        lightRetained.color.set((Tuple3f)this.color);
        lightRetained.parent = this.parent;
        lightRetained.region = null;
        if (this.boundingLeaf != null) {
            if (lightRetained.boundingLeaf != null) {
                lightRetained.boundingLeaf.removeUser(lightRetained);
            }
            lightRetained.boundingLeaf = this.boundingLeaf.mirrorBoundingLeaf;
            lightRetained.boundingLeaf.addUser(lightRetained);
            lightRetained.region = lightRetained.boundingLeaf.transformedRegion;
        } else {
            lightRetained.boundingLeaf = null;
        }
        if (this.regionOfInfluence != null) {
            lightRetained.regionOfInfluence = (Bounds)this.regionOfInfluence.clone();
            if (lightRetained.region == null) {
                lightRetained.region = (Bounds)lightRetained.regionOfInfluence.clone();
                lightRetained.region.transform(lightRetained.regionOfInfluence, lightRetained.lastLocalToVworld[0]);
            }
        } else {
            lightRetained.regionOfInfluence = null;
        }
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.scopes.size()) {
            GroupRetained groupRetained = (GroupRetained)this.scopes.get(n);
            this.tempKey.reset();
            groupRetained.markAllNodesForScopedLight(lightRetained, this.tempKey);
            ++n;
        }
        lightRetained.isScoped = this.scopes.size() > 0;
    }

    void initRemoveScope(int n) {
        GroupRetained groupRetained = (GroupRetained)this.scopes.elementAt(n);
        this.scopes.removeElementAt(n);
    }

    void initScope(Group group, int n) {
        GroupRetained groupRetained = (GroupRetained)group.retained;
        this.scopes.setElementAt(groupRetained, n);
    }

    void insertScope(Group group, int n) {
        Object[] objectArray = new Object[3];
        ArrayList arrayList = new ArrayList();
        GroupRetained groupRetained = (GroupRetained)group.retained;
        this.tempKey.reset();
        groupRetained.getAllScopedNodes(arrayList, this.tempKey);
        this.initInsertScope(group, n);
        objectArray[0] = arrayList;
        objectArray[1] = null;
        objectArray[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, objectArray);
    }

    int numScopes() {
        return this.scopes.size();
    }

    void removeScope(int n) {
        Object[] objectArray = new Object[3];
        ArrayList arrayList = new ArrayList();
        GroupRetained groupRetained = (GroupRetained)this.scopes.elementAt(n);
        this.tempKey.reset();
        groupRetained.getAllScopedNodes(arrayList, this.tempKey);
        objectArray[0] = null;
        objectArray[1] = arrayList;
        objectArray[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.initRemoveScope(n);
        this.sendMessage(2, objectArray);
    }

    void sendMessage(int n, Object object) {
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 4224;
        j3dMessage.type = 19;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = this.inSharedGroup ? new Integer(this.numMirrorLights) : new Integer(1);
        j3dMessage.args[3] = this.mirrorLights.clone();
        j3dMessage.args[4] = object;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void setColor(Color3f color3f) {
        this.initColor(color3f);
        this.sendMessage(8, new Color3f(color3f));
    }

    void setEnable(boolean bl) {
        this.initEnable(bl);
        this.sendMessage(1, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    void setInImmCtx(boolean bl) {
        this.inImmCtx = bl;
    }

    void setInfluencingBoundingLeaf(BoundingLeaf boundingLeaf) {
        int n;
        int n2 = this.numMirrorLights;
        if (this.numMirrorLights == 0) {
            n2 = 1;
        }
        if (this.boundingLeaf != null) {
            n = 0;
            while (n < n2) {
                this.boundingLeaf.mirrorBoundingLeaf.removeUser(this.mirrorLights[n]);
                ++n;
            }
        }
        if (boundingLeaf != null) {
            this.boundingLeaf = (BoundingLeafRetained)boundingLeaf.retained;
            n = 0;
            while (n < n2) {
                this.boundingLeaf.mirrorBoundingLeaf.addUser(this.mirrorLights[n]);
                ++n;
            }
        } else {
            this.boundingLeaf = null;
        }
        this.sendMessage(16, this.boundingLeaf != null ? this.boundingLeaf.mirrorBoundingLeaf : null);
    }

    void setInfluencingBounds(Bounds bounds) {
        this.initInfluencingBounds(bounds);
        this.sendMessage(4, bounds != null ? bounds.clone() : null);
    }

    void setLive(SetLiveState setLiveState) {
        if (this.inImmCtx) {
            throw new IllegalSharingException(J3dI18N.getString("LightRetained0"));
        }
        super.doSetLive(setLiveState);
        if (setLiveState.inSharedGroup) {
            int n = 0;
            while (n < setLiveState.keys.length) {
                LightRetained lightRetained = this.getMirrorLight(setLiveState.keys[n]);
                lightRetained.currentLocalToVworld = new Transform3D[1];
                lightRetained.lastLocalToVworld = new Transform3D[1];
                int n2 = 0;
                while (n2 < this.currentLocalToVworld.length) {
                    if (this.localToVworldKeys[n2].equals(setLiveState.keys[n])) break;
                    ++n2;
                }
                lightRetained.currentLocalToVworld[0] = this.currentLocalToVworld[n2];
                lightRetained.lastLocalToVworld[0] = this.lastLocalToVworld[n2];
                this.initMirrorObject(lightRetained);
                setLiveState.nodeList.add(lightRetained);
                if (setLiveState.transformTargets != null) {
                    setLiveState.transformTargets.add(lightRetained);
                    setLiveState.transformTargetThreads |= 0x1080;
                }
                if (setLiveState.switchLevels[n] >= 0) {
                    lightRetained.clearCompositeSwitchMask();
                    lightRetained.isNewSwitchLeaf = true;
                    ContainsNodes containsNodes = setLiveState.containsNodesList.getContainsNodes(setLiveState.keys[n]);
                    containsNodes.envNodes.add(lightRetained);
                }
                ++n;
            }
        } else {
            LightRetained lightRetained = this.getMirrorLight(null);
            lightRetained.currentLocalToVworld = new Transform3D[1];
            lightRetained.lastLocalToVworld = new Transform3D[1];
            lightRetained.currentLocalToVworld[0] = this.currentLocalToVworld[0];
            lightRetained.lastLocalToVworld[0] = this.lastLocalToVworld[0];
            this.initMirrorObject(lightRetained);
            setLiveState.nodeList.add(lightRetained);
            if (setLiveState.transformTargets != null) {
                setLiveState.transformTargets.add(lightRetained);
                setLiveState.transformTargetThreads |= 0x1080;
            }
            if (setLiveState.switchLevels[0] >= 0) {
                lightRetained.clearCompositeSwitchMask();
                lightRetained.isNewSwitchLeaf = true;
                ContainsNodes containsNodes = setLiveState.containsNodesList.getContainsNodes(0);
                containsNodes.envNodes.add(lightRetained);
            }
        }
        setLiveState.notifyThreads |= 0x1080;
        super.markAsLive();
    }

    void setScope(Group group, int n) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Object[] objectArray = new Object[3];
        GroupRetained groupRetained = (GroupRetained)this.scopes.get(n);
        this.tempKey.reset();
        groupRetained.getAllScopedNodes(arrayList2, this.tempKey);
        groupRetained = (GroupRetained)group.retained;
        this.tempKey.reset();
        groupRetained.getAllScopedNodes(arrayList, this.tempKey);
        this.initScope(group, n);
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        objectArray[0] = arrayList;
        objectArray[1] = arrayList2;
        objectArray[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, objectArray);
    }

    void update(int n, int n2, double d) {
    }

    void updateBoundingLeaf() {
        if (this.boundingLeaf != null && this.boundingLeaf.currentSwitchOn) {
            this.region = this.boundingLeaf.transformedRegion;
        } else if (this.regionOfInfluence != null) {
            this.region = (Bounds)this.regionOfInfluence.clone();
            this.region.transform(this.regionOfInfluence, this.currentLocalToVworld[0]);
        } else {
            this.region = null;
        }
    }

    void updateImmediateMirrorObject(Object[] objectArray) {
        block24: {
            Object e;
            int n;
            int n2;
            LightRetained[] lightRetainedArray;
            int n3;
            int n4;
            block27: {
                block26: {
                    block25: {
                        block23: {
                            Object var2_2 = null;
                            n4 = (Integer)objectArray[1];
                            n3 = (Integer)objectArray[2];
                            lightRetainedArray = (LightRetained[])objectArray[3];
                            if ((n4 & 8) == 0) break block23;
                            int n5 = 0;
                            while (n5 < n3) {
                                lightRetainedArray[n5].color.set((Tuple3f)((Color3f)objectArray[4]));
                                ++n5;
                            }
                            break block24;
                        }
                        if ((n4 & 1) == 0) break block25;
                        int n6 = 0;
                        while (n6 < n3) {
                            lightRetainedArray[n6].lightOn = (Boolean)objectArray[4];
                            ++n6;
                        }
                        break block24;
                    }
                    if ((n4 & 4) == 0) break block26;
                    int n7 = 0;
                    while (n7 < n3) {
                        lightRetainedArray[n7].regionOfInfluence = (Bounds)objectArray[4];
                        if (lightRetainedArray[n7].boundingLeaf == null) {
                            if (objectArray[4] != null) {
                                lightRetainedArray[n7].region = (Bounds)lightRetainedArray[n7].regionOfInfluence.clone();
                                lightRetainedArray[n7].region.transform(lightRetainedArray[n7].regionOfInfluence, lightRetainedArray[n7].currentLocalToVworld[0]);
                            } else {
                                lightRetainedArray[n7].region = null;
                            }
                        }
                        ++n7;
                    }
                    break block24;
                }
                if ((n4 & 0x10) == 0) break block27;
                int n8 = 0;
                while (n8 < n3) {
                    lightRetainedArray[n8].boundingLeaf = (BoundingLeafRetained)objectArray[4];
                    if (objectArray[4] != null) {
                        lightRetainedArray[n8].region = lightRetainedArray[n8].boundingLeaf.transformedRegion;
                    } else if (lightRetainedArray[n8].regionOfInfluence != null) {
                        lightRetainedArray[n8].region = (Bounds)lightRetainedArray[n8].regionOfInfluence.clone();
                        lightRetainedArray[n8].region.transform(lightRetainedArray[n8].regionOfInfluence, lightRetainedArray[n8].currentLocalToVworld[0]);
                    } else {
                        lightRetainedArray[n8].region = null;
                    }
                    ++n8;
                }
                break block24;
            }
            if ((n4 & 2) == 0) break block24;
            Object[] objectArray2 = (Object[])objectArray[4];
            ArrayList arrayList = (ArrayList)objectArray2[0];
            ArrayList arrayList2 = (ArrayList)objectArray2[1];
            boolean bl = (Boolean)objectArray2[2];
            if (arrayList != null) {
                n2 = 0;
                while (n2 < n3) {
                    lightRetainedArray[n2].isScoped = bl;
                    n = 0;
                    while (n < arrayList.size()) {
                        e = arrayList.get(n);
                        if (e instanceof GroupRetained) {
                            ((GroupRetained)e).addLight(lightRetainedArray[n2]);
                        } else if (e instanceof Shape3DRetained) {
                            ((Shape3DRetained)e).addLight(lightRetainedArray[n2]);
                        }
                        ++n;
                    }
                    ++n2;
                }
            }
            if (arrayList2 != null) {
                n2 = 0;
                while (n2 < n3) {
                    lightRetainedArray[n2].isScoped = bl;
                    n = 0;
                    while (n < arrayList2.size()) {
                        e = arrayList2.get(n);
                        if (e instanceof GroupRetained) {
                            ((GroupRetained)e).removeLight(lightRetainedArray[n2]);
                        } else if (e instanceof Shape3DRetained) {
                            ((Shape3DRetained)e).removeLight(lightRetainedArray[n2]);
                        }
                        ++n;
                    }
                    ++n2;
                }
            }
        }
    }

    void updateImmediateTransformChange() {
        if (this.boundingLeaf == null && this.regionOfInfluence != null) {
            this.region = (Bounds)this.regionOfInfluence.clone();
            this.region.transform(this.regionOfInfluence, this.currentLocalToVworld[0]);
        }
    }

    void updateMirrorObject(Object[] objectArray) {
        Object var2_2 = null;
        int n = (Integer)objectArray[1];
        int n2 = (Integer)objectArray[2];
        LightRetained[] lightRetainedArray = (LightRetained[])objectArray[3];
        if ((n & 8) != 0) {
            int n3 = 0;
            while (n3 < n2) {
                lightRetainedArray[n3].color.set((Tuple3f)((Color3f)objectArray[4]));
                ++n3;
            }
        }
    }

    void updateTransformChange() {
    }
}

