/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.io.InputStream;
import java.net.URL;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.SoundException;

class MediaContainerRetained
extends NodeComponentRetained {
    boolean cached = true;
    URL url = null;
    String urlString = null;
    InputStream inputStream = null;

    MediaContainerRetained() {
    }

    boolean getCacheEnable() {
        return this.cached;
    }

    InputStream getInputStream() {
        return this.inputStream;
    }

    URL getURLObject() {
        return this.url;
    }

    String getURLString() {
        return this.urlString;
    }

    void setCacheEnable(boolean bl) {
        this.cached = bl;
        this.notifyUsers();
    }

    void setInputStream(InputStream inputStream) {
        if (inputStream != null && (this.url != null || this.urlString != null)) {
            throw new IllegalArgumentException(J3dI18N.getString("MediaContainer5"));
        }
        this.inputStream = inputStream;
        this.notifyUsers();
    }

    void setURLObject(URL uRL) {
        if (uRL != null && (this.urlString != null || this.inputStream != null)) {
            throw new IllegalArgumentException(J3dI18N.getString("MediaContainer5"));
        }
        this.url = uRL;
        this.notifyUsers();
    }

    void setURLString(String string) {
        if (string != null && (this.url != null || this.inputStream != null)) {
            throw new IllegalArgumentException(J3dI18N.getString("MediaContainer5"));
        }
        this.urlString = string;
        if (string == null) {
            this.url = null;
        } else {
            try {
                this.url = new URL(string);
            }
            catch (Exception exception) {
                throw new SoundException(J3dI18N.getString("MediaContainer0"));
            }
        }
        this.notifyUsers();
    }
}

