/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.AlternateAppearanceRetained;
import javax.media.j3d.Appearance;
import javax.media.j3d.AppearanceRetained;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroupRetained;
import javax.media.j3d.ContainsNodes;
import javax.media.j3d.FogRetained;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.IndexedGeometryArrayRetained;
import javax.media.j3d.IndexedLineArray;
import javax.media.j3d.IndexedLineStripArray;
import javax.media.j3d.IndexedLineStripArrayRetained;
import javax.media.j3d.IndexedPointArray;
import javax.media.j3d.IndexedQuadArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.IndexedTriangleFanArray;
import javax.media.j3d.IndexedTriangleFanArrayRetained;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.IndexedTriangleStripArrayRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.LightRetained;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.LineStripArrayRetained;
import javax.media.j3d.ModelClipRetained;
import javax.media.j3d.Morph;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickShape;
import javax.media.j3d.PointArray;
import javax.media.j3d.QuadArray;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.SwitchRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleFanArrayRetained;
import javax.media.j3d.TriangleStripArray;
import javax.media.j3d.TriangleStripArrayRetained;
import javax.media.j3d.VirtualUniverse;

class MorphRetained
extends LeafRetained {
    static final int GEOMETRY_CHANGED = 1;
    static final int APPEARANCE_CHANGED = 2;
    static final int COLLISION_CHANGED = 4;
    static final int UPDATE_MORPH = 8;
    static final int BOUNDS_CHANGED = 16;
    static final int APPEARANCEOVERRIDE_CHANGED = 32;
    private static final double TOLERANCE = 1.0E-4;
    ArrayList mirrorShape3D = new ArrayList();
    static final int targetThreads = 192;
    AppearanceRetained appearance = null;
    GeometryArrayRetained[] geometryArrays;
    int numGeometryArrays = 0;
    double[] weights;
    BranchGroupRetained[] branchGroupPath;
    boolean isPickable = true;
    boolean isCollidable = true;
    ArrayList orderedGroupsPath = null;
    ArrayList orderedChildIdsPath = null;
    SwitchRetained closestSwitchParent = null;
    int closestSwitchIndex = -1;
    boolean visible = true;
    Bounds collisionBound = null;
    GeometryArray morphedGeometryArray = null;
    float[][] Mcoord = null;
    float[][] Mcolor = null;
    float[][] Mnormal = null;
    float[][][] MtexCoord = null;
    boolean appearanceOverrideEnable = false;

    MorphRetained() {
        this.nodeType = 10;
        this.localBounds = new BoundingBox();
        ((BoundingBox)this.localBounds).setLower(1.0, 1.0, 1.0);
        ((BoundingBox)this.localBounds).setUpper(-1.0, -1.0, -1.0);
    }

    void clearLive(SetLiveState setLiveState) {
        super.clearLive(setLiveState);
        if (this.appearance != null) {
            this.appearance.clearLive(setLiveState.refCount);
        }
        int n = 0;
        while (n < this.numGeometryArrays) {
            this.geometryArrays[n].clearLive(setLiveState.refCount);
            ++n;
        }
        if (this.inSharedGroup) {
            Object[] objectArray = this.mirrorShape3D.toArray();
            n = 0;
            while (n < setLiveState.keys.length) {
                int n2 = 0;
                while (n2 < objectArray.length) {
                    Shape3DRetained shape3DRetained = (Shape3DRetained)objectArray[n2];
                    if (shape3DRetained.key.equals(setLiveState.keys[n])) {
                        this.mirrorShape3D.remove(n2);
                        if (this.appearance != null) {
                            this.appearance.removeAMirrorUser(shape3DRetained);
                        }
                        setLiveState.nodeList.addAll(Shape3DRetained.getGeomAtomsList(shape3DRetained));
                        if (this.inOrderedGroup) {
                            shape3DRetained.orderedGroupsPath = null;
                            shape3DRetained.orderedChildIdsPath = null;
                        }
                    }
                    ++n2;
                }
                ++n;
            }
        } else {
            Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(0);
            this.mirrorShape3D.remove(0);
            if (this.appearance != null) {
                this.appearance.removeAMirrorUser(shape3DRetained);
            }
            setLiveState.nodeList.addAll(Shape3DRetained.getGeomAtomsList(shape3DRetained));
            if (this.inOrderedGroup) {
                shape3DRetained.orderedGroupsPath = null;
                shape3DRetained.orderedChildIdsPath = null;
            }
        }
        setLiveState.notifyThreads |= 0x10C0;
        this.morphedGeometryArray = null;
    }

    void computeCombineBounds(Bounds bounds) {
        if (this.boundsAutoCompute) {
            GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)this.morphedGeometryArray.retained;
            if (geometryArrayRetained != null) {
                BoundingBox boundingBox = geometryArrayRetained.geoBounds;
                synchronized (boundingBox) {
                    bounds.combine(geometryArrayRetained.geoBounds);
                }
            }
        } else {
            Bounds bounds2 = this.localBounds;
            synchronized (bounds2) {
                bounds.combine(this.localBounds);
            }
        }
    }

    void getAllScopedNodes(ArrayList arrayList, HashKey hashKey) {
        Shape3DRetained shape3DRetained = this.inSharedGroup ? this.getMirrorShape(hashKey) : (Shape3DRetained)this.mirrorShape3D.get(0);
        arrayList.add(shape3DRetained);
    }

    Appearance getAppearance() {
        return this.appearance == null ? null : (Appearance)this.appearance.source;
    }

    boolean getAppearanceOverrideEnable() {
        return this.appearanceOverrideEnable;
    }

    Bounds getBounds() {
        if (this.boundsAutoCompute) {
            GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)this.morphedGeometryArray.retained;
            if (geometryArrayRetained != null) {
                BoundingBox boundingBox = geometryArrayRetained.geoBounds;
                synchronized (boundingBox) {
                    Bounds bounds = (Bounds)geometryArrayRetained.geoBounds.clone();
                    Object var4_4 = null;
                    return bounds;
                }
            }
            return null;
        }
        return super.getBounds();
    }

    Bounds getCollisionBounds() {
        return this.collisionBound == null ? null : (Bounds)this.collisionBound.clone();
    }

    GeometryArray getGeometryArray(int n) {
        return (GeometryArray)this.geometryArrays[n].source;
    }

    Shape3DRetained getMirrorShape(HashKey hashKey) {
        int n = this.localToVworldKeys.length - 1;
        while (n >= 0) {
            if (this.localToVworldKeys[n].equals(hashKey)) {
                return (Shape3DRetained)this.mirrorShape3D.get(n);
            }
            --n;
        }
        throw new RuntimeException("Shape3DRetained: MirrorShape Not found!");
    }

    Shape3DRetained getMirrorShape(SceneGraphPath sceneGraphPath) {
        if (!this.inSharedGroup) {
            return (Shape3DRetained)this.mirrorShape3D.get(0);
        }
        HashKey hashKey = new HashKey("");
        sceneGraphPath.getHashKey(hashKey);
        return this.getMirrorShape(hashKey);
    }

    double[] getWeights() {
        return (double[])this.weights.clone();
    }

    void initMorphedGeometry() {
        GeometryArrayRetained geometryArrayRetained;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int[] nArray = null;
        int n5 = this.geometryArrays[0].getVertexFormat();
        int n6 = this.geometryArrays[0].getVertexCount();
        n3 = this.geometryArrays[0].getTexCoordSetCount();
        n4 = this.geometryArrays[0].getTexCoordSetMapLength();
        if (n4 > 0) {
            nArray = new int[n4];
            this.geometryArrays[0].getTexCoordSetMap(nArray);
        }
        int n7 = this.geometryArrays[0].geoType;
        switch (n7) {
            case 1: {
                this.morphedGeometryArray = new QuadArray(n6, n5, n3, nArray);
                break;
            }
            case 2: {
                this.morphedGeometryArray = new TriangleArray(n6, n5, n3, nArray);
                break;
            }
            case 3: {
                this.morphedGeometryArray = new PointArray(n6, n5, n3, nArray);
                break;
            }
            case 4: {
                this.morphedGeometryArray = new LineArray(n6, n5, n3, nArray);
                break;
            }
            case 5: {
                n2 = ((TriangleStripArrayRetained)this.geometryArrays[0]).getNumStrips();
                int[] nArray2 = new int[n2];
                ((TriangleStripArrayRetained)this.geometryArrays[0]).getStripVertexCounts(nArray2);
                this.morphedGeometryArray = new TriangleStripArray(n6, n5, n3, nArray, nArray2);
                break;
            }
            case 6: {
                n2 = ((TriangleFanArrayRetained)this.geometryArrays[0]).getNumStrips();
                int[] nArray2 = new int[n2];
                ((TriangleFanArrayRetained)this.geometryArrays[0]).getStripVertexCounts(nArray2);
                this.morphedGeometryArray = new TriangleFanArray(n6, n5, n3, nArray, nArray2);
                break;
            }
            case 7: {
                n2 = ((LineStripArrayRetained)this.geometryArrays[0]).getNumStrips();
                int[] nArray2 = new int[n2];
                ((LineStripArrayRetained)this.geometryArrays[0]).getStripVertexCounts(nArray2);
                this.morphedGeometryArray = new LineStripArray(n6, n5, n3, nArray, nArray2);
                break;
            }
            case 8: {
                n = ((IndexedGeometryArrayRetained)this.geometryArrays[0]).getIndexCount();
                this.morphedGeometryArray = new IndexedQuadArray(n6, n5, n3, nArray, n);
                break;
            }
            case 9: {
                n = ((IndexedGeometryArrayRetained)this.geometryArrays[0]).getIndexCount();
                this.morphedGeometryArray = new IndexedTriangleArray(n6, n5, n3, nArray, n);
                break;
            }
            case 10: {
                n = ((IndexedGeometryArrayRetained)this.geometryArrays[0]).getIndexCount();
                this.morphedGeometryArray = new IndexedPointArray(n6, n5, n3, nArray, n);
                break;
            }
            case 11: {
                n = ((IndexedGeometryArrayRetained)this.geometryArrays[0]).getIndexCount();
                this.morphedGeometryArray = new IndexedLineArray(n6, n5, n3, nArray, n);
                break;
            }
            case 12: {
                n = ((IndexedGeometryArrayRetained)this.geometryArrays[0]).getIndexCount();
                n2 = ((IndexedTriangleStripArrayRetained)this.geometryArrays[0]).getNumStrips();
                int[] nArray2 = new int[n2];
                ((IndexedTriangleStripArrayRetained)this.geometryArrays[0]).getStripIndexCounts(nArray2);
                this.morphedGeometryArray = new IndexedTriangleStripArray(n6, n5, n3, nArray, n, nArray2);
                break;
            }
            case 13: {
                n = ((IndexedGeometryArrayRetained)this.geometryArrays[0]).getIndexCount();
                n2 = ((IndexedTriangleFanArrayRetained)this.geometryArrays[0]).getNumStrips();
                int[] nArray2 = new int[n2];
                ((IndexedTriangleFanArrayRetained)this.geometryArrays[0]).getStripIndexCounts(nArray2);
                this.morphedGeometryArray = new IndexedTriangleFanArray(n6, n5, n3, nArray, n, nArray2);
                break;
            }
            case 14: {
                n = ((IndexedGeometryArrayRetained)this.geometryArrays[0]).getIndexCount();
                n2 = ((IndexedLineStripArrayRetained)this.geometryArrays[0]).getNumStrips();
                int[] nArray2 = new int[n2];
                ((IndexedLineStripArrayRetained)this.geometryArrays[0]).getStripIndexCounts(nArray2);
                this.morphedGeometryArray = new IndexedLineStripArray(n6, n5, n3, nArray, n, nArray2);
                break;
            }
        }
        if (this.geometryArrays[0] instanceof IndexedGeometryArrayRetained) {
            geometryArrayRetained = (IndexedGeometryArrayRetained)this.geometryArrays[0];
            IndexedGeometryArray indexedGeometryArray = (IndexedGeometryArray)this.morphedGeometryArray;
            if ((n5 & 1) != 0) {
                indexedGeometryArray.setCoordinateIndices(0, ((IndexedGeometryArrayRetained)geometryArrayRetained).indexCoord);
            }
            if ((n5 & 2) != 0) {
                indexedGeometryArray.setNormalIndices(0, ((IndexedGeometryArrayRetained)geometryArrayRetained).indexNormal);
            }
            if ((n5 & 4) != 0) {
                indexedGeometryArray.setColorIndices(0, ((IndexedGeometryArrayRetained)geometryArrayRetained).indexColor);
            }
            if ((n5 & 0x60) != 0) {
                int n8 = 0;
                while (n8 < n3) {
                    indexedGeometryArray.setTextureCoordinateIndices(n8, 0, (int[])((IndexedGeometryArrayRetained)geometryArrayRetained).indexTexCoord[n8]);
                    ++n8;
                }
            }
        }
        this.updateMorphedGeometryArray();
        if (this.geometryArrays[0] instanceof IndexedGeometryArrayRetained) {
            geometryArrayRetained = (GeometryArrayRetained)this.morphedGeometryArray.retained;
            geometryArrayRetained.geomLock.getLock();
            geometryArrayRetained.mirrorGeometry = (GeometryArrayRetained)((IndexedGeometryArrayRetained)geometryArrayRetained).cloneNonIndexedGeometry();
            geometryArrayRetained.geomLock.unLock();
        }
    }

    boolean intersect(SceneGraphPath sceneGraphPath, PickRay pickRay, double[] dArray) {
        Transform3D transform3D = null;
        transform3D = sceneGraphPath.getTransform();
        if (transform3D == null) {
            throw new RuntimeException(J3dI18N.getString("MorphRetained5"));
        }
        if (((GeometryRetained)this.morphedGeometryArray.retained).mirrorGeometry == null) {
            return ((GeometryRetained)this.morphedGeometryArray.retained).intersect(transform3D, pickRay, dArray);
        }
        return ((GeometryRetained)this.morphedGeometryArray.retained).mirrorGeometry.intersect(transform3D, pickRay, dArray);
    }

    boolean intersect(SceneGraphPath sceneGraphPath, PickShape pickShape) {
        Transform3D transform3D = null;
        transform3D = sceneGraphPath.getTransform();
        if (transform3D == null) {
            throw new RuntimeException(J3dI18N.getString("MorphRetained5"));
        }
        if (((GeometryRetained)this.morphedGeometryArray.retained).mirrorGeometry == null) {
            return ((GeometryRetained)this.morphedGeometryArray.retained).intersect(transform3D, pickShape);
        }
        return ((GeometryRetained)this.morphedGeometryArray.retained).mirrorGeometry.intersect(transform3D, pickShape);
    }

    void markAllNodesForScopedAltApp(AlternateAppearanceRetained alternateAppearanceRetained, HashKey hashKey) {
        Shape3DRetained shape3DRetained = this.inSharedGroup ? this.getMirrorShape(hashKey) : (Shape3DRetained)this.mirrorShape3D.get(0);
        shape3DRetained.addAltApp(alternateAppearanceRetained);
    }

    void markAllNodesForScopedFog(FogRetained fogRetained, HashKey hashKey) {
        Shape3DRetained shape3DRetained = this.inSharedGroup ? this.getMirrorShape(hashKey) : (Shape3DRetained)this.mirrorShape3D.get(0);
        shape3DRetained.addFog(fogRetained);
    }

    void markAllNodesForScopedLight(LightRetained lightRetained, HashKey hashKey) {
        Shape3DRetained shape3DRetained = this.inSharedGroup ? this.getMirrorShape(hashKey) : (Shape3DRetained)this.mirrorShape3D.get(0);
        shape3DRetained.addLight(lightRetained);
    }

    void markAllNodesForScopedModelClip(ModelClipRetained modelClipRetained, HashKey hashKey) {
        Shape3DRetained shape3DRetained = this.inSharedGroup ? this.getMirrorShape(hashKey) : (Shape3DRetained)this.mirrorShape3D.get(0);
        shape3DRetained.addModelClip(modelClipRetained);
    }

    void setAppearance(Appearance appearance) {
        boolean bl = false;
        if (((Morph)this.source).isLive()) {
            int n;
            if (appearance != null && ((AppearanceRetained)appearance.retained).getInImmCtx()) {
                throw new IllegalSharingException(J3dI18N.getString("MorphRetained4"));
            }
            if (this.appearance != null) {
                this.appearance.clearLive(this.refCount);
                n = this.mirrorShape3D.size() - 1;
                while (n >= 0) {
                    this.appearance.removeAMirrorUser((Shape3DRetained)this.mirrorShape3D.get(n));
                    --n;
                }
            }
            if (appearance != null) {
                ((AppearanceRetained)appearance.retained).setLive(this.inBackgroundGroup, this.refCount);
                this.appearance = (AppearanceRetained)appearance.retained;
                n = this.mirrorShape3D.size();
                int n2 = 0;
                while (n2 < n) {
                    this.appearance.addAMirrorUser((Shape3DRetained)this.mirrorShape3D.get(n2));
                    ++n2;
                }
                if (this.appearance.renderingAttributes != null && this.visible != this.appearance.renderingAttributes.visible) {
                    this.visible = this.appearance.renderingAttributes.visible;
                    bl = true;
                }
            } else if (!this.visible) {
                this.visible = true;
                bl = true;
            }
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 4224;
            if (bl) {
                j3dMessage.threads |= 0x40;
            }
            j3dMessage.type = 16;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(2);
            j3dMessage.args[2] = this.mirrorShape3D.clone();
            j3dMessage.args[3] = appearance == null ? null : this.appearance.mirror.clone();
            j3dMessage.args[4] = Shape3DRetained.getGeomAtomsList(this.mirrorShape3D);
            VirtualUniverse.mc.processMessage(j3dMessage);
        } else {
            this.appearance = appearance == null ? null : (AppearanceRetained)appearance.retained;
        }
    }

    void setAppearanceOverrideEnable(boolean bl) {
        if (((Morph)this.source).isLive()) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 4224;
            j3dMessage.type = 16;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(32);
            j3dMessage.args[2] = this.mirrorShape3D.clone();
            j3dMessage.args[3] = bl ? Boolean.TRUE : Boolean.FALSE;
            j3dMessage.args[4] = Shape3DRetained.getGeomAtomsList(this.mirrorShape3D);
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
        this.appearanceOverrideEnable = bl;
    }

    void setBounds(Bounds bounds) {
        super.setBounds(bounds);
        if (this.source.isLive() && !this.boundsAutoCompute) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.type = 35;
            j3dMessage.threads = 8384;
            j3dMessage.universe = this.universe;
            j3dMessage.args[1] = this.localBounds != null ? this.localBounds.clone() : null;
            int n = 0;
            while (n < this.mirrorShape3D.size()) {
                Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n);
                shape3DRetained.localBounds = (Bounds)j3dMessage.args[1];
                ++n;
            }
            j3dMessage.args[0] = Shape3DRetained.getGeomAtomsList(this.mirrorShape3D).toArray();
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void setBoundsAutoCompute(boolean bl) {
        if (bl != this.boundsAutoCompute) {
            if (!bl) {
                this.localBounds = this.getBounds();
            }
            super.setBoundsAutoCompute(bl);
            if (this.source.isLive()) {
                J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
                j3dMessage.type = 37;
                j3dMessage.threads = 8384;
                j3dMessage.universe = this.universe;
                j3dMessage.args[2] = bl ? null : (this.localBounds != null ? this.localBounds.clone() : null);
                int n = 0;
                while (n < this.mirrorShape3D.size()) {
                    Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n);
                    if (!bl) {
                        shape3DRetained.localBounds = (Bounds)j3dMessage.args[2];
                    }
                    ++n;
                }
                j3dMessage.args[0] = Shape3DRetained.getGeomAtomsList(this.mirrorShape3D).toArray();
                j3dMessage.args[1] = bl ? Boolean.TRUE : Boolean.FALSE;
                VirtualUniverse.mc.processMessage(j3dMessage);
            }
        }
    }

    void setCollisionBounds(Bounds bounds) {
        this.collisionBound = bounds != null ? (Bounds)bounds.clone() : null;
        if (this.source.isLive()) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.type = 34;
            j3dMessage.threads = 8192;
            j3dMessage.universe = this.universe;
            j3dMessage.args[1] = this.collisionBound.clone();
            int n = 0;
            while (n < this.mirrorShape3D.size()) {
                Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n);
                shape3DRetained.collisionBound = (Bounds)j3dMessage.args[1];
                ++n;
            }
            j3dMessage.args[0] = Shape3DRetained.getGeomAtomsList(this.mirrorShape3D).toArray();
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void setGeometryArrays(GeometryArray[] geometryArrayArray) {
        if (this.numGeometryArrays != 0 && this.numGeometryArrays != geometryArrayArray.length) {
            throw new IllegalArgumentException(J3dI18N.getString("MorphRetained0"));
        }
        this.numGeometryArrays = geometryArrayArray.length;
        int n = ((GeometryArrayRetained)geometryArrayArray[0].retained).vertexFormat;
        int n2 = ((GeometryArrayRetained)geometryArrayArray[0].retained).vertexCount;
        int n3 = ((GeometryArrayRetained)geometryArrayArray[0].retained).texCoordSetCount;
        int n4 = ((GeometryArrayRetained)geometryArrayArray[0].retained).geoType;
        this.geometryArrays = new GeometryArrayRetained[geometryArrayArray.length];
        this.geometryArrays[0] = (GeometryArrayRetained)geometryArrayArray[0].retained;
        int n5 = 1;
        while (n5 < this.numGeometryArrays) {
            if (n != ((GeometryArrayRetained)geometryArrayArray[n5].retained).vertexFormat || n2 != ((GeometryArrayRetained)geometryArrayArray[n5].retained).vertexCount || n3 != ((GeometryArrayRetained)geometryArrayArray[n5].retained).texCoordSetCount) {
                throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
            }
            GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)geometryArrayArray[n5].retained;
            if (n4 != geometryArrayRetained.geoType) {
                throw new IllegalArgumentException(J3dI18N.getString("MorphRetained2"));
            }
            if (((Morph)this.source).isLive()) {
                if (geometryArrayRetained.getInImmCtx()) {
                    throw new IllegalSharingException(J3dI18N.getString("MorphRetained3"));
                }
                if (this.geometryArrays[n5] != null) {
                    this.geometryArrays[n5].clearLive(this.refCount);
                }
                geometryArrayRetained.setLive(this.inBackgroundGroup, this.refCount);
            }
            this.geometryArrays[n5] = geometryArrayRetained;
            ++n5;
        }
        if (this.weights == null) {
            this.weights = new double[this.numGeometryArrays];
            this.weights[0] = 1.0;
            this.Mcoord = new float[n2][3];
            if ((n & 4) != 0) {
                this.Mcolor = new float[n2][4];
            }
            if ((n & 2) != 0) {
                this.Mnormal = new float[n2][3];
            }
            if ((n & 0x60) != 0) {
                this.MtexCoord = new float[n2][n3][3];
            }
        }
        this.initMorphedGeometry();
        if (this.source.isLive()) {
            this.updateMorphedGeometryArray();
            J3dMessage j3dMessage = null;
            j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.type = 16;
            j3dMessage.threads = 8256;
            if (this.geometryArrays[0] instanceof IndexedGeometryArrayRetained) {
                j3dMessage.threads |= 0x80;
            }
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(1);
            j3dMessage.args[2] = this.mirrorShape3D.clone();
            j3dMessage.args[3] = Shape3DRetained.getGeomAtomsList(this.mirrorShape3D).toArray();
            j3dMessage.universe = this.universe;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void setLive(SetLiveState setLiveState) {
        GeometryArrayRetained geometryArrayRetained = null;
        super.doSetLive(setLiveState);
        this.nodeId = this.universe.getNodeId();
        if (this.appearance != null) {
            if (this.appearance.getInImmCtx()) {
                throw new IllegalSharingException(J3dI18N.getString("MorphRetained4"));
            }
            this.appearance.setLive(this.inBackgroundGroup, setLiveState.refCount);
        }
        int n = 0;
        while (n < this.numGeometryArrays) {
            if (this.geometryArrays[n].getInImmCtx()) {
                throw new IllegalSharingException(J3dI18N.getString("MorphRetained9"));
            }
            this.geometryArrays[n].setLive(this.inBackgroundGroup, setLiveState.refCount);
            ++n;
        }
        if (this.morphedGeometryArray == null) {
            this.initMorphedGeometry();
        }
        if ((geometryArrayRetained = (GeometryArrayRetained)this.morphedGeometryArray.retained) != null) {
            geometryArrayRetained.computeBoundingBox();
            if (this.boundsAutoCompute) {
                this.localBounds.setWithLock(geometryArrayRetained.geoBounds);
            }
        }
        if (this.inSharedGroup) {
            n = 0;
            while (n < setLiveState.keys.length) {
                Shape3DRetained shape3DRetained = new Shape3DRetained();
                shape3DRetained.key = setLiveState.keys[n];
                shape3DRetained.currentLocalToVworld = new Transform3D[1];
                shape3DRetained.lastLocalToVworld = new Transform3D[1];
                int n2 = 0;
                while (n2 < this.currentLocalToVworld.length) {
                    if (this.localToVworldKeys[n2].equals(shape3DRetained.key)) break;
                    ++n2;
                }
                shape3DRetained.currentLocalToVworld[0] = this.currentLocalToVworld[n2];
                shape3DRetained.lastLocalToVworld[0] = this.lastLocalToVworld[n2];
                shape3DRetained.branchGroupPath = (BranchGroupRetained[])this.branchGroupPaths.get(n2);
                shape3DRetained.isPickable = setLiveState.pickable[n];
                shape3DRetained.isCollidable = setLiveState.collidable[n];
                if (this.inOrderedGroup) {
                    shape3DRetained.orderedGroupsPath = (ArrayList)setLiveState.orderedGroupsPath.clone();
                    shape3DRetained.orderedChildIdsPath = (ArrayList)setLiveState.orderedChildIdsPath.clone();
                }
                shape3DRetained.initMirrorShape3D(this);
                this.mirrorShape3D.add(shape3DRetained);
                if (this.appearance != null) {
                    this.appearance.addAMirrorUser(shape3DRetained);
                }
                setLiveState.nodeList.addAll(Shape3DRetained.getGeomAtomsList(shape3DRetained));
                if (setLiveState.transformTargets != null) {
                    setLiveState.transformTargets.addAll(Shape3DRetained.getGeomAtomsList(shape3DRetained));
                    setLiveState.transformTargetThreads |= 0x20C0;
                }
                if (setLiveState.switchLevels[n] >= 0) {
                    shape3DRetained.clearCompositeSwitchMask();
                    shape3DRetained.isNewSwitchLeaf = true;
                    ContainsNodes containsNodes = setLiveState.containsNodesList.getContainsNodes(setLiveState.keys[n]);
                    containsNodes.geoNodes.add(shape3DRetained);
                    shape3DRetained.closestSwitchParent = setLiveState.closestSwitchParents[n];
                    shape3DRetained.closestSwitchIndex = setLiveState.closestSwitchIndices[n];
                }
                ++n;
            }
        } else {
            Shape3DRetained shape3DRetained = new Shape3DRetained();
            shape3DRetained.currentLocalToVworld = new Transform3D[1];
            shape3DRetained.lastLocalToVworld = new Transform3D[1];
            shape3DRetained.currentLocalToVworld[0] = this.currentLocalToVworld[0];
            shape3DRetained.lastLocalToVworld[0] = this.lastLocalToVworld[0];
            shape3DRetained.branchGroupPath = (BranchGroupRetained[])this.branchGroupPaths.get(0);
            shape3DRetained.isPickable = setLiveState.pickable[0];
            shape3DRetained.isCollidable = setLiveState.collidable[0];
            if (this.inOrderedGroup) {
                shape3DRetained.orderedGroupsPath = (ArrayList)setLiveState.orderedGroupsPath.clone();
                shape3DRetained.orderedChildIdsPath = (ArrayList)setLiveState.orderedChildIdsPath.clone();
            }
            shape3DRetained.initMirrorShape3D(this);
            this.mirrorShape3D.add(shape3DRetained);
            if (this.appearance != null) {
                this.appearance.addAMirrorUser(shape3DRetained);
            }
            setLiveState.nodeList.addAll(Shape3DRetained.getGeomAtomsList(shape3DRetained));
            if (setLiveState.transformTargets != null) {
                setLiveState.transformTargets.addAll(Shape3DRetained.getGeomAtomsList(shape3DRetained));
                setLiveState.transformTargetThreads |= 0x20C0;
            }
            if (setLiveState.switchLevels[0] >= 0) {
                shape3DRetained.clearCompositeSwitchMask();
                shape3DRetained.isNewSwitchLeaf = true;
                ContainsNodes containsNodes = setLiveState.containsNodesList.getContainsNodes(0);
                containsNodes.geoNodes.add(shape3DRetained);
                shape3DRetained.closestSwitchParent = setLiveState.closestSwitchParents[0];
                shape3DRetained.closestSwitchIndex = setLiveState.closestSwitchIndices[0];
            }
        }
        setLiveState.notifyThreads |= 0x4C0;
        super.markAsLive();
    }

    void setWeights(double[] dArray) {
        double d = 0.0;
        if (dArray.length != this.numGeometryArrays) {
            throw new IllegalArgumentException(J3dI18N.getString("MorphRetained7"));
        }
        int n = dArray.length - 1;
        while (n >= 0) {
            d += dArray[n];
            --n;
        }
        if (Math.abs(d - 1.0) > 1.0E-4) {
            throw new IllegalArgumentException(J3dI18N.getString("MorphRetained8"));
        }
        n = this.numGeometryArrays - 1;
        while (n >= 0) {
            this.weights[n] = dArray[n];
            --n;
        }
        if (this.source.isLive()) {
            this.updateMorphedGeometryArray();
            J3dMessage j3dMessage = null;
            j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.type = 16;
            j3dMessage.threads = 8256;
            if (this.geometryArrays[0] instanceof IndexedGeometryArrayRetained) {
                j3dMessage.threads |= 0x80;
            }
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(1);
            j3dMessage.args[2] = this.mirrorShape3D.clone();
            j3dMessage.args[3] = Shape3DRetained.getGeomAtomsList(this.mirrorShape3D).toArray();
            j3dMessage.universe = this.universe;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void updateCollidable(HashKey[] hashKeyArray, boolean[] blArray) {
        super.updateCollidable(hashKeyArray, blArray);
        if (!this.inSharedGroup) {
            Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(0);
            shape3DRetained.isCollidable = blArray[0];
        } else {
            int n = this.mirrorShape3D.size();
            int n2 = 0;
            while (n2 < hashKeyArray.length) {
                int n3 = 0;
                while (n3 < n) {
                    Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n3);
                    if (hashKeyArray[n2].equals(shape3DRetained.key)) {
                        shape3DRetained.isCollidable = blArray[n2];
                        break;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
    }

    void updateImmediateMirrorObject(Object[] objectArray) {
        int n;
        int n2 = (Integer)objectArray[1];
        ArrayList arrayList = (ArrayList)objectArray[2];
        if (n2 == 2) {
            n = arrayList.size() - 1;
            while (n >= 0) {
                ((Shape3DRetained)arrayList.get((int)n)).appearance = (AppearanceRetained)objectArray[3];
                --n;
            }
        }
        if ((n2 & 0x20) != 0) {
            n = 0;
            while (n < arrayList.size()) {
                ((Shape3DRetained)arrayList.get((int)n)).appearanceOverrideEnable = (Boolean)objectArray[3];
                ++n;
            }
        }
    }

    synchronized void updateMorphedGeometryArray() {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        float[] fArray = new float[3];
        float[] fArray2 = new float[4];
        float[] fArray3 = new float[3];
        float[] fArray4 = new float[3];
        int n3 = this.geometryArrays[0].vertexFormat;
        int n4 = this.geometryArrays[0].vertexCount;
        int n5 = this.geometryArrays[0].geoType;
        n2 = this.geometryArrays[0].getTexCoordSetCount();
        int n6 = 0;
        while (n6 < n4) {
            this.Mcoord[n6][2] = 0.0f;
            this.Mcoord[n6][1] = 0.0f;
            this.Mcoord[n6][0] = 0.0f;
            if ((n3 & 4) != 0) {
                this.Mcolor[n6][3] = 0.0f;
                this.Mcolor[n6][2] = 0.0f;
                this.Mcolor[n6][1] = 0.0f;
                this.Mcolor[n6][0] = 0.0f;
            }
            if ((n3 & 2) != 0) {
                this.Mnormal[n6][2] = 0.0f;
                this.Mnormal[n6][1] = 0.0f;
                this.Mnormal[n6][0] = 0.0f;
            }
            if ((n3 & 0x60) != 0) {
                n = 0;
                while (n < n2) {
                    this.MtexCoord[n6][n][2] = 0.0f;
                    this.MtexCoord[n6][n][1] = 0.0f;
                    this.MtexCoord[n6][n][0] = 0.0f;
                    ++n;
                }
            }
            ++n6;
        }
        int n7 = 0;
        while (n7 < this.numGeometryArrays) {
            double d = this.weights[n7];
            if (d != 0.0) {
                n6 = n4 - 1;
                while (n6 >= 0) {
                    this.geometryArrays[n7].getCoordinate(n6, fArray);
                    float[] fArray5 = this.Mcoord[n6];
                    fArray5[0] = (float)((double)fArray5[0] + (double)fArray[0] * d);
                    float[] fArray6 = this.Mcoord[n6];
                    fArray6[1] = (float)((double)fArray6[1] + (double)fArray[1] * d);
                    float[] fArray7 = this.Mcoord[n6];
                    fArray7[2] = (float)((double)fArray7[2] + (double)fArray[2] * d);
                    --n6;
                }
                if ((n3 & 4) != 0) {
                    n6 = n4 - 1;
                    while (n6 >= 0) {
                        this.geometryArrays[n7].getColor(n6, fArray2);
                        float[] fArray8 = this.Mcolor[n6];
                        fArray8[0] = (float)((double)fArray8[0] + (double)fArray2[0] * d);
                        float[] fArray9 = this.Mcolor[n6];
                        fArray9[1] = (float)((double)fArray9[1] + (double)fArray2[1] * d);
                        float[] fArray10 = this.Mcolor[n6];
                        fArray10[2] = (float)((double)fArray10[2] + (double)fArray2[2] * d);
                        if ((n3 & 8) != 0) {
                            float[] fArray11 = this.Mcolor[n6];
                            fArray11[3] = (float)((double)fArray11[3] + (double)fArray2[3] * d);
                        }
                        --n6;
                    }
                }
                if ((n3 & 2) != 0) {
                    n6 = n4 - 1;
                    while (n6 >= 0) {
                        this.geometryArrays[n7].getNormal(n6, fArray3);
                        float[] fArray12 = this.Mnormal[n6];
                        fArray12[0] = (float)((double)fArray12[0] + (double)fArray3[0] * d);
                        float[] fArray13 = this.Mnormal[n6];
                        fArray13[1] = (float)((double)fArray13[1] + (double)fArray3[1] * d);
                        float[] fArray14 = this.Mnormal[n6];
                        fArray14[2] = (float)((double)fArray14[2] + (double)fArray3[2] * d);
                        --n6;
                    }
                }
                if ((n3 & 0x60) != 0) {
                    n6 = n4 - 1;
                    while (n6 >= 0) {
                        n = 0;
                        while (n < n2) {
                            this.geometryArrays[n7].getTextureCoordinate(n, n6, fArray4);
                            float[] fArray15 = this.MtexCoord[n6][n];
                            fArray15[0] = (float)((double)fArray15[0] + (double)fArray4[0] * d);
                            float[] fArray16 = this.MtexCoord[n6][n];
                            fArray16[1] = (float)((double)fArray16[1] + (double)fArray4[1] * d);
                            if ((n3 & 0x40) != 0) {
                                float[] fArray17 = this.MtexCoord[n6][n];
                                fArray17[2] = (float)((double)fArray17[2] + (double)fArray4[2] * d);
                            }
                            ++n;
                        }
                        --n6;
                    }
                }
            }
            ++n7;
        }
        n6 = n4 - 1;
        while (n6 >= 0) {
            this.morphedGeometryArray.setCoordinate(n6, this.Mcoord[n6]);
            if ((n3 & 4) != 0) {
                this.morphedGeometryArray.setColor(n6, this.Mcolor[n6]);
            }
            if ((n3 & 2) != 0) {
                this.morphedGeometryArray.setNormal(n6, this.Mnormal[n6]);
            }
            if ((n3 & 0x60) != 0) {
                n = 0;
                while (n < n2) {
                    this.morphedGeometryArray.setTextureCoordinate(n, n6, this.MtexCoord[n6][n]);
                    ++n;
                }
            }
            --n6;
        }
    }

    void updatePickable(HashKey[] hashKeyArray, boolean[] blArray) {
        super.updatePickable(hashKeyArray, blArray);
        if (!this.inSharedGroup) {
            Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(0);
            shape3DRetained.isPickable = blArray[0];
        } else {
            int n = this.mirrorShape3D.size();
            int n2 = 0;
            while (n2 < hashKeyArray.length) {
                int n3 = 0;
                while (n3 < n) {
                    Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(n3);
                    if (hashKeyArray[n2].equals(shape3DRetained.key)) {
                        shape3DRetained.isPickable = blArray[n2];
                        break;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
    }
}

