/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributesRetained;
import javax.media.j3d.CompressedGeometryRetained;
import javax.media.j3d.DisplayListRenderMethod;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.LineAttributesRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.MaterialRetained;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.OrientedShape3DRetained;
import javax.media.j3d.PointAttributesRetained;
import javax.media.j3d.PolygonAttributesRetained;
import javax.media.j3d.RasterRetained;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.RenderBin;
import javax.media.j3d.RenderMethod;
import javax.media.j3d.RenderingAttributesRetained;
import javax.media.j3d.TextureBin;
import javax.media.j3d.TextureUnitStateRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransparencyAttributesRetained;
import javax.media.j3d.VertexArrayRenderMethod;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Vector3d;

class RenderMolecule
implements ObjectUpdate {
    static final int POINT = 1;
    static final int LINE = 2;
    static final int SURFACE = 4;
    static final int RASTER = 8;
    static final int COMPRESSED = 16;
    static final int POINTATTRS = 1;
    static final int LINEATTRS = 2;
    static final int POLYGONATTRS = 4;
    static final int MATERIAL = 8;
    static final int TRANSPARENCY = 16;
    static final int COLORINGATTRS = 32;
    static final int ALL_DIRTY_BITS = 63;
    int dirtyAttrsAcrossRms = 63;
    PolygonAttributesRetained definingPolygonAttributes = null;
    LineAttributesRetained definingLineAttributes = null;
    PointAttributesRetained definingPointAttributes = null;
    TextureBin textureBin = null;
    Transform3D localToVworld = null;
    MaterialRetained definingMaterial = null;
    ColoringAttributesRetained definingColoringAttributes = null;
    TransparencyAttributesRetained definingTransparency = null;
    int numRenderAtoms = 0;
    ArrayList addRAs = new ArrayList();
    ArrayList removeRAs = new ArrayList();
    float red = 1.0f;
    float green = 1.0f;
    float blue = 1.0f;
    float dRed = 1.0f;
    float dGreen = 1.0f;
    float dBlue = 1.0f;
    float alpha = 0.0f;
    int geometryType = -1;
    boolean enableLighting = false;
    int primaryMoleculeType = 0;
    static int COMPRESSED_MOLECULE = 1;
    static int TEXT3D_MOLECULE = 2;
    static int DLIST_MOLECULE = 4;
    static int RASTER_MOLECULE = 8;
    static int ORIENTEDSHAPE3D_MOLECULE = 16;
    int polygonMode = 2;
    boolean lineAA = false;
    boolean pointAA = false;
    int vertexFormat = -1;
    RenderMethod primaryRenderMethod = null;
    RenderMethod secondaryRenderMethod = null;
    RenderBin renderBin = null;
    RenderMolecule next = null;
    RenderMolecule prev = null;
    RenderAtom primaryRenderAtomList = null;
    RenderAtom vertexArrayRenderAtomList = null;
    BoundingBox vwcBounds = null;
    int displayListId = 0;
    Integer displayListIdObj = null;
    int onUpdateList = 0;
    static int NEW_RENDERATOMS_UPDATE = 1;
    static int BOUNDS_RECOMPUTE_UPDATE = 2;
    static int LOCALE_TRANSLATION = 4;
    boolean doInfinite;
    Transform3D infLocalToVworld = new Transform3D();
    boolean useAlpha = false;
    Locale locale = null;
    Transform3D localeLocalToVworld = null;
    Vector3d localeTranslation = new Vector3d();

    RenderMolecule(GeometryAtom geometryAtom, PolygonAttributesRetained polygonAttributesRetained, LineAttributesRetained lineAttributesRetained, PointAttributesRetained pointAttributesRetained, MaterialRetained materialRetained, ColoringAttributesRetained coloringAttributesRetained, TransparencyAttributesRetained transparencyAttributesRetained, Transform3D transform3D, RenderBin renderBin) {
        this.renderBin = renderBin;
        this.reset(geometryAtom, polygonAttributesRetained, lineAttributesRetained, pointAttributesRetained, materialRetained, coloringAttributesRetained, transparencyAttributesRetained, transform3D);
    }

    void addRenderAtom(RenderAtom renderAtom, RenderBin renderBin) {
        renderAtom.envSet = this.textureBin.attributeBin.environmentSet;
        renderAtom.renderMolecule = this;
        if ((this.primaryMoleculeType & (COMPRESSED_MOLECULE | RASTER_MOLECULE | TEXT3D_MOLECULE | ORIENTEDSHAPE3D_MOLECULE)) != 0) {
            renderAtom.inPrimaryArray = RenderAtom.OTHER;
        } else if (!(VirtualUniverse.mc.isD3D() || !(renderAtom.geometryAtom.geometry instanceof GeometryArrayRetained) || (((GeometryArrayRetained)renderAtom.geometryAtom.geometry).vertexFormat & 0x80) != 0 || ((GeometryArrayRetained)renderAtom.geometryAtom.geometry).texCoordSetMap != null && ((GeometryArrayRetained)renderAtom.geometryAtom.geometry).texCoordSetMap.length > 1 || renderAtom.geometryAtom.geometry.refCount != 1 || renderAtom.geometryAtom.alphaEditable)) {
            renderAtom.inPrimaryArray = RenderAtom.DLIST;
            if (this.primaryRenderMethod == null) {
                this.primaryMoleculeType = DLIST_MOLECULE;
                this.vwcBounds = new BoundingBox(null);
                this.primaryRenderMethod = VirtualUniverse.mc.getDisplayListRenderMethod();
            }
        } else {
            renderAtom.inPrimaryArray = 0;
            if (this.secondaryRenderMethod == null) {
                this.secondaryRenderMethod = VirtualUniverse.mc.getVertexArrayRenderMethod();
            }
        }
        if (this.removeRAs.contains(renderAtom)) {
            this.removeRAs.remove(this.removeRAs.indexOf(renderAtom));
            if (this.removeRAs.size() == 0) {
                renderBin.removeRenderAtomInRMList.remove(renderBin.removeRenderAtomInRMList.indexOf(this));
            }
        } else {
            this.addRAs.add(renderAtom);
            if (this.onUpdateList == 0) {
                renderBin.objUpdateList.add(this);
            }
            this.onUpdateList |= NEW_RENDERATOMS_UPDATE;
        }
    }

    void checkEquivalenceWithBothNeighbors() {
        RenderMolecule renderMolecule = this.prev;
        RenderMolecule renderMolecule2 = this.next;
        this.dirtyAttrsAcrossRms = 63;
        boolean bl = true;
        if (this.prev != null) {
            this.checkEquivalenceWithLeftNeighbor();
        }
        if (this.next != null) {
            if ((this.vertexFormat & 4) == 0 || (this.vertexFormat & 4) != 0 && (this.next.vertexFormat & 4) != 0) {
                bl = false;
            }
            this.next.dirtyAttrsAcrossRms = 63;
            if (!bl && (this.next.definingMaterial == this.definingMaterial || this.next.definingMaterial != null && this.next.definingMaterial.equivalent(this.definingMaterial) && this.next.alpha == this.alpha && this.enableLighting == this.next.enableLighting && (this.enableLighting || !this.enableLighting && this.next.red == this.red && this.next.green == this.green && this.next.blue == this.blue))) {
                this.next.dirtyAttrsAcrossRms &= 0xFFFFFFF7;
            }
            if (this.next.definingPolygonAttributes == this.definingPolygonAttributes || this.next.definingPolygonAttributes != null && this.next.definingPolygonAttributes.equivalent(this.definingPolygonAttributes)) {
                this.next.dirtyAttrsAcrossRms &= 0xFFFFFFFB;
            }
            if (this.next.definingPointAttributes == this.definingPointAttributes || this.next.definingPointAttributes != null && this.next.definingPointAttributes.equivalent(this.definingPointAttributes)) {
                this.next.dirtyAttrsAcrossRms &= 0xFFFFFFFE;
            }
            if (this.next.definingLineAttributes == this.definingLineAttributes || this.next.definingLineAttributes != null && this.next.definingLineAttributes.equivalent(this.definingLineAttributes)) {
                this.next.dirtyAttrsAcrossRms &= 0xFFFFFFFD;
            }
            if (!bl && (this.next.definingColoringAttributes == this.definingColoringAttributes || this.next.definingColoringAttributes != null && this.next.definingColoringAttributes.equivalent(this.definingColoringAttributes))) {
                this.next.dirtyAttrsAcrossRms &= 0xFFFFFFDF;
            }
            if (this.next.definingTransparency == this.definingTransparency || this.next.definingTransparency != null && this.next.definingTransparency.equivalent(this.definingTransparency)) {
                this.next.dirtyAttrsAcrossRms &= 0xFFFFFFEF;
            }
        }
    }

    void checkEquivalenceWithLeftNeighbor() {
        boolean bl = true;
        if ((this.prev.vertexFormat & 4) == 0 || (this.prev.vertexFormat & 4) != 0 && (this.vertexFormat & 4) != 0) {
            bl = false;
        }
        this.dirtyAttrsAcrossRms = 63;
        if (!bl && (this.prev.definingMaterial == this.definingMaterial || this.prev.definingMaterial != null && this.prev.definingMaterial.equivalent(this.definingMaterial) && this.prev.alpha == this.alpha && this.enableLighting == this.prev.enableLighting && (this.enableLighting || !this.enableLighting && this.prev.red == this.red && this.prev.green == this.green && this.prev.blue == this.blue))) {
            this.dirtyAttrsAcrossRms &= 0xFFFFFFF7;
        }
        if (this.prev.definingPolygonAttributes == this.definingPolygonAttributes || this.prev.definingPolygonAttributes != null && this.prev.definingPolygonAttributes.equivalent(this.definingPolygonAttributes)) {
            this.dirtyAttrsAcrossRms &= 0xFFFFFFFB;
        }
        if (this.prev.definingPointAttributes == this.definingPointAttributes || this.prev.definingPointAttributes != null && this.prev.definingPointAttributes.equivalent(this.definingPointAttributes)) {
            this.dirtyAttrsAcrossRms &= 0xFFFFFFFE;
        }
        if (this.prev.definingLineAttributes == this.definingLineAttributes || this.prev.definingLineAttributes != null && this.prev.definingLineAttributes.equivalent(this.definingLineAttributes)) {
            this.dirtyAttrsAcrossRms &= 0xFFFFFFFD;
        }
        if (!bl && (this.prev.definingColoringAttributes == this.definingColoringAttributes || this.prev.definingColoringAttributes != null && this.prev.definingColoringAttributes.equivalent(this.definingColoringAttributes))) {
            this.dirtyAttrsAcrossRms &= 0xFFFFFFDF;
        }
        if (this.prev.definingTransparency == this.definingTransparency || this.prev.definingTransparency != null && this.prev.definingTransparency.equivalent(this.definingTransparency)) {
            this.dirtyAttrsAcrossRms &= 0xFFFFFFEF;
        }
    }

    void doTextureErrorChecking() {
        if (this.vertexFormat != -1 && this.primaryMoleculeType != COMPRESSED_MOLECULE && this.textureBin.texUnitState != null) {
            TextureUnitStateRetained[] textureUnitStateRetainedArray = this.textureBin.texUnitState;
            int n = 0;
            while (n < textureUnitStateRetainedArray.length) {
                boolean bl = textureUnitStateRetainedArray[n] != null && textureUnitStateRetainedArray[n].isTextureEnabled() && (textureUnitStateRetainedArray[n].texGen == null || !textureUnitStateRetainedArray[n].texGen.enable) && (this.vertexFormat & 0x60) == 0;
                ++n;
            }
        }
    }

    boolean equals(RenderAtom renderAtom, PolygonAttributesRetained polygonAttributesRetained, LineAttributesRetained lineAttributesRetained, PointAttributesRetained pointAttributesRetained, MaterialRetained materialRetained, ColoringAttributesRetained coloringAttributesRetained, TransparencyAttributesRetained transparencyAttributesRetained, Transform3D transform3D) {
        int n = 0;
        GeometryAtom geometryAtom = renderAtom.geometryAtom;
        boolean bl = false;
        if (renderAtom.isOriented && this.primaryMoleculeType != ORIENTEDSHAPE3D_MOLECULE) {
            return false;
        }
        block0 : switch (geometryAtom.geometry.geoType) {
            case 3: 
            case 10: {
                n = 1;
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 14: {
                n = 2;
                break;
            }
            case 15: {
                n = 8;
                break;
            }
            case 17: {
                n = 16;
                switch (((CompressedGeometryRetained)geometryAtom.geometry).getBufferType()) {
                    case 0: {
                        n |= 1;
                        break block0;
                    }
                    case 1: {
                        n |= 2;
                        break block0;
                    }
                }
                n |= 4;
                break;
            }
            default: {
                n = 4;
                if (polygonAttributesRetained == null) break;
                if (polygonAttributesRetained.polygonMode == 0) {
                    n |= 1;
                    break;
                }
                if (polygonAttributesRetained.polygonMode != 1) break;
                n |= 2;
            }
        }
        if (this.geometryType != n) {
            return false;
        }
        if (geometryAtom.geoType == 16 && (this.primaryMoleculeType & TEXT3D_MOLECULE) == 0) {
            return false;
        }
        if (geometryAtom.geometry instanceof GeometryArrayRetained) {
            GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)geometryAtom.geometry;
            if (this.vertexFormat != geometryArrayRetained.vertexFormat) {
                return false;
            }
        } else if (geometryAtom.geometry instanceof CompressedGeometryRetained ? this.vertexFormat != ((CompressedGeometryRetained)geometryAtom.geometry).getVertexFormat() : this.vertexFormat != -1) {
            return false;
        }
        if (!(this.definingPolygonAttributes == polygonAttributesRetained || this.definingPolygonAttributes != null && this.definingPolygonAttributes.equivalent(polygonAttributesRetained))) {
            return false;
        }
        if (!(this.definingLineAttributes == lineAttributesRetained || this.definingLineAttributes != null && this.definingLineAttributes.equivalent(lineAttributesRetained))) {
            return false;
        }
        if (!(this.definingPointAttributes == pointAttributesRetained || this.definingPointAttributes != null && this.definingPointAttributes.equivalent(pointAttributesRetained))) {
            return false;
        }
        if (!(this.definingMaterial == materialRetained || this.definingMaterial != null && this.definingMaterial.equivalent(materialRetained))) {
            return false;
        }
        if (!(this.definingColoringAttributes == coloringAttributesRetained || this.definingColoringAttributes != null && this.definingColoringAttributes.equivalent(coloringAttributesRetained))) {
            return false;
        }
        if (!(this.definingTransparency == transparencyAttributesRetained || this.definingTransparency != null && this.definingTransparency.equivalent(transparencyAttributesRetained))) {
            return false;
        }
        if (this.localToVworld != transform3D) {
            return false;
        }
        return this.locale == renderAtom.geometryAtom.source.locale;
    }

    void evalAlphaUsage() {
        boolean bl = false;
        boolean bl2 = this.definingTransparency != null && this.definingTransparency.transparencyMode != 4 && (VirtualUniverse.mc.isD3D() || !VirtualUniverse.mc.isD3D() && this.definingTransparency.transparencyMode != 3);
        RenderingAttributesRetained renderingAttributesRetained = this.textureBin.attributeBin.definingRenderingAttributes;
        if (this.textureBin.texUnitState != null) {
            int n = 0;
            while (!bl && n < this.textureBin.texUnitState.length) {
                if (this.textureBin.texUnitState[n] != null && this.textureBin.texUnitState[n].texAttrs != null) {
                    bl = bl || this.textureBin.texUnitState[n].texAttrs.textureMode == 4;
                }
                ++n;
            }
        }
        boolean bl3 = renderingAttributesRetained != null && renderingAttributesRetained.alphaTestFunction != 0;
        this.useAlpha = bl2 || bl3 || bl;
    }

    void recalcBounds() {
        if (this.primaryRenderMethod == VirtualUniverse.mc.getDisplayListRenderMethod()) {
            this.vwcBounds.set(null);
            RenderAtom renderAtom = this.primaryRenderAtomList;
            while (renderAtom != null) {
                this.vwcBounds.combine(renderAtom.localeVwcBounds);
                renderAtom = renderAtom.next;
            }
        }
    }

    void removeRenderAtom(RenderAtom renderAtom) {
        if (this.removeRAs.contains(renderAtom)) {
            System.out.println("RenderMolecule : removeRenderMolecule: something is wrong!");
        }
        renderAtom.renderMolecule = null;
        if (this.addRAs.contains(renderAtom)) {
            this.addRAs.remove(this.addRAs.indexOf(renderAtom));
            renderAtom.envSet = null;
            if (this.addRAs.size() == 0) {
                if (this.onUpdateList == NEW_RENDERATOMS_UPDATE) {
                    this.renderBin.objUpdateList.remove(this.renderBin.objUpdateList.indexOf(this));
                }
                this.onUpdateList &= ~NEW_RENDERATOMS_UPDATE;
            }
        } else {
            this.removeRAs.add(renderAtom);
            if (!this.renderBin.removeRenderAtomInRMList.contains(this)) {
                this.renderBin.removeRenderAtomInRMList.add(this);
            }
        }
    }

    void render(Canvas3D canvas3D, int n) {
        boolean bl = false;
        if (this.primaryRenderAtomList != null) {
            bl = this.primaryRenderAtomList.geometryAtom.source.lastSwitchOn;
        } else if (this.vertexArrayRenderAtomList != null) {
            bl = this.vertexArrayRenderAtomList.geometryAtom.source.lastSwitchOn;
        }
        if (!bl) {
            return;
        }
        int n2 = this.geometryType | 8 | 0x20 | 0x10;
        if ((canvas3D.canvasDirty & n2) != 0) {
            if ((this.geometryType & 4) != 0) {
                if (this.definingPolygonAttributes == null) {
                    canvas3D.resetPolygonAttributes(canvas3D.ctx);
                } else {
                    this.definingPolygonAttributes.updateNative(canvas3D.ctx);
                }
                canvas3D.polygonAttributes = this.definingPolygonAttributes;
            }
            if ((this.geometryType & 2) != 0) {
                if (this.definingLineAttributes == null) {
                    canvas3D.resetLineAttributes(canvas3D.ctx);
                } else {
                    this.definingLineAttributes.updateNative(canvas3D.ctx);
                }
                canvas3D.lineAttributes = this.definingLineAttributes;
            }
            if ((this.geometryType & 1) != 0) {
                if (this.definingPointAttributes == null) {
                    canvas3D.resetPointAttributes(canvas3D.ctx);
                } else {
                    this.definingPointAttributes.updateNative(canvas3D.ctx);
                }
                canvas3D.pointAttributes = this.definingPointAttributes;
            }
            if (this.definingMaterial == null) {
                canvas3D.updateMaterial(canvas3D.ctx, this.red, this.green, this.blue, this.alpha);
            } else {
                this.definingMaterial.updateNative(canvas3D.ctx, this.red, this.green, this.blue, this.alpha, this.enableLighting);
            }
            canvas3D.material = this.definingMaterial;
            if (this.definingTransparency == null) {
                canvas3D.resetTransparency(canvas3D.ctx, this.polygonMode, this.lineAA, this.pointAA);
            } else {
                this.definingTransparency.updateNative(canvas3D.ctx, this.alpha, this.polygonMode, this.lineAA, this.pointAA);
            }
            canvas3D.transparency = this.definingTransparency;
            if (this.definingColoringAttributes == null) {
                canvas3D.resetColoringAttributes(canvas3D.ctx, this.red, this.green, this.blue, this.alpha, this.enableLighting);
            } else {
                this.definingColoringAttributes.updateNative(canvas3D.ctx, this.dRed, this.dBlue, this.dGreen, this.alpha, this.enableLighting);
            }
            canvas3D.coloringAttributes = this.definingColoringAttributes;
        } else if (canvas3D.renderMolecule != this && this.dirtyAttrsAcrossRms != 0) {
            if ((this.dirtyAttrsAcrossRms & 8) != 0) {
                if (this.definingMaterial == null) {
                    canvas3D.updateMaterial(canvas3D.ctx, this.red, this.green, this.blue, this.alpha);
                } else {
                    this.definingMaterial.updateNative(canvas3D.ctx, this.red, this.green, this.blue, this.alpha, this.enableLighting);
                }
                canvas3D.material = this.definingMaterial;
            }
            if ((this.dirtyAttrsAcrossRms & 0x10) != 0) {
                if (this.definingTransparency == null) {
                    canvas3D.resetTransparency(canvas3D.ctx, this.polygonMode, this.lineAA, this.pointAA);
                } else {
                    this.definingTransparency.updateNative(canvas3D.ctx, this.alpha, this.polygonMode, this.lineAA, this.pointAA);
                }
                canvas3D.transparency = this.definingTransparency;
            }
            if ((this.dirtyAttrsAcrossRms & 4) != 0) {
                if (this.definingPolygonAttributes == null) {
                    canvas3D.resetPolygonAttributes(canvas3D.ctx);
                } else {
                    this.definingPolygonAttributes.updateNative(canvas3D.ctx);
                }
                canvas3D.polygonAttributes = this.definingPolygonAttributes;
            }
            if ((this.dirtyAttrsAcrossRms & 2) != 0) {
                if (this.definingLineAttributes == null) {
                    canvas3D.resetLineAttributes(canvas3D.ctx);
                } else {
                    this.definingLineAttributes.updateNative(canvas3D.ctx);
                }
                canvas3D.lineAttributes = this.definingLineAttributes;
            }
            if ((this.dirtyAttrsAcrossRms & 1) != 0) {
                if (this.definingPointAttributes == null) {
                    canvas3D.resetPointAttributes(canvas3D.ctx);
                } else {
                    this.definingPointAttributes.updateNative(canvas3D.ctx);
                }
                canvas3D.pointAttributes = this.definingPointAttributes;
            }
            if ((this.dirtyAttrsAcrossRms & 0x20) != 0) {
                if (this.definingColoringAttributes == null) {
                    canvas3D.resetColoringAttributes(canvas3D.ctx, this.red, this.green, this.blue, this.alpha, this.enableLighting);
                } else {
                    this.definingColoringAttributes.updateNative(canvas3D.ctx, this.dRed, this.dBlue, this.dGreen, this.alpha, this.enableLighting);
                }
                canvas3D.coloringAttributes = this.definingColoringAttributes;
            }
            canvas3D.renderMolecule = this;
        }
        canvas3D.canvasDirty &= ~n2;
        canvas3D.renderMolecule = this;
        if (this.primaryRenderAtomList != null) {
            this.primaryRenderMethod.render(this, canvas3D);
        }
        if (this.vertexArrayRenderAtomList != null) {
            ((VertexArrayRenderMethod)this.secondaryRenderMethod).setVertexFormat(this);
            ((VertexArrayRenderMethod)this.secondaryRenderMethod).render(this, canvas3D, n);
            ((VertexArrayRenderMethod)this.secondaryRenderMethod).disableGlobalAlpha(canvas3D.ctx, this);
        }
    }

    void renderTransparencyAttributes(Canvas3D canvas3D) {
        if (this.definingTransparency == null) {
            canvas3D.resetTransparency(canvas3D.ctx, this.polygonMode, this.lineAA, this.pointAA);
        } else {
            this.definingTransparency.updateNative(canvas3D.ctx, this.alpha, this.polygonMode, this.lineAA, this.pointAA);
        }
    }

    void reset(GeometryAtom geometryAtom, PolygonAttributesRetained polygonAttributesRetained, LineAttributesRetained lineAttributesRetained, PointAttributesRetained pointAttributesRetained, MaterialRetained materialRetained, ColoringAttributesRetained coloringAttributesRetained, TransparencyAttributesRetained transparencyAttributesRetained, Transform3D transform3D) {
        this.primaryMoleculeType = 0;
        this.numRenderAtoms = 0;
        this.onUpdateList = 0;
        this.dirtyAttrsAcrossRms = 63;
        this.primaryRenderMethod = null;
        if (geometryAtom.geometry instanceof GeometryArrayRetained) {
            if (this.displayListId == 0) {
                this.displayListIdObj = VirtualUniverse.mc.getDisplayListId();
                this.displayListId = this.displayListIdObj;
            }
            if (geometryAtom.source instanceof OrientedShape3DRetained) {
                this.primaryRenderMethod = VirtualUniverse.mc.getOrientedShape3DRenderMethod();
                this.primaryMoleculeType = ORIENTEDSHAPE3D_MOLECULE;
            } else if (geometryAtom.geoType == 16) {
                this.primaryRenderMethod = VirtualUniverse.mc.getText3DRenderMethod();
                this.primaryMoleculeType = TEXT3D_MOLECULE;
            } else if (!(VirtualUniverse.mc.isD3D() || geometryAtom.alphaEditable || !(geometryAtom.geometry instanceof GeometryArrayRetained) || (((GeometryArrayRetained)geometryAtom.geometry).vertexFormat & 0x80) != 0 || ((GeometryArrayRetained)geometryAtom.geometry).texCoordSetMap != null && ((GeometryArrayRetained)geometryAtom.geometry).texCoordSetMap.length > 1 || geometryAtom.geometry.refCount != 1)) {
                this.primaryRenderMethod = VirtualUniverse.mc.getDisplayListRenderMethod();
                this.primaryMoleculeType = DLIST_MOLECULE;
                if (this.vwcBounds == null) {
                    this.vwcBounds = new BoundingBox(null);
                } else {
                    this.vwcBounds.set(null);
                }
            } else {
                this.secondaryRenderMethod = VirtualUniverse.mc.getVertexArrayRenderMethod();
            }
        } else if (geometryAtom.geoType == 17) {
            this.primaryRenderMethod = VirtualUniverse.mc.getCompressedGeometryRenderMethod();
            this.primaryMoleculeType = COMPRESSED_MOLECULE;
        } else if (geometryAtom.geometry instanceof RasterRetained) {
            this.primaryRenderMethod = VirtualUniverse.mc.getDefaultRenderMethod();
            this.primaryMoleculeType = RASTER_MOLECULE;
        }
        this.prev = null;
        this.next = null;
        this.primaryRenderAtomList = null;
        this.vertexArrayRenderAtomList = null;
        block0 : switch (geometryAtom.geometry.geoType) {
            case 3: 
            case 10: {
                this.geometryType = 1;
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 14: {
                this.geometryType = 2;
                break;
            }
            case 15: {
                this.geometryType = 8;
                break;
            }
            case 17: {
                this.geometryType = 16;
                switch (((CompressedGeometryRetained)geometryAtom.geometry).getBufferType()) {
                    case 0: {
                        this.geometryType |= 1;
                        break block0;
                    }
                    case 1: {
                        this.geometryType |= 2;
                        break block0;
                    }
                }
                this.geometryType |= 4;
                break;
            }
            default: {
                this.geometryType = 4;
                if (polygonAttributesRetained == null) break;
                if (polygonAttributesRetained.polygonMode == 0) {
                    this.geometryType |= 1;
                    break;
                }
                if (polygonAttributesRetained.polygonMode != 1) break;
                this.geometryType |= 2;
            }
        }
        this.localToVworld = transform3D;
        this.doInfinite = geometryAtom.source.inBackgroundGroup;
        if (this.doInfinite) {
            this.localToVworld.getRotation(this.infLocalToVworld);
        }
        if (polygonAttributesRetained != null) {
            if (this.definingPolygonAttributes != null) {
                this.definingPolygonAttributes.set(polygonAttributesRetained);
            } else {
                this.definingPolygonAttributes = (PolygonAttributesRetained)polygonAttributesRetained.clone();
            }
            this.polygonMode = this.definingPolygonAttributes.polygonMode;
        } else {
            this.polygonMode = 2;
            this.definingPolygonAttributes = null;
        }
        if (lineAttributesRetained != null) {
            if (this.definingLineAttributes != null) {
                this.definingLineAttributes.set(lineAttributesRetained);
            } else {
                this.definingLineAttributes = (LineAttributesRetained)lineAttributesRetained.clone();
            }
            this.lineAA = this.definingLineAttributes.lineAntialiasing;
        } else {
            this.lineAA = false;
            this.definingLineAttributes = null;
        }
        if (pointAttributesRetained != null) {
            if (this.definingPointAttributes != null) {
                this.definingPointAttributes.set(pointAttributesRetained);
            } else {
                this.definingPointAttributes = (PointAttributesRetained)pointAttributesRetained.clone();
            }
            this.pointAA = this.definingPointAttributes.pointAntialiasing;
        } else {
            this.pointAA = false;
            this.definingPointAttributes = null;
        }
        boolean bl = true;
        if (geometryAtom.geometry instanceof GeometryArrayRetained) {
            GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)geometryAtom.geometry;
            this.vertexFormat = geometryArrayRetained.vertexFormat;
            if ((this.vertexFormat & 2) == 0) {
                bl = false;
            }
        } else if (geometryAtom.geometry instanceof CompressedGeometryRetained) {
            this.vertexFormat = ((CompressedGeometryRetained)geometryAtom.geometry).getVertexFormat();
            if ((this.vertexFormat & 2) == 0) {
                bl = false;
            }
        } else {
            this.vertexFormat = -1;
        }
        if (materialRetained != null) {
            if (this.definingMaterial != null) {
                this.definingMaterial.set(materialRetained);
            } else {
                this.definingMaterial = (MaterialRetained)materialRetained.clone();
            }
            if ((this.geometryType & 8) != 0) {
                this.enableLighting = false;
                this.dRed = 1.0f;
                this.dGreen = 1.0f;
                this.dBlue = 1.0f;
            } else {
                this.enableLighting = bl ? this.definingMaterial.lightingEnable : false;
                this.dRed = this.definingMaterial.diffuseColor.x;
                this.dGreen = this.definingMaterial.diffuseColor.y;
                this.dBlue = this.definingMaterial.diffuseColor.z;
            }
        } else {
            this.enableLighting = false;
            this.definingMaterial = null;
            this.dRed = 1.0f;
            this.dGreen = 1.0f;
            this.dBlue = 1.0f;
        }
        if (coloringAttributesRetained != null) {
            if (this.definingColoringAttributes != null) {
                this.definingColoringAttributes.set(coloringAttributesRetained);
            } else {
                this.definingColoringAttributes = (ColoringAttributesRetained)coloringAttributesRetained.clone();
            }
            this.red = coloringAttributesRetained.color.x;
            this.green = coloringAttributesRetained.color.y;
            this.blue = coloringAttributesRetained.color.z;
        } else {
            this.red = 1.0f;
            this.green = 1.0f;
            this.blue = 1.0f;
            this.definingColoringAttributes = null;
        }
        if (transparencyAttributesRetained != null) {
            if (this.definingTransparency != null) {
                this.definingTransparency.set(transparencyAttributesRetained);
            } else {
                this.definingTransparency = (TransparencyAttributesRetained)transparencyAttributesRetained.clone();
            }
            this.alpha = 1.0f - transparencyAttributesRetained.transparency;
        } else {
            this.alpha = 1.0f;
            this.definingTransparency = null;
        }
        this.locale = geometryAtom.source.locale;
        if (this.locale != this.renderBin.locale) {
            this.localeLocalToVworld = VirtualUniverse.mc.getTransform3D(null);
            geometryAtom.locale.hiRes.difference(this.renderBin.locale.hiRes, this.localeTranslation);
            this.translate();
        } else {
            this.localeLocalToVworld = this.localToVworld;
        }
    }

    void translate() {
        this.localeLocalToVworld.mat[0] = this.localToVworld.mat[0];
        this.localeLocalToVworld.mat[1] = this.localToVworld.mat[1];
        this.localeLocalToVworld.mat[2] = this.localToVworld.mat[2];
        this.localeLocalToVworld.mat[3] = this.localToVworld.mat[3] + this.localeTranslation.x;
        this.localeLocalToVworld.mat[4] = this.localToVworld.mat[4];
        this.localeLocalToVworld.mat[5] = this.localToVworld.mat[5];
        this.localeLocalToVworld.mat[6] = this.localToVworld.mat[6];
        this.localeLocalToVworld.mat[7] = this.localToVworld.mat[7] + this.localeTranslation.y;
        this.localeLocalToVworld.mat[8] = this.localToVworld.mat[8];
        this.localeLocalToVworld.mat[9] = this.localToVworld.mat[9];
        this.localeLocalToVworld.mat[10] = this.localToVworld.mat[10];
        this.localeLocalToVworld.mat[11] = this.localToVworld.mat[11] + this.localeTranslation.z;
        this.localeLocalToVworld.mat[12] = this.localToVworld.mat[12];
        this.localeLocalToVworld.mat[13] = this.localToVworld.mat[13];
        this.localeLocalToVworld.mat[14] = this.localToVworld.mat[14];
        this.localeLocalToVworld.mat[15] = this.localToVworld.mat[15];
    }

    void updateDisplayList(Canvas3D canvas3D, boolean bl) {
        if (this.primaryRenderAtomList != null) {
            ((DisplayListRenderMethod)this.primaryRenderMethod).buildDisplayList(this, canvas3D, bl);
        }
    }

    public void updateObject() {
        if (this.addRAs.size() > 0) {
            Object object;
            int n = 0;
            while (n < this.addRAs.size()) {
                ++this.numRenderAtoms;
                RenderAtom renderAtom = (RenderAtom)this.addRAs.get(n);
                renderAtom.renderMolecule = this;
                if (renderAtom.inPrimaryArray != 0) {
                    if (this.primaryRenderAtomList == null) {
                        this.primaryRenderAtomList = renderAtom;
                    } else {
                        renderAtom.next = this.primaryRenderAtomList;
                        this.primaryRenderAtomList.prev = renderAtom;
                        this.primaryRenderAtomList = renderAtom;
                    }
                    if (this.primaryMoleculeType == 8) {
                        object = (RasterRetained)renderAtom.geometryAtom.geometry;
                        this.renderBin.addGeometryToLockList(object);
                        if (((RasterRetained)object).image != null && ((RasterRetained)object).image.isByReference()) {
                            this.renderBin.addNodeComponent(((RasterRetained)object).image);
                        }
                    }
                } else {
                    if (this.vertexArrayRenderAtomList == null) {
                        this.vertexArrayRenderAtomList = renderAtom;
                    } else {
                        renderAtom.next = this.vertexArrayRenderAtomList;
                        this.vertexArrayRenderAtomList.prev = renderAtom;
                        this.vertexArrayRenderAtomList = renderAtom;
                    }
                    this.renderBin.addGeometryToLockList(renderAtom.geometryAtom.geometry);
                    object = (GeometryArrayRetained)renderAtom.geometryAtom.geometry;
                    if ((((GeometryArrayRetained)object).vertexFormat & 0x80) != 0 && ((GeometryArrayRetained)object).c4fAllocated == 0 && (((GeometryArrayRetained)object).vertexFormat & 4) != 0 && this.useAlpha && !this.renderBin.multiScreen) {
                        this.renderBin.addDirtyReferenceGeometry(renderAtom.geometryAtom.geometry);
                    }
                }
                ++n;
            }
            if ((this.primaryMoleculeType & DLIST_MOLECULE) != 0) {
                this.renderBin.addDirtyRenderMolecule(this);
                this.vwcBounds.set(null);
                object = this.primaryRenderAtomList;
                while (object != null) {
                    this.vwcBounds.combine(((RenderAtom)object).localeVwcBounds);
                    object = ((RenderAtom)object).next;
                }
            }
            if (this.locale != this.renderBin.locale) {
                this.translate();
            }
        } else {
            if ((this.onUpdateList & LOCALE_TRANSLATION) != 0) {
                this.translate();
            }
            if ((this.onUpdateList & BOUNDS_RECOMPUTE_UPDATE) != 0) {
                this.vwcBounds.set(null);
                RenderAtom renderAtom = this.primaryRenderAtomList;
                while (renderAtom != null) {
                    this.vwcBounds.combine(renderAtom.localeVwcBounds);
                    renderAtom = renderAtom.next;
                }
            }
        }
        this.addRAs.clear();
        this.onUpdateList = 0;
    }

    public void updateRemoveRenderAtoms() {
        Object object;
        int n = 0;
        while (n < this.removeRAs.size()) {
            RenderAtom renderAtom = (RenderAtom)this.removeRAs.get(n);
            --this.numRenderAtoms;
            if (renderAtom.inPrimaryArray != 0) {
                if (renderAtom.prev == null) {
                    this.primaryRenderAtomList = renderAtom.next;
                    if (renderAtom.next != null) {
                        renderAtom.next.prev = null;
                    }
                } else {
                    renderAtom.prev.next = renderAtom.next;
                    if (renderAtom.next != null) {
                        renderAtom.next.prev = renderAtom.prev;
                    }
                }
                if (this.primaryMoleculeType == 8) {
                    object = (RasterRetained)renderAtom.geometryAtom.geometry;
                    this.renderBin.removeGeometryFromLockList(object);
                    if (((RasterRetained)object).image != null && ((RasterRetained)object).image.isByReference() && ((RasterRetained)object).image.isByReference()) {
                        this.renderBin.removeNodeComponent(((RasterRetained)object).image);
                    }
                }
            } else {
                if (renderAtom.prev == null) {
                    this.vertexArrayRenderAtomList = renderAtom.next;
                    if (renderAtom.next != null) {
                        renderAtom.next.prev = null;
                    }
                } else {
                    renderAtom.prev.next = renderAtom.next;
                    if (renderAtom.next != null) {
                        renderAtom.next.prev = renderAtom.prev;
                    }
                }
                this.renderBin.removeGeometryFromLockList(renderAtom.geometryAtom.geometry);
            }
            renderAtom.prev = null;
            renderAtom.next = null;
            ++n;
        }
        this.removeRAs.clear();
        if (this.addRAs.size() == 0) {
            if (this.numRenderAtoms == 0) {
                if ((this.primaryMoleculeType & DLIST_MOLECULE) != 0) {
                    this.renderBin.addDisplayListResourceFreeList(this);
                    this.renderBin.removeDirtyRenderMolecule(this);
                    this.vwcBounds.set(null);
                }
                this.displayListId = 0;
                this.displayListIdObj = null;
                if (this.locale != this.renderBin.locale) {
                    VirtualUniverse.mc.addToTransformFreeList(this.localeLocalToVworld);
                    this.localeLocalToVworld = null;
                }
                this.textureBin.removeRenderMolecule(this);
            } else if ((this.primaryMoleculeType & DLIST_MOLECULE) != 0) {
                this.renderBin.addDirtyRenderMolecule(this);
                this.vwcBounds.set(null);
                object = this.primaryRenderAtomList;
                while (object != null) {
                    this.vwcBounds.combine(((RenderAtom)object).localeVwcBounds);
                    object = ((RenderAtom)object).next;
                }
            }
        }
    }
}

