/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.ContainsNodes;
import javax.media.j3d.HashKey;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.MediaContainerRetained;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.SoundSchedulerAtom;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;

abstract class SoundRetained
extends LeafRetained {
    static final int NULL_SOUND = -1;
    MediaContainer soundData = null;
    float initialGain = 1.0f;
    int loopCount = 0;
    boolean enable = false;
    boolean release = false;
    boolean continuous = false;
    float priority = 1.0f;
    Bounds schedulingRegion = null;
    BoundingLeafRetained boundingLeaf = null;
    Bounds transformedRegion = null;
    static final int SOUND_DATA_DIRTY_BIT = 1;
    static final int INITIAL_GAIN_DIRTY_BIT = 2;
    static final int LOOP_COUNT_DIRTY_BIT = 4;
    static final int RELEASE_DIRTY_BIT = 8;
    static final int CONTINUOUS_DIRTY_BIT = 16;
    static final int ENABLE_DIRTY_BIT = 32;
    static final int BOUNDS_DIRTY_BIT = 64;
    static final int BOUNDING_LEAF_DIRTY_BIT = 128;
    static final int PRIORITY_DIRTY_BIT = 256;
    static final int POSITION_DIRTY_BIT = 512;
    static final int DISTANCE_GAIN_DIRTY_BIT = 1024;
    static final int BACK_DISTANCE_GAIN_DIRTY_BIT = 2048;
    static final int DIRECTION_DIRTY_BIT = 4096;
    static final int ANGULAR_ATTENUATION_DIRTY_BIT = 8192;
    static final int BOUNDS_CHANGED = 192;
    static final int ATTRIBUTE_DIRTY_BITS = 319;
    static final int POSITIONAL_DIRTY_BITS = 1855;
    static final int DIRECTIONAL_DIRTY_BITS = 16191;
    static final int ALL_ATTIBS_DIRTY_BITS = 16383;
    static final int LIVE_DIRTY_BIT = 1;
    static final int IMMEDIATE_MODE_DIRTY_BIT = 2;
    static final int LOAD_SOUND_DIRTY_BIT = 4;
    static final int XFORM_DIRTY_BIT = 32768;
    static final int ALL_STATE_DIRTY_BITS = 32775;
    int soundType = -1;
    SoundRetained sgSound = null;
    HashKey key = null;
    SoundRetained[] mirrorSounds = new SoundRetained[1];
    int numMirrorSounds = 0;
    private SoundSchedulerAtom[] loadedAtoms = new SoundSchedulerAtom[1];
    private int atomCount = 0;
    boolean inImmCtx = false;
    static final int LOAD_COMPLETE = 2;
    static final int LOAD_PENDING = 1;
    static final int LOAD_NULL = 0;
    static final int LOAD_FAILED = -1;
    int loadStatus = 0;
    long duration = -1L;
    static final int targetThreads = 514;
    static final boolean debugFlag = false;
    static final boolean internalErrors = false;

    static {
        VirtualUniverse.loadLibraries();
    }

    SoundRetained() {
    }

    void changeAtomList(SoundSchedulerAtom soundSchedulerAtom, int n) {
        if (soundSchedulerAtom == null) {
            return;
        }
        if (n == 2) {
            int n2 = 0;
            while (n2 < this.atomCount) {
                if (soundSchedulerAtom == this.loadedAtoms[n2]) {
                    return;
                }
                ++n2;
            }
            ++this.atomCount;
            int n3 = this.loadedAtoms.length;
            if (this.atomCount > n3) {
                this.loadedAtoms = new SoundSchedulerAtom[2 * n3];
            }
            this.loadedAtoms[this.atomCount - 1] = soundSchedulerAtom;
            this.duration = soundSchedulerAtom.sampleLength;
        } else {
            if (this.atomCount == 0) {
                return;
            }
            boolean bl = false;
            int n4 = 0;
            while (n4 < this.atomCount) {
                if (soundSchedulerAtom == this.loadedAtoms[n4]) {
                    bl = true;
                }
                ++n4;
            }
            if (!bl) {
                return;
            }
            int n5 = n4;
            while (n5 < this.atomCount) {
                this.loadedAtoms[n5] = this.loadedAtoms[n5 + 1];
                ++n5;
            }
            --this.atomCount;
            if (this.atomCount == 0) {
                this.duration = -1L;
            }
        }
    }

    void clearLive(SetLiveState setLiveState) {
        super.clearLive(setLiveState);
        if (this.soundData != null) {
            ((MediaContainerRetained)this.soundData.retained).clearLive(setLiveState.refCount);
        }
    }

    void debugPrint(String string) {
    }

    void dispatchAttribChange(int n, Object object) {
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 514;
        j3dMessage.type = 38;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = this.inSharedGroup ? new Integer(this.numMirrorSounds) : new Integer(1);
        j3dMessage.args[3] = this.mirrorSounds.clone();
        j3dMessage.args[4] = object;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void dispatchStateChange(int n, Object object) {
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 514;
        j3dMessage.type = 45;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = this.inSharedGroup ? new Integer(this.numMirrorSounds) : new Integer(1);
        j3dMessage.args[3] = this.mirrorSounds.clone();
        j3dMessage.args[4] = object;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    boolean getContinuousEnable() {
        return this.continuous;
    }

    long getDuration() {
        return this.duration;
    }

    boolean getEnable() {
        return this.enable;
    }

    boolean getInImmCtx() {
        return this.inImmCtx;
    }

    float getInitialGain() {
        return this.initialGain;
    }

    int getLoop() {
        return this.loopCount;
    }

    SoundRetained getMirrorSound(HashKey hashKey) {
        if (this.inSharedGroup) {
            int n = 0;
            while (n < this.numMirrorSounds) {
                if (this.mirrorSounds[n].key.equals(hashKey)) {
                    return this.mirrorSounds[n];
                }
                ++n;
            }
            if (this.numMirrorSounds == this.mirrorSounds.length) {
                SoundRetained[] soundRetainedArray = new SoundRetained[this.numMirrorSounds * 2];
                n = 0;
                while (n < this.numMirrorSounds) {
                    soundRetainedArray[n] = this.mirrorSounds[n];
                    ++n;
                }
                this.mirrorSounds = soundRetainedArray;
            }
            this.mirrorSounds[this.numMirrorSounds] = (SoundRetained)this.clone();
            this.mirrorSounds[this.numMirrorSounds].key = hashKey;
            this.mirrorSounds[this.numMirrorSounds].sgSound = this;
            return this.mirrorSounds[this.numMirrorSounds++];
        }
        if (this.mirrorSounds[0] == null) {
            this.mirrorSounds[0] = (SoundRetained)this.clone();
            this.mirrorSounds[0].sgSound = this;
        }
        return this.mirrorSounds[0];
    }

    int getNumberOfChannelsUsed() {
        View view = this.universe.getCurrentView();
        if (view == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.atomCount) {
            SoundSchedulerAtom soundSchedulerAtom = this.loadedAtoms[n2];
            if (soundSchedulerAtom == null) {
                return 0;
            }
            if (soundSchedulerAtom.soundScheduler != null && soundSchedulerAtom.soundScheduler.view == view) {
                n = soundSchedulerAtom.numberChannels;
            }
            ++n2;
        }
        return n;
    }

    float getPriority() {
        return this.priority;
    }

    boolean getReleaseEnable() {
        return this.release;
    }

    BoundingLeaf getSchedulingBoundingLeaf() {
        if (this.boundingLeaf != null) {
            return (BoundingLeaf)this.boundingLeaf.source;
        }
        return null;
    }

    Bounds getSchedulingBounds() {
        if (this.schedulingRegion != null) {
            return (Bounds)this.schedulingRegion.clone();
        }
        return null;
    }

    MediaContainer getSoundData() {
        return this.soundData;
    }

    synchronized void initMirrorObject(SoundRetained soundRetained) {
        Object var4_2 = null;
        soundRetained.setSchedulingBounds(this.getSchedulingBounds());
        soundRetained.setSchedulingBoundingLeaf(this.getSchedulingBoundingLeaf());
        soundRetained.sgSound = this.sgSound;
        soundRetained.inImmCtx = this.inImmCtx;
        soundRetained.setSoundData(this.getSoundData());
        soundRetained.parent = this.parent;
        soundRetained.inSharedGroup = false;
        soundRetained.inOrderedGroup = this.inOrderedGroup;
        soundRetained.locale = this.locale;
        soundRetained.parent = this.parent;
        soundRetained.localBounds = (Bounds)this.localBounds.clone();
        soundRetained.transformedRegion = null;
        if (this.boundingLeaf != null) {
            if (soundRetained.boundingLeaf != null) {
                soundRetained.boundingLeaf.removeUser(soundRetained);
            }
            soundRetained.boundingLeaf = this.boundingLeaf.mirrorBoundingLeaf;
            soundRetained.boundingLeaf.addUser(soundRetained);
            soundRetained.transformedRegion = soundRetained.boundingLeaf.transformedRegion;
        } else {
            soundRetained.boundingLeaf = null;
        }
        if (this.schedulingRegion != null) {
            soundRetained.schedulingRegion = (Bounds)this.schedulingRegion.clone();
            if (soundRetained.transformedRegion == null) {
                soundRetained.transformedRegion = (Bounds)soundRetained.schedulingRegion.clone();
                soundRetained.transformedRegion.transform(soundRetained.schedulingRegion, soundRetained.lastLocalToVworld[0]);
            }
        } else {
            soundRetained.schedulingRegion = null;
        }
    }

    boolean isPlaying() {
        int n = 0;
        while (n < this.atomCount) {
            SoundSchedulerAtom soundSchedulerAtom = this.loadedAtoms[n];
            if (soundSchedulerAtom == null) {
                return false;
            }
            if (soundSchedulerAtom.status == 1) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean isPlayingSilently() {
        int n = 0;
        while (n < this.atomCount) {
            SoundSchedulerAtom soundSchedulerAtom = this.loadedAtoms[n];
            if (soundSchedulerAtom == null) {
                return false;
            }
            if (soundSchedulerAtom.status == 2) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean isReady() {
        int n = 0;
        while (n < this.atomCount) {
            SoundSchedulerAtom soundSchedulerAtom = this.loadedAtoms[n];
            if (soundSchedulerAtom == null) {
                return false;
            }
            if (soundSchedulerAtom.loadStatus != 2) {
                return false;
            }
            ++n;
        }
        return true;
    }

    void setContinuousEnable(boolean bl) {
        this.continuous = bl;
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setEnable(boolean bl) {
        this.enable = bl;
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
        this.dispatchAttribChange(32, new Boolean(this.enable));
    }

    void setInImmCtx(boolean bl) {
        this.inImmCtx = bl;
    }

    void setInitialGain(float f) {
        this.initialGain = f < 0.0f ? 0.0f : f;
        this.dispatchAttribChange(2, new Float(f));
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setLive(SetLiveState setLiveState) {
        if (this.inImmCtx) {
            throw new IllegalSharingException(J3dI18N.getString("SoundRetained2"));
        }
        super.setLive(setLiveState);
        if (this.inBackgroundGroup) {
            throw new IllegalSharingException(J3dI18N.getString("SoundRetained3"));
        }
        if (this.loadStatus == 1) {
            this.dispatchStateChange(4, this.soundData);
        }
        if (this.soundData != null) {
            ((MediaContainerRetained)this.soundData.retained).setLive(this.inBackgroundGroup, setLiveState.refCount);
        }
        if (setLiveState.inSharedGroup) {
            int n = 0;
            while (n < setLiveState.keys.length) {
                SoundRetained soundRetained = this.getMirrorSound(setLiveState.keys[n]);
                soundRetained.currentLocalToVworld = new Transform3D[1];
                soundRetained.lastLocalToVworld = new Transform3D[1];
                int n2 = 0;
                while (n2 < this.currentLocalToVworld.length) {
                    if (this.localToVworldKeys[n2].equals(setLiveState.keys[n])) break;
                    ++n2;
                }
                soundRetained.currentLocalToVworld[0] = this.currentLocalToVworld[n2];
                soundRetained.lastLocalToVworld[0] = this.lastLocalToVworld[n2];
                setLiveState.nodeList.add(soundRetained);
                if (setLiveState.switchLevels[n] >= 0) {
                    soundRetained.clearCompositeSwitchMask();
                    soundRetained.isNewSwitchLeaf = true;
                    ContainsNodes containsNodes = setLiveState.containsNodesList.getContainsNodes(setLiveState.keys[n]);
                    containsNodes.soundNodes.add(soundRetained);
                }
                if (setLiveState.transformTargets != null) {
                    setLiveState.transformTargets.add(soundRetained);
                    setLiveState.transformTargetThreads |= 0x202;
                }
                ++n;
            }
        } else {
            SoundRetained soundRetained = this.getMirrorSound(null);
            soundRetained.currentLocalToVworld = new Transform3D[1];
            soundRetained.lastLocalToVworld = new Transform3D[1];
            soundRetained.currentLocalToVworld[0] = this.currentLocalToVworld[0];
            soundRetained.lastLocalToVworld[0] = this.lastLocalToVworld[0];
            setLiveState.nodeList.add(soundRetained);
            if (setLiveState.switchLevels[0] >= 0) {
                soundRetained.clearCompositeSwitchMask();
                soundRetained.isNewSwitchLeaf = true;
                ContainsNodes containsNodes = setLiveState.containsNodesList.getContainsNodes(0);
                containsNodes.soundNodes.add(soundRetained);
            }
            if (setLiveState.transformTargets != null) {
                setLiveState.transformTargets.add(soundRetained);
                setLiveState.transformTargetThreads |= 0x202;
            }
        }
        this.dispatchStateChange(1, this.soundData);
        setLiveState.notifyThreads |= 0x202;
    }

    void setLoop(int n) {
        this.loopCount = n < -1 ? -1 : n;
        this.dispatchAttribChange(4, new Integer(n));
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setPriority(float f) {
        if (f == this.priority) {
            return;
        }
        this.priority = f;
        this.dispatchAttribChange(256, new Float(f));
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setReleaseEnable(boolean bl) {
        this.release = bl;
        this.dispatchAttribChange(8, bl ? Boolean.TRUE : Boolean.FALSE);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setSchedulingBoundingLeaf(BoundingLeaf boundingLeaf) {
        int n;
        int n2 = this.numMirrorSounds;
        if (this.numMirrorSounds == 0) {
            n2 = 1;
        }
        if (this.boundingLeaf != null && this.source != null && this.source.isLive()) {
            n = 0;
            while (n < n2) {
                this.boundingLeaf.mirrorBoundingLeaf.removeUser(this.mirrorSounds[n]);
                ++n;
            }
        }
        if (boundingLeaf != null) {
            this.boundingLeaf = (BoundingLeafRetained)boundingLeaf.retained;
            if (this.source != null && this.source.isLive()) {
                n = 0;
                while (n < n2) {
                    this.boundingLeaf.mirrorBoundingLeaf.addUser(this.mirrorSounds[n]);
                    ++n;
                }
            }
        } else {
            this.boundingLeaf = null;
        }
        this.dispatchAttribChange(128, boundingLeaf);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setSchedulingBounds(Bounds bounds) {
        if (bounds != null) {
            this.schedulingRegion = (Bounds)bounds.clone();
            this.transformedRegion = (Bounds)bounds.clone();
        } else {
            this.schedulingRegion = null;
            this.transformedRegion = null;
        }
        this.dispatchAttribChange(64, bounds);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setSoundData(MediaContainer mediaContainer) {
        if (this.soundData == mediaContainer) {
            return;
        }
        if (this.soundData != null) {
            ((MediaContainerRetained)this.soundData.retained).removeUser(this);
        }
        if (this.source != null && this.source.isLive()) {
            if (this.soundData != null) {
                ((MediaContainerRetained)this.soundData.retained).clearLive(this.refCount);
            }
            if (mediaContainer != null) {
                ((MediaContainerRetained)mediaContainer.retained).setLive(this.inBackgroundGroup, this.refCount);
                ((MediaContainerRetained)mediaContainer.retained).addUser(this);
            }
        }
        this.soundData = mediaContainer;
        this.dispatchAttribChange(1, mediaContainer);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setSoundDataState(MediaContainer mediaContainer) {
        this.soundData = mediaContainer;
    }

    void updateBoundingLeaf(long l) {
        if (this.boundingLeaf != null && this.boundingLeaf.currentSwitchOn) {
            this.transformedRegion = this.boundingLeaf.transformedRegion;
        } else if (this.schedulingRegion != null) {
            this.transformedRegion = (Bounds)this.schedulingRegion.clone();
            this.transformedRegion.transform(this.schedulingRegion, this.lastLocalToVworld[0]);
        } else {
            this.transformedRegion = null;
        }
    }

    synchronized void updateMirrorObject(Object[] objectArray) {
        block17: {
            SoundRetained[] soundRetainedArray;
            int n;
            int n2;
            block25: {
                block24: {
                    block23: {
                        block22: {
                            block21: {
                                block20: {
                                    block19: {
                                        block18: {
                                            block16: {
                                                Object var2_2 = null;
                                                n2 = (Integer)objectArray[1];
                                                if (n2 != -1) break block16;
                                                this.initMirrorObject((SoundRetained)objectArray[2]);
                                                break block17;
                                            }
                                            n = (Integer)objectArray[2];
                                            soundRetainedArray = (SoundRetained[])objectArray[3];
                                            if ((n2 & 1) == 0) break block18;
                                            int n3 = 0;
                                            while (n3 < n) {
                                                soundRetainedArray[n3].setSoundData((MediaContainer)objectArray[4]);
                                                ++n3;
                                            }
                                            break block17;
                                        }
                                        if ((n2 & 2) == 0) break block19;
                                        int n4 = 0;
                                        while (n4 < n) {
                                            soundRetainedArray[n4].initialGain = ((Float)objectArray[4]).floatValue();
                                            ++n4;
                                        }
                                        break block17;
                                    }
                                    if ((n2 & 4) == 0) break block20;
                                    int n5 = 0;
                                    while (n5 < n) {
                                        soundRetainedArray[n5].loopCount = (Integer)objectArray[4];
                                        ++n5;
                                    }
                                    break block17;
                                }
                                if ((n2 & 8) == 0) break block21;
                                int n6 = 0;
                                while (n6 < n) {
                                    soundRetainedArray[n6].release = (Boolean)objectArray[4];
                                    ++n6;
                                }
                                break block17;
                            }
                            if ((n2 & 0x10) == 0) break block22;
                            int n7 = 0;
                            while (n7 < n) {
                                soundRetainedArray[n7].continuous = (Boolean)objectArray[4];
                                ++n7;
                            }
                            break block17;
                        }
                        if ((n2 & 0x100) == 0) break block23;
                        int n8 = 0;
                        while (n8 < n) {
                            soundRetainedArray[n8].initialGain = ((Float)objectArray[4]).floatValue();
                            ++n8;
                        }
                        break block17;
                    }
                    if ((n2 & 0x20) == 0) break block24;
                    int n9 = 0;
                    while (n9 < n) {
                        soundRetainedArray[n9].enable = (Boolean)objectArray[4];
                        ++n9;
                    }
                    break block17;
                }
                if ((n2 & 0x40) == 0) break block25;
                int n10 = 0;
                while (n10 < n) {
                    soundRetainedArray[n10].schedulingRegion = (Bounds)objectArray[4];
                    if (soundRetainedArray[n10].boundingLeaf == null) {
                        if (objectArray[4] != null) {
                            soundRetainedArray[n10].transformedRegion = (Bounds)soundRetainedArray[n10].schedulingRegion.clone();
                            soundRetainedArray[n10].transformedRegion.transform(soundRetainedArray[n10].schedulingRegion, soundRetainedArray[n10].lastLocalToVworld[0]);
                        } else {
                            soundRetainedArray[n10].transformedRegion = null;
                        }
                    }
                    ++n10;
                }
                break block17;
            }
            if ((n2 & 0x80) == 0) break block17;
            int n11 = 0;
            while (n11 < n) {
                soundRetainedArray[n11].boundingLeaf = (BoundingLeafRetained)objectArray[4];
                if (objectArray[4] != null) {
                    soundRetainedArray[n11].transformedRegion = soundRetainedArray[n11].boundingLeaf.transformedRegion;
                } else if (soundRetainedArray[n11].schedulingRegion != null) {
                    soundRetainedArray[n11].transformedRegion = (Bounds)soundRetainedArray[n11].schedulingRegion.clone();
                    soundRetainedArray[n11].transformedRegion.transform(soundRetainedArray[n11].schedulingRegion, soundRetainedArray[n11].lastLocalToVworld[0]);
                } else {
                    soundRetainedArray[n11].transformedRegion = null;
                }
                ++n11;
            }
        }
    }

    void updateTransformChange() {
        if (this.boundingLeaf == null && this.schedulingRegion != null) {
            this.transformedRegion = (Bounds)this.schedulingRegion.clone();
            this.transformedRegion.transform(this.schedulingRegion, this.lastLocalToVworld[0]);
        }
        this.dispatchStateChange(32768, null);
    }
}

